/*
 * Decompiled with CFR 0.152.
 */
package networking.nameserver;

import aspect.Aspect;
import aspect.TMainWin;
import drivers.aspect.TDriverStructRecord;
import drivers.files.TBinaryFile;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import networking.TNetworkSettings;
import networking.nameserver.TNameServerRegistrant;
import networking.nameserver.TNameServerSocket;
import resources.TAppDriversObject;
import resources.TAppToolbar;
import resources.TApplication;
import utility.TFormulaEvaluator;
import utility.asciifiles.TAsciiOutput;
import utility.ftp.TFtpClient;
import utility.netutil;
import utility.objectutil;

public class TNameServer
extends Thread {
    public static boolean IsInitialized = false;
    public static boolean IsTerminated = false;
    private TApplication Application = null;
    private TMainWin MainWin = Aspect.MainWin;
    private TNetworkSettings NetworkSettings = null;
    private SSLServerSocketFactory sslserversocketfactory;
    private SSLServerSocket sslserverSocket = null;
    private TBinaryFile FDns;
    private String DnsFileName;
    private TDriverStructRecord DSRecUsed;
    private TDriverStructRecord DSRecComputerName;
    private TDriverStructRecord DSRecIPAddress;
    private TDriverStructRecord DSRecConnectionPort;
    private boolean IsValid = true;
    private boolean EndTask = false;
    private boolean Debug = false;

    public TNameServer(TApplication tApplication, TNetworkSettings tNetworkSettings) {
        super("TNameServer");
        this.Application = tApplication;
        this.NetworkSettings = tNetworkSettings;
        this.DnsFileName = this.Application.parse_tokens("{programdir}dns.dta");
    }

    public static void initializeTokens(TApplication tApplication) {
        TNameServer.setToolbarIcon(tApplication, 2);
    }

    public static synchronized void setToolbarIcon(TApplication tApplication, int n) {
        if (TAppToolbar.NameServerStatusIcon != null) {
            switch (n) {
                case 0: {
                    TAppToolbar.NameServerStatusIcon.update("", "/images/NameServerInactive.gif");
                    break;
                }
                case 1: {
                    TAppToolbar.NameServerStatusIcon.update("", "/images/NameServerInitializing.gif");
                    break;
                }
                case 2: {
                    TAppToolbar.NameServerStatusIcon.update("", "/images/NameServerWaiting.gif");
                    break;
                }
                case 3: {
                    TAppToolbar.NameServerStatusIcon.update("", "/images/NameServerSending.gif");
                    break;
                }
                case 4: {
                    TAppToolbar.NameServerStatusIcon.update("", "/images/NameServerReceiving.gif");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadIP() {
        block13: {
            String string = netutil.getExternalIP();
            String string2 = this.Application.getTokenValue("FtpPassive").toUpperCase();
            StringBuilder stringBuilder = new StringBuilder();
            string = netutil.getExternalIP();
            this.MainWin.appendToLog("TNameServer", "uploadIP", Thread.currentThread(), null, 9, "Uploading IP address to " + this.NetworkSettings.NameServerFTPHost);
            try {
                TFtpClient tFtpClient = new TFtpClient();
                String string3 = tFtpClient.connect(this.NetworkSettings.NameServerFTPHost, this.NetworkSettings.NameServerFTPUserName, this.NetworkSettings.NameServerFTPPassword);
                if (string3.trim().equalsIgnoreCase("ok")) {
                    this.MainWin.appendToLog("TNameServer", "uploadIP", Thread.currentThread(), null, 9, "Connected to " + this.NetworkSettings.NameServerFTPHost + "  " + tFtpClient.getReplyString());
                    this.MainWin.appendToLog("TNameServer", "uploadIP", Thread.currentThread(), null, 9, "Current Directory: " + tFtpClient.printWorkingDirectory());
                    try {
                        if (string2.startsWith("T") || string2.startsWith("Y")) {
                            tFtpClient.setPassiveMode(true);
                        } else {
                            tFtpClient.setPassiveMode(false);
                        }
                        String string4 = this.Application.parse_tokens("{execdir}") + this.NetworkSettings.ComputerName + ".txt";
                        TAsciiOutput tAsciiOutput = new TAsciiOutput(string4, ',', false);
                        tAsciiOutput.writeString(this.NetworkSettings.ComputerName, true);
                        tAsciiOutput.writeString(string, true);
                        tAsciiOutput.writeInt(this.NetworkSettings.NameServerPort);
                        tAsciiOutput.dispose();
                        tFtpClient.binary();
                        this.MainWin.appendToLog("TNameServer", "uploadIP", Thread.currentThread(), null, 9, "Changing directory to: " + this.NetworkSettings.NameServerFTPDirectory);
                        if (!this.EndTask && tFtpClient.changeWorkingDirectory(this.NetworkSettings.NameServerFTPDirectory)) {
                            if (!this.EndTask) {
                                this.MainWin.appendToLog("TNameServer", "uploadIP", Thread.currentThread(), null, 9, "Uploading " + this.NetworkSettings.ComputerName + ", " + string + ", " + this.NetworkSettings.NameServerPort);
                                tFtpClient.uploadFile(string4, this.NetworkSettings.ComputerName + ".txt");
                            }
                        } else {
                            this.MainWin.appendToLog("TNameServer", "uploadIP", Thread.currentThread(), null, 9, "Invalid directory");
                        }
                        break block13;
                    }
                    catch (Exception exception) {
                        this.MainWin.appendToLog("TNameServer", "uploadIP", Thread.currentThread(), exception, 4, "");
                        break block13;
                    }
                    finally {
                        this.MainWin.appendToLog("TNameServer", "uploadIP", Thread.currentThread(), null, 9, "Disconnecting...");
                        tFtpClient.logout();
                        tFtpClient.disconnect();
                        this.MainWin.appendToLog("TNameServer", "uploadIP", Thread.currentThread(), null, 9, "Complete.");
                    }
                }
                this.MainWin.appendToLog("TNameServer", "uploadIP", Thread.currentThread(), null, 9, "Connection failed");
            }
            catch (Exception exception) {
                this.MainWin.appendToLog("TNameServer", "uploadIP", Thread.currentThread(), exception, 4, "");
            }
        }
    }

    public boolean openDnsFile() {
        try {
            TAppDriversObject tAppDriversObject = new TAppDriversObject(this.DnsFileName, "DnsRegistrants");
            this.FDns = new TBinaryFile(this.Application, tAppDriversObject, 1, false);
            this.FDns.makeEditableFile();
            this.DSRecUsed = this.FDns.DriverStruct.getField("Used");
            this.DSRecComputerName = this.FDns.DriverStruct.getField("ComputerName");
            this.DSRecIPAddress = this.FDns.DriverStruct.getField("IPAddress");
            this.DSRecConnectionPort = this.FDns.DriverStruct.getField("ConnectionPort");
            return true;
        }
        catch (Exception exception) {
            this.MainWin.appendToLog("TNameServer", "openDnsFile", Thread.currentThread(), exception, 4, "Error opening name server file.");
            return false;
        }
    }

    public void addRegistrant(TNameServerRegistrant tNameServerRegistrant) {
        int n = this.getRegistrantIndex(tNameServerRegistrant.ComputerName);
        if (n < 0) {
            n = this.initializeNewRecord();
        }
        this.FDns.putField(this.DSRecComputerName, n, (Object)tNameServerRegistrant.ComputerName);
        this.FDns.putField(this.DSRecIPAddress, n, (Object)tNameServerRegistrant.IPAddress);
        this.FDns.putField(this.DSRecConnectionPort, n, (Object)new Integer(tNameServerRegistrant.ConnectionPort));
        this.MainWin.appendToLog("TNameServer", "addRegistrant", Thread.currentThread(), null, 9, "Adding registrant: " + tNameServerRegistrant.ComputerName + ", " + tNameServerRegistrant.IPAddress + ", " + tNameServerRegistrant.ConnectionPort);
    }

    public synchronized int getRegistrantIndex(String string) {
        for (int i = 0; i < this.FDns.getRecordCount(); ++i) {
            String string2;
            Boolean bl = (Boolean)this.FDns.getField(this.DSRecUsed, i);
            if (!bl.booleanValue() || !(string2 = (String)this.FDns.getField(this.DSRecComputerName, i)).equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    public synchronized TNameServerRegistrant getRegistrant(String string) {
        TNameServerRegistrant tNameServerRegistrant = null;
        int n = this.getRegistrantIndex(string);
        if (n >= 0) {
            String string2 = (String)this.FDns.getField(this.DSRecIPAddress, n);
            int n2 = (Integer)this.FDns.getField(this.DSRecConnectionPort, n);
            tNameServerRegistrant = new TNameServerRegistrant(string, string2, n2);
        }
        return tNameServerRegistrant;
    }

    public int initializeNewRecord() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        boolean bl = false;
        int n3 = this.FDns.getRecordCount();
        for (n = 0; !bl && n < n3; ++n) {
            if (!this.FDns.isDeleted(n, "Used=false")) continue;
            n2 = n;
            bl = true;
        }
        if (!bl) {
            n2 = this.FDns.getRecordCount();
        }
        TFormulaEvaluator tFormulaEvaluator = this.FDns.getFormulaEvaluator();
        for (n = 0; n < this.FDns.DriverStruct.FieldColl.size(); ++n) {
            Object object;
            TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)this.FDns.DriverStruct.FieldColl.get(n);
            stringBuilder.setLength(0);
            if (tFormulaEvaluator != null && tDriverStructRecord.DefaultOnInsert.length() > 0 && (object = tFormulaEvaluator.getFormulaValue(tDriverStructRecord.DefaultOnInsert, n2, 0)) != null) {
                stringBuilder.append(TFormulaEvaluator.convertToString(object));
            }
            Object object2 = objectutil.convertStringToFieldType(tDriverStructRecord.FieldType, stringBuilder.toString(), n2);
            this.FDns.putField(tDriverStructRecord, n2, object2);
        }
        return n2;
    }

    @Override
    public void run() {
        System.out.println("\n---------------------------------");
        System.out.println("* Starting Name Server *");
        System.out.println("---------------------------------");
        TNameServer.setToolbarIcon(this.Application, 1);
        if (!TMainWin.AllConnectionsLocal) {
            this.uploadIP();
        }
        TNameServer.setToolbarIcon(this.Application, 2);
        this.openDnsFile();
        try {
            this.sslserversocketfactory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
            this.sslserverSocket = (SSLServerSocket)this.sslserversocketfactory.createServerSocket(this.NetworkSettings.NameServerPort);
            this.MainWin.appendToLog("TNameServer", "run", Thread.currentThread(), null, 9, "Name server now listening on port " + this.NetworkSettings.NameServerPort);
            this.IsValid = true;
        }
        catch (Exception exception) {
            this.MainWin.appendToLog("TNameServer", "run", Thread.currentThread(), exception, 4, "Error initializing name server,");
            this.IsValid = false;
        }
        IsInitialized = true;
        while (this.IsValid && !this.EndTask) {
            try {
                SSLSocket sSLSocket = (SSLSocket)this.sslserverSocket.accept();
                if (sSLSocket == null) continue;
                TNameServerSocket tNameServerSocket = new TNameServerSocket(this.Application, sSLSocket, this);
                tNameServerSocket.start();
            }
            catch (Exception exception) {
                this.IsValid = false;
            }
        }
        IsTerminated = true;
    }

    public void endTask() {
        this.EndTask = true;
        if (this.FDns != null) {
            this.FDns.dispose();
        }
        if (this.sslserverSocket != null) {
            try {
                this.sslserverSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

