/*
 * Decompiled with CFR 0.152.
 */
package networking.nameserver;

import javax.net.ssl.SSLSocket;
import networking.nameserver.TNameServer;
import networking.nameserver.TNameServerRegistrant;
import resources.TApplication;
import utility.sockets.TSSLSocketWrapper;

public class TNameServerSocket
extends Thread {
    TApplication Application;
    TSSLSocketWrapper socket = null;
    TNameServer NameServer;

    public TNameServerSocket(TApplication tApplication, SSLSocket sSLSocket, TNameServer tNameServer) {
        super("TNameServerSocket");
        this.Application = tApplication;
        this.socket = new TSSLSocketWrapper(this.Application, sSLSocket);
        this.NameServer = tNameServer;
    }

    public void addRegistrant() {
        TNameServerRegistrant tNameServerRegistrant = new TNameServerRegistrant();
        TNameServer.setToolbarIcon(this.Application, 4);
        tNameServerRegistrant.ComputerName = this.socket.readString();
        tNameServerRegistrant.IPAddress = this.socket.readString();
        tNameServerRegistrant.ConnectionPort = this.socket.readInt();
        TNameServer.setToolbarIcon(this.Application, 2);
        this.NameServer.addRegistrant(tNameServerRegistrant);
    }

    public synchronized void lookupRegistrant() {
        boolean bl = true;
        String string = this.socket.readString();
        TNameServerRegistrant tNameServerRegistrant = this.NameServer.getRegistrant(string);
        if (bl) {
            System.out.println("TNameServerSocket.setting icon");
        }
        if (tNameServerRegistrant != null) {
            if (bl) {
                System.out.println("Registrant found: " + tNameServerRegistrant.ComputerName + ", " + tNameServerRegistrant.IPAddress + ", " + tNameServerRegistrant.ConnectionPort);
            }
            this.socket.writeString(tNameServerRegistrant.ComputerName, false);
            this.socket.writeString(tNameServerRegistrant.IPAddress, false);
            this.socket.writeInt(tNameServerRegistrant.ConnectionPort, true);
        } else {
            if (bl) {
                System.out.println("Registrant not found.");
            }
            this.socket.writeString("unknown", false);
            this.socket.writeString("unknown", false);
            this.socket.writeInt(0, true);
        }
    }

    @Override
    public void run() {
        int n = this.socket.readCommand();
        switch (n) {
            case 99: {
                this.addRegistrant();
                break;
            }
            case 100: {
                this.lookupRegistrant();
            }
        }
        this.socket.dispose();
    }
}

