/*
 * Decompiled with CFR 0.152.
 */
package performance;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import performance.TPerformanceMarkInterface;
import utility.charutil;

public class TPerformanceAbstractMark
implements TPerformanceMarkInterface {
    DateFormat df = DateFormat.getInstance();
    public int MarkType = -1;
    public String ClassName = "";
    public String CollectionID = "";
    public String ScriptID = "";
    public String DriverID = "";
    public String Filename = "";
    public String Params = "";
    public String SocketRequestNetwork = "";
    public String SocketRequestID = "";
    public String SocketIPAddress = "";
    public Date create = new Date();
    public Date destroy = new Date(0L);
    public int CacheType;
    public int cWrite = 0;
    public int cRead = 0;
    public int cReadMs = 0;
    public int cWriteMs = 0;
    public int cReadBytes = 0;
    public int cWriteBytes = 0;
    public int cCached = 0;
    public int cUpdated = 0;

    public TPerformanceAbstractMark() {
        ((SimpleDateFormat)this.df).applyPattern("MM-dd-yyyy HH:mm:ss:SSS");
    }

    public void destroy() {
        this.destroy = new Date();
    }

    public String getMarkType() {
        return Integer.toString(this.MarkType);
    }

    public String getClassName() {
        return this.ClassName;
    }

    public String getCollectionID() {
        return this.CollectionID;
    }

    public String getDriverID() {
        return this.DriverID;
    }

    public String getFilename() {
        return this.Filename;
    }

    public String getParams() {
        return charutil.replaceChar(charutil.replaceChar(this.Params, ',', '.'), '\"', '\'');
    }

    public String getParams(int n) {
        String string = this.getParams();
        string = charutil.replaceAllSubstrings(string, "==", "=");
        string = charutil.replaceAllSubstrings(string, ",", "%2c");
        return string.substring(0, Math.min(string.length(), n));
    }

    public String getCacheType() {
        return Integer.toString(this.CacheType);
    }

    public String getCreate() {
        return this.df.format(this.create);
    }

    public String getDestroy() {
        return this.df.format(this.destroy);
    }

    public String getWrite() {
        return Integer.toString(this.cWrite);
    }

    public String getRead() {
        return Integer.toString(this.cRead);
    }

    public String getReadMs() {
        return Integer.toString(this.cReadMs);
    }

    public String getWriteMs() {
        return Integer.toString(this.cWriteMs);
    }

    public String getReadBytes() {
        return Integer.toString(this.cReadBytes);
    }

    public String getWriteBytes() {
        return Integer.toString(this.cWriteBytes);
    }

    public String getCached() {
        return Integer.toString(this.cCached);
    }

    public String getUpdated() {
        return Integer.toString(this.cUpdated);
    }

    public String getScriptID() {
        return this.ScriptID;
    }

    public String getSocketRequestNetwork() {
        return this.SocketRequestNetwork;
    }

    public String getSocketRequestID() {
        return this.SocketRequestID;
    }

    public String getSocketIPAddress() {
        return this.SocketIPAddress;
    }

    public String toString() {
        Object object;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        String string10 = "";
        if (this.Params.length() > 0) {
            object = charutil.getSubStringArray(this.Params, '&', true);
            for (int i = 0; i < ((String[])object).length; ++i) {
                int n = object[i].indexOf(61);
                if (n < 0) continue;
                String string11 = ((String)object[i]).substring(0, n);
                String string12 = ((String)object[i]).substring(n + 1);
                if (string11.equalsIgnoreCase("Filter")) {
                    string = string12;
                }
                if (string11.equalsIgnoreCase("DocumentID")) {
                    string2 = string12;
                }
                if (string11.equalsIgnoreCase("Widget")) {
                    string3 = string12;
                }
                if (string11.equalsIgnoreCase("ContainerItemID")) {
                    string4 = string12;
                }
                if (string11.equalsIgnoreCase("Params")) {
                    string5 = string12;
                }
                if (string11.equalsIgnoreCase("Action")) {
                    string6 = string12;
                }
                if (string11.equalsIgnoreCase("DriverID")) {
                    string7 = string12;
                }
                if (string11.equalsIgnoreCase("Driver_ID")) {
                    string7 = string12;
                }
                if (string11.equalsIgnoreCase("metadata")) {
                    string8 = string12;
                }
                if (string11.equalsIgnoreCase("displayname")) {
                    string9 = string12;
                }
                if (!string11.equalsIgnoreCase("query")) continue;
                string10 = string12;
            }
        }
        if (string5.length() > 0) {
            if (string10.length() == 0) {
                string10 = charutil.getParamValue(string5, "query", '|');
            }
            if (string10.length() == 0) {
                string10 = charutil.getParamValue(string5, "action", '|');
            }
        }
        object = new StringBuilder();
        ((StringBuilder)object).append(this.getMarkType() + ",");
        ((StringBuilder)object).append(this.getClassName() + ",");
        ((StringBuilder)object).append(this.getCollectionID() + ",");
        ((StringBuilder)object).append(this.getDriverID() + ",");
        ((StringBuilder)object).append(this.getFilename() + ",");
        ((StringBuilder)object).append(this.getParams(256) + ",");
        ((StringBuilder)object).append(this.getCacheType() + ",");
        ((StringBuilder)object).append(this.getCreate() + ",");
        ((StringBuilder)object).append(this.getDestroy() + ",");
        ((StringBuilder)object).append(this.getWrite() + ",");
        ((StringBuilder)object).append(this.getRead() + ",");
        ((StringBuilder)object).append(this.getCached() + ",");
        ((StringBuilder)object).append(this.getUpdated() + ",");
        ((StringBuilder)object).append(this.getReadMs() + ",");
        ((StringBuilder)object).append(this.getWriteMs() + ",");
        ((StringBuilder)object).append(this.getReadBytes() + ",");
        ((StringBuilder)object).append(this.getWriteBytes() + ",");
        ((StringBuilder)object).append(this.getScriptID() + ",");
        ((StringBuilder)object).append(this.getSocketRequestNetwork() + ",");
        ((StringBuilder)object).append(this.getSocketRequestID() + ",");
        ((StringBuilder)object).append(this.getSocketIPAddress() + ",");
        ((StringBuilder)object).append(string + ",");
        ((StringBuilder)object).append(string2 + ",");
        ((StringBuilder)object).append(string3 + ",");
        ((StringBuilder)object).append(string4 + ",");
        ((StringBuilder)object).append(string5 + ",");
        ((StringBuilder)object).append(string6 + ",");
        ((StringBuilder)object).append(string7 + ",");
        ((StringBuilder)object).append("Driver Data,");
        ((StringBuilder)object).append(string8 + ",");
        ((StringBuilder)object).append(string9 + ",");
        ((StringBuilder)object).append("Process Content,");
        ((StringBuilder)object).append(string10);
        charutil.replace_char((StringBuilder)object, (StringBuilder)object, '\\', '/');
        charutil.replaceAllSubstrings((StringBuilder)object, (StringBuilder)object, "\r", "/r");
        charutil.replaceAllSubstrings((StringBuilder)object, (StringBuilder)object, "\n", "/n");
        return ((StringBuilder)object).toString();
    }
}

