/*
 * Decompiled with CFR 0.152.
 */
package resources;

import controls.TMenuBar;
import java.awt.Color;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import resources.TActionObject;
import resources.TAppBase;
import resources.TAppMenuObject;
import resources.TApplication;
import utility.charutil;
import utility.objectutil;

public class TAppMenu
extends TAppBase
implements ActionListener {
    public TAppMenu(TApplication tApplication) {
        super(tApplication);
    }

    @Override
    public Object create_resource_object(String string, TApplication tApplication, int n, int n2, long l, long l2, StringBuilder stringBuilder, String[] stringArray) {
        StringBuilder stringBuilder2 = new StringBuilder(stringBuilder.toString());
        this.Application.parse_tokens(stringBuilder2, stringBuilder2);
        TAppMenuObject tAppMenuObject = new TAppMenuObject(string, tApplication, n, n2, l, l2, stringBuilder2, stringArray);
        return tAppMenuObject;
    }

    @Override
    public String getResourceDescription() {
        return "Menu";
    }

    @Override
    public String getResourceName() {
        return "AppMenuFile";
    }

    @Override
    public int required_fields() {
        return 14;
    }

    public TAppMenuObject getAppMenuObjectByName(String string) {
        for (TAppMenuObject tAppMenuObject : this.ResourceColl) {
            if (!tAppMenuObject.MenuItemName.toString().equalsIgnoreCase(string)) continue;
            return tAppMenuObject;
        }
        return null;
    }

    public boolean is_sub_menu(String string, String string2) {
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < this.ResourceColl.size(); ++i) {
            TAppMenuObject tAppMenuObject = (TAppMenuObject)this.ResourceColl.get(i);
            if (tAppMenuObject.MenuID.equalsIgnoreCase(string2)) {
                if (charutil.strcmpi(tAppMenuObject.MenuName, string) == 0) {
                    bl = true;
                }
                if (charutil.strcmpi(tAppMenuObject.MenuItemName, string) == 0) {
                    bl2 = true;
                }
            }
            if (!bl || !bl2) continue;
            return true;
        }
        return false;
    }

    public int index_of_menu(JMenuBar jMenuBar, String string) {
        for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
            JMenu jMenu = jMenuBar.getMenu(i);
            if (charutil.strcmpi(jMenu.getText(), string) != 0) continue;
            return i;
        }
        return -1;
    }

    public void add_menu_items(JMenu jMenu, String string, ActionListener actionListener) {
        JMenu jMenu2 = null;
        boolean bl = true;
        for (int i = 0; i < this.ResourceColl.size(); ++i) {
            Object object;
            JMenuItem jMenuItem;
            TAppMenuObject tAppMenuObject = (TAppMenuObject)this.ResourceColl.get(i);
            if (!tAppMenuObject.Enabled || !tAppMenuObject.MenuID.equalsIgnoreCase(string) || charutil.strcmpi(jMenu.getText(), tAppMenuObject.getMenuName()) != 0) continue;
            if (this.Application.AppMenu.is_sub_menu(tAppMenuObject.getMenuItemName(), string)) {
                if (tAppMenuObject.isSeparator() && jMenu.getItemCount() > 0) {
                    jMenu.addSeparator();
                }
                jMenu2 = new JMenu(tAppMenuObject.MenuItemName.toString());
                objectutil.setFont(jMenu2, tAppMenuObject.FontName, tAppMenuObject.FontSize, tAppMenuObject.FontStyle);
                jMenu2.setForeground(new Color(tAppMenuObject.FontColor));
                if (tAppMenuObject.MenuMnemonic != 0) {
                    jMenu2.setMnemonic(tAppMenuObject.MenuMnemonic);
                }
                jMenu.add(jMenu2);
                this.add_menu_items(jMenu2, string, actionListener);
                continue;
            }
            if (tAppMenuObject.isSeparator() && jMenu.getItemCount() > 0) {
                jMenu.addSeparator();
            }
            if (charutil.nullstr(tAppMenuObject.Parameters)) continue;
            TActionObject tActionObject = this.Application.AppAction.getActionObject(tAppMenuObject.Parameters);
            if (tAppMenuObject.IsCheckBox) {
                jMenuItem = new JCheckBoxMenuItem(tActionObject);
                jMenuItem.addActionListener(this);
            } else {
                jMenuItem = new JMenuItem(tActionObject);
            }
            if (actionListener != null) {
                jMenuItem.addActionListener(actionListener);
            }
            jMenuItem.setText(tAppMenuObject.MenuItemName.toString());
            if (tAppMenuObject.MenuMnemonic != 0) {
                jMenuItem.setMnemonic(tAppMenuObject.MenuItemMnemonic);
            }
            if (tActionObject != null && (object = tActionObject.getValue("ActionAccelerator")) != null) {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke((String)object));
            }
            if (!tAppMenuObject.ShowIcon) {
                jMenuItem.setIcon(null);
            }
            objectutil.setFont(jMenuItem, tAppMenuObject.FontName, tAppMenuObject.FontSize, tAppMenuObject.FontStyle);
            jMenuItem.setForeground(new Color(tAppMenuObject.FontColor));
            jMenu.add(jMenuItem);
        }
    }

    public void addNoSwingMenuItems(Menu menu, String string, ActionListener actionListener) {
        Menu menu2 = null;
        boolean bl = true;
        for (int i = 0; i < this.ResourceColl.size(); ++i) {
            TAppMenuObject tAppMenuObject = (TAppMenuObject)this.ResourceColl.get(i);
            if (!tAppMenuObject.Enabled || !tAppMenuObject.MenuID.equalsIgnoreCase(string) || !menu.getLabel().equalsIgnoreCase(tAppMenuObject.getMenuName())) continue;
            if (this.Application.AppMenu.is_sub_menu(tAppMenuObject.getMenuItemName(), string)) {
                if (tAppMenuObject.isSeparator() && menu.getItemCount() > 0) {
                    menu.addSeparator();
                }
                menu2 = new Menu(tAppMenuObject.MenuItemName.toString());
                menu.add(menu2);
                this.addNoSwingMenuItems(menu2, string, actionListener);
                continue;
            }
            if (tAppMenuObject.isSeparator() && menu.getItemCount() > 0) {
                menu.addSeparator();
            }
            if (charutil.nullstr(tAppMenuObject.Parameters)) continue;
            TActionObject tActionObject = this.Application.AppAction.getActionObject(tAppMenuObject.Parameters);
            MenuItem menuItem = new MenuItem();
            if (actionListener != null) {
                menuItem.addActionListener(actionListener);
            }
            menuItem.setLabel(tAppMenuObject.MenuItemName.toString());
            menu.add(menuItem);
        }
    }

    public TMenuBar createMainMenu(String string) {
        TMenuBar tMenuBar = null;
        tMenuBar = new TMenuBar();
        for (int i = 0; i < this.ResourceColl.size(); ++i) {
            TAppMenuObject tAppMenuObject = (TAppMenuObject)this.ResourceColl.get(i);
            if (!tAppMenuObject.Enabled || !tAppMenuObject.MenuID.equalsIgnoreCase(string) || this.index_of_menu(tMenuBar, tAppMenuObject.getMenuName()) >= 0 || this.is_sub_menu(tAppMenuObject.getMenuName(), string)) continue;
            JMenu jMenu = new JMenu(tAppMenuObject.MenuName.toString());
            objectutil.setFont(jMenu, tAppMenuObject.FontName, tAppMenuObject.FontSize, tAppMenuObject.FontStyle);
            jMenu.setForeground(new Color(tAppMenuObject.FontColor));
            if (tAppMenuObject.MenuMnemonic != 0) {
                jMenu.setMnemonic(tAppMenuObject.MenuMnemonic);
            }
            this.add_menu_items(jMenu, string, null);
            if (jMenu.getItemCount() <= 0) continue;
            tMenuBar.add(jMenu);
        }
        return tMenuBar;
    }

    public JPopupMenu createPopupMenu(String string, ActionListener actionListener) {
        JPopupMenu jPopupMenu = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        boolean bl = false;
        for (int i = 0; i < this.ResourceColl.size(); ++i) {
            Object object;
            JMenuItem jMenuItem;
            String string2;
            TAppMenuObject tAppMenuObject = (TAppMenuObject)this.ResourceColl.get(i);
            if (!tAppMenuObject.Enabled || !tAppMenuObject.MenuID.equalsIgnoreCase(string)) continue;
            if (jPopupMenu == null) {
                jPopupMenu = new JPopupMenu();
            }
            if (!hashtable.contains(string2 = tAppMenuObject.MenuItemName.toString()) && this.is_sub_menu(string2, string) && !this.is_sub_menu(tAppMenuObject.MenuName.toString(), string)) {
                JMenu jMenu = new JMenu(string2);
                if (tAppMenuObject.MenuMnemonic != 0) {
                    jMenu.setMnemonic(tAppMenuObject.MenuMnemonic);
                }
                objectutil.setFont(jMenu, tAppMenuObject.FontName, tAppMenuObject.FontSize, tAppMenuObject.FontStyle);
                jMenu.setForeground(new Color(tAppMenuObject.FontColor));
                jPopupMenu.add(jMenu);
                this.add_menu_items(jMenu, string, actionListener);
                hashtable.put(string2, string2);
                continue;
            }
            if (this.is_sub_menu(tAppMenuObject.MenuName.toString(), string) || charutil.nullstr(tAppMenuObject.Parameters)) continue;
            if (tAppMenuObject.isSeparator()) {
                jPopupMenu.addSeparator();
            }
            TActionObject tActionObject = this.Application.AppAction.getActionObject(tAppMenuObject.Parameters);
            if (tAppMenuObject.IsCheckBox) {
                jMenuItem = new JCheckBoxMenuItem(tActionObject);
                jMenuItem.addActionListener(this);
            } else {
                jMenuItem = new JMenuItem(tActionObject);
            }
            jMenuItem.setText(tAppMenuObject.MenuItemName.toString());
            if (actionListener != null) {
                jMenuItem.addActionListener(actionListener);
            }
            if (tAppMenuObject.MenuItemMnemonic != 0) {
                jMenuItem.setMnemonic(tAppMenuObject.MenuItemMnemonic);
            }
            if (tActionObject != null && (object = tActionObject.getValue("ActionAccelerator")) != null) {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke((String)object));
            }
            if (!tAppMenuObject.ShowIcon) {
                jMenuItem.setIcon(null);
            }
            objectutil.setFont(jMenuItem, tAppMenuObject.FontName, tAppMenuObject.FontSize, tAppMenuObject.FontStyle);
            jMenuItem.setForeground(new Color(tAppMenuObject.FontColor));
            jPopupMenu.add(jMenuItem);
        }
        return jPopupMenu;
    }

    public PopupMenu createNoSwingPopupMenu(String string, ActionListener actionListener) {
        PopupMenu popupMenu = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        boolean bl = false;
        for (int i = 0; i < this.ResourceColl.size(); ++i) {
            String string2;
            TAppMenuObject tAppMenuObject = (TAppMenuObject)this.ResourceColl.get(i);
            if (!tAppMenuObject.Enabled || !tAppMenuObject.MenuID.equalsIgnoreCase(string)) continue;
            if (popupMenu == null) {
                popupMenu = new PopupMenu();
            }
            if (!hashtable.contains(string2 = tAppMenuObject.MenuItemName.toString()) && this.is_sub_menu(string2, string) && !this.is_sub_menu(tAppMenuObject.MenuName.toString(), string)) {
                Menu menu = new Menu(string2);
                popupMenu.add(menu);
                this.addNoSwingMenuItems(menu, string, actionListener);
                hashtable.put(string2, string2);
                continue;
            }
            if (this.is_sub_menu(tAppMenuObject.MenuName.toString(), string) || charutil.nullstr(tAppMenuObject.Parameters)) continue;
            if (tAppMenuObject.isSeparator()) {
                popupMenu.addSeparator();
            }
            TActionObject tActionObject = this.Application.AppAction.getActionObject(tAppMenuObject.Parameters);
            MenuItem menuItem = new MenuItem();
            menuItem.setLabel(tAppMenuObject.MenuItemName.toString());
            if (actionListener != null) {
                menuItem.addActionListener(actionListener);
            }
            popupMenu.add(menuItem);
        }
        return popupMenu;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = actionEvent.getActionCommand();
        if (actionEvent.getSource() instanceof JCheckBoxMenuItem) {
            for (int i = 0; i < this.ResourceColl.size(); ++i) {
                TAppMenuObject tAppMenuObject = (TAppMenuObject)this.ResourceColl.get(i);
                stringBuilder.setLength(0);
                stringBuilder.append((CharSequence)tAppMenuObject.MenuItemName);
                tAppMenuObject.get_mnemonic(stringBuilder, stringBuilder);
                if (!stringBuilder.toString().equalsIgnoreCase(string) || tAppMenuObject.AssociatedToken.length() <= 0) continue;
                String string2 = ((JCheckBoxMenuItem)actionEvent.getSource()).isSelected() ? "true" : "false";
                if (!this.Application.getTokenValue(tAppMenuObject.AssociatedToken).equalsIgnoreCase(string2)) {
                    this.Application.setTokenValue(tAppMenuObject.AssociatedToken, string2);
                }
                return;
            }
        }
    }
}

