/*
 * Decompiled with CFR 0.152.
 */
package scrollwin.dialogpanel;

import aspect.Aspect;
import aspect.TMainWin;
import collections.TComboBoxColl;
import controls.TButton;
import controls.TCheckBox;
import controls.TComboBox;
import controls.TDateSpinner;
import controls.TDesktopPane;
import controls.TIntegerSpinner;
import controls.TLabel;
import controls.TPanel;
import controls.TPassword;
import controls.TTabbedPane;
import controls.TTextArea;
import controls.TTextField;
import controls.htmlviewer.THtmlEditorPane;
import controls.htmlviewer.THtmlViewer;
import drivers.aspect.TAbstractDriver;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverStructRecord;
import drivers.aspect.TEditDialogsDriver;
import extensions.SwingWorker;
import extensions.TClassLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.JTextComponent;
import resources.TAppActionObject;
import resources.TAppDialogsObject;
import resources.TAppDriversObject;
import resources.TAppToolbarObject;
import resources.TApplication;
import resources.TApplicationListenerEvent;
import resources.TApplicationListenerInterface;
import scripts.TExecScript;
import scrollwin.dialogpanel.TDialogTablePanel;
import scrollwin.dialogpanel.TScriptDialogListener;
import scrollwin.dialogpanel.TScrollDialogPanelControl;
import scrollwin.dialogpanel.TScrollDialogPanelEvent;
import scrollwin.dialogpanel.TScrollDialogPanelListenerInterface;
import scrollwin.filtertree.TScrollFilterTree;
import scrollwin.filtertree.TScrollFilterTreeNode;
import scrollwin.filtertree.TScrollFilterTreeNodeEvent;
import scrollwin.filtertree.TScrollFilterTreeNodeListenerInterface;
import scrollwin.table.TScrollTable;
import scrollwin.table.TScrollTablePanel;
import scrollwin.toolbar.TScrollToolbarControlInterface;
import utility.TFormulaEvaluator;
import utility.charutil;
import utility.imageutil;
import utility.objectutil;

public class TScrollDialogPanel
extends TPanel
implements ComponentListener,
ActionListener,
FocusListener,
TableModelListener,
ChangeListener,
VetoableChangeListener,
ItemListener,
ListSelectionListener,
HyperlinkListener,
TScrollToolbarControlInterface,
TApplicationListenerInterface,
TScrollFilterTreeNodeListenerInterface {
    public static final Color ColorBkgnd = Color.LIGHT_GRAY;
    private TMainWin MainWin = Aspect.MainWin;
    private boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTScrollDialogPanel");
    TApplication Application;
    public TAspectDriver AspectDriver = null;
    TClassLoader classLoader = null;
    TEditDialogsDriver EditDialogsDriver = null;
    Timer CallbackTimer = null;
    int CallbackTime = 0;
    int cCallbacks = 0;
    ArrayList altResourceElements = null;
    ArrayList arListeners = new ArrayList();
    JComponent DefaultFocus = null;
    TButton DefaultButton = null;
    ArrayList arPanel = null;
    public ArrayList arControls = null;
    ArrayList arFileList = null;
    static double ScaleX = 1.0;
    static double ScaleY = 1.0;
    String DialogID;
    String TitleStr = null;
    public int RecordNumber = -1;
    boolean IsTransferring = false;
    boolean HasAlternateCollections = false;
    String ReturnValue = "";
    boolean IsPreview = false;
    ArrayList arPanelsToDispose = new ArrayList();
    private static File FileChooserDefault = null;
    Hashtable hashImages = new Hashtable();
    boolean UseCustomTabbedPane = true;
    private static long starttime = new Date().getTime();

    public TScrollDialogPanel(TApplication tApplication, TAspectDriver tAspectDriver, String string) {
        this.setOpaque(false);
        this.Application = tApplication;
        this.AspectDriver = tAspectDriver;
        this.DialogID = string;
        this.arControls = new ArrayList(100);
        this.addScrollDialogPanelListener(new TScriptDialogListener());
        this.Application.addListener(this);
    }

    public TScrollDialogPanel(TApplication tApplication, TEditDialogsDriver tEditDialogsDriver, String string) {
        this.Application = tApplication;
        this.EditDialogsDriver = tEditDialogsDriver;
        this.AspectDriver = null;
        this.DialogID = string;
        this.IsPreview = true;
        this.arControls = new ArrayList(100);
        this.addScrollDialogPanelListener(new TScriptDialogListener());
    }

    @Override
    public void dispose() {
        int n;
        if (this.arFileList != null) {
            this.arFileList.clear();
        }
        if (this.CallbackTimer != null) {
            this.CallbackTimer.stop();
        }
        this.Application.removeListener(this);
        if (this.altResourceElements != null) {
            this.altResourceElements.clear();
        }
        if (this.arListeners != null) {
            this.arListeners.clear();
        }
        for (n = 0; n < this.arPanelsToDispose.size(); ++n) {
            ((TPanel)this.arPanelsToDispose.get(n)).dispose();
        }
        this.arPanelsToDispose.clear();
        Enumeration enumeration = this.hashImages.elements();
        while (enumeration.hasMoreElements()) {
            ((Image)enumeration.nextElement()).flush();
        }
        if (this.arControls != null) {
            block8: for (n = 0; n < this.arControls.size(); ++n) {
                TScrollDialogPanelControl tScrollDialogPanelControl = (TScrollDialogPanelControl)this.arControls.get(n);
                switch (tScrollDialogPanelControl.ControlType) {
                    case 14: {
                        ImageIcon imageIcon = (ImageIcon)((JLabel)tScrollDialogPanelControl.ControlObj).getIcon();
                        if (imageIcon == null) continue block8;
                        imageIcon.getImage().flush();
                        continue block8;
                    }
                    case 52: {
                        ((THtmlViewer)tScrollDialogPanelControl.ControlObj).removeListener(this);
                        continue block8;
                    }
                    case 7: {
                        ((TDialogTablePanel)tScrollDialogPanelControl.ControlObj).dispose();
                        continue block8;
                    }
                    case 68: {
                        Component[] componentArray = ((JScrollPane)tScrollDialogPanelControl.ControlObj).getViewport().getComponents();
                        for (int i = 0; i < componentArray.length; ++i) {
                            if (!(componentArray[i] instanceof TScrollFilterTree)) continue;
                            ((TScrollFilterTree)componentArray[i]).AspectDriver.dispose();
                        }
                        continue block8;
                    }
                }
            }
            this.arControls.clear();
        }
        System.gc();
    }

    public int getRecordNumber() {
        return this.RecordNumber;
    }

    public void setResourceElements(ArrayList arrayList) {
        this.altResourceElements = new ArrayList();
        for (int i = 0; i < arrayList.size(); ++i) {
            this.altResourceElements.add(arrayList.get(i));
        }
    }

    public TAspectDriver getAspectDriver() {
        return this.AspectDriver;
    }

    public void addScrollDialogPanelListener(TScrollDialogPanelListenerInterface tScrollDialogPanelListenerInterface) {
        this.arListeners.add(tScrollDialogPanelListenerInterface);
    }

    public void addScrollDialogPanelListener(String string) {
        Class clazz;
        if (this.classLoader == null) {
            this.classLoader = new TClassLoader();
        }
        if ((clazz = this.classLoader.loadClass(string)) != null) {
            try {
                this.arListeners.add(clazz.newInstance());
            }
            catch (Exception exception) {
                this.MainWin.appendToLog("TScrollDialogPanel", "addScrollDialogPanelListener", Thread.currentThread(), exception, 4, "Error adding dialog listener.");
            }
        }
    }

    public String getTitleStr() {
        return this.TitleStr;
    }

    public String getReturnValue() {
        return this.ReturnValue;
    }

    public TButton getDefaultButton() {
        return this.DefaultButton;
    }

    public JComponent getDefaultFocus() {
        return this.DefaultFocus;
    }

    private Rectangle scaleControl(TAppDialogsObject tAppDialogsObject) {
        Rectangle rectangle = new Rectangle();
        rectangle.x = (int)((double)tAppDialogsObject.ControlX * ScaleX);
        rectangle.y = (int)((double)tAppDialogsObject.ControlY * ScaleY);
        rectangle.width = (int)((double)tAppDialogsObject.ControlW * ScaleX);
        rectangle.height = (int)((double)tAppDialogsObject.ControlH * ScaleY);
        return rectangle;
    }

    private JComponent addLabel(TAppDialogsObject tAppDialogsObject) {
        Image image;
        Rectangle rectangle = this.scaleControl(tAppDialogsObject);
        StringBuilder stringBuilder = new StringBuilder();
        this.Application.parse_tokens(stringBuilder, tAppDialogsObject.ControlLabel);
        TLabel tLabel = new TLabel(stringBuilder);
        if (tAppDialogsObject.Mnemonic != '\u0000') {
            tLabel.setDisplayedMnemonic(tAppDialogsObject.Mnemonic);
        }
        switch (tAppDialogsObject.HorzLabelPosition) {
            case 0: 
            case 1: {
                tLabel.setHorizontalAlignment(2);
                break;
            }
            case 3: {
                tLabel.setHorizontalAlignment(0);
                break;
            }
            case 2: {
                tLabel.setHorizontalAlignment(4);
                break;
            }
            case 4: {
                tLabel.setHorizontalAlignment(10);
                break;
            }
            case 5: {
                tLabel.setHorizontalAlignment(11);
            }
        }
        switch (tAppDialogsObject.VertLabelPosition) {
            case 0: 
            case 3: {
                tLabel.setVerticalAlignment(0);
                break;
            }
            case 1: {
                tLabel.setVerticalAlignment(1);
                break;
            }
            case 2: {
                tLabel.setVerticalAlignment(3);
            }
        }
        if (tAppDialogsObject.Transparent) {
            tLabel.setOpaque(false);
        }
        if (tAppDialogsObject.IconFile.length() > 0 && (image = imageutil.getScaledImage(this.getClass(), charutil.removeQuotes(tAppDialogsObject.IconFile), -1, -1)) != null) {
            ImageIcon imageIcon = new ImageIcon(image);
            imageIcon.setImageObserver(tLabel);
            tLabel.setIcon(imageIcon);
            tLabel.setIconTextGap(5);
            switch (tAppDialogsObject.HorzIconPosition) {
                case 0: 
                case 1: {
                    tLabel.setHorizontalTextPosition(4);
                    break;
                }
                case 3: {
                    tLabel.setHorizontalTextPosition(0);
                    break;
                }
                case 2: {
                    tLabel.setHorizontalTextPosition(2);
                    break;
                }
                case 4: {
                    tLabel.setHorizontalTextPosition(11);
                    break;
                }
                case 5: {
                    tLabel.setHorizontalTextPosition(10);
                }
            }
            switch (tAppDialogsObject.VertIconPosition) {
                case 0: 
                case 3: {
                    tLabel.setVerticalTextPosition(0);
                    break;
                }
                case 1: {
                    tLabel.setVerticalTextPosition(3);
                    break;
                }
                case 2: {
                    tLabel.setVerticalTextPosition(1);
                }
            }
        }
        return tLabel;
    }

    private String transferLabel(TScrollDialogPanelControl tScrollDialogPanelControl, int n) {
        Object object;
        if (n == 1) {
            return ((TLabel)tScrollDialogPanelControl.ControlObj).getText();
        }
        String string = "";
        String string2 = tScrollDialogPanelControl.AppDialogsObject.FormatPattern;
        if (tScrollDialogPanelControl.AppDialogsObject.ControlLabel.toString().startsWith("=")) {
            string = tScrollDialogPanelControl.AppDialogsObject.ControlLabel.toString();
        } else if (tScrollDialogPanelControl.AppDialogsObject.ControlLabel.length() == 0 && tScrollDialogPanelControl.AppDialogsObject.ControlID.length() > 0) {
            string = "=" + tScrollDialogPanelControl.AppDialogsObject.ControlID.toString();
            if (string2.length() == 0 && (object = this.AspectDriver.DriverStruct.getField(tScrollDialogPanelControl.AppDialogsObject.ControlID)) != null) {
                string2 = ((TDriverStructRecord)object).FormatPattern;
            }
        }
        if (string.length() > 0) {
            object = this.AspectDriver.getFormulaEvaluator();
            Object object2 = ((TFormulaEvaluator)object).getFormulaValue(string, this.AspectDriver.getAbsoluteDiskIndex(this.RecordNumber), 0);
            string = objectutil.applyPattern(object2, string2);
            ((TLabel)tScrollDialogPanelControl.ControlObj).setText(string);
        }
        return string;
    }

    private JComponent addTokenLabel(TAppDialogsObject tAppDialogsObject) {
        StringBuilder stringBuilder = new StringBuilder();
        TLabel tLabel = (TLabel)this.addLabel(tAppDialogsObject);
        tLabel.setText(this.Application.getTokenValue(tAppDialogsObject.ControlLabel.toString()));
        return tLabel;
    }

    private JComponent addImage(TAppDialogsObject tAppDialogsObject) {
        JLabel jLabel = new JLabel();
        jLabel.setOpaque(false);
        if (tAppDialogsObject.IconFile.length() > 0) {
            Image image = tAppDialogsObject.ControlType == 14 ? this.getHashedImage(this.Application.parse_tokens(charutil.removeQuotes(tAppDialogsObject.IconFile))) : this.getHashedImage(this.Application.getTokenValue(charutil.removeQuotes(tAppDialogsObject.IconFile)));
            if (image != null) {
                ImageIcon imageIcon = new ImageIcon(image);
                imageIcon.setImageObserver(jLabel);
                jLabel.setIcon(imageIcon);
            }
            jLabel.setVerticalAlignment(0);
            jLabel.setHorizontalAlignment(0);
        }
        if (tAppDialogsObject.Tip.trim().length() > 0) {
            jLabel.setToolTipText(charutil.wrapAsHtml(tAppDialogsObject.Tip));
        }
        return jLabel;
    }

    private Object transferImage(TScrollDialogPanelControl tScrollDialogPanelControl, Object object, int n) {
        JLabel jLabel = (JLabel)tScrollDialogPanelControl.ControlObj;
        if (n == 0 && object instanceof String) {
            Dimension dimension = jLabel.getPreferredSize();
            Image image = imageutil.getScaledImage(this.getClass(), (String)object, dimension.width, -1);
            if (image != null) {
                ImageIcon imageIcon = new ImageIcon(image);
                imageIcon.setImageObserver(jLabel);
                jLabel.setIcon(imageIcon);
                jLabel.setPreferredSize(new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight()));
            }
            jLabel.setVerticalAlignment(0);
            jLabel.setHorizontalAlignment(0);
        }
        return object;
    }

    private JComponent addButton(TAppDialogsObject tAppDialogsObject) {
        Object object;
        TButton tButton = null;
        TButtonAction tButtonAction = null;
        ImageIcon imageIcon = null;
        String string = this.Application.parse_tokens(tAppDialogsObject.ActionID);
        if (tAppDialogsObject.ControlType == 49) {
            object = this.Application.AppAction.getAppActionObject(string);
            if (object != null) {
                tButtonAction = new TButtonAction(((TAppActionObject)object).ActionObject);
                tButtonAction.putValue("ControlType", new Integer(tAppDialogsObject.ControlType));
                if (tAppDialogsObject.ControlLabel.length() > 0) {
                    tButtonAction.putValue("Name", tAppDialogsObject.ControlLabel.toString());
                }
                if (tAppDialogsObject.Tip.trim().length() > 0) {
                    tButtonAction.putValue("ShortDescription", charutil.wrapAsHtml(tAppDialogsObject.Tip));
                    tButtonAction.putValue("LongDescription", charutil.wrapAsHtml(tAppDialogsObject.Tip));
                }
            } else {
                this.MainWin.appendToLog("TScrollDialogPanel", "addButton", Thread.currentThread(), null, 4, "Cannot locate action with ID of " + tAppDialogsObject.ActionID);
            }
        } else {
            tButtonAction = new TButtonAction();
            tButtonAction.putValue("Name", tAppDialogsObject.ControlLabel.toString());
            if (tAppDialogsObject.Tip.trim().length() > 0) {
                tButtonAction.putValue("ShortDescription", charutil.wrapAsHtml(tAppDialogsObject.Tip));
                tButtonAction.putValue("LongDescription", charutil.wrapAsHtml(tAppDialogsObject.Tip));
            }
            tButtonAction.putValue("ControlType", new Integer(tAppDialogsObject.ControlType));
            tButtonAction.putValue("ActionID", string);
            tButtonAction.putValue("ActionDriverCmd", tAppDialogsObject.DriverCmd);
            tButtonAction.putValue("ActionParameters", tAppDialogsObject.Params);
        }
        if (tButtonAction != null) {
            tButton = new TButton(tButtonAction);
            switch (tAppDialogsObject.HorzLabelPosition) {
                case 0: 
                case 3: {
                    tButton.setHorizontalAlignment(0);
                    break;
                }
                case 1: {
                    tButton.setHorizontalAlignment(2);
                    break;
                }
                case 2: {
                    tButton.setHorizontalAlignment(4);
                    break;
                }
                case 4: {
                    tButton.setHorizontalAlignment(10);
                    break;
                }
                case 5: {
                    tButton.setHorizontalAlignment(11);
                }
            }
            switch (tAppDialogsObject.VertLabelPosition) {
                case 0: 
                case 3: {
                    tButton.setVerticalAlignment(0);
                    break;
                }
                case 1: {
                    tButton.setVerticalAlignment(1);
                    break;
                }
                case 2: {
                    tButton.setVerticalAlignment(3);
                }
            }
            if (tAppDialogsObject.IconFile.length() > 0 && (object = imageutil.getScaledImage(this.getClass(), charutil.removeQuotes(tAppDialogsObject.IconFile), -1, -1)) != null) {
                imageIcon = new ImageIcon((Image)object);
                tButton.setIcon(imageIcon);
                tButton.setIconTextGap(5);
                switch (tAppDialogsObject.HorzIconPosition) {
                    case 0: 
                    case 1: {
                        tButton.setHorizontalTextPosition(4);
                        break;
                    }
                    case 3: {
                        tButton.setHorizontalTextPosition(0);
                        break;
                    }
                    case 2: {
                        tButton.setHorizontalTextPosition(2);
                        break;
                    }
                    case 4: {
                        tButton.setHorizontalTextPosition(11);
                        break;
                    }
                    case 5: {
                        tButton.setHorizontalTextPosition(10);
                    }
                }
                switch (tAppDialogsObject.VertIconPosition) {
                    case 0: 
                    case 3: {
                        tButton.setVerticalTextPosition(0);
                        break;
                    }
                    case 1: {
                        tButton.setVerticalTextPosition(3);
                        break;
                    }
                    case 2: {
                        tButton.setVerticalTextPosition(1);
                    }
                }
            }
            if (imageIcon != null) {
                // empty if block
            }
            if (tAppDialogsObject.Mnemonic != '\u0000') {
                tButton.setMnemonic(tAppDialogsObject.Mnemonic);
            }
            if (!tAppDialogsObject.ShowText && tButton.getIcon() != null) {
                tButton.setText("");
            }
            if (tAppDialogsObject.ControlType == 54 || tAppDialogsObject.ControlType == 55) {
                tButton.setEnabled(false);
            }
        }
        return tButton;
    }

    private JComponent addColorChooser(TAppDialogsObject tAppDialogsObject) {
        TButton tButton = (TButton)this.addButton(tAppDialogsObject);
        return tButton;
    }

    private Object transferColorChooser(TScrollDialogPanelControl tScrollDialogPanelControl, Object object, int n) {
        TButton tButton = (TButton)tScrollDialogPanelControl.ControlObj;
        if (n == 0) {
            if (object instanceof Integer) {
                tButton.setForeground(new Color((Integer)object));
            }
        } else {
            object = new Integer(tButton.getForeground().getRGB());
        }
        return object;
    }

    private JComponent addInputBox(TAppDialogsObject tAppDialogsObject, TDriverStructRecord tDriverStructRecord) {
        Rectangle rectangle = this.scaleControl(tAppDialogsObject);
        int n = 0;
        int n2 = 0;
        switch (tDriverStructRecord.FieldType) {
            case 24: {
                n = tDriverStructRecord.ArraySize - 1;
                break;
            }
            case 3: {
                n = tDriverStructRecord.ArraySize;
                break;
            }
            case 26: {
                n = tDriverStructRecord.ArraySize;
                break;
            }
            case 11: {
                n = tDriverStructRecord.ArraySize - 1;
            }
        }
        if (!charutil.nullstr(tDriverStructRecord.MaxValue) && (n2 = charutil.ival(tDriverStructRecord.MaxValue)) > 0) {
            n = Math.min(n, n2);
        }
        TTextField tTextField = new TTextField(tAppDialogsObject.ControlID.toString(), n);
        tTextField.addActionListener(this);
        if (tAppDialogsObject.Mnemonic != '\u0000') {
            tTextField.setFocusAccelerator(tAppDialogsObject.Mnemonic);
        }
        if (tAppDialogsObject.ReadOnly) {
            tTextField.setEditable(false);
            tTextField.setBackground(Color.white);
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        tTextField.registerKeyboardAction(new EnterListener(), keyStroke, 0);
        return tTextField;
    }

    private Object transferInputBox(TScrollDialogPanelControl tScrollDialogPanelControl, Object object, int n) {
        TTextField tTextField = (TTextField)tScrollDialogPanelControl.ControlObj;
        if (n == 0) {
            if (object instanceof String) {
                tTextField.setText((String)object);
            } else {
                tTextField.setText("");
            }
            return object;
        }
        return tTextField.getText().trim();
    }

    private JComponent addTextArea(TAppDialogsObject tAppDialogsObject, TDriverStructRecord tDriverStructRecord) {
        int n = 0;
        int n2 = 0;
        n = 0;
        switch (tDriverStructRecord.FieldType) {
            case 24: {
                n = tDriverStructRecord.ArraySize - 1;
                break;
            }
            case 3: {
                n = tDriverStructRecord.ArraySize;
                break;
            }
            case 26: {
                n = tDriverStructRecord.ArraySize;
                break;
            }
            case 11: {
                n = tDriverStructRecord.ArraySize - 1;
            }
        }
        if (!charutil.nullstr(tDriverStructRecord.MaxValue) && (n2 = charutil.ival(tDriverStructRecord.MaxValue)) > 0) {
            n = Math.min(n, n2);
        }
        n2 = 0;
        if (!charutil.nullstr(tDriverStructRecord.MinValue)) {
            n2 = charutil.ival(tDriverStructRecord.MinValue);
        }
        JTextArea jTextArea = new JTextArea();
        jTextArea.addVetoableChangeListener(this);
        jTextArea.addFocusListener(this);
        jTextArea.setEditable(true);
        TTextArea tTextArea = new TTextArea(jTextArea, tAppDialogsObject.ControlID, n2, n);
        if (tAppDialogsObject.ReadOnly) {
            jTextArea.setEditable(false);
            jTextArea.setBackground(Color.white);
        }
        return tTextArea;
    }

    private Object transferTextArea(TScrollDialogPanelControl tScrollDialogPanelControl, Object object, int n) {
        TTextArea tTextArea = (TTextArea)tScrollDialogPanelControl.ControlObj;
        if (n == 0) {
            if (object instanceof String) {
                tTextArea.setText((String)object);
            } else {
                tTextArea.setText("");
            }
            tTextArea.setRows(tTextArea.textArea.getLineCount());
            tTextArea.setCaretPosition(0);
            return object;
        }
        return tTextArea.getText();
    }

    private JComponent addHtmlViewer(TAppDialogsObject tAppDialogsObject, TDriverStructRecord tDriverStructRecord) {
        THtmlViewer tHtmlViewer = new THtmlViewer(new THtmlEditorPane("text/html", ""));
        tHtmlViewer.addListener(this);
        return tHtmlViewer;
    }

    private Object transferHtmlViewer(TScrollDialogPanelControl tScrollDialogPanelControl, Object object, int n) {
        THtmlViewer tHtmlViewer = (THtmlViewer)tScrollDialogPanelControl.ControlObj;
        if (n == 0) {
            if (object instanceof String) {
                tHtmlViewer.setText((String)object, false, true);
            } else {
                tHtmlViewer.setText(objectutil.convertToString(object), false, true);
            }
            return object;
        }
        object = tHtmlViewer.getText();
        return object;
    }

    private JComponent addPassword(TAppDialogsObject tAppDialogsObject, TDriverStructRecord tDriverStructRecord) {
        Rectangle rectangle = this.scaleControl(tAppDialogsObject);
        int n = 0;
        int n2 = 0;
        n = 0;
        switch (tDriverStructRecord.FieldType) {
            case 24: {
                n = tDriverStructRecord.ArraySize - 1;
                break;
            }
            case 3: {
                n = tDriverStructRecord.ArraySize;
                break;
            }
            case 26: {
                n = tDriverStructRecord.ArraySize;
                break;
            }
            case 11: {
                n = tDriverStructRecord.ArraySize - 1;
            }
        }
        if (!charutil.nullstr(tDriverStructRecord.MaxValue) && (n2 = charutil.ival(tDriverStructRecord.MaxValue)) > 0) {
            n = Math.min(n, n2);
        }
        n2 = 0;
        if (!charutil.nullstr(tDriverStructRecord.MinValue)) {
            n2 = charutil.ival(tDriverStructRecord.MinValue);
        }
        TPassword tPassword = new TPassword(tAppDialogsObject.ControlID, n2, n);
        tPassword.addActionListener(this);
        return tPassword;
    }

    private Object transferPassword(TScrollDialogPanelControl tScrollDialogPanelControl, Object object, int n) {
        TPassword tPassword = (TPassword)tScrollDialogPanelControl.ControlObj;
        if (n == 0) {
            if (object instanceof String) {
                tPassword.setText((String)object);
            } else {
                tPassword.setText("");
            }
            return object;
        }
        char[] cArray = tPassword.getPassword();
        return new String(cArray);
    }

    private JComponent addIntegerSpinner(TAppDialogsObject tAppDialogsObject, TDriverStructRecord tDriverStructRecord) {
        StringBuilder stringBuilder = new StringBuilder();
        Rectangle rectangle = this.scaleControl(tAppDialogsObject);
        TIntegerSpinner tIntegerSpinner = new TIntegerSpinner(tAppDialogsObject.ControlID.toString());
        tIntegerSpinner.addChangeListener(this);
        tIntegerSpinner.getEditor().addFocusListener(this);
        int n = charutil.ival(tDriverStructRecord.MinValue);
        int n2 = charutil.ival(tDriverStructRecord.MaxValue);
        int n3 = charutil.ival(tDriverStructRecord.StepValue);
        if (n2 < n) {
            n2 = n;
        }
        if (n == 0 && n2 == 0) {
            n2 = TAbstractDriver.getMaxFieldValue(tDriverStructRecord.FieldType);
        }
        if (n3 == 0) {
            n3 = 1;
        }
        tIntegerSpinner.setMinimum(n);
        tIntegerSpinner.setMaximum(n2);
        tIntegerSpinner.setStepSize(n3);
        if (tAppDialogsObject.Mnemonic != '\u0000') {
            ((JSpinner.DefaultEditor)tIntegerSpinner.getEditor()).getTextField().setFocusAccelerator(tAppDialogsObject.Mnemonic);
        }
        tIntegerSpinner.getTextField().addFocusListener(this);
        return tIntegerSpinner;
    }

    private Object transferIntegerSpinner(TScrollDialogPanelControl tScrollDialogPanelControl, Object object, int n) {
        TIntegerSpinner tIntegerSpinner = (TIntegerSpinner)tScrollDialogPanelControl.ControlObj;
        if (n == 0) {
            if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long) {
                tIntegerSpinner.setValue(object);
            } else {
                tIntegerSpinner.setValue(new Integer(0));
            }
            return object;
        }
        return tIntegerSpinner.getValue();
    }

    private JComponent addFloatInput(TAppDialogsObject tAppDialogsObject, TDriverStructRecord tDriverStructRecord) {
        double d = 0.0;
        double d2 = TAbstractDriver.getMaxFieldValue(tDriverStructRecord.FieldType);
        double d3 = 0.01;
        if (tDriverStructRecord.MinValue.length() > 0) {
            d = charutil.dval(tDriverStructRecord.MinValue);
        }
        if (tDriverStructRecord.MaxValue.length() > 0) {
            d2 = charutil.dval(tDriverStructRecord.MaxValue);
        }
        if (tDriverStructRecord.StepValue.length() > 0) {
            d3 = charutil.dval(tDriverStructRecord.StepValue);
        }
        TIntegerSpinner tIntegerSpinner = new TIntegerSpinner(0.0, d, d2, d3);
        tIntegerSpinner.addChangeListener(this);
        tIntegerSpinner.getEditor().addFocusListener(this);
        return tIntegerSpinner;
    }

    private Object transferFloatInput(TScrollDialogPanelControl tScrollDialogPanelControl, Object object, int n) {
        TIntegerSpinner tIntegerSpinner = (TIntegerSpinner)tScrollDialogPanelControl.ControlObj;
        if (n == 0) {
            if (object instanceof Double || object instanceof Float) {
                tIntegerSpinner.setValue(object);
            } else {
                tIntegerSpinner.setValue(new Double(0.0));
            }
            return object;
        }
        return tIntegerSpinner.getValue();
    }

    private JComponent addDateSpinner(TAppDialogsObject tAppDialogsObject, TDriverStructRecord tDriverStructRecord, int n) {
        Rectangle rectangle = this.scaleControl(tAppDialogsObject);
        TDateSpinner tDateSpinner = new TDateSpinner(tAppDialogsObject.ControlID.toString(), n);
        tDateSpinner.addChangeListener(this);
        tDateSpinner.getEditor().addFocusListener(this);
        if (tAppDialogsObject.ReadOnly) {
            tDateSpinner.getTextField().setEditable(false);
            tDateSpinner.setEnabled(false);
            tDateSpinner.getTextField().setBackground(Color.white);
        }
        return tDateSpinner;
    }

    private Object transferDateSpinner(TScrollDialogPanelControl tScrollDialogPanelControl, Object object, int n) {
        TDateSpinner tDateSpinner = (TDateSpinner)tScrollDialogPanelControl.ControlObj;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        if (n == 0) {
            if (object instanceof Date) {
                tDateSpinner.setValue((Date)object);
                return object;
            }
            tDateSpinner.setValue(new Date());
        }
        Date date = (Date)tDateSpinner.getValue();
        return date;
    }

    private JComponent addComboBox(TAppDialogsObject tAppDialogsObject, TDriverStructRecord tDriverStructRecord) {
        TComboBoxColl tComboBoxColl = new TComboBoxColl(true, 0);
        Rectangle rectangle = this.scaleControl(tAppDialogsObject);
        boolean bl = false;
        TComboBox tComboBox = new TComboBox(tAppDialogsObject.ControlID, tComboBoxColl, tDriverStructRecord.FieldType);
        if (tAppDialogsObject.ControlType == 47 || tAppDialogsObject.ControlType == 8) {
            tComboBox.setEditable(true);
        }
        tComboBox.addActionListener(this);
        tComboBox.addItemListener(this);
        tComboBox.addFocusListener(this);
        return tComboBox;
    }

    private Object transferComboBox(TScrollDialogPanelControl tScrollDialogPanelControl, Object object, int n, TDriverStructRecord tDriverStructRecord) {
        TComboBoxColl tComboBoxColl = null;
        Object object2 = null;
        TComboBox tComboBox = (TComboBox)tScrollDialogPanelControl.ControlObj;
        if (n == 0) {
            if (tScrollDialogPanelControl.AppDialogsObject.ControlType == 5 || tScrollDialogPanelControl.AppDialogsObject.ControlType == 47) {
                String string = tDriverStructRecord.CollectionID;
                TFormulaEvaluator tFormulaEvaluator = this.AspectDriver.getFormulaEvaluator();
                if (tFormulaEvaluator != null && tDriverStructRecord.AlternateCollection.length() > 0) {
                    Object object3 = tFormulaEvaluator.getFormulaValue(tDriverStructRecord.AlternateCollection, this.AspectDriver.getAbsoluteDiskIndex(this.RecordNumber), 0);
                    if (object3 instanceof String) {
                        string = (String)object3;
                    }
                    this.HasAlternateCollections = true;
                }
                if (tDriverStructRecord.CollectionID.equalsIgnoreCase("StructureFields") && tDriverStructRecord.Formula.length() > 0) {
                    this.HasAlternateCollections = true;
                }
                this.AspectDriver.getFormulaEvaluator().setAltRecordNumber(this.AspectDriver.getAbsoluteDiskIndex(this.RecordNumber));
                tComboBoxColl = tScrollDialogPanelControl.AppDialogsObject.ControlType == 5 ? this.AspectDriver.getComboBoxColl(tScrollDialogPanelControl.AppDialogsObject.ControlID.toString(), tDriverStructRecord.Formula, this.AspectDriver.getFormulaEvaluator(), true, false, this.RecordNumber) : this.AspectDriver.getComboBoxColl(tScrollDialogPanelControl.AppDialogsObject.ControlID.toString(), tDriverStructRecord.Formula, this.AspectDriver.getFormulaEvaluator(), true, true, this.RecordNumber);
                if (tComboBoxColl != null) {
                    tComboBox.setComboBoxColl(tComboBoxColl, object);
                } else {
                    this.MainWin.appendToLog("TScrollDialogPanel", "transferComboBox", Thread.currentThread(), null, 4, "Invalid collection for combo box with ID = " + tScrollDialogPanelControl.ControlID);
                }
            } else if (tScrollDialogPanelControl.AppDialogsObject.ControlType == 8) {
                TDriverStructRecord tDriverStructRecord2 = null;
                TDriverStructRecord tDriverStructRecord3 = this.AspectDriver.getDriverStructRecord(tScrollDialogPanelControl.AppDialogsObject.ControlID.toString());
                if (tDriverStructRecord3.EditorParams.length() > 0) {
                    tDriverStructRecord2 = this.AspectDriver.getDriverStructRecord(tDriverStructRecord3.EditorParams);
                    if (tDriverStructRecord2 == null) {
                        tDriverStructRecord2 = this.AspectDriver.getDriverStructRecordFromDescription(tDriverStructRecord3.EditorParams);
                    }
                } else {
                    tDriverStructRecord2 = tDriverStructRecord3;
                }
                if (tDriverStructRecord2 != null) {
                    ArrayList arrayList = this.AspectDriver.makeCollectionOfValues(tDriverStructRecord2);
                    tComboBoxColl = new TComboBoxColl(true, arrayList.size());
                    for (int i = 0; i < arrayList.size(); ++i) {
                        tComboBoxColl.add((String)arrayList.get(i), (String)arrayList.get(i));
                    }
                }
                if (tComboBoxColl == null) {
                    tComboBoxColl = new TComboBoxColl(true, 0);
                }
                tComboBox.setComboBoxColl(tComboBoxColl, object);
            }
            return object;
        }
        object2 = tScrollDialogPanelControl.AppDialogsObject.ControlType == 5 ? tComboBox.getSelectedKey() : (tScrollDialogPanelControl.AppDialogsObject.ControlType == 47 ? tComboBox.getSelectedKey() : tComboBox.getSelectedItem());
        return object2;
    }

    private JComponent addCheckBox(TAppDialogsObject tAppDialogsObject, TDriverStructRecord tDriverStructRecord) {
        Rectangle rectangle = this.scaleControl(tAppDialogsObject);
        TCheckBox tCheckBox = new TCheckBox(tAppDialogsObject.ControlID, tAppDialogsObject.ControlLabel);
        tCheckBox.addActionListener(this);
        tCheckBox.addChangeListener(this);
        tCheckBox.addItemListener(this);
        if (tAppDialogsObject.Mnemonic != '\u0000') {
            tCheckBox.setMnemonic(tAppDialogsObject.Mnemonic);
        }
        return tCheckBox;
    }

    private Object transferCheckBox(TScrollDialogPanelControl tScrollDialogPanelControl, Object object, int n) {
        TCheckBox tCheckBox = (TCheckBox)tScrollDialogPanelControl.ControlObj;
        if (n == 0) {
            if (object instanceof Boolean) {
                tCheckBox.setSelected((Boolean)object);
            } else {
                tCheckBox.setSelected(false);
            }
            return object;
        }
        Object[] objectArray = tCheckBox.getSelectedObjects();
        boolean bl = true;
        if (objectArray == null || objectArray[0] == null) {
            bl = false;
        }
        return new Boolean(bl);
    }

    private JComponent addFileList(TAppDialogsObject tAppDialogsObject, TDriverStructRecord tDriverStructRecord) {
        TAppDriversObject tAppDriversObject = null;
        TScrollTablePanel tScrollTablePanel = null;
        TDialogTablePanel tDialogTablePanel = null;
        TAspectDriver tAspectDriver = null;
        Rectangle rectangle = this.scaleControl(tAppDialogsObject);
        StringBuilder stringBuilder = new StringBuilder();
        this.Application.parse_tokens(stringBuilder, tAppDialogsObject.DriverID);
        tAppDriversObject = this.Application.AppDrivers.getAppDriversObject(stringBuilder);
        if (tAppDriversObject != null) {
            if (this.arFileList != null) {
                for (int i = 0; i < this.arFileList.size(); ++i) {
                    TAspectDriver tAspectDriver2 = (TAspectDriver)this.arFileList.get(i);
                    if (tAspectDriver2.FileName.length() > 0 && tAspectDriver2.FileName.toString().equalsIgnoreCase(tAppDriversObject.FileName.toString())) {
                        tAspectDriver = new TAspectDriver(this.Application, tAppDriversObject, (TAbstractDriver)tAspectDriver2.F, true, true);
                        tAspectDriver.setHashComboBoxColl(tAspectDriver2.getHashComboBoxColl());
                        continue;
                    }
                    if (tAppDriversObject.FileType != 8 || tAspectDriver2.AppDriverObj.FileType != 8) continue;
                    tAspectDriver = new TAspectDriver(this.Application, tAppDriversObject, (TAbstractDriver)tAspectDriver2.F, true, true);
                    tAspectDriver.setHashComboBoxColl(tAspectDriver2.getHashComboBoxColl());
                }
            }
            if (tAspectDriver == null) {
                this.MainWin.executeDriverPreActions(tAppDriversObject);
                tAspectDriver = new TAspectDriver(this.Application, tAppDriversObject, 1, true, "");
                tAspectDriver.initCollections();
                tAspectDriver.createUndoManager();
                if (this.arFileList == null) {
                    this.arFileList = new ArrayList();
                }
                this.arFileList.add(tAspectDriver);
            }
            tScrollTablePanel = new TScrollTablePanel(Aspect.MainWin, this, this.Application, tAppDriversObject, tAspectDriver);
            tScrollTablePanel.Table.getModel().addTableModelListener(this);
            tScrollTablePanel.Table.addFocusListener(this);
            tDialogTablePanel = new TDialogTablePanel();
            tDialogTablePanel.addTablePanel(tScrollTablePanel);
            if (tAppDialogsObject.Transparent) {
                tDialogTablePanel.setOpaque(true);
            }
        } else {
            this.MainWin.appendToLog("TScrollDialogPanel", "addFileList", Thread.currentThread(), null, 4, "Cannot locate a driver with the ID '" + tAppDialogsObject.DriverID + "'");
        }
        return tDialogTablePanel;
    }

    private JComponent addFilterTree(TAppDialogsObject tAppDialogsObject, TDriverStructRecord tDriverStructRecord) {
        TAppDriversObject tAppDriversObject = null;
        TScrollFilterTree tScrollFilterTree = null;
        JScrollPane jScrollPane = null;
        TAspectDriver tAspectDriver = null;
        StringBuilder stringBuilder = new StringBuilder();
        this.Application.parse_tokens(stringBuilder, tAppDialogsObject.DriverID);
        tAppDriversObject = this.Application.AppDrivers.getAppDriversObject(stringBuilder);
        if (tAppDriversObject != null) {
            if (tAspectDriver == null) {
                this.MainWin.executeDriverPreActions(tAppDriversObject);
                tAspectDriver = new TAspectDriver(this.Application, tAppDriversObject, 1, true, "");
                tAspectDriver.initCollections();
                if (this.arFileList == null) {
                    this.arFileList = new ArrayList();
                }
                this.arFileList.add(tAspectDriver);
            }
            tScrollFilterTree = new TScrollFilterTree(new TScrollFilterTreeNode(tAppDriversObject.Description.toString(), true), this, tAspectDriver);
            tScrollFilterTree.setCheckboxes(false);
            jScrollPane = new JScrollPane(tScrollFilterTree);
        } else {
            this.MainWin.appendToLog("TScrollDialogPanel", "addFileList", Thread.currentThread(), null, 4, "Cannot locate a driver with the ID '" + tAppDialogsObject.DriverID + "'");
        }
        return jScrollPane;
    }

    public String setFileList(String string, TAspectDriver tAspectDriver) {
        TScrollDialogPanelControl tScrollDialogPanelControl = this.getControlWithId(string);
        if (tScrollDialogPanelControl == null) {
            return "Cannot locate control with ID=" + string;
        }
        if (!(tScrollDialogPanelControl.ControlObj instanceof TDialogTablePanel)) {
            return "Control with ID=" + string + " is not a table";
        }
        if (this.arFileList == null) {
            this.arFileList = new ArrayList();
        }
        this.arFileList.add(tAspectDriver);
        TScrollTablePanel tScrollTablePanel = new TScrollTablePanel(Aspect.MainWin, this, this.Application, tAspectDriver.AppDriverObj, tAspectDriver);
        tScrollTablePanel.Table.getModel().addTableModelListener(this);
        tScrollTablePanel.Table.addFocusListener(this);
        ((TDialogTablePanel)tScrollDialogPanelControl.ControlObj).setTablePanel(tScrollTablePanel);
        tScrollTablePanel.setOpaque(true);
        if (tScrollDialogPanelControl.AppDialogsObject.Transparent) {
            tScrollDialogPanelControl.ControlObj.setOpaque(false);
        }
        if (tScrollDialogPanelControl.AppDialogsObject.OverrideBackgroundColor) {
            tScrollDialogPanelControl.ControlObj.setBackground(new Color(tScrollDialogPanelControl.AppDialogsObject.BackgroundColor));
        }
        return "ok";
    }

    public String setFileList(String string, String string2, String string3) {
        TScrollDialogPanelControl tScrollDialogPanelControl = this.getControlWithId(string);
        if (tScrollDialogPanelControl == null) {
            return "Cannot locate control with ID=" + string;
        }
        if (!(tScrollDialogPanelControl.ControlObj instanceof TDialogTablePanel)) {
            return "Control with ID=" + string + " is not a table";
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.Application.parse_tokens(stringBuilder, string2);
        TAppDriversObject tAppDriversObject = this.Application.AppDrivers.getAppDriversObject(stringBuilder);
        if (tAppDriversObject == null) {
            return "Unrecognized driver ID: " + string2;
        }
        this.MainWin.executeDriverPreActions(tAppDriversObject);
        TAspectDriver tAspectDriver = null;
        String string4 = charutil.getParamValue(string3, "HashID", '|');
        if (string4.trim().length() > 0) {
            if (tAppDriversObject != null) {
                tAspectDriver = TFormulaEvaluator.getCache().openCacheDriver(string4, tAppDriversObject.DriverID.toString(), 1, string3);
                tAspectDriver.setActiveFilter("true", true);
            } else {
                this.MainWin.appendToLog("TScrollDialogPanel", "setFileList", Thread.currentThread(), null, 4, "Invalid or missing driver ID in driver params");
            }
        } else {
            tAspectDriver = new TAspectDriver(this.Application, tAppDriversObject, 1, true, string3);
        }
        tAspectDriver.initCollections();
        tAspectDriver.createUndoManager();
        if (this.arFileList == null) {
            this.arFileList = new ArrayList();
        }
        this.arFileList.add(tAspectDriver);
        TScrollTablePanel tScrollTablePanel = new TScrollTablePanel(Aspect.MainWin, this, this.Application, tAppDriversObject, tAspectDriver);
        tScrollTablePanel.Table.getModel().addTableModelListener(this);
        tScrollTablePanel.Table.addFocusListener(this);
        ((TDialogTablePanel)tScrollDialogPanelControl.ControlObj).setTablePanel(tScrollTablePanel);
        tScrollTablePanel.setOpaque(true);
        if (tScrollDialogPanelControl.AppDialogsObject.Transparent) {
            tScrollDialogPanelControl.ControlObj.setOpaque(false);
        }
        if (tScrollDialogPanelControl.AppDialogsObject.OverrideBackgroundColor) {
            tScrollDialogPanelControl.ControlObj.setBackground(new Color(tScrollDialogPanelControl.AppDialogsObject.BackgroundColor));
        }
        return "ok";
    }

    private boolean isValidControl(TAppDialogsObject tAppDialogsObject, TDriverStructRecord tDriverStructRecord) {
        boolean bl = false;
        switch (tAppDialogsObject.ControlType) {
            case 1: 
            case 50: 
            case 67: {
                bl = true;
                break;
            }
            case 10: 
            case 14: 
            case 20: 
            case 21: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 66: {
                bl = true;
                break;
            }
            case 7: 
            case 68: {
                bl = true;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 47: 
            case 52: {
                if (tDriverStructRecord == null) break;
                bl = true;
            }
        }
        return bl;
    }

    private Image getHashedImage(String string) {
        Image image = imageutil.getScaledImage(this.getClass(), string, -1, -1);
        if (image != null) {
            // empty if block
        }
        return image;
    }

    private static int getControlType(TAppDialogsObject tAppDialogsObject) {
        int n = -1;
        if (tAppDialogsObject == null) {
            return -1;
        }
        switch (tAppDialogsObject.ControlType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 66: 
            case 67: 
            case 68: {
                n = 1;
                break;
            }
            case 16: {
                n = 0;
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                n = 2;
                break;
            }
            case 31: {
                n = 3;
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                n = 7;
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                n = 4;
                break;
            }
            case 43: {
                n = 5;
                break;
            }
            case 44: {
                n = 6;
                break;
            }
            case 69: {
                n = 8;
                break;
            }
            case 70: {
                n = 9;
                break;
            }
            case 71: {
                n = 10;
            }
        }
        return n;
    }

    public void transferValues(int n, int n2) {
        if (this.IsPreview) {
            return;
        }
        this.IsTransferring = true;
        this.notifyListenersBeginTransferValues(n2);
        if (this.Debug) {
            this.MainWin.appendToLog("TScrollDialogPanel", "transferValues", Thread.currentThread(), null, 3, "TScrollDialogPanel.transferValues(" + n + "," + n2 + ")");
        }
        if (n2 == 0) {
            this.RecordNumber = n;
            int n3 = this.AspectDriver.getAbsoluteDiskIndex(n);
            TMainWin.Application.setTokenValue("DialogEditingRecord", Integer.toString(n));
            TMainWin.Application.setTokenValue("DialogEditingRecordAbsolute", Integer.toString(n3));
        }
        for (int i = 0; i < this.arControls.size(); ++i) {
            TScrollDialogPanelControl tScrollDialogPanelControl = (TScrollDialogPanelControl)this.arControls.get(i);
            TDriverStructRecord tDriverStructRecord = this.AspectDriver.DriverStruct.getField(tScrollDialogPanelControl.ControlID);
            Object object = null;
            if (n2 == 0) {
                object = this.AspectDriver.getField(tScrollDialogPanelControl.ControlID, n);
            }
            switch (tScrollDialogPanelControl.ControlType) {
                case 1: {
                    this.transferLabel(tScrollDialogPanelControl, n2);
                    break;
                }
                case 14: {
                    object = this.transferImage(tScrollDialogPanelControl, object, n2);
                    break;
                }
                case 2: {
                    object = this.transferInputBox(tScrollDialogPanelControl, object, n2);
                    break;
                }
                case 3: {
                    object = this.transferCheckBox(tScrollDialogPanelControl, object, n2);
                    break;
                }
                case 4: {
                    break;
                }
                case 5: 
                case 8: 
                case 47: {
                    object = this.transferComboBox(tScrollDialogPanelControl, object, n2, tDriverStructRecord);
                    break;
                }
                case 6: {
                    break;
                }
                case 17: 
                case 24: 
                case 25: {
                    object = this.transferDateSpinner(tScrollDialogPanelControl, object, n2);
                    break;
                }
                case 18: {
                    object = this.transferIntegerSpinner(tScrollDialogPanelControl, object, n2);
                    break;
                }
                case 19: {
                    object = this.transferFloatInput(tScrollDialogPanelControl, object, n2);
                    break;
                }
                case 22: {
                    object = this.transferTextArea(tScrollDialogPanelControl, object, n2);
                    break;
                }
                case 52: {
                    object = this.transferHtmlViewer(tScrollDialogPanelControl, object, n2);
                    break;
                }
                case 23: {
                    object = this.transferPassword(tScrollDialogPanelControl, object, n2);
                    break;
                }
                case 9: {
                    object = this.transferColorChooser(tScrollDialogPanelControl, object, n2);
                }
            }
            if (n2 == 0 && tScrollDialogPanelControl.ControlType == 7) {
                ((TDialogTablePanel)tScrollDialogPanelControl.ControlObj).Table.refreshTable();
            }
            if (n2 != 1) continue;
            if (object != null) {
                if (this.AspectDriver.getRecordCount() <= n) {
                    this.AspectDriver.initializeNewRecord(this.AspectDriver.AppDriverObj.InsertMode, n);
                }
                this.AspectDriver.putField(tScrollDialogPanelControl.ControlID, n, object);
            }
            if (tScrollDialogPanelControl.ControlType != 7) continue;
            ((TDialogTablePanel)tScrollDialogPanelControl.ControlObj).Table.stopEditing();
        }
        this.notifyListenersEndTransferValues(n2);
        this.IsTransferring = false;
    }

    public void enableScrollWinCommands(TScrollTable tScrollTable) {
        TAspectDriver tAspectDriver = tScrollTable.AspectDriver;
    }

    @Override
    public void paintAll(Graphics graphics) {
        super.paintAll(graphics);
    }

    @Override
    public void paintComponents(Graphics graphics) {
        super.paintComponents(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
    }

    @Override
    public void update(Graphics graphics) {
        super.update(graphics);
    }

    public void browse(TScrollDialogPanelControl tScrollDialogPanelControl, int n) {
        TScrollDialogPanelControl tScrollDialogPanelControl2;
        int n2;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(n);
        if (FileChooserDefault != null) {
            jFileChooser.setCurrentDirectory(FileChooserDefault);
        }
        if ((n2 = jFileChooser.showOpenDialog(this)) == 0 && (tScrollDialogPanelControl2 = this.getControlWithId(tScrollDialogPanelControl.AppDialogsObject.Params)) != null) {
            String string = jFileChooser.getSelectedFile().getPath();
            FileChooserDefault = new File(string);
            if (tScrollDialogPanelControl2.ControlObj instanceof TTextField) {
                ((TTextField)tScrollDialogPanelControl2.ControlObj).setText(string);
            } else if (tScrollDialogPanelControl2.ControlObj instanceof TComboBox) {
                ((TComboBox)tScrollDialogPanelControl2.ControlObj).setText(string);
            }
        }
    }

    public void Ok() {
        this.transferValues(this.RecordNumber, 1);
        this.ReturnValue = "ok";
    }

    public void Cancel() {
        this.ReturnValue = "cancel";
    }

    public void Close(String string) {
        this.transferValues(this.RecordNumber, 1);
        this.ReturnValue = string;
    }

    public void createPanel() {
        Object var4_1 = null;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        this.setOpaque(false);
        ArrayList arrayList = this.EditDialogsDriver != null ? this.EditDialogsDriver.getResourceElements(this.DialogID) : (this.altResourceElements != null ? this.altResourceElements : this.Application.getResourceElements(9, this.DialogID));
        TContainerStack tContainerStack = new TContainerStack(this);
        for (int i = 0; i < arrayList.size(); ++i) {
            TAppDialogsObject tAppDialogsObject = (TAppDialogsObject)arrayList.get(i);
            if (this.TitleStr == null) {
                this.TitleStr = tAppDialogsObject.Description.toString();
            }
            int n = TScrollDialogPanel.getControlType(tAppDialogsObject);
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    JComponent jComponent = tContainerStack.addControl(tAppDialogsObject);
                    if (jComponent == null) break;
                    jComponent.addFocusListener(this);
                    this.arControls.add(new TScrollDialogPanelControl(this.arControls.size(), tAppDialogsObject, jComponent));
                    if (this.DefaultFocus != null || tAppDialogsObject.ControlType == 1 || tAppDialogsObject.ControlType == 14) break;
                    this.DefaultFocus = jComponent;
                    this.DefaultFocus.addComponentListener(this);
                    if (!this.Debug) break;
                    this.MainWin.appendToLog("TScrollDialogPanel", "createPanel", Thread.currentThread(), null, 10, "Setting default focus to Type=" + tAppDialogsObject.ControlType + " ID=" + tAppDialogsObject.ControlID);
                    break;
                }
                case 2: {
                    tContainerStack.startPanel(tAppDialogsObject);
                    break;
                }
                case 3: {
                    tContainerStack.endPanel(tAppDialogsObject);
                    break;
                }
                case 4: {
                    tContainerStack.startTabbedPane(tAppDialogsObject);
                    break;
                }
                case 5: {
                    tContainerStack.endTabbedPane(tAppDialogsObject);
                    break;
                }
                case 6: {
                    tContainerStack.startNewTab(tAppDialogsObject);
                    break;
                }
                case 7: {
                    tContainerStack.addBoxFormatter(tAppDialogsObject);
                    break;
                }
                case 8: {
                    tContainerStack.startSplitPane(tAppDialogsObject);
                    break;
                }
                case 9: {
                    tContainerStack.addSplitPaneDivider(tAppDialogsObject);
                    break;
                }
                case 10: {
                    tContainerStack.endSplitPane(tAppDialogsObject);
                }
            }
            tContainerStack.outputStack("Control " + Integer.toString(i));
            if (tAppDialogsObject.CallbackTime <= 0) continue;
            if (this.CallbackTimer == null) {
                this.CallbackTime = tAppDialogsObject.CallbackTime;
                this.CallbackTimer = new Timer(this.CallbackTime, new TimerListener());
            } else {
                this.CallbackTime = Math.min(this.CallbackTime, tAppDialogsObject.CallbackTime);
                this.CallbackTimer.setDelay(this.CallbackTime);
            }
            this.CallbackTimer.start();
        }
        tContainerStack.closeoutStack();
    }

    @Override
    public boolean isTokenControl() {
        return false;
    }

    @Override
    public void update(String string, String string2) {
    }

    @Override
    public String getTokenID() {
        return "";
    }

    @Override
    public String getControlValue() {
        return "";
    }

    @Override
    public TAppToolbarObject getAppToolbarObject() {
        return null;
    }

    public int getControlWithId(String string, int n) {
        for (int i = n; i < this.arControls.size(); ++i) {
            TScrollDialogPanelControl tScrollDialogPanelControl = (TScrollDialogPanelControl)this.arControls.get(i);
            if (!tScrollDialogPanelControl.ControlID.equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    public TScrollDialogPanelControl getControlWithId(String string) {
        TScrollDialogPanelControl tScrollDialogPanelControl;
        int n;
        for (n = 0; n < this.arControls.size(); ++n) {
            tScrollDialogPanelControl = (TScrollDialogPanelControl)this.arControls.get(n);
            if (!tScrollDialogPanelControl.ControlID.equalsIgnoreCase(string)) continue;
            return tScrollDialogPanelControl;
        }
        this.MainWin.appendToLog("TScrollDialogPanel", "getControlWithId", Thread.currentThread(), null, 4, "Cannot locate input control with ID of " + string);
        for (n = 0; n < this.arControls.size(); ++n) {
            tScrollDialogPanelControl = (TScrollDialogPanelControl)this.arControls.get(n);
            System.out.println("DialogControl.ControlID=" + tScrollDialogPanelControl.ControlID);
        }
        return null;
    }

    public TScrollTablePanel getTablePanelWithDriverID(String string) {
        for (int i = 0; i < this.arControls.size(); ++i) {
            TScrollDialogPanelControl tScrollDialogPanelControl = (TScrollDialogPanelControl)this.arControls.get(i);
            if (!(tScrollDialogPanelControl.ControlObj instanceof TDialogTablePanel) || !((TDialogTablePanel)tScrollDialogPanelControl.ControlObj).AspectDriver.getDriverID().equalsIgnoreCase(string)) continue;
            return ((TDialogTablePanel)tScrollDialogPanelControl.ControlObj).TablePanel;
        }
        return null;
    }

    public Object getValueOfControl(TScrollDialogPanelControl tScrollDialogPanelControl) {
        Object object = null;
        switch (tScrollDialogPanelControl.ControlType) {
            case 1: {
                object = this.transferLabel(tScrollDialogPanelControl, 1);
                break;
            }
            case 14: {
                object = this.transferImage(tScrollDialogPanelControl, object, 1);
                break;
            }
            case 2: {
                object = this.transferInputBox(tScrollDialogPanelControl, object, 1);
                break;
            }
            case 3: {
                object = this.transferCheckBox(tScrollDialogPanelControl, object, 1);
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 8: 
            case 47: {
                TDriverStructRecord tDriverStructRecord = this.AspectDriver.DriverStruct.getField(tScrollDialogPanelControl.ControlID);
                object = this.transferComboBox(tScrollDialogPanelControl, object, 1, tDriverStructRecord);
                break;
            }
            case 6: {
                break;
            }
            case 17: 
            case 24: 
            case 25: {
                object = this.transferDateSpinner(tScrollDialogPanelControl, object, 1);
                break;
            }
            case 18: {
                object = this.transferIntegerSpinner(tScrollDialogPanelControl, object, 1);
                break;
            }
            case 19: {
                object = this.transferFloatInput(tScrollDialogPanelControl, object, 1);
                break;
            }
            case 22: {
                object = this.transferTextArea(tScrollDialogPanelControl, object, 1);
                break;
            }
            case 52: {
                object = this.transferHtmlViewer(tScrollDialogPanelControl, object, 1);
                break;
            }
            case 23: {
                object = this.transferPassword(tScrollDialogPanelControl, object, 1);
                break;
            }
            case 9: {
                object = this.transferColorChooser(tScrollDialogPanelControl, object, 1);
            }
        }
        return object;
    }

    public String setValueOfControl(TScrollDialogPanelControl tScrollDialogPanelControl, String string) {
        Object object = null;
        switch (tScrollDialogPanelControl.ControlType) {
            case 2: {
                this.transferInputBox(tScrollDialogPanelControl, string, 0);
                break;
            }
            case 3: {
                object = new Boolean(charutil.boolval(string));
                this.transferCheckBox(tScrollDialogPanelControl, object, 0);
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 8: 
            case 47: {
                ((TComboBox)tScrollDialogPanelControl.ControlObj).setComboBoxSelection(string);
                break;
            }
            case 6: {
                break;
            }
            case 17: 
            case 24: 
            case 25: {
                object = objectutil.convertStringToFieldType(13, string, 0);
                this.transferDateSpinner(tScrollDialogPanelControl, object, 0);
                break;
            }
            case 18: {
                object = new Integer(charutil.ival(string));
                this.transferIntegerSpinner(tScrollDialogPanelControl, object, 0);
                break;
            }
            case 19: {
                object = objectutil.convertStringToFieldType(8, string, 0);
                this.transferFloatInput(tScrollDialogPanelControl, object, 0);
                break;
            }
            case 22: {
                this.transferTextArea(tScrollDialogPanelControl, string, 0);
                break;
            }
            case 52: {
                this.transferHtmlViewer(tScrollDialogPanelControl, string, 0);
                break;
            }
            case 23: {
                this.transferPassword(tScrollDialogPanelControl, string, 0);
                break;
            }
            case 9: {
                object = new Integer(charutil.ival(string));
                this.transferColorChooser(tScrollDialogPanelControl, object, 0);
                break;
            }
            default: {
                return "not supported";
            }
        }
        return "ok";
    }

    public Object getControlValue(String string) {
        TScrollDialogPanelControl tScrollDialogPanelControl = this.getControlWithId(string);
        if (tScrollDialogPanelControl == null) {
            this.MainWin.appendToLog("TScrollDialogPanel", "getControlValue", Thread.currentThread(), null, 4, "Cannot locate control with ID of " + string);
            return null;
        }
        return this.getValueOfControl(tScrollDialogPanelControl);
    }

    public String putControlValue(String string, String string2) {
        TScrollDialogPanelControl tScrollDialogPanelControl = this.getControlWithId(string);
        if (tScrollDialogPanelControl == null) {
            this.MainWin.appendToLog("TScrollDialogPanel", "putControlValue", Thread.currentThread(), null, 4, "Cannot locate control with ID of " + string);
            return "Could not locate control with ID=" + string;
        }
        return this.setValueOfControl(tScrollDialogPanelControl, string2);
    }

    public String enableControl(String string, boolean bl) {
        TScrollDialogPanelControl tScrollDialogPanelControl = this.getControlWithId(string);
        if (tScrollDialogPanelControl == null) {
            this.MainWin.appendToLog("TScrollDialogPanel", "enableControl", Thread.currentThread(), null, 4, "Cannot locate control with ID of " + string);
            return "Could not locate control with ID=" + string;
        }
        tScrollDialogPanelControl.ControlObj.setEnabled(bl);
        return "ok";
    }

    public String setFocus(String string) {
        TScrollDialogPanelControl tScrollDialogPanelControl = this.getControlWithId(string);
        System.out.println("TScrollDialogPanel.setFocus");
        if (tScrollDialogPanelControl == null) {
            this.MainWin.appendToLog("TScrollDialogPanel", "enableControl", Thread.currentThread(), null, 4, "Cannot locate control with ID of " + string);
            return "Could not locate control with ID=" + string;
        }
        tScrollDialogPanelControl.ControlObj.requestFocus();
        tScrollDialogPanelControl.ControlObj.requestFocusInWindow();
        return "ok";
    }

    public boolean isControlVisible(String string) {
        TScrollDialogPanelControl tScrollDialogPanelControl = this.getControlWithId(string);
        if (tScrollDialogPanelControl == null) {
            return false;
        }
        return tScrollDialogPanelControl.ControlObj.isVisible();
    }

    public TScrollDialogPanelControl getScrollDialogPanelControl(Object object) {
        boolean bl = false;
        for (int i = 0; !bl && i < this.arControls.size(); ++i) {
            TScrollDialogPanelControl tScrollDialogPanelControl = (TScrollDialogPanelControl)this.arControls.get(i);
            if (!(tScrollDialogPanelControl.ControlType == 7 ? ((TDialogTablePanel)tScrollDialogPanelControl.ControlObj).Table.getTableModel().equals(object) : tScrollDialogPanelControl.ControlObj.equals(object))) continue;
            return tScrollDialogPanelControl;
        }
        return null;
    }

    public void updateComboBoxCollections() {
        Object object;
        TDriverStructRecord tDriverStructRecord;
        int n;
        if (this.IsPreview) {
            return;
        }
        if (this.IsTransferring) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        boolean bl = false;
        for (n = 0; n < this.AspectDriver.DriverStruct.FieldColl.size(); ++n) {
            tDriverStructRecord = (TDriverStructRecord)this.AspectDriver.DriverStruct.FieldColl.get(n);
            if (tDriverStructRecord.IsVirtual || tDriverStructRecord.IsCalculated || (object = this.AspectDriver.getField(tDriverStructRecord.FullID, this.RecordNumber)) == null) continue;
            hashtable.put(tDriverStructRecord.FullID, object);
        }
        this.transferValues(this.RecordNumber, 1);
        for (n = 0; n < this.arControls.size(); ++n) {
            TScrollDialogPanelControl tScrollDialogPanelControl = (TScrollDialogPanelControl)this.arControls.get(n);
            if (tScrollDialogPanelControl.ControlType != 5 && tScrollDialogPanelControl.ControlType != 47) continue;
            tDriverStructRecord = this.AspectDriver.DriverStruct.getField(tScrollDialogPanelControl.ControlID);
            if (!tDriverStructRecord.CollectionID.equalsIgnoreCase("StructureFields") && tDriverStructRecord.AlternateCollection.length() <= 0 && tDriverStructRecord.Formula.length() <= 0) continue;
            object = this.transferComboBox(tScrollDialogPanelControl, null, 1, tDriverStructRecord);
            this.IsTransferring = true;
            this.transferComboBox(tScrollDialogPanelControl, object, 0, tDriverStructRecord);
            this.transferValues(this.RecordNumber, 1);
            this.IsTransferring = false;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.AspectDriver.putField(string, this.RecordNumber, hashtable.get(string));
        }
        hashtable.clear();
    }

    public void updateLabels() {
        int n;
        if (this.IsPreview) {
            return;
        }
        if (this.IsTransferring) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        if (this.RecordNumber < 0) {
            return;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        for (n = 0; n < this.AspectDriver.DriverStruct.FieldColl.size(); ++n) {
            Object object;
            TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)this.AspectDriver.DriverStruct.FieldColl.get(n);
            if (tDriverStructRecord.IsVirtual || tDriverStructRecord.IsCalculated || (object = this.AspectDriver.getField(tDriverStructRecord.FullID, this.RecordNumber)) == null) continue;
            hashtable.put(tDriverStructRecord.FullID, object);
        }
        this.transferValues(this.RecordNumber, 1);
        for (n = 0; n < this.arControls.size(); ++n) {
            TScrollDialogPanelControl tScrollDialogPanelControl = (TScrollDialogPanelControl)this.arControls.get(n);
            if (tScrollDialogPanelControl.ControlType != 1 || !tScrollDialogPanelControl.AppDialogsObject.ControlLabel.toString().startsWith("=") && (tScrollDialogPanelControl.AppDialogsObject.ControlLabel.length() != 0 || tScrollDialogPanelControl.AppDialogsObject.ControlID.length() <= 0)) continue;
            this.IsTransferring = true;
            this.transferLabel(tScrollDialogPanelControl, 0);
            this.IsTransferring = false;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.AspectDriver.putField(string, this.RecordNumber, hashtable.get(string));
        }
        hashtable.clear();
    }

    public TScrollDialogPanelControl getHtmlViewer(String string) {
        for (int i = 0; i < this.arControls.size(); ++i) {
            TScrollDialogPanelControl tScrollDialogPanelControl = (TScrollDialogPanelControl)this.arControls.get(i);
            if (tScrollDialogPanelControl.ControlType != 52 || !tScrollDialogPanelControl.ControlID.equalsIgnoreCase(string)) continue;
            return tScrollDialogPanelControl;
        }
        this.MainWin.appendToLog("TScrollDialogPanel", "getControlWithId", Thread.currentThread(), null, 4, "Cannot locate html viewer with ID of " + string);
        return null;
    }

    public TScrollDialogPanelControl getHtmlViewerBackButton(String string) {
        for (int i = 0; i < this.arControls.size(); ++i) {
            TScrollDialogPanelControl tScrollDialogPanelControl = (TScrollDialogPanelControl)this.arControls.get(i);
            if (tScrollDialogPanelControl.ControlType != 54 || !tScrollDialogPanelControl.ControlID.equalsIgnoreCase(string)) continue;
            return tScrollDialogPanelControl;
        }
        return null;
    }

    public TScrollDialogPanelControl getHtmlViewerNextButton(String string) {
        for (int i = 0; i < this.arControls.size(); ++i) {
            TScrollDialogPanelControl tScrollDialogPanelControl = (TScrollDialogPanelControl)this.arControls.get(i);
            if (tScrollDialogPanelControl.ControlType != 55 || !tScrollDialogPanelControl.ControlID.equalsIgnoreCase(string)) continue;
            return tScrollDialogPanelControl;
        }
        return null;
    }

    public void enableHtmlViewerButtons() {
        for (int i = 0; i < this.arControls.size(); ++i) {
            TButton tButton;
            TScrollDialogPanelControl tScrollDialogPanelControl = (TScrollDialogPanelControl)this.arControls.get(i);
            if (tScrollDialogPanelControl.ControlType != 52) continue;
            THtmlViewer tHtmlViewer = (THtmlViewer)tScrollDialogPanelControl.ControlObj;
            TScrollDialogPanelControl tScrollDialogPanelControl2 = this.getHtmlViewerBackButton(tScrollDialogPanelControl.ControlID);
            if (tScrollDialogPanelControl2 != null) {
                tButton = (TButton)tScrollDialogPanelControl2.ControlObj;
                if (tHtmlViewer.getStackCount(0) <= 0) {
                    tButton.setEnabled(false);
                } else {
                    tButton.setEnabled(true);
                }
            }
            if ((tScrollDialogPanelControl2 = this.getHtmlViewerNextButton(tScrollDialogPanelControl.ControlID)) == null) continue;
            tButton = (TButton)tScrollDialogPanelControl2.ControlObj;
            if (tHtmlViewer.getStackCount(1) <= 0) {
                tButton.setEnabled(false);
                continue;
            }
            tButton.setEnabled(true);
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        String string = hyperlinkEvent.getURL().toString();
        String string2 = string.toUpperCase();
        if (string2.startsWith("HTTP://SCRIPT.") || string2.startsWith("HTTP://ACTION.") || string2.startsWith("HTTP://DRIVERCMD.") || string2.startsWith("HTTP://DIALOG.") || string2.startsWith("HTTP://VIEW.")) {
            if (this.getParent() instanceof TDesktopPane && this.RecordNumber >= 0) {
                this.transferValues(this.RecordNumber, 1);
            }
            this.Close(string.substring(7));
            this.notifyListenersClose();
        } else {
            this.enableHtmlViewerButtons();
            if (this.arListeners.size() > 0) {
                this.notifyListeners(10, hyperlinkEvent);
            }
        }
    }

    public void notifyListeners(int n, EventObject eventObject) {
        TScrollDialogPanelControl tScrollDialogPanelControl = this.getScrollDialogPanelControl(eventObject.getSource());
        TScrollDialogPanelEvent tScrollDialogPanelEvent = new TScrollDialogPanelEvent(this, tScrollDialogPanelControl, n, eventObject);
        for (int i = 0; i < this.arListeners.size(); ++i) {
            ((TScrollDialogPanelListenerInterface)this.arListeners.get(i)).scrollDialogPanelEventOccurred(tScrollDialogPanelEvent);
        }
    }

    public void notifyListenersOk() {
        for (int i = 0; i < this.arListeners.size(); ++i) {
            TScrollDialogPanelListenerInterface tScrollDialogPanelListenerInterface = (TScrollDialogPanelListenerInterface)this.arListeners.get(i);
            tScrollDialogPanelListenerInterface.ok();
        }
    }

    public void notifyListenersCancel() {
        for (int i = 0; i < this.arListeners.size(); ++i) {
            TScrollDialogPanelListenerInterface tScrollDialogPanelListenerInterface = (TScrollDialogPanelListenerInterface)this.arListeners.get(i);
            tScrollDialogPanelListenerInterface.cancel();
        }
    }

    public void notifyListenersClose() {
        for (int i = 0; i < this.arListeners.size(); ++i) {
            TScrollDialogPanelListenerInterface tScrollDialogPanelListenerInterface = (TScrollDialogPanelListenerInterface)this.arListeners.get(i);
            tScrollDialogPanelListenerInterface.close(this.getReturnValue());
        }
    }

    public void notifyListenersNextRecord() {
        for (int i = 0; i < this.arListeners.size(); ++i) {
            TScrollDialogPanelListenerInterface tScrollDialogPanelListenerInterface = (TScrollDialogPanelListenerInterface)this.arListeners.get(i);
            tScrollDialogPanelListenerInterface.nextRecord();
        }
    }

    public void notifyListenersPreviousRecord() {
        for (int i = 0; i < this.arListeners.size(); ++i) {
            TScrollDialogPanelListenerInterface tScrollDialogPanelListenerInterface = (TScrollDialogPanelListenerInterface)this.arListeners.get(i);
            tScrollDialogPanelListenerInterface.previousRecord();
        }
    }

    public void notifyListenersFirstRecord() {
        for (int i = 0; i < this.arListeners.size(); ++i) {
            TScrollDialogPanelListenerInterface tScrollDialogPanelListenerInterface = (TScrollDialogPanelListenerInterface)this.arListeners.get(i);
            tScrollDialogPanelListenerInterface.firstRecord();
        }
    }

    public void notifyListenersLastRecord() {
        for (int i = 0; i < this.arListeners.size(); ++i) {
            TScrollDialogPanelListenerInterface tScrollDialogPanelListenerInterface = (TScrollDialogPanelListenerInterface)this.arListeners.get(i);
            tScrollDialogPanelListenerInterface.lastRecord();
        }
    }

    public void notifyListenersRecordGoto(int n) {
        for (int i = 0; i < this.arListeners.size(); ++i) {
            TScrollDialogPanelListenerInterface tScrollDialogPanelListenerInterface = (TScrollDialogPanelListenerInterface)this.arListeners.get(i);
            tScrollDialogPanelListenerInterface.gotoRecord(n);
        }
    }

    public void notifyListenersBeginTransferValues(int n) {
        for (int i = 0; i < this.arListeners.size(); ++i) {
            TScrollDialogPanelListenerInterface tScrollDialogPanelListenerInterface = (TScrollDialogPanelListenerInterface)this.arListeners.get(i);
            tScrollDialogPanelListenerInterface.beginTransferValues(this, n);
        }
    }

    public void notifyListenersEndTransferValues(int n) {
        for (int i = 0; i < this.arListeners.size(); ++i) {
            TScrollDialogPanelListenerInterface tScrollDialogPanelListenerInterface = (TScrollDialogPanelListenerInterface)this.arListeners.get(i);
            tScrollDialogPanelListenerInterface.endTransferValues(this, n);
        }
    }

    public boolean canClose() {
        boolean bl = true;
        return bl;
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        if (this.DefaultFocus != null) {
            this.DefaultFocus.requestFocus();
            System.out.println("requesting focus");
        }
    }

    public void stopTableEditing() {
        for (int i = 0; i < this.arControls.size(); ++i) {
            TScrollDialogPanelControl tScrollDialogPanelControl = (TScrollDialogPanelControl)this.arControls.get(i);
            if (tScrollDialogPanelControl.ControlType != 7) continue;
            ((TDialogTablePanel)tScrollDialogPanelControl.ControlObj).Table.stopEditing();
        }
    }

    @Override
    public void filterTreeNodeChanged(TScrollFilterTreeNodeEvent tScrollFilterTreeNodeEvent) {
        TScrollFilterTreeNode tScrollFilterTreeNode = tScrollFilterTreeNodeEvent.getSource();
        String string = "TreeNodeSelected_" + tScrollFilterTreeNode.DriverID;
        if (TMainWin.Application.AppScripts.isResourceDefined(string)) {
            TExecScript tExecScript = new TExecScript(string, null, null);
            tExecScript.setParameters(Integer.toString(tScrollFilterTreeNode.Record));
            tExecScript.start();
        } else {
            System.out.println("Script not defined: " + string);
        }
    }

    @Override
    public synchronized Object notifyApplicationEvent(TApplicationListenerEvent tApplicationListenerEvent) {
        final String string = tApplicationListenerEvent.getTokenValue();
        String string2 = tApplicationListenerEvent.getTokenID();
        String string3 = null;
        if (string2.equalsIgnoreCase("DialogMessage") && string.equalsIgnoreCase("UpdateComboBox")) {
            this.updateComboBoxCollections();
        }
        for (int i = 0; i < this.arControls.size(); ++i) {
            Object object;
            JComponent jComponent;
            TScrollDialogPanelControl tScrollDialogPanelControl = (TScrollDialogPanelControl)this.arControls.get(i);
            if (tScrollDialogPanelControl.ControlType == 50) {
                if (tApplicationListenerEvent.getEventType() != 0 || !tScrollDialogPanelControl.AppDialogsObject.ControlLabel.toString().equalsIgnoreCase(string2)) continue;
                jComponent = (TLabel)tScrollDialogPanelControl.ControlObj;
                object = new SwingWorker((TLabel)jComponent, string){
                    final /* synthetic */ TLabel val$label;
                    final /* synthetic */ String val$TokenValue;
                    {
                        this.val$label = tLabel;
                        this.val$TokenValue = string;
                    }

                    @Override
                    public Object construct() {
                        return null;
                    }

                    @Override
                    public void finished() {
                        this.val$label.setText(this.val$TokenValue);
                    }
                };
                ((SwingWorker)object).start();
                continue;
            }
            if (tScrollDialogPanelControl.ControlType == 67) {
                if (tApplicationListenerEvent.getEventType() != 0 || !tScrollDialogPanelControl.AppDialogsObject.IconFile.equalsIgnoreCase(string2)) continue;
                jComponent = (JLabel)tScrollDialogPanelControl.ControlObj;
                object = this.Application.getTokenValue(charutil.removeQuotes(tScrollDialogPanelControl.AppDialogsObject.IconFile));
                SwingWorker swingWorker = new SwingWorker((String)object, (JLabel)jComponent){
                    final /* synthetic */ String val$String1;
                    final /* synthetic */ JLabel val$label;
                    {
                        this.val$String1 = string;
                        this.val$label = jLabel;
                    }

                    @Override
                    public Object construct() {
                        return null;
                    }

                    @Override
                    public void finished() {
                        if (this.val$String1.length() > 0) {
                            Image image = imageutil.getScaledImage(this.getClass(), this.val$String1, -1, -1);
                            try {
                                ImageIcon imageIcon = new ImageIcon(image);
                                imageIcon.setImageObserver(this.val$label);
                                this.val$label.setIcon(imageIcon);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                };
                swingWorker.start();
                continue;
            }
            if (tScrollDialogPanelControl.ControlType != 52) continue;
            if (tApplicationListenerEvent.getEventType() == 0) {
                if (!tScrollDialogPanelControl.AppDialogsObject.ControlLabel.toString().equalsIgnoreCase(string2)) continue;
                jComponent = (THtmlViewer)tScrollDialogPanelControl.ControlObj;
                object = new SwingWorker((THtmlViewer)jComponent){
                    final /* synthetic */ THtmlViewer val$HtmlViewer;
                    {
                        this.val$HtmlViewer = tHtmlViewer;
                    }

                    @Override
                    public Object construct() {
                        return null;
                    }

                    @Override
                    public void finished() {
                        if (string.equalsIgnoreCase("home")) {
                            this.val$HtmlViewer.homePage();
                        } else {
                            this.val$HtmlViewer.refresh();
                        }
                    }
                };
                ((SwingWorker)object).start();
                continue;
            }
            if (tApplicationListenerEvent.getEventType() == 1) {
                ((THtmlViewer)tScrollDialogPanelControl.ControlObj).setElementText(string2, string);
                continue;
            }
            if (tApplicationListenerEvent.getEventType() != 2) continue;
            string3 = ((THtmlViewer)tScrollDialogPanelControl.ControlObj).getElementText(string2);
        }
        return string3;
    }

    public void buttonPressed(TButtonAction tButtonAction, ActionEvent actionEvent) {
        this.stopTableEditing();
        this.notifyListeners(0, actionEvent);
        TScrollDialogPanelControl tScrollDialogPanelControl = this.getScrollDialogPanelControl(actionEvent.getSource());
        int n = (Integer)tButtonAction.getValue("ControlType");
        String string = (String)tButtonAction.getValue("ActionID");
        String string2 = (String)tButtonAction.getValue("ActionDriverCmd");
        String string3 = (String)tButtonAction.getValue("ActionParameters");
        String string4 = (String)tButtonAction.getValue("Name");
        TScrollDialogPanelControl tScrollDialogPanelControl2 = this.getControlWithId(tScrollDialogPanelControl.AppDialogsObject.Params);
        if (n == 49) {
            if (this.getParent() instanceof TDesktopPane && this.RecordNumber >= 0) {
                this.transferValues(this.RecordNumber, 1);
            }
            if (tScrollDialogPanelControl.AppDialogsObject.CloseOnAction) {
                this.Close(string4);
                this.notifyListenersClose();
            }
            if (tScrollDialogPanelControl2 != null && tScrollDialogPanelControl2.ControlObj instanceof TDialogTablePanel) {
                this.MainWin.executeActionObject(tButtonAction, ((TDialogTablePanel)tScrollDialogPanelControl2.ControlObj).TablePanel);
            } else {
                this.MainWin.executeActionObject(tButtonAction, null);
            }
        } else if (n == 61) {
            if (this.getParent() instanceof TDesktopPane && this.RecordNumber >= 0) {
                this.transferValues(this.RecordNumber, 1);
            }
            TExecScript tExecScript = new TExecScript(tScrollDialogPanelControl.AppDialogsObject.ScriptID, null, null);
            String[] stringArray = charutil.getSubStringArray(tScrollDialogPanelControl.AppDialogsObject.DriverCmdParams, ',', true);
            if (stringArray != null && stringArray.length > 0) {
                tExecScript.setParameters(stringArray);
            }
            tExecScript.start();
        } else if (n == 48) {
            if (this.getParent() instanceof TDesktopPane && this.RecordNumber >= 0) {
                this.transferValues(this.RecordNumber, 1);
            }
            if (tScrollDialogPanelControl2 != null && tScrollDialogPanelControl2.ControlObj instanceof TDialogTablePanel) {
                this.Application.setTokenValue("$ScrollWinFileID", ((TDialogTablePanel)tScrollDialogPanelControl2.ControlObj).AspectDriver.AppDriverObj.DriverID.toString());
                this.Application.setTokenValue("$ScrollWinDisplayName", ((TDialogTablePanel)tScrollDialogPanelControl2.ControlObj).AspectDriver.AppDriverObj.Description.toString());
                ((TDialogTablePanel)tScrollDialogPanelControl2.ControlObj).Table.executeDriverCommand(tScrollDialogPanelControl.getDriverCmd(), tScrollDialogPanelControl.getDriverCmdParams());
            } else {
                tButtonAction.putValue("ActionType", new Integer(31));
                this.MainWin.executeActionObject(tButtonAction, null);
            }
        } else if (n == 20) {
            if (this.canClose()) {
                this.Ok();
                this.notifyListenersOk();
            }
        } else if (n == 21) {
            this.Cancel();
            this.notifyListenersCancel();
        } else if (n == 51) {
            this.Close(string4);
            this.notifyListenersClose();
        } else if (n == 56) {
            this.Close("RecordNext");
            this.notifyListenersNextRecord();
        } else if (n == 57) {
            this.Close("RecordPrevious");
            this.notifyListenersPreviousRecord();
        } else if (n == 58) {
            this.Close("RecordFirst");
            this.notifyListenersFirstRecord();
        } else if (n == 59) {
            this.Close("RecordLast");
            this.notifyListenersLastRecord();
        } else if (n == 66) {
            TScrollDialogPanelControl tScrollDialogPanelControl3 = this.getControlWithId(tScrollDialogPanelControl.AppDialogsObject.Params);
            if (tScrollDialogPanelControl3 != null) {
                this.Close("RecordGoto");
                Object object = this.getValueOfControl(tScrollDialogPanelControl3);
                int n2 = (int)objectutil.convertToNumber(object);
                this.notifyListenersRecordGoto(n2);
            } else {
                this.MainWin.appendToLog("TScrollDialogPanel", "buttonPressed", Thread.currentThread(), null, 4, "Cannot locate control with ID='" + tScrollDialogPanelControl.AppDialogsObject.Params + "'");
            }
        } else if (n == 9) {
            JColorChooser jColorChooser = new JColorChooser();
            if (tScrollDialogPanelControl.ControlObj instanceof JButton) {
                jColorChooser.setColor(((JButton)tScrollDialogPanelControl.ControlObj).getForeground());
            }
            ColorChooserOkListener colorChooserOkListener = new ColorChooserOkListener(jColorChooser, (JButton)actionEvent.getSource());
            JDialog jDialog = JColorChooser.createDialog((JComponent)actionEvent.getSource(), "Pick a Color", true, jColorChooser, colorChooserOkListener, null);
            jDialog.setVisible(true);
        } else if (n == 45) {
            this.browse(tScrollDialogPanelControl, 0);
        } else if (n == 60) {
            this.browse(tScrollDialogPanelControl, 2);
        } else if (n == 46) {
            this.browse(tScrollDialogPanelControl, 1);
        } else if (n == 53) {
            TScrollDialogPanelControl tScrollDialogPanelControl4 = this.getHtmlViewer(tScrollDialogPanelControl.ControlID);
            if (tScrollDialogPanelControl4 != null) {
                THtmlViewer tHtmlViewer = (THtmlViewer)tScrollDialogPanelControl4.ControlObj;
                tHtmlViewer.homePage();
            }
            this.enableHtmlViewerButtons();
        } else if (n == 54) {
            TScrollDialogPanelControl tScrollDialogPanelControl5 = this.getHtmlViewer(tScrollDialogPanelControl.ControlID);
            if (tScrollDialogPanelControl5 != null) {
                THtmlViewer tHtmlViewer = (THtmlViewer)tScrollDialogPanelControl5.ControlObj;
                tHtmlViewer.previousPage();
            }
            this.enableHtmlViewerButtons();
        } else if (n == 55) {
            TScrollDialogPanelControl tScrollDialogPanelControl6 = this.getHtmlViewer(tScrollDialogPanelControl.ControlID);
            if (tScrollDialogPanelControl6 != null) {
                THtmlViewer tHtmlViewer = (THtmlViewer)tScrollDialogPanelControl6.ControlObj;
                tHtmlViewer.nextPage();
            }
            this.enableHtmlViewerButtons();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        this.stopTableEditing();
        TScrollDialogPanelControl tScrollDialogPanelControl = this.getScrollDialogPanelControl(actionEvent.getSource());
        String string = actionEvent.getActionCommand();
        this.updateComboBoxCollections();
        this.notifyListeners(0, actionEvent);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (new Date().getTime() - starttime > 60000L) {
            this.notifyListeners(1, tableModelEvent);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() instanceof TScrollTable) {
            this.enableScrollWinCommands((TScrollTable)focusEvent.getSource());
        }
        if (focusEvent.getSource() instanceof JTextField) {
            final JTextField jTextField = (JTextField)focusEvent.getSource();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    jTextField.selectAll();
                }
            });
        }
        this.notifyListeners(2, focusEvent);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.notifyListeners(3, focusEvent);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.updateLabels();
        this.notifyListeners(4, changeEvent);
    }

    @Override
    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateLabels();
        this.notifyListeners(5, propertyChangeEvent);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateLabels();
        this.notifyListeners(6, listSelectionEvent);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.updateLabels();
        this.notifyListeners(7, itemEvent);
    }

    public void executeTimerCallback() {
        for (int i = 0; i < this.arControls.size(); ++i) {
            TScrollDialogPanelControl tScrollDialogPanelControl = (TScrollDialogPanelControl)this.arControls.get(i);
            if (tScrollDialogPanelControl.AppDialogsObject.CallbackTime <= 0) continue;
            if (tScrollDialogPanelControl.ControlType == 50) {
                String string = this.Application.getTokenValue(tScrollDialogPanelControl.AppDialogsObject.ControlLabel.toString());
                if (((TLabel)tScrollDialogPanelControl.ControlObj).getText().equalsIgnoreCase(string)) continue;
                ((TLabel)tScrollDialogPanelControl.ControlObj).setText(string);
                continue;
            }
            if (tScrollDialogPanelControl.ControlType != 52) continue;
            ((THtmlViewer)tScrollDialogPanelControl.ControlObj).refresh();
        }
        --this.cCallbacks;
    }

    class TimerListener
    implements ActionListener {
        TimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (TScrollDialogPanel.this.cCallbacks > 0) {
                return;
            }
            ++TScrollDialogPanel.this.cCallbacks;
            SwingWorker swingWorker = new SwingWorker(){

                @Override
                public Object construct() {
                    return null;
                }

                @Override
                public void finished() {
                    TScrollDialogPanel.this.executeTimerCallback();
                }
            };
            swingWorker.start();
        }
    }

    public class HorizontalTextIcon
    implements Icon,
    SwingConstants {
        private final int textIconGap = 10;
        private TAppDialogsObject AppDialogsObject;
        private Font font;
        private Color color;
        private FontMetrics fm;
        private ImageIcon imageIcon = null;
        private String text;
        private int width;
        private int height;

        public HorizontalTextIcon(String string, TAppDialogsObject tAppDialogsObject) {
            Image image;
            this.AppDialogsObject = tAppDialogsObject;
            this.font = objectutil.makeFont(this.AppDialogsObject.FontName, this.AppDialogsObject.FontStyle, this.AppDialogsObject.FontSize);
            this.color = new Color(this.AppDialogsObject.FontColor);
            this.fm = new JLabel().getFontMetrics(this.font);
            this.text = string;
            this.width = SwingUtilities.computeStringWidth(this.fm, string);
            this.height = this.fm.getHeight();
            if (this.AppDialogsObject.IconFile.length() > 0 && (image = imageutil.getScaledImage(this.getClass(), charutil.removeQuotes(this.AppDialogsObject.IconFile), -1, -1)) != null) {
                this.imageIcon = new ImageIcon(image);
                this.imageIcon.setImageObserver(TScrollDialogPanel.this);
                this.width += this.imageIcon.getIconWidth();
                this.height = Math.max(this.height, this.imageIcon.getIconHeight());
                if (string.trim().length() > 0) {
                    this.width += 10;
                }
            }
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Font font = graphics.getFont();
            Color color = graphics.getColor();
            graphics.setFont(this.font);
            graphics.setColor(this.color);
            if (this.imageIcon != null) {
                graphics.drawImage(this.imageIcon.getImage(), n, n2 + (this.height - this.imageIcon.getIconHeight()) / 2, this.imageIcon.getImageObserver());
                n += this.imageIcon.getIconWidth() + 10;
            }
            graphics.drawString(this.text, n, n2 + this.height - (this.height - this.fm.getAscent()));
            graphics.setFont(font);
            graphics.setColor(color);
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }

    public class VerticalTextIcon
    implements Icon,
    SwingConstants {
        private final int textIconGap = 10;
        private TAppDialogsObject AppDialogsObject;
        private Font font;
        private Color color;
        private FontMetrics fm;
        private ImageIcon imageIcon = null;
        private String text;
        private int width;
        private int height;
        private boolean clockwize;

        public VerticalTextIcon(String string, boolean bl, TAppDialogsObject tAppDialogsObject) {
            Image image;
            this.AppDialogsObject = tAppDialogsObject;
            this.font = objectutil.makeFont(tAppDialogsObject.FontName, tAppDialogsObject.FontStyle, tAppDialogsObject.FontSize);
            this.color = new Color(tAppDialogsObject.FontColor);
            this.fm = new JLabel().getFontMetrics(this.font);
            this.text = string;
            this.width = SwingUtilities.computeStringWidth(this.fm, string);
            this.height = this.fm.getHeight();
            if (this.AppDialogsObject.IconFile.length() > 0 && (image = imageutil.getScaledImage(this.getClass(), charutil.removeQuotes(this.AppDialogsObject.IconFile), -1, -1)) != null) {
                this.imageIcon = new ImageIcon(image);
                this.imageIcon.setImageObserver(TScrollDialogPanel.this);
                this.width += this.imageIcon.getIconHeight();
                this.height = Math.max(this.height, this.imageIcon.getIconWidth());
                if (string.trim().length() > 0) {
                    this.height += 10;
                }
            }
            this.clockwize = bl;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Font font = graphics.getFont();
            Color color = graphics.getColor();
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics.setFont(this.font);
            graphics.setColor(this.color);
            if (this.clockwize) {
                graphics2D.translate(n + this.getIconWidth(), n2);
                graphics2D.rotate(1.5707963267948966);
            } else {
                graphics2D.translate(n, n2 + this.getIconHeight());
                graphics2D.rotate(-1.5707963267948966);
            }
            if (this.imageIcon != null) {
                graphics.drawImage(this.imageIcon.getImage(), 0, (this.height - this.imageIcon.getIconHeight()) / 2, this.imageIcon.getImageObserver());
                graphics.drawString(this.text, this.imageIcon.getIconWidth() + 10, this.fm.getLeading() + this.fm.getAscent());
            } else {
                graphics.drawString(this.text, 0, this.fm.getLeading() + this.fm.getAscent());
            }
            graphics.setFont(font);
            graphics.setColor(color);
            graphics2D.setTransform(affineTransform);
        }

        @Override
        public int getIconWidth() {
            return this.height;
        }

        @Override
        public int getIconHeight() {
            return this.width;
        }
    }

    private class TEmptyBorder
    extends MatteBorder {
        public TEmptyBorder(int n, int n2, int n3, int n4, Color color) {
            super(n, n2, n3, n4, color);
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            super.paintBorder(component, graphics, n, n2, n3, n4);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return super.getBorderInsets(component);
        }
    }

    public class TContainerStack
    extends Stack {
        private TPanel ContentPane;

        public TContainerStack(TPanel tPanel) {
            this.ContentPane = tPanel;
        }

        public void outputStack(String string) {
            if (!TScrollDialogPanel.this.Debug) {
                return;
            }
            System.out.println("Output stack: " + string);
            if (this.empty()) {
                System.out.println("Stack is empty");
            } else {
                Stack stack = new Stack();
                int n = 0;
                while (!this.empty()) {
                    stack.push(this.pop());
                }
                while (!stack.empty()) {
                    TContainerStackObj tContainerStackObj = (TContainerStackObj)stack.pop();
                    tContainerStackObj.outputStackObj(Integer.toString(n++));
                    this.push(tContainerStackObj);
                }
            }
        }

        public TContainerStackObj getTopContainerFromStack() {
            if (this.empty()) {
                this.ContentPane.setLayout(new FlowLayout(3));
                this.push(new TContainerStackObj(null, this.ContentPane, 28));
            }
            TContainerStackObj tContainerStackObj = (TContainerStackObj)this.peek();
            if (TScrollDialogPanel.getControlType(tContainerStackObj.AppDialogsObject) == 4) {
                this.push(new TContainerStackObj(tContainerStackObj.AppDialogsObject, null, -1));
            }
            if (TScrollDialogPanel.getControlType(tContainerStackObj.AppDialogsObject) == 6) {
                JPanel jPanel = new JPanel(new FlowLayout(3));
                jPanel.setOpaque(false);
                this.push(new TContainerStackObj(null, jPanel, 28));
                tContainerStackObj = (TContainerStackObj)this.peek();
            }
            return tContainerStackObj;
        }

        public void setFont(TAppDialogsObject tAppDialogsObject, JComponent jComponent) {
            JComponent jComponent2 = jComponent;
            if (jComponent instanceof TTextArea) {
                jComponent2 = ((TTextArea)jComponent).textArea;
            } else if (jComponent instanceof TIntegerSpinner) {
                jComponent2 = ((TIntegerSpinner)jComponent).getTextField();
            } else if (jComponent instanceof TDateSpinner) {
                jComponent2 = ((TDateSpinner)jComponent).getTextField();
            }
            objectutil.setFont(jComponent2, tAppDialogsObject.FontName, tAppDialogsObject.FontSize, tAppDialogsObject.FontStyle);
            jComponent2.setForeground(new Color(tAppDialogsObject.FontColor));
        }

        public void setAlignment(TAppDialogsObject tAppDialogsObject, JComponent jComponent) {
            if (tAppDialogsObject.ControlAlignX > 0) {
                switch (tAppDialogsObject.ControlAlignX) {
                    case 1: {
                        jComponent.setAlignmentX(0.0f);
                        break;
                    }
                    case 2: {
                        jComponent.setAlignmentX(1.0f);
                        break;
                    }
                    case 3: {
                        jComponent.setAlignmentX(0.5f);
                    }
                }
            }
            if (tAppDialogsObject.ControlAlignY > 0) {
                switch (tAppDialogsObject.ControlAlignY) {
                    case 1: {
                        jComponent.setAlignmentY(0.0f);
                        break;
                    }
                    case 2: {
                        jComponent.setAlignmentY(1.0f);
                        break;
                    }
                    case 3: {
                        jComponent.setAlignmentY(0.5f);
                    }
                }
            }
        }

        public JComponent addControl(TAppDialogsObject tAppDialogsObject) {
            JComponent jComponent;
            TDriverStructRecord tDriverStructRecord;
            block57: {
                block56: {
                    tDriverStructRecord = null;
                    jComponent = null;
                    StringBuilder stringBuilder = new StringBuilder();
                    if (TScrollDialogPanel.this.Debug) {
                        System.out.println("*** addControl ***");
                    }
                    if (!TScrollDialogPanel.this.IsPreview) break block56;
                    switch (tAppDialogsObject.ControlType) {
                        case 1: {
                            jComponent = TScrollDialogPanel.this.addLabel(tAppDialogsObject);
                            if (tAppDialogsObject.ControlLabel.length() == 0) {
                                ((JLabel)jComponent).setText("Text");
                                break;
                            }
                            break block57;
                        }
                        case 50: {
                            TScrollDialogPanel.this.Application.getTokenValue(stringBuilder, tAppDialogsObject.ControlLabel);
                            if (stringBuilder.length() == 0) {
                                stringBuilder.append((CharSequence)tAppDialogsObject.ControlLabel);
                            }
                            jComponent = TScrollDialogPanel.this.addLabel(tAppDialogsObject);
                            if (stringBuilder.length() == 0) {
                                ((JLabel)jComponent).setText("Text");
                                break;
                            }
                            ((JLabel)jComponent).setText(stringBuilder.toString());
                            break;
                        }
                        case 14: 
                        case 67: {
                            jComponent = TScrollDialogPanel.this.addImage(tAppDialogsObject);
                            break;
                        }
                        case 2: {
                            jComponent = new JTextField();
                            if (tAppDialogsObject.ReadOnly) {
                                ((JTextComponent)jComponent).setEditable(false);
                                break;
                            }
                            break block57;
                        }
                        case 22: {
                            jComponent = new TTextArea(new JTextArea(), new StringBuilder(""), 0, 512);
                            ((TTextArea)jComponent).textArea.setLineWrap(true);
                            ((TTextArea)jComponent).textArea.setWrapStyleWord(true);
                            ((TTextArea)jComponent).setBorder(BorderFactory.createEtchedBorder(0));
                            ((TTextArea)jComponent).textArea.setFont(new JLabel().getFont());
                            if (tAppDialogsObject.ReadOnly) {
                                ((TTextArea)jComponent).textArea.setEditable(false);
                                ((TTextArea)jComponent).textArea.setBackground(Color.white);
                                break;
                            }
                            break block57;
                        }
                        case 52: {
                            jComponent = new THtmlViewer(new THtmlEditorPane("text/html", ""));
                            ((THtmlViewer)jComponent).setText("--- Html Viewer ---", false, true);
                            ((THtmlViewer)jComponent).setBorder(BorderFactory.createEtchedBorder(0));
                            break;
                        }
                        case 23: {
                            jComponent = new JPasswordField();
                            break;
                        }
                        case 18: {
                            jComponent = new TIntegerSpinner("");
                            break;
                        }
                        case 19: {
                            jComponent = new JTextField();
                            break;
                        }
                        case 17: 
                        case 24: 
                        case 25: {
                            JComponent jComponent2;
                            jComponent = new TDateSpinner("", 2);
                            if (tAppDialogsObject.ReadOnly && (jComponent2 = ((JSpinner)jComponent).getEditor()) instanceof JSpinner.DefaultEditor) {
                                ((JSpinner.DefaultEditor)jComponent2).getTextField().setEditable(false);
                                break;
                            }
                            break block57;
                        }
                        case 5: 
                        case 8: 
                        case 47: {
                            jComponent = new JComboBox();
                            if (tAppDialogsObject.Transparent) {
                                TComboBox.makeTransparent(((JComboBox)jComponent).getComponents());
                                break;
                            }
                            break block57;
                        }
                        case 3: {
                            jComponent = new TCheckBox(tAppDialogsObject.ControlLabel.toString());
                            break;
                        }
                        case 10: 
                        case 20: 
                        case 21: 
                        case 45: 
                        case 46: 
                        case 48: 
                        case 49: 
                        case 51: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 66: {
                            jComponent = TScrollDialogPanel.this.addButton(tAppDialogsObject);
                            break;
                        }
                        case 9: {
                            jComponent = TScrollDialogPanel.this.addColorChooser(tAppDialogsObject);
                            break;
                        }
                        case 7: {
                            jComponent = TScrollDialogPanel.this.addFileList(tAppDialogsObject, tDriverStructRecord);
                            break;
                        }
                        case 68: {
                            jComponent = TScrollDialogPanel.this.addFilterTree(tAppDialogsObject, tDriverStructRecord);
                            break;
                        }
                        default: {
                            jComponent = null;
                            break;
                        }
                    }
                    break block57;
                }
                tDriverStructRecord = TScrollDialogPanel.this.AspectDriver.DriverStruct.getField(tAppDialogsObject.ControlID);
                if (TScrollDialogPanel.this.isValidControl(tAppDialogsObject, tDriverStructRecord)) {
                    switch (tAppDialogsObject.ControlType) {
                        case 1: {
                            jComponent = TScrollDialogPanel.this.addLabel(tAppDialogsObject);
                            break;
                        }
                        case 50: {
                            jComponent = TScrollDialogPanel.this.addTokenLabel(tAppDialogsObject);
                            break;
                        }
                        case 14: 
                        case 67: {
                            jComponent = TScrollDialogPanel.this.addImage(tAppDialogsObject);
                            break;
                        }
                        case 2: {
                            jComponent = TScrollDialogPanel.this.addInputBox(tAppDialogsObject, tDriverStructRecord);
                            break;
                        }
                        case 22: {
                            jComponent = TScrollDialogPanel.this.addTextArea(tAppDialogsObject, tDriverStructRecord);
                            break;
                        }
                        case 52: {
                            jComponent = TScrollDialogPanel.this.addHtmlViewer(tAppDialogsObject, tDriverStructRecord);
                            break;
                        }
                        case 23: {
                            jComponent = TScrollDialogPanel.this.addPassword(tAppDialogsObject, tDriverStructRecord);
                            break;
                        }
                        case 18: {
                            jComponent = TScrollDialogPanel.this.addIntegerSpinner(tAppDialogsObject, tDriverStructRecord);
                            break;
                        }
                        case 19: {
                            jComponent = TScrollDialogPanel.this.addFloatInput(tAppDialogsObject, tDriverStructRecord);
                            break;
                        }
                        case 17: {
                            jComponent = TScrollDialogPanel.this.addDateSpinner(tAppDialogsObject, tDriverStructRecord, 0);
                            break;
                        }
                        case 24: {
                            jComponent = TScrollDialogPanel.this.addDateSpinner(tAppDialogsObject, tDriverStructRecord, 1);
                            break;
                        }
                        case 25: {
                            jComponent = TScrollDialogPanel.this.addDateSpinner(tAppDialogsObject, tDriverStructRecord, 2);
                            break;
                        }
                        case 5: 
                        case 8: 
                        case 47: {
                            jComponent = TScrollDialogPanel.this.addComboBox(tAppDialogsObject, tDriverStructRecord);
                            break;
                        }
                        case 3: {
                            jComponent = TScrollDialogPanel.this.addCheckBox(tAppDialogsObject, tDriverStructRecord);
                            break;
                        }
                        case 10: 
                        case 20: 
                        case 21: 
                        case 45: 
                        case 46: 
                        case 48: 
                        case 49: 
                        case 51: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 66: {
                            jComponent = TScrollDialogPanel.this.addButton(tAppDialogsObject);
                            break;
                        }
                        case 9: {
                            jComponent = TScrollDialogPanel.this.addColorChooser(tAppDialogsObject);
                            break;
                        }
                        case 7: {
                            jComponent = TScrollDialogPanel.this.addFileList(tAppDialogsObject, tDriverStructRecord);
                            break;
                        }
                        case 68: {
                            jComponent = TScrollDialogPanel.this.addFilterTree(tAppDialogsObject, tDriverStructRecord);
                            break;
                        }
                        default: {
                            jComponent = null;
                            break;
                        }
                    }
                } else {
                    TScrollDialogPanel.this.MainWin.appendToLog("TScrollDialogPanel", "addControl", Thread.currentThread(), null, 4, "Invalid control: " + tAppDialogsObject.ControlID + " in dialog " + tAppDialogsObject.DialogID);
                }
            }
            if (jComponent != null) {
                jComponent.setOpaque(true);
                if (tAppDialogsObject.Transparent) {
                    jComponent.setOpaque(false);
                    if (jComponent instanceof THtmlViewer) {
                        boolean bl = true;
                        ((THtmlViewer)jComponent).setOpaque(false);
                        ((THtmlViewer)jComponent).getEditorPane().setOpaque(false);
                        ((THtmlViewer)jComponent).getViewport().setOpaque(false);
                    } else if (jComponent instanceof TDialogTablePanel) {
                        ((TDialogTablePanel)jComponent).setOpaque(false);
                    }
                }
                this.setFont(tAppDialogsObject, jComponent);
                if (tAppDialogsObject.OverrideBackgroundColor) {
                    jComponent.setBackground(new Color(tAppDialogsObject.BackgroundColor));
                }
                this.setAlignment(tAppDialogsObject, jComponent);
                if (tAppDialogsObject.ReadOnly && tAppDialogsObject.ControlType != 1 && tAppDialogsObject.ControlType != 50) {
                    jComponent.setEnabled(false);
                }
                if (tDriverStructRecord != null && tDriverStructRecord.Tooltip.trim().length() > 0) {
                    jComponent.setToolTipText(charutil.wrapAsHtml(tDriverStructRecord.Tooltip));
                }
                TContainerStackObj tContainerStackObj = this.getTopContainerFromStack();
                tContainerStackObj.add(jComponent, tAppDialogsObject);
            }
            return jComponent;
        }

        public void addBoxFormatter(TAppDialogsObject tAppDialogsObject) {
            TContainerStackObj tContainerStackObj = this.getTopContainerFromStack();
            if (TScrollDialogPanel.this.Debug) {
                System.out.println("*** addBoxFormatter ***");
            }
            Dimension dimension = new Dimension(tAppDialogsObject.ControlW, tAppDialogsObject.ControlH);
            Dimension dimension2 = new Dimension(tAppDialogsObject.MaximumWidth, tAppDialogsObject.MaximumHeight);
            Dimension dimension3 = new Dimension(tAppDialogsObject.MinimumWidth, tAppDialogsObject.MinimumHeight);
            switch (tAppDialogsObject.ControlType) {
                case 32: {
                    tContainerStackObj.container.add(new Box.Filler(dimension3, dimension, dimension2));
                    break;
                }
                case 33: {
                    tContainerStackObj.container.add(Box.createGlue());
                    break;
                }
                case 34: {
                    tContainerStackObj.container.add(Box.createRigidArea(dimension));
                }
            }
        }

        public void startPanel(TAppDialogsObject tAppDialogsObject) {
            TPanel tPanel;
            if (TScrollDialogPanel.this.Debug) {
                System.out.println("*** startPanel ***");
            }
            if (this.empty()) {
                tPanel = this.ContentPane;
                TContainerStackObj tContainerStackObj = new TContainerStackObj(tAppDialogsObject, tPanel, tAppDialogsObject.ControlType);
                tContainerStackObj.setBorder(tPanel, tAppDialogsObject, 0);
                tContainerStackObj.setBorder(tPanel, tAppDialogsObject, 1);
                this.push(tContainerStackObj);
            } else {
                tPanel = new TPanel();
                TScrollDialogPanel.this.arPanelsToDispose.add(tPanel);
                TContainerStackObj tContainerStackObj = new TContainerStackObj(tAppDialogsObject, tPanel, tAppDialogsObject.ControlType);
                tContainerStackObj.setBorder(tPanel, tAppDialogsObject, 0);
                tContainerStackObj.setBorder(tPanel, tAppDialogsObject, 1);
                this.push(tContainerStackObj);
            }
            switch (tAppDialogsObject.ControlType) {
                case 26: {
                    tPanel.setLayout(null);
                    break;
                }
                case 27: {
                    tPanel.setLayout(new BorderLayout(tAppDialogsObject.PanelHorizontalGap, tAppDialogsObject.PanelVerticalGap));
                    break;
                }
                case 28: {
                    int n = 1;
                    switch (tAppDialogsObject.PanelAlignment) {
                        case 1: {
                            n = 0;
                            break;
                        }
                        case 2: {
                            n = 2;
                            break;
                        }
                        case 3: {
                            n = 3;
                            break;
                        }
                        case 4: {
                            n = 1;
                            break;
                        }
                        case 5: {
                            n = 4;
                        }
                    }
                    tPanel.setLayout(new FlowLayout(n, tAppDialogsObject.PanelHorizontalGap, tAppDialogsObject.PanelVerticalGap));
                    break;
                }
                case 29: {
                    int n = 2;
                    if (tAppDialogsObject.PanelAlignment == 7) {
                        n = 3;
                    }
                    tPanel.setLayout(new BoxLayout(tPanel, n));
                    break;
                }
                case 30: {
                    tPanel.setLayout(new GridBagLayout());
                }
            }
            this.setAlignment(tAppDialogsObject, tPanel);
            tPanel.setOpaque(true);
            if (tAppDialogsObject.Transparent) {
                tPanel.setOpaque(false);
            }
            if (tAppDialogsObject.OverrideBackgroundColor) {
                tPanel.setBackground(new Color(tAppDialogsObject.BackgroundColor));
            }
            if (tAppDialogsObject.BackgroundImage.length() > 0) {
                Object object;
                Object object2;
                String string = TScrollDialogPanel.this.Application.parse_tokens(tAppDialogsObject.BackgroundImage);
                if (TScrollDialogPanel.this.AspectDriver != null && (object2 = TScrollDialogPanel.this.AspectDriver.getFormulaEvaluator()) != null && (object = ((TFormulaEvaluator)object2).getFormulaValue(string, 0, 0)) != null) {
                    string = TScrollDialogPanel.this.Application.parse_tokens(TFormulaEvaluator.convertToString(object));
                }
                object2 = TScrollDialogPanel.this.getHashedImage(string);
                tPanel.setImage((Image)object2, tAppDialogsObject.ScaleBackgroundImage);
            }
            if (tAppDialogsObject.ControlW > 0 || tAppDialogsObject.ControlH > 0) {
                tPanel.setPreferredSize(new Dimension(tAppDialogsObject.ControlW, tAppDialogsObject.ControlH));
            }
        }

        public void endPanel(TAppDialogsObject tAppDialogsObject) {
            if (TScrollDialogPanel.this.Debug) {
                System.out.println("*** endPanel ***");
            }
            if (this.size() > 1) {
                TContainerStackObj tContainerStackObj = (TContainerStackObj)this.pop();
                TContainerStackObj tContainerStackObj2 = (TContainerStackObj)this.peek();
                switch (tContainerStackObj2.AppDialogsObject.ControlType) {
                    case 26: {
                        tContainerStackObj.container.setBounds(tContainerStackObj.AppDialogsObject.ControlX, tContainerStackObj.AppDialogsObject.ControlY, tContainerStackObj.AppDialogsObject.ControlW, tContainerStackObj.AppDialogsObject.ControlH);
                        tContainerStackObj2.container.add(tContainerStackObj.container);
                        break;
                    }
                    case 27: {
                        tContainerStackObj2.container.add((Component)tContainerStackObj.container, tContainerStackObj.AppDialogsObject.PanelControlPosition);
                        break;
                    }
                    case 28: {
                        tContainerStackObj2.container.add(tContainerStackObj.container);
                        break;
                    }
                    case 29: {
                        tContainerStackObj2.container.add(tContainerStackObj.container);
                        break;
                    }
                    case 30: {
                        tContainerStackObj2.container.add(tContainerStackObj.container);
                        break;
                    }
                    case 69: 
                    case 70: {
                        tContainerStackObj2.container.add(tContainerStackObj.container);
                        break;
                    }
                    case 44: {
                        if (tContainerStackObj2.container == null) {
                            tContainerStackObj2.container = tContainerStackObj.container;
                            break;
                        }
                        tContainerStackObj2.container.add(tContainerStackObj.container);
                    }
                }
            }
        }

        public JTabbedPane createTabbedPane(TAppDialogsObject tAppDialogsObject, int n, int n2, boolean bl) {
            TTabbedPane tTabbedPane = null;
            Integer n3 = (Integer)UIManager.get("TabbedPane.textIconGap");
            Insets insets = (Insets)UIManager.get("TabbedPane.tabInsets");
            Insets insets2 = (Insets)insets.clone();
            int n4 = n3;
            if (tAppDialogsObject.BorderType[0] != 0) {
                insets.top = tAppDialogsObject.BorderTopWidth[0];
                insets.left = tAppDialogsObject.BorderLeftWidth[0];
                insets.bottom = tAppDialogsObject.BorderBottomWidth[0];
                insets.right = tAppDialogsObject.BorderRightWidth[0];
            }
            if (bl) {
                insets.left = insets2.top;
                insets.top = insets2.right;
                insets.bottom = insets2.left;
                insets.right = insets2.bottom;
            }
            UIManager.put("TabbedPane.textIconGap", new Integer(0));
            UIManager.put("TabbedPane.tabInsets", (Insets)insets.clone());
            tTabbedPane = new TTabbedPane(n, n2);
            UIManager.put("TabbedPane.textIconGap", new Integer(n4));
            UIManager.put("TabbedPane.tabInsets", insets2);
            return tTabbedPane;
        }

        public void startTabbedPane(TAppDialogsObject tAppDialogsObject) {
            JTabbedPane jTabbedPane = null;
            if (TScrollDialogPanel.this.Debug) {
                System.out.println("*** startTabbedPane ***");
            }
            if (TScrollDialogPanel.this.UseCustomTabbedPane) {
                switch (tAppDialogsObject.ControlType) {
                    case 35: {
                        jTabbedPane = this.createTabbedPane(tAppDialogsObject, 1, 0, false);
                        break;
                    }
                    case 36: {
                        jTabbedPane = this.createTabbedPane(tAppDialogsObject, 1, 1, false);
                        break;
                    }
                    case 37: {
                        jTabbedPane = this.createTabbedPane(tAppDialogsObject, 2, 0, false);
                        break;
                    }
                    case 38: {
                        jTabbedPane = this.createTabbedPane(tAppDialogsObject, 2, 1, false);
                        break;
                    }
                    case 39: {
                        jTabbedPane = this.createTabbedPane(tAppDialogsObject, 4, 0, false);
                        break;
                    }
                    case 40: {
                        jTabbedPane = this.createTabbedPane(tAppDialogsObject, 4, 1, false);
                        break;
                    }
                    case 41: {
                        jTabbedPane = this.createTabbedPane(tAppDialogsObject, 3, 0, false);
                        break;
                    }
                    case 42: {
                        jTabbedPane = this.createTabbedPane(tAppDialogsObject, 3, 1, false);
                        break;
                    }
                    case 62: {
                        jTabbedPane = this.createTabbedPane(tAppDialogsObject, 2, 0, true);
                        break;
                    }
                    case 63: {
                        jTabbedPane = this.createTabbedPane(tAppDialogsObject, 2, 1, true);
                        break;
                    }
                    case 64: {
                        jTabbedPane = this.createTabbedPane(tAppDialogsObject, 4, 0, true);
                        break;
                    }
                    case 65: {
                        jTabbedPane = this.createTabbedPane(tAppDialogsObject, 4, 1, true);
                    }
                }
            } else {
                switch (tAppDialogsObject.ControlType) {
                    case 35: {
                        jTabbedPane = new JTabbedPane(1, 0);
                        break;
                    }
                    case 36: {
                        jTabbedPane = new JTabbedPane(1, 1);
                        break;
                    }
                    case 37: {
                        jTabbedPane = new JTabbedPane(2, 0);
                        break;
                    }
                    case 38: {
                        jTabbedPane = new JTabbedPane(2, 1);
                        break;
                    }
                    case 39: {
                        jTabbedPane = new JTabbedPane(4, 0);
                        break;
                    }
                    case 40: {
                        jTabbedPane = new JTabbedPane(4, 1);
                        break;
                    }
                    case 41: {
                        jTabbedPane = new JTabbedPane(3, 0);
                        break;
                    }
                    case 42: {
                        jTabbedPane = new JTabbedPane(3, 1);
                        break;
                    }
                    case 62: {
                        jTabbedPane = new JTabbedPane(2, 0);
                        break;
                    }
                    case 63: {
                        jTabbedPane = new JTabbedPane(2, 1);
                        break;
                    }
                    case 64: {
                        jTabbedPane = new JTabbedPane(4, 0);
                        break;
                    }
                    case 65: {
                        jTabbedPane = new JTabbedPane(4, 1);
                    }
                }
            }
            if (tAppDialogsObject.Transparent) {
                jTabbedPane.setOpaque(false);
            } else {
                jTabbedPane.setOpaque(true);
            }
            if (tAppDialogsObject.ControlW > 0 || tAppDialogsObject.ControlH > 0) {
                jTabbedPane.setPreferredSize(new Dimension(tAppDialogsObject.ControlW, tAppDialogsObject.ControlH));
            }
            if (tAppDialogsObject.ControlAlignX > 0) {
                switch (tAppDialogsObject.ControlAlignX) {
                    case 1: {
                        jTabbedPane.setAlignmentX(0.0f);
                        break;
                    }
                    case 2: {
                        jTabbedPane.setAlignmentX(1.0f);
                        break;
                    }
                    case 3: {
                        jTabbedPane.setAlignmentX(0.5f);
                    }
                }
            }
            if (tAppDialogsObject.ControlAlignY > 0) {
                switch (tAppDialogsObject.ControlAlignY) {
                    case 1: {
                        jTabbedPane.setAlignmentY(0.0f);
                        break;
                    }
                    case 2: {
                        jTabbedPane.setAlignmentY(1.0f);
                        break;
                    }
                    case 3: {
                        jTabbedPane.setAlignmentY(0.5f);
                    }
                }
            }
            this.push(new TContainerStackObj(tAppDialogsObject, jTabbedPane, -1));
        }

        public void addTab(JTabbedPane jTabbedPane, String string, Component component, TAppDialogsObject tAppDialogsObject, int n) {
            int n2 = jTabbedPane.getTabPlacement();
            if (n == 62 || n == 63 || n == 64 || n == 65) {
                jTabbedPane.addTab(null, new VerticalTextIcon(string, n2 == 4, tAppDialogsObject), component);
            } else {
                jTabbedPane.addTab(null, new HorizontalTextIcon(string, tAppDialogsObject), component);
            }
        }

        public void endTabbedPane(TAppDialogsObject tAppDialogsObject) {
            Stack<TContainerStackObj> stack = new Stack<TContainerStackObj>();
            boolean bl = false;
            if (TScrollDialogPanel.this.Debug) {
                System.out.println("*** endTabbedPane ***");
            }
            while (this.size() > 1 && !bl) {
                TContainerStackObj tContainerStackObj = (TContainerStackObj)this.pop();
                if (tContainerStackObj.AppDialogsObject != null && TScrollDialogPanel.getControlType(tContainerStackObj.AppDialogsObject) == 4) {
                    while (!stack.empty()) {
                        Image image;
                        TContainerStackObj tContainerStackObj2 = (TContainerStackObj)stack.pop();
                        if (tContainerStackObj2.container == null) continue;
                        JTabbedPane jTabbedPane = (JTabbedPane)tContainerStackObj.container;
                        this.setFont(tContainerStackObj2.AppDialogsObject, jTabbedPane);
                        if (TScrollDialogPanel.this.UseCustomTabbedPane) {
                            this.addTab((JTabbedPane)tContainerStackObj.container, tContainerStackObj2.AppDialogsObject.BorderTitleLabel[0] + " ", tContainerStackObj2.container, tContainerStackObj2.AppDialogsObject, tContainerStackObj.AppDialogsObject.ControlType);
                            continue;
                        }
                        ((JTabbedPane)tContainerStackObj.container).add(tContainerStackObj2.AppDialogsObject.BorderTitleLabel[0] + " ", tContainerStackObj2.container);
                        if (tContainerStackObj2.AppDialogsObject.IconFile.length() <= 0 || (image = imageutil.getScaledImage(this.getClass(), charutil.removeQuotes(tContainerStackObj2.AppDialogsObject.IconFile), -1, -1)) == null) continue;
                        ImageIcon imageIcon = new ImageIcon(image);
                        imageIcon.setImageObserver(tContainerStackObj.container);
                        jTabbedPane.setIconAt(jTabbedPane.getTabCount() - 1, imageIcon);
                    }
                    TContainerStackObj tContainerStackObj3 = (TContainerStackObj)this.peek();
                    tContainerStackObj3.container.add(tContainerStackObj.container);
                    switch (tContainerStackObj3.AppDialogsObject.ControlType) {
                        case 26: {
                            tContainerStackObj.container.setBounds(tContainerStackObj.AppDialogsObject.ControlX, tContainerStackObj.AppDialogsObject.ControlY, tContainerStackObj.AppDialogsObject.ControlW, tContainerStackObj.AppDialogsObject.ControlH);
                            tContainerStackObj3.container.add(tContainerStackObj.container);
                            break;
                        }
                        case 27: {
                            tContainerStackObj3.container.add((Component)tContainerStackObj.container, tContainerStackObj.AppDialogsObject.PanelControlPosition);
                            break;
                        }
                        case 28: {
                            tContainerStackObj3.container.add(tContainerStackObj.container);
                            break;
                        }
                        case 29: {
                            tContainerStackObj3.container.add(tContainerStackObj.container);
                            break;
                        }
                        case 30: {
                            tContainerStackObj3.container.add(tContainerStackObj.container);
                            break;
                        }
                        case 44: {
                            if (tContainerStackObj3.container == null) {
                                tContainerStackObj3.container = tContainerStackObj.container;
                                break;
                            }
                            tContainerStackObj3.container.add(tContainerStackObj.container);
                        }
                    }
                    bl = true;
                    continue;
                }
                stack.push(tContainerStackObj);
            }
        }

        public void closeoutTab() {
        }

        public void startNewTab(TAppDialogsObject tAppDialogsObject) {
            if (TScrollDialogPanel.this.Debug) {
                System.out.println("*** startNewTab ***");
            }
            this.closeoutTab();
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 3));
            jPanel.setOpaque(false);
            this.push(new TContainerStackObj(tAppDialogsObject, jPanel, -1));
        }

        public void startSplitPane(TAppDialogsObject tAppDialogsObject) {
            if (TScrollDialogPanel.this.Debug) {
                System.out.println("*** startSplitPane ***");
            }
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 3));
            jPanel.setOpaque(false);
            this.push(new TContainerStackObj(tAppDialogsObject, jPanel, 29));
        }

        public void addSplitPaneDivider(TAppDialogsObject tAppDialogsObject) {
            if (TScrollDialogPanel.this.Debug) {
                System.out.println("*** SplitPane Divider ***");
            }
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 3));
            jPanel.setOpaque(false);
            this.push(new TContainerStackObj(tAppDialogsObject, jPanel, 29));
        }

        public void endSplitPane(TAppDialogsObject tAppDialogsObject) {
            TContainerStackObj tContainerStackObj = (TContainerStackObj)this.pop();
            TContainerStackObj tContainerStackObj2 = (TContainerStackObj)this.pop();
            if (TScrollDialogPanel.this.Debug) {
                System.out.println("*** endSplitPane ***");
            }
            int n = 1;
            int n2 = tContainerStackObj2.AppDialogsObject.ControlW;
            int n3 = tContainerStackObj.AppDialogsObject.ControlW;
            if (tContainerStackObj2.AppDialogsObject.PanelAlignment == 7) {
                n = 0;
                n2 = tContainerStackObj2.AppDialogsObject.ControlH;
                n3 = tContainerStackObj.AppDialogsObject.ControlH;
            }
            JSplitPane jSplitPane = new JSplitPane(n, true, tContainerStackObj2.container, tContainerStackObj.container);
            jSplitPane.setOneTouchExpandable(true);
            jSplitPane.setDividerLocation(n2);
            TContainerStackObj tContainerStackObj3 = (TContainerStackObj)this.peek();
            tContainerStackObj3.container.add(jSplitPane);
        }

        public void closeoutStack() {
            if (TScrollDialogPanel.this.Debug) {
                System.out.println("*** closeoutStack ***");
            }
        }
    }

    public class TContainerStackObj {
        public TAppDialogsObject AppDialogsObject = null;
        public Container container = null;
        public int Layout = -1;

        public TContainerStackObj(TAppDialogsObject tAppDialogsObject, Container container, int n) {
            this.AppDialogsObject = tAppDialogsObject;
            this.container = container;
            this.Layout = n;
        }

        public void outputStackObj(String string) {
            if (!TScrollDialogPanel.this.Debug) {
                return;
            }
            System.out.print("Stk " + string + ": ");
            if (this.AppDialogsObject == null) {
                System.out.print("Type=null");
            } else {
                int n = TScrollDialogPanel.getControlType(this.AppDialogsObject);
                switch (n) {
                    case 0: {
                        System.out.print("Type=Info");
                        break;
                    }
                    case 1: {
                        System.out.print("Type=Control");
                        break;
                    }
                    case 2: {
                        System.out.print("Type=LayoutStart");
                        break;
                    }
                    case 3: {
                        System.out.print("Type=LayoutEnd");
                        break;
                    }
                    case 4: {
                        System.out.print("Type=TabPaneStart");
                        break;
                    }
                    case 5: {
                        System.out.print("Type=TabPaneEnd");
                        break;
                    }
                    case 6: {
                        System.out.print("Type=NewTab");
                        break;
                    }
                    case 7: {
                        System.out.print("Type=BoxFormatter");
                        break;
                    }
                    case 8: {
                        System.out.print("Type=SplitPaneBegin");
                        break;
                    }
                    case 9: {
                        System.out.print("Type=SplitPaneDivider");
                        break;
                    }
                    case 10: {
                        System.out.print("Type=SplitPaneEnd");
                    }
                }
            }
            System.out.print(" Layout=");
            switch (this.Layout) {
                case 26: {
                    System.out.print("XY");
                    break;
                }
                case 27: {
                    System.out.print("Border");
                    break;
                }
                case 28: {
                    System.out.print("Flow");
                    break;
                }
                case 29: {
                    System.out.print("Box");
                    break;
                }
                case 30: {
                    System.out.print("Grid");
                    break;
                }
                default: {
                    System.out.print(this.Layout);
                }
            }
            System.out.print(" Alignment=");
            if (this.AppDialogsObject == null) {
                System.out.print("null");
            } else {
                switch (this.AppDialogsObject.PanelAlignment) {
                    case 0: {
                        System.out.print("N/A");
                        break;
                    }
                    case 1: {
                        System.out.print("Left");
                        break;
                    }
                    case 2: {
                        System.out.print("Right");
                        break;
                    }
                    case 3: {
                        System.out.print("Leading");
                        break;
                    }
                    case 4: {
                        System.out.print("Center");
                        break;
                    }
                    case 5: {
                        System.out.print("Trailing");
                        break;
                    }
                    case 6: {
                        System.out.print("Line Axis");
                        break;
                    }
                    case 7: {
                        System.out.print("Page Axis");
                        break;
                    }
                    default: {
                        System.out.print(-1);
                    }
                }
            }
            if (this.container == null) {
                System.out.print(" container items=null");
            } else {
                System.out.print(" container items=" + this.container.getComponentCount());
            }
            System.out.print(" Width: " + this.AppDialogsObject.ControlW);
            System.out.print(" Height: " + this.AppDialogsObject.ControlH);
            System.out.println();
        }

        public GridBagConstraints getConstraints() {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = this.AppDialogsObject.GridX;
            gridBagConstraints.gridy = this.AppDialogsObject.GridY;
            gridBagConstraints.fill = this.AppDialogsObject.GridFill;
            gridBagConstraints.ipadx = this.AppDialogsObject.GridPadX;
            gridBagConstraints.ipady = this.AppDialogsObject.GridPadY;
            gridBagConstraints.insets = new Insets(this.AppDialogsObject.GridInsetTop, this.AppDialogsObject.GridInsetLeft, this.AppDialogsObject.GridInsetBottom, this.AppDialogsObject.GridInsetRight);
            gridBagConstraints.weightx = this.AppDialogsObject.GridWeightX;
            gridBagConstraints.weighty = this.AppDialogsObject.GridWeightY;
            return gridBagConstraints;
        }

        public void setBorder(JComponent jComponent, TAppDialogsObject tAppDialogsObject, int n) {
            if (tAppDialogsObject.BorderType[n] != 0) {
                int n2;
                switch (tAppDialogsObject.BorderStyle[n]) {
                    case 1: {
                        n2 = 0;
                        break;
                    }
                    case 2: {
                        n2 = 1;
                        break;
                    }
                    default: {
                        n2 = 0;
                    }
                }
                Color color = new Color(tAppDialogsObject.BorderHighlight[n]);
                Color color2 = new Color(tAppDialogsObject.BorderShadow[n]);
                Border border = null;
                switch (tAppDialogsObject.BorderType[n]) {
                    case 1: {
                        border = BorderFactory.createBevelBorder(n2, color, color2);
                        break;
                    }
                    case 2: {
                        border = new TEmptyBorder(tAppDialogsObject.BorderTopWidth[n], tAppDialogsObject.BorderLeftWidth[n], tAppDialogsObject.BorderBottomWidth[n], tAppDialogsObject.BorderRightWidth[n], TScrollDialogPanel.this.getBackground());
                        break;
                    }
                    case 3: {
                        border = BorderFactory.createEtchedBorder(n2, color, color2);
                        break;
                    }
                    case 4: {
                        border = BorderFactory.createLineBorder(color, tAppDialogsObject.BorderLeftWidth[n]);
                        break;
                    }
                    case 5: {
                        border = BorderFactory.createLoweredBevelBorder();
                        break;
                    }
                    case 6: {
                        border = BorderFactory.createRaisedBevelBorder();
                        break;
                    }
                    case 7: {
                        border = BorderFactory.createMatteBorder(tAppDialogsObject.BorderTopWidth[n], tAppDialogsObject.BorderLeftWidth[n], tAppDialogsObject.BorderBottomWidth[n], tAppDialogsObject.BorderRightWidth[n], color);
                    }
                }
                if (border != null) {
                    if (!charutil.nullstr(tAppDialogsObject.BorderTitleLabel[n])) {
                        int n3 = 1;
                        int n4 = 1;
                        switch (tAppDialogsObject.BorderTitleJustification[n]) {
                            case 0: {
                                n3 = 1;
                                break;
                            }
                            case 1: {
                                n3 = 2;
                                break;
                            }
                            case 2: {
                                n3 = 3;
                                break;
                            }
                            case 3: {
                                n3 = 4;
                                break;
                            }
                            case 4: {
                                n3 = 5;
                            }
                        }
                        switch (tAppDialogsObject.BorderTitlePosition[n]) {
                            case 0: {
                                n4 = 1;
                                break;
                            }
                            case 1: {
                                n4 = 2;
                                break;
                            }
                            case 2: {
                                n4 = 3;
                                break;
                            }
                            case 3: {
                                n4 = 4;
                                break;
                            }
                            case 4: {
                                n4 = 5;
                                break;
                            }
                            case 5: {
                                n4 = 6;
                            }
                        }
                        String string = "  " + tAppDialogsObject.BorderTitleLabel[n] + "  ";
                        Font font = objectutil.makeFont(tAppDialogsObject.FontName, tAppDialogsObject.FontStyle, tAppDialogsObject.FontSize);
                        Color color3 = new Color(tAppDialogsObject.FontColor);
                        border = BorderFactory.createTitledBorder(border, string, n3, n4, font, color3);
                    }
                    if (n == 0) {
                        jComponent.setBorder(border);
                    } else {
                        jComponent.setBorder(BorderFactory.createCompoundBorder(border, jComponent.getBorder()));
                    }
                }
            }
        }

        public void add(JComponent jComponent, TAppDialogsObject tAppDialogsObject) {
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < 2; ++i) {
                if (tAppDialogsObject.BorderType[i] == 0) continue;
                n += tAppDialogsObject.BorderLeftWidth[i] + tAppDialogsObject.BorderRightWidth[i];
                n2 += tAppDialogsObject.BorderTopWidth[i] + tAppDialogsObject.BorderBottomWidth[i];
            }
            if (tAppDialogsObject.ControlW * tAppDialogsObject.ControlH != 0) {
                jComponent.setPreferredSize(new Dimension(tAppDialogsObject.ControlW + n, tAppDialogsObject.ControlH + n2));
            }
            if (tAppDialogsObject.MaximumWidth * tAppDialogsObject.MaximumHeight > 0) {
                jComponent.setMaximumSize(new Dimension(tAppDialogsObject.MaximumWidth, tAppDialogsObject.MaximumHeight + n2));
            } else {
                jComponent.setMaximumSize(new Dimension(tAppDialogsObject.ControlW + n, tAppDialogsObject.ControlH + n2));
            }
            if (tAppDialogsObject.MinimumWidth * tAppDialogsObject.MinimumHeight > 0) {
                jComponent.setMinimumSize(new Dimension(tAppDialogsObject.MinimumWidth + n, tAppDialogsObject.MinimumHeight + n2));
            }
            this.setBorder(jComponent, tAppDialogsObject, 0);
            this.setBorder(jComponent, tAppDialogsObject, 1);
            switch (this.Layout) {
                case 26: {
                    this.container.add(jComponent);
                    break;
                }
                case 27: {
                    this.container.add((Component)jComponent, tAppDialogsObject.PanelControlPosition);
                    break;
                }
                case 28: {
                    this.container.add(jComponent);
                    break;
                }
                case 29: {
                    this.container.add(jComponent);
                    break;
                }
                case 30: {
                    GridBagConstraints gridBagConstraints = this.getConstraints();
                    this.container.add((Component)jComponent, gridBagConstraints);
                }
            }
        }
    }

    public class TButtonAction
    extends AbstractAction {
        public TButtonAction() {
        }

        public TButtonAction(AbstractAction abstractAction) {
            Object[] objectArray = abstractAction.getKeys();
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = abstractAction.getValue((String)objectArray[i]);
                    if (object == null) continue;
                    this.putValue((String)objectArray[i], object);
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TScrollDialogPanel.this.buttonPressed(this, actionEvent);
        }
    }

    public class ColorChooserOkListener
    implements ActionListener {
        JColorChooser colorChooser;
        JButton button;

        public ColorChooserOkListener(JColorChooser jColorChooser, JButton jButton) {
            this.colorChooser = jColorChooser;
            this.button = jButton;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.button.setForeground(this.colorChooser.getColor());
        }
    }

    public class EnterListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TScrollDialogPanel.this.Ok();
        }
    }
}

