/*
 * Decompiled with CFR 0.152.
 */
package scrollwin.subtotaltree;

import drivers.aspect.TAspectDriver;
import drivers.aspect.TSubtotalsDriver;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import resources.TAppDisplaysObject;
import resources.TAppTablesObject;
import scrollwin.subtotaltree.TScrollSubtotalTreeNode;
import scrollwin.subtotaltree.TScrollSubtotalTreeNodeListenerInterface;
import utility.objectutil;

public class TScrollSubtotalTree
extends JTree {
    private DefaultTreeModel Model;
    public TScrollSubtotalTreeNode TopNode;
    private TTreeCellEditor treeCellEditor;
    private TTreeCellRenderer treeCellRenderer;
    private TAspectDriver AspectDriver;
    private TAppTablesObject AppTablesObj;
    private TSubtotalsDriver SubtotalsDriver;
    private Color ColorTreeBackground;
    private Color ColorTreeForeground;
    private Color ColorTreeSelectedBackground;
    private Color ColorTreeSelectedForeground;
    private Font TreeRootFont = null;
    private Font TreeFont = null;
    boolean bEnableDetails = true;
    public static int cSubtotalTreeBuilderInstance = 0;
    private TScrollSubtotalTreeNodeListenerInterface TreeNodeListener;

    public TScrollSubtotalTree(TScrollSubtotalTreeNode tScrollSubtotalTreeNode, TScrollSubtotalTreeNodeListenerInterface tScrollSubtotalTreeNodeListenerInterface, TAspectDriver tAspectDriver) {
        super(tScrollSubtotalTreeNode);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.Model = (DefaultTreeModel)this.getModel();
        this.TopNode = tScrollSubtotalTreeNode;
        this.AspectDriver = tAspectDriver;
        this.AppTablesObj = this.AspectDriver.AspectDriverFilter.ActiveAppTablesObj;
        this.TreeNodeListener = tScrollSubtotalTreeNodeListenerInterface;
        if (this.AppTablesObj != null) {
            this.ColorTreeBackground = new Color(this.AppTablesObj.TreeBackground);
            this.ColorTreeForeground = new Color(this.AppTablesObj.TreeForeground);
            this.ColorTreeSelectedBackground = new Color(this.AppTablesObj.TreeSelectedBackground);
            this.ColorTreeSelectedForeground = new Color(this.AppTablesObj.TreeSelectedForeground);
            this.TreeFont = objectutil.makeFont(this.AppTablesObj.TreeFontName, this.AppTablesObj.TreeFontStyle, this.AppTablesObj.TreeFontSize);
            this.TreeRootFont = objectutil.makeFont(this.AppTablesObj.TreeFontName, 3, this.AppTablesObj.TreeFontSize + 1);
        }
        this.setShowsRootHandles(true);
        this.SubtotalsDriver = this.AspectDriver.AspectDriverFilter.SubtotalsDriver;
        this.getSelectionModel().setSelectionMode(1);
        this.addMouseListener(new NodeSelectionListener(this));
        this.initializeTree();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void initializeTree() {
        if (this.AspectDriver.AspectDriverFilter.ColumnList == null) {
            return;
        }
        if (this.AspectDriver.AspectDriverFilter.ColumnList.size() == 0) {
            return;
        }
        TAppDisplaysObject tAppDisplaysObject = (TAppDisplaysObject)this.AspectDriver.AspectDriverFilter.ColumnList.get(0);
        TScrollSubtotalTreeNode tScrollSubtotalTreeNode = this.TopNode;
        StringBuilder stringBuilder = new StringBuilder();
        TScrollSubtotalTreeNode tScrollSubtotalTreeNode2 = new TScrollSubtotalTreeNode(-1, "Totals by...", -1, false, null, true);
        int n = 0;
        while (true) {
            block29: {
                TScrollSubtotalTreeNode tScrollSubtotalTreeNode3;
                int n2;
                TScrollSubtotalTreeNode tScrollSubtotalTreeNode4;
                TSubtotalsDriver.TSubtotalGroup tSubtotalGroup;
                block30: {
                    block28: {
                        if (n >= this.SubtotalsDriver.getGroupCount()) {
                            this.TopNode = tScrollSubtotalTreeNode2;
                            this.Model.setRoot(this.TopNode);
                            tScrollSubtotalTreeNode.dispose();
                            this.expandSelectedPaths(this.TopNode);
                            this.updateUI();
                            return;
                        }
                        tSubtotalGroup = this.SubtotalsDriver.getSubtotalGroup(n);
                        tScrollSubtotalTreeNode4 = new TScrollSubtotalTreeNode(tSubtotalGroup.GroupType, tSubtotalGroup.getDescription(), -1, false, null, false);
                        if (tScrollSubtotalTreeNode4.GroupType == 0) {
                            if (tAppDisplaysObject.ShowDetails) {
                                tScrollSubtotalTreeNode4.CheckBox.setSelected(true);
                            }
                            tScrollSubtotalTreeNode4.addListener(this.TreeNodeListener);
                        }
                        tScrollSubtotalTreeNode2.add(tScrollSubtotalTreeNode4);
                        if (tSubtotalGroup.GroupType >= 3) break block28;
                        if (tSubtotalGroup.GroupType == 0) break block29;
                        break block30;
                    }
                    for (n2 = 0; n2 < tSubtotalGroup.arTemplates.size(); ++n2) {
                        TSubtotalsDriver.TSubtotalTemplate tSubtotalTemplate = tSubtotalGroup.getTemplate(n2);
                        tScrollSubtotalTreeNode3 = new TScrollSubtotalTreeNode(-1, tSubtotalGroup.getTemplateDescription(n2), tSubtotalGroup.SubtotalType, false, tSubtotalTemplate.arKeyFields, false);
                        tScrollSubtotalTreeNode3.addListener(this.TreeNodeListener);
                        tScrollSubtotalTreeNode4.add(tScrollSubtotalTreeNode3);
                        if (n2 != tSubtotalGroup.arTemplates.size() - 1) continue;
                        tScrollSubtotalTreeNode3.CheckBox.setSelected(true);
                    }
                    break block29;
                }
                block22: for (n2 = 0; n2 < TSubtotalsDriver.arSubtotalFunctionNames.length; ++n2) {
                    boolean bl = tSubtotalGroup.GroupType == 2;
                    tScrollSubtotalTreeNode3 = new TScrollSubtotalTreeNode(-1, TSubtotalsDriver.arSubtotalFunctionNames[n2], n2, bl, null, false);
                    tScrollSubtotalTreeNode3.addListener(this.TreeNodeListener);
                    tScrollSubtotalTreeNode4.add(tScrollSubtotalTreeNode3);
                    switch (tSubtotalGroup.GroupType) {
                        case 1: {
                            switch (n2) {
                                case 0: {
                                    if (!tAppDisplaysObject.ShowGrandSum) break;
                                    tScrollSubtotalTreeNode3.CheckBox.setSelected(true);
                                    break;
                                }
                                case 1: {
                                    if (!tAppDisplaysObject.ShowGrandCount) break;
                                    tScrollSubtotalTreeNode3.CheckBox.setSelected(true);
                                    break;
                                }
                                case 2: {
                                    if (!tAppDisplaysObject.ShowGrandMaximum) break;
                                    tScrollSubtotalTreeNode3.CheckBox.setSelected(true);
                                    break;
                                }
                                case 3: {
                                    if (!tAppDisplaysObject.ShowGrandMinimum) break;
                                    tScrollSubtotalTreeNode3.CheckBox.setSelected(true);
                                    break;
                                }
                                case 4: {
                                    if (!tAppDisplaysObject.ShowGrandAverage) break;
                                    tScrollSubtotalTreeNode3.CheckBox.setSelected(true);
                                    break;
                                }
                                case 5: {
                                    if (!tAppDisplaysObject.ShowGrandStdDev) break;
                                    tScrollSubtotalTreeNode3.CheckBox.setSelected(true);
                                    break;
                                }
                            }
                            continue block22;
                        }
                        case 2: {
                            switch (n2) {
                                case 0: {
                                    if (!tAppDisplaysObject.ShowDisplayedSum) break;
                                    tScrollSubtotalTreeNode3.CheckBox.setSelected(true);
                                    break;
                                }
                                case 1: {
                                    if (!tAppDisplaysObject.ShowDisplayedCount) break;
                                    tScrollSubtotalTreeNode3.CheckBox.setSelected(true);
                                    break;
                                }
                                case 2: {
                                    if (!tAppDisplaysObject.ShowDisplayedMaximum) break;
                                    tScrollSubtotalTreeNode3.CheckBox.setSelected(true);
                                    break;
                                }
                                case 3: {
                                    if (!tAppDisplaysObject.ShowDisplayedMinimum) break;
                                    tScrollSubtotalTreeNode3.CheckBox.setSelected(true);
                                    break;
                                }
                                case 4: {
                                    if (!tAppDisplaysObject.ShowDisplayedAverage) break;
                                    tScrollSubtotalTreeNode3.CheckBox.setSelected(true);
                                    break;
                                }
                                case 5: {
                                    if (!tAppDisplaysObject.ShowDisplayedStdDev) break;
                                    tScrollSubtotalTreeNode3.CheckBox.setSelected(true);
                                }
                            }
                            continue block22;
                        }
                    }
                }
            }
            ++n;
        }
    }

    public void enableDetails(boolean bl) {
        this.bEnableDetails = bl;
        for (int i = 0; i < this.TopNode.getChildCount(); ++i) {
            TScrollSubtotalTreeNode tScrollSubtotalTreeNode = (TScrollSubtotalTreeNode)this.TopNode.getChildAt(i);
            if (tScrollSubtotalTreeNode.GroupType != 0) continue;
            tScrollSubtotalTreeNode.CheckBox.setSelected(bl);
            return;
        }
    }

    public void enableSubtotal(int n, int n2, String[] stringArray) {
        int n3;
        int[] nArray = null;
        if (stringArray != null) {
            nArray = new int[stringArray.length];
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                nArray[n3] = this.AspectDriver.DriverStruct.getFieldIndex(stringArray[n3]);
            }
        }
        for (n3 = 0; n3 < this.TopNode.getChildCount(); ++n3) {
            TScrollSubtotalTreeNode tScrollSubtotalTreeNode = (TScrollSubtotalTreeNode)this.TopNode.getChildAt(n3);
            if (tScrollSubtotalTreeNode.GroupType != n) continue;
            for (int i = 0; i < tScrollSubtotalTreeNode.getChildCount(); ++i) {
                TScrollSubtotalTreeNode tScrollSubtotalTreeNode2 = (TScrollSubtotalTreeNode)tScrollSubtotalTreeNode.getChildAt(i);
                if (tScrollSubtotalTreeNode2.SubtotalType != n2) continue;
                if (stringArray == null) {
                    tScrollSubtotalTreeNode2.CheckBox.setSelected(true);
                    return;
                }
                if (nArray.length != tScrollSubtotalTreeNode2.arKeyFields.length) continue;
                boolean bl = true;
                for (int j = 0; j < nArray.length; ++j) {
                    if (nArray[j] == tScrollSubtotalTreeNode2.arKeyFields[j]) continue;
                    bl = false;
                }
                if (!bl) continue;
                tScrollSubtotalTreeNode2.CheckBox.setSelected(true);
                return;
            }
        }
    }

    public void expandSelectedPaths(TScrollSubtotalTreeNode tScrollSubtotalTreeNode) {
        TScrollSubtotalTreeNode tScrollSubtotalTreeNode2 = null;
        Enumeration<TreeNode> enumeration = tScrollSubtotalTreeNode.children();
        while (enumeration.hasMoreElements()) {
            tScrollSubtotalTreeNode2 = (TScrollSubtotalTreeNode)enumeration.nextElement();
            if (tScrollSubtotalTreeNode.equals(this.TopNode)) {
                this.expandSelectedPaths(tScrollSubtotalTreeNode2);
                continue;
            }
            if (!tScrollSubtotalTreeNode2.isSelected()) continue;
            Object[] objectArray = tScrollSubtotalTreeNode2.getPath();
            TreePath treePath = new TreePath(objectArray);
            this.expandPath(treePath.getParentPath());
        }
    }

    public boolean showDetails() {
        for (int i = 0; i < this.TopNode.getChildCount(); ++i) {
            TScrollSubtotalTreeNode tScrollSubtotalTreeNode = (TScrollSubtotalTreeNode)this.TopNode.getChildAt(i);
            if (tScrollSubtotalTreeNode.GroupType != 0) continue;
            return tScrollSubtotalTreeNode.CheckBox.isSelected();
        }
        return this.bEnableDetails;
    }

    public boolean isInTree(int n) {
        boolean bl = false;
        TSubtotalsDriver.TSubtotal tSubtotal = (TSubtotalsDriver.TSubtotal)this.SubtotalsDriver.arSubtotals.get(n);
        block3: for (int i = 0; !bl && i < this.TopNode.getChildCount(); ++i) {
            TScrollSubtotalTreeNode tScrollSubtotalTreeNode = (TScrollSubtotalTreeNode)this.TopNode.getChildAt(i);
            switch (tScrollSubtotalTreeNode.GroupType) {
                case 1: 
                case 2: 
                case 3: {
                    for (int j = 0; !bl && j < tScrollSubtotalTreeNode.getChildCount(); ++j) {
                        TScrollSubtotalTreeNode tScrollSubtotalTreeNode2 = (TScrollSubtotalTreeNode)tScrollSubtotalTreeNode.getChildAt(j);
                        if (!tScrollSubtotalTreeNode2.CheckBox.isSelected()) continue;
                        if (tScrollSubtotalTreeNode2.arKeyFields == null) {
                            if (tSubtotal.arKeyFields.length != 0 || tScrollSubtotalTreeNode2.SubtotalType != tSubtotal.SubtotalType || tScrollSubtotalTreeNode2.IsFilteredTotal != tSubtotal.IsFilteredTotal) continue;
                            bl = true;
                            continue;
                        }
                        if (tScrollSubtotalTreeNode2.SubtotalType != tSubtotal.SubtotalType || tScrollSubtotalTreeNode2.arKeyFields.length != tSubtotal.arKeyFields.length) continue;
                        bl = true;
                        for (int k = 0; k < tScrollSubtotalTreeNode2.arKeyFields.length; ++k) {
                            if (tScrollSubtotalTreeNode2.arKeyFields[k] == tSubtotal.arKeyFields[k]) continue;
                            bl = false;
                        }
                    }
                    continue block3;
                }
            }
        }
        return bl;
    }

    public boolean isVisibleFilteredTotal(int n) {
        boolean bl = false;
        boolean bl2 = false;
        TSubtotalsDriver.TSubtotal tSubtotal = (TSubtotalsDriver.TSubtotal)this.SubtotalsDriver.arSubtotals.get(n);
        if (!tSubtotal.IsFilteredTotal) {
            return false;
        }
        for (int i = 0; !bl2 && i < this.TopNode.getChildCount(); ++i) {
            TScrollSubtotalTreeNode tScrollSubtotalTreeNode = (TScrollSubtotalTreeNode)this.TopNode.getChildAt(i);
            if (tScrollSubtotalTreeNode.GroupType != 2) continue;
            for (int j = 0; j < tScrollSubtotalTreeNode.getChildCount(); ++j) {
                TScrollSubtotalTreeNode tScrollSubtotalTreeNode2 = (TScrollSubtotalTreeNode)tScrollSubtotalTreeNode.getChildAt(j);
                if (!tScrollSubtotalTreeNode2.CheckBox.isSelected() || tScrollSubtotalTreeNode2.SubtotalType != tSubtotal.SubtotalType) continue;
                bl = true;
            }
            bl2 = true;
        }
        return bl;
    }

    @Override
    public TreeCellEditor getCellEditor() {
        if (this.treeCellEditor == null) {
            this.treeCellEditor = new TTreeCellEditor();
        }
        return this.treeCellEditor;
    }

    @Override
    public TreeCellRenderer getCellRenderer() {
        if (this.treeCellRenderer == null) {
            this.treeCellRenderer = new TTreeCellRenderer();
        }
        return this.treeCellRenderer;
    }

    class NodeSelectionListener
    extends MouseAdapter {
        JTree tree;

        NodeSelectionListener(JTree jTree) {
            this.tree = jTree;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            int n2 = mouseEvent.getX();
            int n3 = this.tree.getRowForLocation(n2, n = mouseEvent.getY());
            TreePath treePath = this.tree.getPathForRow(n3);
            if (treePath != null) {
                TScrollSubtotalTreeNode tScrollSubtotalTreeNode = (TScrollSubtotalTreeNode)treePath.getLastPathComponent();
                boolean bl = !tScrollSubtotalTreeNode.CheckBox.isSelected();
                tScrollSubtotalTreeNode.CheckBox.setSelected(bl);
                ((DefaultTreeModel)this.tree.getModel()).nodeChanged(tScrollSubtotalTreeNode);
                if (bl) {
                    // empty if block
                }
                if (n3 == 0) {
                    this.tree.revalidate();
                    this.tree.repaint();
                }
                TScrollSubtotalTree.this.fireValueChanged(new TreeSelectionEvent((Object)TScrollSubtotalTree.this, treePath, false, null, null));
            }
        }
    }

    public class TTreeCellRenderer
    extends DefaultTreeCellRenderer
    implements TreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            TScrollSubtotalTreeNode tScrollSubtotalTreeNode = (TScrollSubtotalTreeNode)object;
            DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            defaultTreeCellRenderer.setOpaque(TScrollSubtotalTree.this.isOpaque());
            defaultTreeCellRenderer.setOpaque(TScrollSubtotalTree.this.isOpaque());
            tScrollSubtotalTreeNode.CheckBox.setOpaque(TScrollSubtotalTree.this.isOpaque());
            if (TScrollSubtotalTree.this.TreeFont == null) {
                Font font = defaultTreeCellRenderer.getFont();
                TScrollSubtotalTree.this.TreeFont = new Font(font.getName(), 0, font.getSize());
            }
            if (TScrollSubtotalTree.this.TreeRootFont == null) {
                TScrollSubtotalTree.this.TreeRootFont = new Font(TScrollSubtotalTree.this.TreeFont.getName(), 1, TScrollSubtotalTree.this.TreeFont.getSize() + 1);
            }
            if (n == 0 || tScrollSubtotalTreeNode.GroupType != 0 && !bl3) {
                defaultTreeCellRenderer.setBackground(TScrollSubtotalTree.this.ColorTreeBackground);
                defaultTreeCellRenderer.setBackgroundSelectionColor(TScrollSubtotalTree.this.ColorTreeBackground);
                defaultTreeCellRenderer.setBackgroundNonSelectionColor(TScrollSubtotalTree.this.ColorTreeBackground);
                defaultTreeCellRenderer.setForeground(TScrollSubtotalTree.this.ColorTreeForeground);
                defaultTreeCellRenderer.setTextNonSelectionColor(TScrollSubtotalTree.this.ColorTreeForeground);
                defaultTreeCellRenderer.setTextSelectionColor(TScrollSubtotalTree.this.ColorTreeForeground);
                if (n == 0) {
                    defaultTreeCellRenderer.setFont(TScrollSubtotalTree.this.TreeRootFont);
                } else {
                    defaultTreeCellRenderer.setFont(TScrollSubtotalTree.this.TreeFont);
                }
                return defaultTreeCellRenderer;
            }
            tScrollSubtotalTreeNode.CheckBox.setBackground(TScrollSubtotalTree.this.ColorTreeBackground);
            tScrollSubtotalTreeNode.CheckBox.setForeground(TScrollSubtotalTree.this.ColorTreeForeground);
            tScrollSubtotalTreeNode.CheckBox.setFont(TScrollSubtotalTree.this.TreeFont);
            return tScrollSubtotalTreeNode.CheckBox;
        }
    }

    public class TTreeCellEditor
    extends DefaultTreeCellEditor
    implements TreeCellEditor {
        public TTreeCellEditor() {
            super(TScrollSubtotalTree.this, (DefaultTreeCellRenderer)TScrollSubtotalTree.this.getCellRenderer());
        }

        @Override
        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            return super.getTreeCellEditorComponent(jTree, object, bl, bl2, bl3, n);
        }
    }
}

