/*
 * Decompiled with CFR 0.152.
 */
package scrollwin.table;

import aspect.Aspect;
import aspect.TMainWin;
import collections.TComboBoxColl;
import controls.TComboBox;
import controls.TProgressBar;
import controls.TTable;
import controls.editors.TCheckBoxCellEditor;
import controls.editors.TColorEditor;
import controls.editors.TDateSpinnerCellEditor;
import controls.editors.TDisplaysRowsDropDownEditor;
import controls.editors.TDropDownListEditor;
import controls.editors.TExecActionCellEditor;
import controls.editors.TExecDriverCmdCellEditor;
import controls.editors.TExecScriptCellEditor;
import controls.editors.TFileChooserCellEditor;
import controls.editors.TNumberSpinnerCellEditor;
import controls.editors.TSliderEditor;
import controls.editors.TStringCellEditor;
import controls.editors.TTextAreaCellEditor;
import controls.renderers.TButtonRenderer;
import controls.renderers.TCheckboxRenderer;
import controls.renderers.TColorRenderer;
import controls.renderers.TDateSpinnerCellRenderer;
import controls.renderers.TFormulaCellRenderer;
import controls.renderers.TImageCellRenderer;
import controls.renderers.TLabelRenderer;
import controls.renderers.TMeterRenderer;
import controls.renderers.TNumberRenderer;
import controls.renderers.TScriptCommandRenderer;
import controls.renderers.TSliderRenderer;
import drivers.aspect.TAbstractDriver;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDisplaysFile;
import drivers.aspect.TDriverStructRecord;
import extensions.Launch;
import extensions.SwingWorker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import resources.TAppActionObject;
import resources.TAppDriversObject;
import resources.TAppTablesObject;
import resources.TApplication;
import scripts.TExecScript;
import scrollwin.dialogpanel.TScrollDialogPanel;
import scrollwin.filtertree.TScrollFilterTree;
import scrollwin.filtertree.TScrollFilterTreeNode;
import scrollwin.filtertree.TScrollFilterTreeNodeEvent;
import scrollwin.filtertree.TScrollFilterTreeNodeListenerInterface;
import scrollwin.subtotaltree.TScrollSubtotalTree;
import scrollwin.subtotaltree.TScrollSubtotalTreeNode;
import scrollwin.subtotaltree.TScrollSubtotalTreeNodeEvent;
import scrollwin.subtotaltree.TScrollSubtotalTreeNodeListenerInterface;
import scrollwin.table.TScrollTableColumnModel;
import scrollwin.table.TScrollTableModel;
import scrollwin.table.TScrollTablePanel;
import scrollwin.table.TScrollTableView;
import utility.TFormulaEvaluator;
import utility.charutil;
import utility.dosutil;
import utility.objectutil;

public class TScrollTable
extends TTable
implements ActionListener,
FocusListener {
    private TMainWin MainWin = Aspect.MainWin;
    private boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTScrollTable");
    public TAspectDriver AspectDriver = null;
    TApplication Application;
    TAppDriversObject AppDriversObject;
    TScrollTablePanel ScrollTablePanel;
    TScrollFilterTree FilterTree = null;
    TScrollSubtotalTree SubtotalTree = null;
    Font fontDetail = null;
    Font fontSubtotal = null;
    public MouseListener popupListener;
    Hashtable hashComboBox = new Hashtable();
    Timer CallbackTimer = null;
    int cCallbacks = 0;
    int LastFindRow = -1;
    int LastFindCol = -1;
    public boolean InitializeColumnWidths = true;
    public boolean InitializeEditors = true;
    private boolean DebugShowEntry = false;
    boolean IsShutDown = false;
    boolean ColumnsHaveMoved = false;
    boolean IsRefreshing = false;
    boolean SaveDisplayOnClose = false;
    TScrollSubtotalTreeNodeListenerInterface SubtotalTreeListener = null;
    TScrollFilterTreeNodeListenerInterface FilterTreeListener = null;
    TSliderEditor SliderEditor = null;
    TColorEditor ColorEditor = null;
    TDropDownListEditor DropDownListEditor = null;
    TTextAreaCellEditor TextAreaEditor = null;
    TSliderRenderer SliderRenderer = null;
    TColorRenderer ColorRenderer = null;
    TMeterRenderer MeterRenderer = null;
    TImageCellRenderer ImageRenderer = null;
    TFormulaCellRenderer FormulaRenderer = null;
    TButtonRenderer ButtonRenderer = null;
    TLabelRenderer LabelRenderer = null;
    TLabelRenderer HtmlLabelRenderer = null;
    TScriptCommandRenderer ScriptCommandRenderer = null;
    private boolean InitializingColumnWidths = false;
    public Color colorTableBackground;
    public Color colorTableForeground;
    public Color colorSelectionForeground;
    public Color colorSelectionBackground;
    public Color colorSubtotalBackground;
    public Color colorSubtotalForeground;
    public Color colorSubtotalSelectedBackground;
    public Color colorSubtotalSelectedForeground;

    public TScrollTable(TApplication tApplication, TAppDriversObject tAppDriversObject, TAspectDriver tAspectDriver, TScrollTablePanel tScrollTablePanel) {
        this.setColumnModel(new TScrollTableColumnModel());
        this.popupListener = new PopupListener();
        this.addMouseListener(this.popupListener);
        this.SubtotalTreeListener = new TSubtotalTreeListener();
        this.FilterTreeListener = new TFilterTreeListener();
        this.getColumnModel().addColumnModelListener(new TColumnModelListener());
        this.putClientProperty("terminateEditOnFocusLost", Boolean.FALSE);
        this.addFocusListener(this);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(37, 2, false);
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(39, 2, false);
        KeyStroke keyStroke4 = KeyStroke.getKeyStroke(38, 2, false);
        KeyStroke keyStroke5 = KeyStroke.getKeyStroke(40, 2, false);
        KeyStroke keyStroke6 = KeyStroke.getKeyStroke(155, 3, false);
        KeyStroke keyStroke7 = KeyStroke.getKeyStroke(84, 2, false);
        KeyStroke keyStroke8 = KeyStroke.getKeyStroke(88, 2, false);
        KeyStroke keyStroke9 = KeyStroke.getKeyStroke(67, 2, false);
        KeyStroke keyStroke10 = KeyStroke.getKeyStroke(86, 2, false);
        KeyStroke keyStroke11 = KeyStroke.getKeyStroke(155, 0, false);
        KeyStroke keyStroke12 = KeyStroke.getKeyStroke(127, 0, false);
        KeyStroke keyStroke13 = KeyStroke.getKeyStroke(67, 3, false);
        KeyStroke keyStroke14 = KeyStroke.getKeyStroke(86, 3, false);
        KeyStroke keyStroke15 = KeyStroke.getKeyStroke(114, 0, false);
        KeyStroke keyStroke16 = KeyStroke.getKeyStroke(8, 2, false);
        KeyStroke keyStroke17 = KeyStroke.getKeyStroke(38, 3, false);
        KeyStroke keyStroke18 = KeyStroke.getKeyStroke(40, 3, false);
        KeyStroke keyStroke19 = KeyStroke.getKeyStroke(85, 2, false);
        KeyStroke keyStroke20 = KeyStroke.getKeyStroke(69, 2, false);
        KeyStroke keyStroke21 = KeyStroke.getKeyStroke(83, 2, false);
        KeyStroke keyStroke22 = KeyStroke.getKeyStroke(89, 2, false);
        KeyStroke keyStroke23 = KeyStroke.getKeyStroke(155, 2, false);
        this.registerKeyboardAction(this, "Escape", keyStroke, 0);
        this.registerKeyboardAction(this, "CtrlLeft", keyStroke2, 0);
        this.registerKeyboardAction(this, "CtrlRight", keyStroke3, 0);
        this.registerKeyboardAction(this, "CtrlUp", keyStroke4, 0);
        this.registerKeyboardAction(this, "CtrlDown", keyStroke5, 0);
        this.registerKeyboardAction(this, "Append", keyStroke23, 0);
        this.registerKeyboardAction(this, "InsertNoDialog", keyStroke6, 0);
        this.registerKeyboardAction(this, "CutCells", keyStroke7, 0);
        this.registerKeyboardAction(this, "DeleteCells", keyStroke8, 0);
        this.registerKeyboardAction(this, "CopyCells", keyStroke9, 0);
        this.registerKeyboardAction(this, "PasteCells", keyStroke10, 0);
        this.registerKeyboardAction(this, "Insert", keyStroke11, 0);
        this.registerKeyboardAction(this, "Delete", keyStroke12, 0);
        this.registerKeyboardAction(this, "CopyRecords", keyStroke13, 0);
        this.registerKeyboardAction(this, "InsertCopiedRecords", keyStroke14, 0);
        this.registerKeyboardAction(this, "SearchAgain", keyStroke15, 0);
        this.registerKeyboardAction(this, "Undo", keyStroke16, 0);
        this.registerKeyboardAction(this, "MoveUp", keyStroke17, 0);
        this.registerKeyboardAction(this, "MoveDown", keyStroke18, 0);
        this.registerKeyboardAction(this, "Duplicate", keyStroke19, 0);
        this.registerKeyboardAction(this, "Edit Record", keyStroke20, 0);
        this.registerKeyboardAction(this, "Search", keyStroke21, 0);
        this.registerKeyboardAction(this, "DisplayOptions", keyStroke22, 0);
        this.Application = tApplication;
        this.AppDriversObject = tAppDriversObject;
        this.AspectDriver = tAspectDriver;
        this.ScrollTablePanel = tScrollTablePanel;
        TAppTablesObject tAppTablesObject = this.AspectDriver.getAppTablesObject();
        int n = 0;
        switch (tAppTablesObject.ListSelectionMode) {
            case 0: {
                n = 1;
                break;
            }
            case 1: {
                n = 2;
                break;
            }
            default: {
                n = 0;
            }
        }
        this.getSelectionModel().setSelectionMode(n);
        if (!tAppTablesObject.AutoResize) {
            this.setAutoResizeMode(0);
        }
        this.colorTableBackground = new Color(tAppTablesObject.TableBackground);
        this.colorTableForeground = new Color(tAppTablesObject.TableForeground);
        this.colorSelectionForeground = new Color(tAppTablesObject.SelectionForeground);
        this.colorSelectionBackground = new Color(tAppTablesObject.SelectionBackground);
        this.colorSubtotalBackground = new Color(tAppTablesObject.SubtotalBackground);
        this.colorSubtotalForeground = new Color(tAppTablesObject.SubtotalForeground);
        this.colorSubtotalSelectedBackground = new Color(tAppTablesObject.SubtotalSelectedBackground);
        this.colorSubtotalSelectedForeground = new Color(tAppTablesObject.SubtotalSelectedForeground);
        this.setBackground(this.colorTableBackground);
        this.setForeground(this.colorTableForeground);
        this.setSelectionBackground(this.colorSelectionBackground);
        this.setSelectionForeground(this.colorSelectionForeground);
        if (tAppTablesObject.SingleCellSelect) {
            this.setCellSelectionEnabled(true);
        }
        this.setShowHorizontalLines(tAppTablesObject.HorizontalGridLines);
        this.setShowVerticalLines(tAppTablesObject.VerticalGridLines);
        this.setGridColor(new Color(tAppTablesObject.GridColor));
        int n2 = tAppTablesObject.ColumnMargin;
        if (tAppTablesObject.VerticalGridLines) {
            if (n2 < 1) {
                n2 = 1;
            }
        } else {
            n2 = 0;
        }
        int n3 = tAppTablesObject.RowMargin;
        if (tAppTablesObject.HorizontalGridLines) {
            if (n3 < 1) {
                n3 = 1;
            }
        } else {
            n3 = 0;
        }
        this.setIntercellSpacing(new Dimension(n2, n3));
        this.fontDetail = objectutil.makeFont(tAppTablesObject.FontName, tAppTablesObject.FontStyle, tAppTablesObject.FontSize);
        this.fontSubtotal = objectutil.makeFont(tAppTablesObject.SubtotalFontName, tAppTablesObject.SubtotalFontStyle, tAppTablesObject.SubtotalFontSize);
        this.setOpaque(true);
    }

    public void closeWindow() {
        this.ScrollTablePanel.closeWindow();
    }

    public void shutDownTable() {
        boolean bl = false;
        if (this.IsShutDown) {
            return;
        }
        this.IsShutDown = true;
        if (bl) {
            System.out.println("\t\tshutDownTable: stopEditing()");
        }
        this.stopEditing();
        if (bl) {
            System.out.println("\t\tshutDownTable: dispose dialog");
        }
        this.getTableModel().disposeDialog();
        if (!TMainWin.IsClosing) {
            if (this.AspectDriver.isModified() && !this.AspectDriver.verifySaveChanges()) {
                this.AspectDriver.setModified(false);
            }
            if (this.SaveDisplayOnClose) {
                this.updateDisplayColumnOrder();
                this.AspectDriver.AspectDriverFilter.saveCurrentDisplay(true);
            }
        }
        if (bl) {
            System.out.println("\t\tshutDownTable: kill timer");
        }
        if (this.CallbackTimer != null) {
            this.CallbackTimer.stop();
        }
        if (bl) {
            System.out.println("\t\tshutDownTable: dispose Aspect driver");
        }
        this.AspectDriver.dispose();
        if (!TMainWin.IsClosing && this.AspectDriver.isModified()) {
            final String string = this.Application.parse_tokens(this.AppDriversObject.ExecuteOnCloseMethod.toString());
            final String string2 = this.Application.parse_tokens(this.AppDriversObject.ExecuteOnCloseAction);
            final String string3 = this.Application.parse_tokens(this.AppDriversObject.ExecuteOnCloseScript);
            SwingWorker swingWorker = new SwingWorker(){

                @Override
                public Object construct() {
                    return null;
                }

                @Override
                public void finished() {
                    Object object;
                    int n;
                    String[] stringArray;
                    if (string.length() > 0 && (stringArray = charutil.getSubStringArray(string, '|', true)) != null) {
                        for (n = 0; n < stringArray.length; ++n) {
                            TMainWin.execClassMethod(stringArray[n]);
                        }
                    }
                    if (string2.length() > 0 && (stringArray = charutil.getSubStringArray(string2, '|', true)) != null) {
                        for (n = 0; n < stringArray.length; ++n) {
                            object = TScrollTable.this.Application.AppAction.getAppActionObject(stringArray[n]);
                            if (object == null) continue;
                            TScrollTable.this.MainWin.executeActionObject(((TAppActionObject)object).ActionObject, null);
                        }
                    }
                    if (string3.length() > 0) {
                        object = new TExecScript(string3, null, null);
                        ((Thread)object).start();
                    }
                }
            };
            swingWorker.start();
        }
        if (bl) {
            System.out.println("\t\tshutDownTable: complete");
        }
    }

    @Override
    public void setOpaque(boolean bl) {
        super.setOpaque(bl);
        if (this.getTableHeader() != null) {
            this.getTableHeader().setOpaque(bl);
            TableCellRenderer tableCellRenderer = this.getTableHeader().getDefaultRenderer();
            if (tableCellRenderer != null && tableCellRenderer instanceof JComponent) {
                ((JComponent)((Object)tableCellRenderer)).setOpaque(bl);
            }
        }
    }

    public void updateDisplayColumnOrder() {
        if (this.ColumnsHaveMoved) {
            this.AspectDriver.AspectDriverFilter.updateColumnOrderFromTable(this.getColumnModel());
            this.ColumnsHaveMoved = false;
        }
        this.AspectDriver.AspectDriverFilter.updateSortOptionsFromTable();
        this.AspectDriver.AspectDriverFilter.updateSubtotalSelectionsFromTable();
    }

    public TScrollTablePanel getScrollTablePanel() {
        return this.ScrollTablePanel;
    }

    public TScrollTableModel getTableModel() {
        if (this.DebugShowEntry) {
            System.out.println("TScrollTable.getTableModel");
        }
        return (TScrollTableModel)this.getModel();
    }

    public int ensureRowIsValid(int n) {
        int n2 = n;
        int n3 = this.getRowCount();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= n3) {
            n2 = n3 - 1;
        }
        return n2;
    }

    public int ensureColumnIsValid(int n) {
        int n2 = n;
        int n3 = this.getColumnCount();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= n3) {
            n2 = n3 - 1;
        }
        return n2;
    }

    public void setSelectedRow(int n, boolean bl) {
        int n2 = this.ensureRowIsValid(n);
        if (n2 >= 0) {
            this.setRowSelectionInterval(n2, n2);
            if (bl) {
                this.scrollToCell(n2, -1);
            }
        }
    }

    public void setSelectedColumn(int n, boolean bl) {
        int n2 = this.ensureColumnIsValid(n);
        this.setColumnSelectionInterval(n2, n2);
        if (bl) {
            this.scrollToCell(-1, n2);
        }
    }

    public void setSelectedColumns(int[] nArray) {
        int n = nArray.length;
        if (n > 0) {
            int n2;
            int n3 = n2 = this.ensureColumnIsValid(nArray[0]);
            if (n > 1) {
                n3 = this.ensureColumnIsValid(nArray[n - 1]);
            }
            this.setColumnSelectionInterval(n2, n3);
        }
    }

    public void setSelectedRows(int[] nArray) {
        int n = nArray.length;
        if (n > 0) {
            int n2;
            int n3 = n2 = this.ensureRowIsValid(nArray[0]);
            if (n > 1) {
                n3 = this.ensureRowIsValid(nArray[n - 1]);
            }
            this.setRowSelectionInterval(n2, n3);
        }
    }

    @Override
    public void setRowSelectionInterval(int n, int n2) {
        super.setRowSelectionInterval(this.ensureRowIsValid(n), this.ensureRowIsValid(n2));
    }

    public void setSelectedRows(int n, int n2) {
        int n3 = this.ensureRowIsValid(n);
        int n4 = this.ensureRowIsValid(n2);
        this.setRowSelectionInterval(n3, n4);
    }

    public void scrollToCell(int n, int n2) {
        Cloneable cloneable;
        int n3 = n;
        int n4 = n2;
        if (n3 < 0) {
            n3 = this.getSelectedRow();
        }
        n3 = this.ensureRowIsValid(n3);
        if (n4 < 0) {
            n4 = this.getSelectedColumn();
        }
        if (n4 < 0) {
            if (this.getParent() instanceof JScrollPane) {
                cloneable = ((JScrollPane)this.getParent()).getViewport().getViewPosition();
                n4 = this.columnAtPoint((Point)cloneable);
            } else if (this.getParent() instanceof JViewport) {
                Point point = ((JViewport)this.getParent()).getViewPosition();
                n4 = this.columnAtPoint(point);
                Rectangle rectangle = this.getCellRect(n3, n4, false);
                rectangle.x = point.x;
                final Rectangle rectangle2 = rectangle;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TScrollTable.this.scrollRectToVisible(rectangle2);
                    }
                });
                return;
            }
        }
        n4 = this.ensureColumnIsValid(n4);
        cloneable = this.getCellRect(n3, n4, false);
        this.scrollRectToVisible((Rectangle)cloneable);
    }

    public void addScrollTableView(TScrollTableView tScrollTableView) {
        if (this.DebugShowEntry) {
            System.out.println("TScrollTable.addScrollTableView");
        }
        this.getTableModel().addScrollTableView(tScrollTableView);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.DebugShowEntry) {
            System.out.println("TScrollTable.tableChanged");
        }
        int n = this.getSelectedRow();
        int n2 = this.getModel().getRowCount();
        super.tableChanged(tableModelEvent);
        this.applyTableDisplay();
        if (n2 > 0) {
            if (n >= n2) {
                n = n2 - 1;
            }
            if (n < 0) {
                n = 0;
            }
            this.setRowSelectionInterval(n, n);
        }
    }

    public void applyTableDisplay() {
        if (this.DebugShowEntry) {
            System.out.println("TScrollTable.applyTableDisplay");
        }
        if (this.AspectDriver == null) {
            return;
        }
        TAppTablesObject tAppTablesObject = this.AspectDriver.AspectDriverFilter.ActiveAppTablesObj;
        if (tAppTablesObject.CallbackTime > 0) {
            if (this.CallbackTimer == null) {
                this.CallbackTimer = new Timer(tAppTablesObject.CallbackTime * 1000, new ScrollTableTimerListener());
            } else {
                this.CallbackTimer.setDelay(tAppTablesObject.CallbackTime * 1000);
            }
            this.CallbackTimer.start();
        } else if (this.CallbackTimer != null) {
            this.CallbackTimer.stop();
        }
        if (tAppTablesObject.TableRowHeight > 0 && this.getRowHeight() != tAppTablesObject.TableRowHeight) {
            this.setRowHeight(tAppTablesObject.TableRowHeight);
        }
    }

    @Override
    public synchronized void paint(Graphics graphics) {
        if (this.DebugShowEntry) {
            new Throwable().printStackTrace();
            System.out.println("TScrollTable.paint");
        }
        super.paint(graphics);
    }

    @Override
    public void update(Graphics graphics) {
        if (this.DebugShowEntry) {
            System.out.println("TScrollTable.update");
        }
        this.paint(graphics);
    }

    public String executeDialog() {
        String string = "";
        int n = this.getSelectedRow();
        if (n >= 0) {
            TScrollTableModel tScrollTableModel = this.getTableModel();
            string = tScrollTableModel.executeDialog(n, this);
        }
        return string;
    }

    public String executeDialog(int n) {
        String string = "";
        TScrollTableModel tScrollTableModel = this.getTableModel();
        string = tScrollTableModel.executeDialog(n, this);
        return string;
    }

    public void stopEditing() {
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
        Component component = this.getEditorComponent();
        if (this.DebugShowEntry) {
            System.out.println("TScrollTable.editingCanceled");
        }
        if (component instanceof TComboBox) {
            ((TComboBox)component).setReturnKey(true);
        }
        super.editingCanceled(changeEvent);
        this.requestFocus();
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        Component component = this.getEditorComponent();
        if (this.DebugShowEntry) {
            System.out.println("TScrollTable.editingStopped");
        }
        if (component instanceof TComboBox) {
            ((TComboBox)component).setReturnKey(true);
        }
        int n = this.getSelectedColumn();
        super.editingStopped(changeEvent);
        this.setSelectedColumn(n, false);
        this.requestFocus();
    }

    public void advanceRow() {
        int n = this.getSelectedRow();
        int n2 = this.getSelectedColumn();
        if (n >= 0 && n < this.getRowCount() - 1) {
            this.setSelectedRow(n + 1, false);
            this.setSelectedColumn(n2, false);
            this.scrollToCell(n + 1, n2);
        }
    }

    public void advanceColumn() {
        int n = this.getSelectedRow();
        int n2 = this.getSelectedColumn();
        if (n2 < this.getColumnCount() - 1) {
            this.setSelectedColumn(n2 + 1, false);
            this.scrollToCell(n, n2 + 1);
        } else {
            this.setSelectedColumn(0, false);
            this.advanceRow();
        }
    }

    public void previousColumn() {
        int n = this.getSelectedRow();
        int n2 = this.getSelectedColumn();
        if (n2 > 0) {
            this.setSelectedColumn(n2 - 1, false);
            this.scrollToCell(n, n2 - 1);
        } else {
            this.setSelectedColumn(this.getColumnCount() - 1, false);
            if (n > 0) {
                --n;
            }
            this.setSelectedRow(n, false);
            this.scrollToCell(n, this.getColumnCount() - 1);
        }
    }

    @Override
    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        if (this.isEditing()) {
            this.cellEditor.stopCellEditing();
        }
        this.ColumnsHaveMoved = true;
        this.SaveDisplayOnClose = true;
        super.columnMoved(tableColumnModelEvent);
    }

    @Override
    public void columnMarginChanged(ChangeEvent changeEvent) {
        if (this.isEditing()) {
            this.cellEditor.stopCellEditing();
        }
        super.columnMarginChanged(changeEvent);
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if ((keyStroke.getModifiers() & 8) > 0) {
            return false;
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    public void initializeEditors() {
        if (this.DebugShowEntry) {
            System.out.println("TScrollTable.initializeEditors");
        }
        block7: for (int i = 0; i < this.getColumnCount(); ++i) {
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            TDriverStructRecord tDriverStructRecord = this.AspectDriver.getDriverStructRecord(i);
            if (tDriverStructRecord == null) continue;
            switch (tDriverStructRecord.FieldType) {
                case 1: 
                case 19: 
                case 25: {
                    tableColumn.setCellEditor(new TCheckBoxCellEditor(true, this.AspectDriver));
                    tableColumn.setCellRenderer(new TCheckboxRenderer(true, this.AspectDriver));
                    continue block7;
                }
                case 3: 
                case 11: 
                case 22: 
                case 24: 
                case 26: {
                    Object object;
                    int n = 0;
                    TFormulaEvaluator tFormulaEvaluator = this.AspectDriver.getFormulaEvaluator();
                    if (tFormulaEvaluator != null) {
                        object = tFormulaEvaluator.getFormulaValue(tDriverStructRecord.MaxValue, 0, 0);
                        if (object != null) {
                            n = (int)TFormulaEvaluator.convertToNumber(object);
                        }
                    } else {
                        n = charutil.ival(tDriverStructRecord.MaxValue);
                    }
                    n = n == 0 ? tDriverStructRecord.ArraySize : Math.min(n, tDriverStructRecord.ArraySize);
                    if (tDriverStructRecord.FieldType == 24) {
                        n = Math.min(n, tDriverStructRecord.ArraySize - 1);
                    }
                    tableColumn.setCellEditor(new TStringCellEditor(n, this.fontDetail));
                    tableColumn.setCellRenderer(new TLabelRenderer(true, this.AspectDriver, false));
                    continue block7;
                }
                case 10: 
                case 13: 
                case 18: 
                case 21: {
                    tableColumn.setCellEditor(new TDateSpinnerCellEditor(tDriverStructRecord));
                    tableColumn.setCellRenderer(new TDateSpinnerCellRenderer(true, tDriverStructRecord));
                    continue block7;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    Object object;
                    int n = 0;
                    int n2 = 0;
                    int n3 = 0;
                    TFormulaEvaluator tFormulaEvaluator = this.AspectDriver.getFormulaEvaluator();
                    if (tFormulaEvaluator != null) {
                        object = tFormulaEvaluator.getFormulaValue(tDriverStructRecord.MinValue, 0, 0);
                        if (object != null) {
                            n = (int)TFormulaEvaluator.convertToNumber(object);
                        }
                        if ((object = tFormulaEvaluator.getFormulaValue(tDriverStructRecord.MaxValue, 0, 0)) != null) {
                            n2 = (int)TFormulaEvaluator.convertToNumber(object);
                        }
                        if ((object = tFormulaEvaluator.getFormulaValue(tDriverStructRecord.StepValue, 0, 0)) != null) {
                            n3 = (int)TFormulaEvaluator.convertToNumber(object);
                        }
                    } else {
                        n = charutil.ival(tDriverStructRecord.MinValue);
                        n2 = charutil.ival(tDriverStructRecord.MaxValue);
                        n3 = charutil.ival(tDriverStructRecord.StepValue);
                    }
                    if (n2 < n) {
                        n2 = n;
                    }
                    if (n == 0 && n2 == 0) {
                        n2 = TAbstractDriver.getMaxFieldValue(tDriverStructRecord.FieldType);
                    }
                    if (n3 == 0) {
                        n3 = 1;
                    }
                    tableColumn.setCellEditor(new TNumberSpinnerCellEditor(n, n2, n3));
                    if (!tDriverStructRecord.IsLookup) {
                        tableColumn.setCellRenderer(new TNumberRenderer(true, this.AspectDriver));
                        continue block7;
                    }
                    tableColumn.setCellRenderer(new TLabelRenderer(true, this.AspectDriver, false));
                    continue block7;
                }
                case 8: 
                case 9: 
                case 12: {
                    Object object;
                    double d = 0.0;
                    double d2 = 0.0;
                    double d3 = 0.0;
                    TFormulaEvaluator tFormulaEvaluator = this.AspectDriver.getFormulaEvaluator();
                    if (tFormulaEvaluator != null) {
                        object = tFormulaEvaluator.getFormulaValue(tDriverStructRecord.MinValue, 0, 0);
                        if (object != null) {
                            d = TFormulaEvaluator.convertToNumber(object);
                        }
                        if ((object = tFormulaEvaluator.getFormulaValue(tDriverStructRecord.MaxValue, 0, 0)) != null) {
                            d2 = TFormulaEvaluator.convertToNumber(object);
                        }
                        if ((object = tFormulaEvaluator.getFormulaValue(tDriverStructRecord.StepValue, 0, 0)) != null) {
                            d3 = TFormulaEvaluator.convertToNumber(object);
                        }
                    } else {
                        d = charutil.dval(tDriverStructRecord.MinValue);
                        d2 = charutil.dval(tDriverStructRecord.MaxValue);
                        d3 = charutil.dval(tDriverStructRecord.StepValue);
                    }
                    if (d2 < d) {
                        d2 = d;
                    }
                    if (d == 0.0 && d2 == 0.0) {
                        d2 = TAbstractDriver.getMaxFieldValue(tDriverStructRecord.FieldType);
                    }
                    if (d3 == 0.0) {
                        d3 = 0.01;
                    }
                    tableColumn.setCellEditor(new TNumberSpinnerCellEditor(d, d2, d3));
                    tableColumn.setCellRenderer(new TNumberRenderer(true, this.AspectDriver));
                }
            }
        }
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        TableCellRenderer tableCellRenderer = super.getCellRenderer(n, n2);
        TableColumn tableColumn = this.getColumnModel().getColumn(n2);
        if (tableColumn == null) {
            return tableCellRenderer;
        }
        int n3 = tableColumn.getModelIndex();
        TDriverStructRecord tDriverStructRecord = this.AspectDriver.getDriverStructRecord(n3);
        if (tDriverStructRecord == null) {
            return tableCellRenderer;
        }
        if (tDriverStructRecord.RendererType == 8) {
            if (this.LabelRenderer == null) {
                this.LabelRenderer = new TLabelRenderer(true, this.AspectDriver, false);
            }
            return this.LabelRenderer;
        }
        if (tDriverStructRecord.RendererType == 9) {
            if (this.ScriptCommandRenderer == null) {
                this.ScriptCommandRenderer = new TScriptCommandRenderer(true, this.AspectDriver, false);
            }
            return this.ScriptCommandRenderer;
        }
        if (tDriverStructRecord.RendererType == 7) {
            if (this.HtmlLabelRenderer == null) {
                this.HtmlLabelRenderer = new TLabelRenderer(true, this.AspectDriver, true);
            }
            return this.HtmlLabelRenderer;
        }
        if (tDriverStructRecord.RendererType == 6) {
            if (this.ButtonRenderer == null) {
                this.ButtonRenderer = new TButtonRenderer(true, this.AspectDriver);
            }
            return this.ButtonRenderer;
        }
        if (tDriverStructRecord.RendererType == 5) {
            if (this.FormulaRenderer == null) {
                this.FormulaRenderer = new TFormulaCellRenderer(true, this.AspectDriver);
            }
            return this.FormulaRenderer;
        }
        if (tDriverStructRecord.RendererType == 4) {
            if (this.ImageRenderer == null) {
                this.ImageRenderer = new TImageCellRenderer(true, this.getRowHeight(n));
            }
            return this.ImageRenderer;
        }
        if (tDriverStructRecord.RendererType == 3) {
            Object object;
            double d = 0.0;
            double d2 = 0.0;
            TFormulaEvaluator tFormulaEvaluator = this.AspectDriver.getFormulaEvaluator();
            if (tFormulaEvaluator != null) {
                object = tFormulaEvaluator.getFormulaValue(tDriverStructRecord.MinValue, 0, 0);
                if (object != null) {
                    d = TFormulaEvaluator.convertToNumber(object);
                }
                if ((object = tFormulaEvaluator.getFormulaValue(tDriverStructRecord.MaxValue, 0, 0)) != null) {
                    d2 = TFormulaEvaluator.convertToNumber(object);
                }
            }
            if ((object = this.AspectDriver.getMinValue(tDriverStructRecord, n)) != null) {
                d = ((Integer)object).intValue();
            }
            if ((object = this.AspectDriver.getMaxValue(tDriverStructRecord, n)) != null) {
                d2 = ((Integer)object).intValue();
            }
            if (d2 < d) {
                d2 = d;
            }
            this.SliderRenderer = new TSliderRenderer(this, true, (int)d, (int)d2);
            return this.SliderRenderer;
        }
        if (tDriverStructRecord.RendererType == 1) {
            Object object;
            double d = 0.0;
            double d3 = 0.0;
            TFormulaEvaluator tFormulaEvaluator = this.AspectDriver.getFormulaEvaluator();
            if (tFormulaEvaluator != null) {
                object = tFormulaEvaluator.getFormulaValue(tDriverStructRecord.MinValue, 0, 0);
                if (object != null) {
                    d = TFormulaEvaluator.convertToNumber(object);
                }
                if ((object = tFormulaEvaluator.getFormulaValue(tDriverStructRecord.MaxValue, 0, 0)) != null) {
                    d3 = TFormulaEvaluator.convertToNumber(object);
                }
            }
            if ((object = this.AspectDriver.getMinValue(tDriverStructRecord, n)) != null) {
                d = ((Integer)object).intValue();
            }
            if ((object = this.AspectDriver.getMaxValue(tDriverStructRecord, n)) != null) {
                d3 = ((Integer)object).intValue();
            }
            if (d3 < d) {
                d3 = d;
            }
            if (this.MeterRenderer == null) {
                this.MeterRenderer = new TMeterRenderer(true, (int)d, (int)d3);
            } else {
                this.MeterRenderer.setMinimum((int)d);
                this.MeterRenderer.setMaximum((int)d3);
            }
            return this.MeterRenderer;
        }
        if (tDriverStructRecord.RendererType == 2) {
            if (this.ColorRenderer == null) {
                this.ColorRenderer = new TColorRenderer(true);
            }
            return this.ColorRenderer;
        }
        if (tableCellRenderer instanceof TNumberRenderer) {
            ((TNumberRenderer)tableCellRenderer).setMinimumFractionDigits(tDriverStructRecord.Decimals);
            ((TNumberRenderer)tableCellRenderer).setMaximumFractionDigits(tDriverStructRecord.Decimals);
            ((TNumberRenderer)tableCellRenderer).setSuppressZeros(tDriverStructRecord.SuppressZeros);
            if (tDriverStructRecord.FormatPattern.length() > 0) {
                ((TNumberRenderer)tableCellRenderer).applyPattern(tDriverStructRecord.FormatPattern);
            }
        }
        return tableCellRenderer;
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        if (tableCellRenderer == null) {
            return null;
        }
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        boolean bl = this.isRowSelected(n);
        boolean bl2 = this.isColumnSelected(n2);
        boolean bl3 = true;
        if (component == null) {
            return null;
        }
        if (this.fontDetail == null) {
            this.fontDetail = component.getFont();
        }
        if (this.SubtotalTree != null) {
            bl3 = this.SubtotalTree.showDetails();
        }
        if (bl3 && this.AspectDriver.isSubtotal(n)) {
            if (this.fontSubtotal != null) {
                component.setFont(this.fontSubtotal);
            }
            if (bl) {
                component.setBackground(this.colorSubtotalSelectedBackground);
                component.setForeground(this.colorSubtotalSelectedForeground);
            } else {
                component.setBackground(this.colorSubtotalBackground);
                component.setForeground(this.colorSubtotalForeground);
            }
        } else {
            if (this.fontDetail != null) {
                component.setFont(this.fontDetail);
            }
            if (!(tableCellRenderer instanceof TColorRenderer || tableCellRenderer instanceof TButtonRenderer || tableCellRenderer instanceof TMeterRenderer)) {
                if (bl) {
                    if (this.isOpaque()) {
                        if (bl2) {
                            component.setBackground(this.colorSelectionForeground);
                            component.setForeground(this.colorSelectionBackground);
                        } else {
                            component.setBackground(this.colorSelectionBackground);
                            component.setForeground(this.colorSelectionForeground);
                        }
                    } else if (bl2) {
                        component.setBackground(this.colorSelectionForeground);
                        component.setForeground(this.colorSelectionBackground);
                    } else {
                        component.setBackground(this.colorSelectionBackground);
                        component.setForeground(this.colorSelectionForeground);
                    }
                } else {
                    component.setBackground(this.colorTableBackground);
                    component.setForeground(this.colorTableForeground);
                }
            }
        }
        if (!this.isOpaque() && component instanceof JComponent && !(tableCellRenderer instanceof TColorRenderer)) {
            if (bl) {
                if (bl2) {
                    ((JComponent)component).setOpaque(false);
                } else {
                    ((JComponent)component).setOpaque(true);
                }
            } else {
                ((JComponent)component).setOpaque(false);
            }
        }
        return component;
    }

    @Override
    public TableCellEditor getCellEditor(int n, int n2) {
        int n3;
        TFormulaEvaluator tFormulaEvaluator = null;
        TableCellEditor tableCellEditor = null;
        TComboBox tComboBox = null;
        boolean bl = false;
        if (this.DebugShowEntry) {
            System.out.println("TScrollTable.getCellEditor");
        }
        TableColumn tableColumn = this.getColumnModel().getColumn(n2);
        int n4 = tableColumn.getModelIndex();
        TDriverStructRecord tDriverStructRecord = this.AspectDriver.getDriverStructRecord(n4);
        if (tDriverStructRecord.IsLookup) {
            String string = this.AspectDriver.getFieldID(n4);
            if (!charutil.nullstr(tDriverStructRecord.Formula)) {
                bl = true;
            }
            if (!bl && (tComboBox = (TComboBox)this.hashComboBox.get(string)) != null) {
                tComboBox.setReturnKey(false);
            }
            if (tComboBox == null) {
                tFormulaEvaluator = this.AspectDriver.getFormulaEvaluator();
                tFormulaEvaluator.setAltRecordNumber(this.AspectDriver.getAbsoluteDiskIndex(n));
                TComboBoxColl tComboBoxColl = this.AspectDriver.getComboBoxColl(string, tDriverStructRecord.Formula, tFormulaEvaluator, false, false, n);
                if (tComboBoxColl != null) {
                    tComboBox = new TComboBox(tComboBoxColl, tDriverStructRecord.FieldType);
                    if (!bl) {
                        // empty if block
                    }
                } else {
                    System.out.println("ComboBoxColl is null in getCellEditor() ID=" + string);
                }
            }
            if (tComboBox != null) {
                if (tDriverStructRecord.EditorType == 7) {
                    tComboBox.setEditable(true);
                }
                tComboBox.addMouseListener(this.popupListener);
                tableCellEditor = new DefaultCellEditor(tComboBox);
                n3 = this.Application.getTokenValueAsInt("$EditClickCount");
                if (n3 < 1) {
                    n3 = 1;
                }
                ((DefaultCellEditor)tableCellEditor).setClickCountToStart(n3);
            }
        }
        if (tDriverStructRecord.EditorType == 5) {
            tableCellEditor = new TExecActionCellEditor(this.AspectDriver);
        }
        if (tDriverStructRecord.EditorType == 8) {
            tableCellEditor = new TExecDriverCmdCellEditor(this.AspectDriver);
        }
        if (tDriverStructRecord.EditorType == 9) {
            tableCellEditor = new TExecScriptCellEditor(this.AspectDriver);
        }
        if (tDriverStructRecord.EditorType == 3) {
            tableCellEditor = new TFileChooserCellEditor(0);
        }
        if (tDriverStructRecord.EditorType == 10) {
            tableCellEditor = new TFileChooserCellEditor(1);
        }
        if (tDriverStructRecord.EditorType == 1) {
            int n5 = charutil.ival(tDriverStructRecord.MinValue);
            int n6 = charutil.ival(tDriverStructRecord.MaxValue);
            Integer n7 = this.AspectDriver.getMinValue(tDriverStructRecord, n);
            if (n7 != null) {
                n5 = n7;
            }
            if ((n7 = this.AspectDriver.getMaxValue(tDriverStructRecord, n)) != null) {
                n6 = n7;
            }
            if (n6 < n5) {
                n6 = n5;
            }
            if (this.SliderEditor == null) {
                this.SliderEditor = new TSliderEditor(this, tDriverStructRecord, n, true, n5, n6);
            } else {
                this.SliderEditor.updateEditor(tDriverStructRecord, n, n5, n6);
            }
            return this.SliderEditor;
        }
        if (tDriverStructRecord.EditorType == 2) {
            if (this.ColorEditor == null) {
                this.ColorEditor = new TColorEditor();
            }
            return this.ColorEditor;
        }
        if (tDriverStructRecord.EditorType == 4 && TAbstractDriver.isString(tDriverStructRecord.FieldType)) {
            String string = "Driver_Displays_Rows";
            if (this.AppDriversObject.DriverID.toString().equalsIgnoreCase(string) && (tDriverStructRecord.ID.equalsIgnoreCase("Aspect_Displays_Filter_Value_1") || tDriverStructRecord.ID.equalsIgnoreCase("Aspect_Displays_Filter_Value_2"))) {
                TAspectDriver tAspectDriver = ((TDisplaysFile)this.AspectDriver.F).ClientDriver;
                TDriverStructRecord tDriverStructRecord2 = this.AspectDriver.DriverStruct.getField("Aspect_Displays_Rows_Structure_FieldID");
                String string2 = (String)this.AspectDriver.getField(tDriverStructRecord2, n);
                TDriverStructRecord tDriverStructRecord3 = tAspectDriver.DriverStruct.getField(string2);
                TDisplaysRowsDropDownEditor tDisplaysRowsDropDownEditor = new TDisplaysRowsDropDownEditor(tAspectDriver, tDriverStructRecord3);
                return tDisplaysRowsDropDownEditor;
            }
            this.DropDownListEditor = new TDropDownListEditor(this.AspectDriver);
            return this.DropDownListEditor;
        }
        if (tDriverStructRecord.EditorType == 6) {
            return new TTextAreaCellEditor(tDriverStructRecord.ArraySize, this.fontDetail);
        }
        if (tableCellEditor == null && (tableCellEditor = super.getCellEditor(n, n2)) instanceof DefaultCellEditor) {
            n3 = this.Application.getTokenValueAsInt("$EditClickCount");
            if (n3 < 1) {
                n3 = 1;
            }
            ((DefaultCellEditor)tableCellEditor).setClickCountToStart(n3);
        }
        return tableCellEditor;
    }

    @Override
    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        if (this.DebugShowEntry) {
            System.out.println("TScrollTable.prepareEditor");
        }
        final Component component = super.prepareEditor(tableCellEditor, n, n2);
        boolean bl = this.isRowSelected(n);
        boolean bl2 = this.isColumnSelected(n2);
        if (this.fontDetail != null) {
            component.setFont(this.fontDetail);
        }
        if (component instanceof JComponent && !this.isOpaque()) {
            ((JComponent)component).setOpaque(false);
            component.setForeground(this.colorTableForeground);
        }
        if (this.fontDetail != null) {
            component.setFont(this.fontDetail);
        }
        if (bl) {
            if (bl2) {
                component.setBackground(this.colorSelectionForeground);
                component.setForeground(this.colorSelectionBackground);
            } else {
                component.setBackground(this.colorSelectionBackground);
                component.setForeground(this.colorSelectionForeground);
            }
        } else {
            component.setBackground(this.colorTableBackground);
            component.setForeground(this.colorTableForeground);
        }
        if (tableCellEditor instanceof TStringCellEditor) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((TStringCellEditor.TStringEditor)component).requestFocusInWindow();
                }
            });
        }
        if (tableCellEditor instanceof TDropDownListEditor) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((JComboBox)component).getEditor().getEditorComponent().requestFocusInWindow();
                }
            });
        }
        if (component instanceof TNumberSpinnerCellEditor.TNumberSpinner) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((TNumberSpinnerCellEditor.TNumberSpinner)component).getTextField().requestFocusInWindow();
                }
            });
        }
        return component;
    }

    @Override
    public String getColumnName(int n) {
        return this.getTableModel().getColumnName(n);
    }

    public void initColumnWidths() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        this.InitializingColumnWidths = true;
        TProgressBar tProgressBar = null;
        TScrollTableModel tScrollTableModel = (TScrollTableModel)this.getModel();
        TableColumn tableColumn = null;
        TableCellRenderer tableCellRenderer = this.getTableHeader().getDefaultRenderer();
        Component component = null;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        int n8 = 0;
        int n9 = 0;
        boolean bl = false;
        if (this.DebugShowEntry) {
            System.out.println("TScrollTable.initColumnWidths");
        }
        this.setAutoResizeMode(0);
        String string = "Formatting ";
        if (this.AppDriversObject != null) {
            string = string + this.AppDriversObject.Description;
        }
        if ((n7 = (n6 = tScrollTableModel.getRowCount()) / 30) < 1) {
            n7 = 1;
        }
        if ((n5 = tScrollTableModel.getColumnCount()) != (n4 = ((TScrollTableColumnModel)this.getColumnModel()).getTableColumnCount())) {
            return;
        }
        for (n3 = 0; n3 < tScrollTableModel.getColumnCount(); ++n3) {
            tableColumn = this.getColumnModel().getColumn(n3);
            if (tableColumn == null) continue;
            stringBuilder.setLength(0);
            stringBuilder.append(this.getModel().getColumnName(n3));
            string = "";
            while (!charutil.nullstr(stringBuilder)) {
                charutil.getsubstring(stringBuilder2, stringBuilder, 0, '\n', true);
                if (stringBuilder2.length() <= string.length()) continue;
                string = stringBuilder2.toString() + "  ";
            }
            component = tableCellRenderer.getTableCellRendererComponent(this, string, false, false, 0, 0);
            n8 = component.getPreferredSize().width + 10;
            TDriverStructRecord tDriverStructRecord = this.AspectDriver.getDriverStructRecord(n3);
            n2 = 0;
            if (this.getModel().getColumnName(n3).equals("Structure\nField ID") || this.getModel().getColumnName(n3).equals("Structure Field")) {
                n2 = 50;
            } else {
                TableCellRenderer tableCellRenderer2 = this.getCellRenderer(0, n3);
                n = 0;
                for (int i = 0; n < 5 && i < n6; i += n7) {
                    ++n;
                    component = this.prepareRenderer(tableCellRenderer2, i, n3);
                    if (component == null) continue;
                    int n10 = component.getPreferredSize().width + 10;
                    int n11 = component.getPreferredSize().height;
                    if (tDriverStructRecord.IsLookup) {
                        n10 += 15;
                    }
                    if (tDriverStructRecord.RendererType == 7 && n11 > 0 && this.getRowHeight() / n11 > 0) {
                        n10 /= this.getRowHeight() / n11;
                    }
                    if (tDriverStructRecord.RendererType == 8 && n10 > (n4 = (int)charutil.divby(this.getWidth(), tScrollTableModel.getColumnCount()) * 4)) {
                        n10 = n4;
                    }
                    if (tDriverStructRecord.MinimumCellWidth > 0 && n10 < tDriverStructRecord.MinimumCellWidth) {
                        n10 = tDriverStructRecord.MinimumCellWidth;
                    }
                    if (tDriverStructRecord.MaximumCellWidth > 0 && n10 > tDriverStructRecord.MaximumCellWidth) {
                        n10 = tDriverStructRecord.MaximumCellWidth;
                    }
                    n2 = Math.max(n2, n10);
                }
            }
            n5 = (int)Math.floor((double)Math.max(n8, n2) * 1.1);
            if (tableColumn != null) {
                tableColumn.setPreferredWidth(n5);
            }
            n9 += n5;
        }
        n5 = (int)((double)n9 * 0.66);
        for (n3 = 0; n3 < tScrollTableModel.getColumnCount(); ++n3) {
            tableColumn = this.getColumnModel().getColumn(n3);
            if (tableColumn == null || (n2 = tableColumn.getPreferredWidth()) <= n5) continue;
            tableColumn.setPreferredWidth(n5);
        }
        n9 = 0;
        for (n3 = 0; n3 < tScrollTableModel.getColumnCount(); ++n3) {
            tableColumn = this.getColumnModel().getColumn(n3);
            if (tableColumn == null) continue;
            n9 += tableColumn.getPreferredWidth();
        }
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = this.ScrollTablePanel.getBounds();
        if (this.AspectDriver.AspectDriverFilter.ActiveAppTablesObj.AutoResize || n9 < rectangle2.width) {
            this.setAutoResizeMode(2);
            n5 = rectangle.width - n9;
            n = (int)Math.floor((double)n5 / (double)tScrollTableModel.getColumnCount());
            int n12 = 0;
            if (tScrollTableModel.getColumnCount() > 0) {
                n12 = n5 % tScrollTableModel.getColumnCount();
            }
            for (n3 = 0; n3 < tScrollTableModel.getColumnCount(); ++n3) {
                tableColumn = this.getColumnModel().getColumn(n3);
                if (tableColumn == null) continue;
                tableColumn.setPreferredWidth(tableColumn.getPreferredWidth() + n);
                if (n12 == 0) continue;
                tableColumn.setPreferredWidth(tableColumn.getPreferredWidth() + n12);
                if (n12 < 0) {
                    ++n12;
                    continue;
                }
                --n12;
            }
        }
        if (tProgressBar != null) {
            tProgressBar.dispose();
        }
        this.InitializingColumnWidths = false;
    }

    public String editRecord() {
        int n = this.getSelectedRow();
        int n2 = this.getSelectedColumn();
        this.stopEditing();
        String string = this.executeDialog();
        this.getTableModel().fireTableDataChanged();
        this.requestFocus();
        this.scrollToCell(n, n2);
        if (n2 >= 0) {
            this.setColumnSelectionInterval(n2, n2);
        }
        this.setRowSelectionInterval(n, n);
        this.refreshFilterTree();
        return string;
    }

    public String insertRecord(boolean bl, boolean bl2) {
        int n;
        this.stopEditing();
        if (!this.AspectDriver.AspectDriverFilter.ActiveAppTablesObj.CanInsert) {
            return "Cancel";
        }
        Integer n2 = null;
        int n3 = this.AspectDriver.getMaxRecords();
        String string = "ok";
        boolean bl3 = this.getTableModel().isDialogDefined();
        if (n3 > 0 && this.AspectDriver.getAbsoluteRecordCount() >= n3) {
            this.AspectDriver.showMaxRecordsReachedMessage();
            return "cancel";
        }
        if (this.DebugShowEntry) {
            System.out.println("TScrollTable.insertRecord");
        }
        this.AspectDriver.beginNewUndoOperation("Insert Record");
        TDriverStructRecord tDriverStructRecord = this.AspectDriver.getVirtualIndexField();
        int n4 = this.getSelectedRow();
        if (tDriverStructRecord != null && n4 >= 0) {
            n2 = (Integer)this.AspectDriver.getField(tDriverStructRecord, n4);
        }
        int n5 = this.AspectDriver.initializeNewRecord(this.AppDriversObject.InsertMode, n4);
        if (bl2 && bl3) {
            n = this.AspectDriver.addToFilterList(n5, -1);
            this.getTableModel().WizardTempRecordExists = true;
            string = this.executeDialog(n);
            this.AspectDriver.removeFromFilterList(n5);
            this.getTableModel().WizardTempRecordExists = false;
        }
        if (string.equalsIgnoreCase("ok")) {
            if (tDriverStructRecord != null) {
                if (bl) {
                    n2 = new Integer(this.AspectDriver.getNextVirtualIndex());
                } else if (n2 != null) {
                    this.AspectDriver.createUnusedVirtualIndex(n2);
                } else {
                    n2 = new Integer(this.AspectDriver.getNextVirtualIndex());
                }
                this.AspectDriver.putFieldAbsolute(tDriverStructRecord, n5, (Object)n2);
            }
            n = bl ? this.AspectDriver.addToFilterList(n5, -1) : (bl3 ? this.AspectDriver.addToFilterList(n5) : this.AspectDriver.addToFilterList(n5, n4));
            this.getTableModel().fireTableRowsInserted(n, n);
            this.setSelectedRow(n, false);
            this.getTableModel().fireTableDataChanged();
            this.setSelectedRow(n, true);
        } else {
            this.AspectDriver.deleteRecordAbsolute(n5);
            this.AspectDriver.removeLastUndo();
        }
        return string;
    }

    public boolean deleteRecords() {
        this.stopEditing();
        if (!this.AspectDriver.AspectDriverFilter.ActiveAppTablesObj.CanDelete) {
            return false;
        }
        int[] nArray = this.getSelectedRows();
        if (nArray.length == 0) {
            return false;
        }
        String string = "Delete this record?";
        if (nArray.length > 1) {
            string = "Delete these records?";
        }
        if (this.MainWin.showConfirmDialog(null, string, "Confirm...", 0) != 0) {
            return false;
        }
        this.AspectDriver.beginNewUndoOperation("Delete Records");
        TProgressBar tProgressBar = null;
        for (int i = 0; i < nArray.length; ++i) {
            this.AspectDriver.deleteRecord(nArray[i]);
            if (tProgressBar == null) continue;
            tProgressBar.increment();
        }
        if (tProgressBar != null) {
            tProgressBar.dispose();
        }
        this.AspectDriver.initializeFilteredList();
        this.getTableModel().fireTableDataChanged();
        this.refreshFilterTree();
        return true;
    }

    public int moveRowUp(int n) {
        if (n > 0) {
            this.AspectDriver.swapRecords(n, n - 1);
            this.AspectDriver.swapVirtualIndexField(n, n - 1);
            return 1;
        }
        return 0;
    }

    public void moveSelectionUp() {
        this.stopEditing();
        int[] nArray = this.getSelectedRows();
        int n = nArray.length;
        this.AspectDriver.beginNewUndoOperation("Move Selection Up");
        if (n > 0 && nArray[0] > 0) {
            for (int i = 0; i < n; ++i) {
                this.moveRowUp(nArray[i]);
            }
            this.setSelectedRows(nArray[0] - 1, nArray[n - 1] - 1);
            this.scrollToCell(nArray[0] - 1, -1);
        }
    }

    public int moveRowDown(int n) {
        if (n < this.getTableModel().getRowCount() - 1) {
            this.AspectDriver.swapRecords(n, n + 1);
            this.AspectDriver.swapVirtualIndexField(n, n + 1);
            return 1;
        }
        return 0;
    }

    public void moveSelectionDown() {
        this.stopEditing();
        this.AspectDriver.beginNewUndoOperation("Move Selection Down");
        int[] nArray = this.getSelectedRows();
        int n = nArray.length;
        if (n > 0 && nArray[n - 1] < this.getRowCount() - 1) {
            for (int i = n - 1; i >= 0; --i) {
                this.moveRowDown(nArray[i]);
            }
            this.scrollToCell(nArray[n - 1] + 2, -1);
            this.setSelectedRows(nArray[0] + 1, nArray[n - 1] + 1);
        }
    }

    public void cutRecords() {
        this.stopEditing();
        this.copyRecords();
        this.deleteRecords();
    }

    public void copyRecords() {
        TDriverStructRecord tDriverStructRecord;
        int n;
        this.stopEditing();
        ArrayList<TDriverStructRecord> arrayList = new ArrayList<TDriverStructRecord>();
        StringBuilder stringBuilder = new StringBuilder();
        int[] nArray = this.getSelectedRows();
        int n2 = this.getSelectedRowCount();
        int n3 = this.AspectDriver.DriverStruct.FieldColl.size();
        for (n = 0; n < n3; ++n) {
            tDriverStructRecord = (TDriverStructRecord)this.AspectDriver.DriverStruct.FieldColl.get(n);
            if (tDriverStructRecord.IsCalculated || tDriverStructRecord.IsVirtual) continue;
            arrayList.add(tDriverStructRecord);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            tDriverStructRecord = (TDriverStructRecord)arrayList.get(n);
            stringBuilder.append(tDriverStructRecord.FullID);
            if (n >= arrayList.size() - 1) continue;
            stringBuilder.append("\t");
        }
        stringBuilder.append("\n");
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < arrayList.size(); ++i) {
                tDriverStructRecord = (TDriverStructRecord)arrayList.get(i);
                Object object = this.AspectDriver.getField(tDriverStructRecord, nArray[n]);
                if (object != null) {
                    stringBuilder.append(objectutil.convertFieldTypeToString(tDriverStructRecord.FieldType, object));
                }
                if (i >= arrayList.size() - 1) continue;
                stringBuilder.append("\t");
            }
            stringBuilder.append("\n");
        }
        StringSelection stringSelection = new StringSelection(stringBuilder.toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, stringSelection);
    }

    public void duplicateRecords() {
        this.stopEditing();
        this.copyRecords();
        this.pasteRecords(true);
    }

    public void pasteRecords(boolean bl) {
        this.stopEditing();
        String[] stringArray = null;
        Object var10_3 = null;
        int[] nArray = this.getSelectedRows();
        int n = -1;
        int n2 = this.AspectDriver.getMaxRecords();
        boolean bl2 = false;
        TAppTablesObject tAppTablesObject = this.AspectDriver.AspectDriverFilter.ActiveAppTablesObj;
        if (!tAppTablesObject.CanEdit) {
            JOptionPane.showMessageDialog(null, "This table does not permit editing.", "Information", 1);
            return;
        }
        if (n2 > 0 && this.AspectDriver.getAbsoluteRecordCount() >= n2) {
            JOptionPane.showMessageDialog(null, "The maximum number of records allowed is " + n2 + ".", "Information...", 1);
            return;
        }
        this.AspectDriver.beginNewUndoOperation("Paste Records");
        TDriverStructRecord tDriverStructRecord = this.AspectDriver.getVirtualIndexField();
        if (tDriverStructRecord != null) {
            n = this.AspectDriver.getNextVirtualIndex() - 1;
        }
        int n3 = this.getTableModel().getRowCount();
        if (nArray.length > 0) {
            n3 = nArray[0];
            if (tDriverStructRecord != null) {
                n = (Integer)this.AspectDriver.getField(tDriverStructRecord, n3);
            }
        }
        try {
            TDriverStructRecord tDriverStructRecord2;
            int n4;
            String string;
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            String string2 = (String)clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
            if (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                stringArray = charutil.getSubStringArray(string, '\t', true);
            }
            boolean bl3 = false;
            for (n4 = 0; n4 < stringArray.length; ++n4) {
                tDriverStructRecord2 = this.AspectDriver.getDriverStructRecord(stringArray[n4]);
                if (tDriverStructRecord2 == null) continue;
                bl3 = true;
            }
            if (!bl3) {
                JOptionPane.showMessageDialog(null, "No valid records were found on the clipboard.", "Information", 1);
            }
            while (bl3 && !bl2 && stringTokenizer.hasMoreTokens()) {
                int n5;
                int n6;
                string = stringTokenizer.nextToken();
                if (string.trim().length() <= 0) continue;
                if (bl) {
                    n6 = this.AspectDriver.initializeNewRecord(this.AppDriversObject.InsertMode, n3);
                    n5 = this.AspectDriver.addToFilterList(n6, n3);
                    if (tDriverStructRecord != null) {
                        this.AspectDriver.createUnusedVirtualIndex(n);
                        this.AspectDriver.putField(tDriverStructRecord, n3, (Object)new Integer(n));
                        ++n;
                    }
                } else if (n3 >= this.getTableModel().getRowCount()) {
                    n6 = this.AspectDriver.initializeNewRecord(this.AppDriversObject.InsertMode, n3);
                    n5 = this.AspectDriver.addToFilterList(n6, -1);
                    if (tDriverStructRecord != null) {
                        this.AspectDriver.createUnusedVirtualIndex(n + 1);
                        this.AspectDriver.putField(tDriverStructRecord, n3, (Object)new Integer(n + 1));
                        ++n;
                    }
                } else if (tDriverStructRecord != null) {
                    n = (Integer)this.AspectDriver.getField(tDriverStructRecord, n3);
                }
                if (!this.AspectDriver.isSubtotal(n3)) {
                    String[] stringArray2 = charutil.getSubStringArray(string, '\t', false);
                    for (n4 = 0; n4 < stringArray2.length && n4 < stringArray.length; ++n4) {
                        tDriverStructRecord2 = this.AspectDriver.getDriverStructRecord(stringArray[n4]);
                        if (tDriverStructRecord2 == null || tDriverStructRecord2.IsCalculated || tDriverStructRecord2.IsVirtual || tDriverStructRecord2.DoNotPaste || tDriverStructRecord != null && tDriverStructRecord2.FullID.equalsIgnoreCase(tDriverStructRecord.FullID)) continue;
                        Object object = objectutil.convertStringToFieldType(tDriverStructRecord2.FieldType, stringArray2[n4], -1);
                        this.AspectDriver.putField(tDriverStructRecord2, n3, object);
                    }
                }
                ++n3;
            }
            if (n2 > 0 && this.AspectDriver.getAbsoluteRecordCount() >= n2) {
                this.AspectDriver.showMaxRecordsReachedMessage();
                bl2 = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.getTableModel().fireTableDataChanged();
    }

    public void cutCells() {
        this.copyCells();
        this.deleteCells();
    }

    public void deleteCells() {
        this.stopEditing();
        int n = this.getSelectedRow();
        int n2 = this.getSelectedColumn();
        int[] nArray = this.getSelectedRows();
        int[] nArray2 = this.getSelectedColumns();
        int n3 = this.getSelectedColumnCount();
        int n4 = this.getSelectedRowCount();
        if (nArray.length == 0 || nArray2.length == 0) {
            return;
        }
        this.AspectDriver.beginNewUndoOperation("Delete Cells");
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                TDriverStructRecord tDriverStructRecord = this.AspectDriver.getDriverStructRecord(nArray2[j]);
                Object object = objectutil.getErrorValue(tDriverStructRecord.FieldType);
                this.AspectDriver.putField(nArray[i], nArray2[j], object);
            }
        }
        this.getTableModel().updateCalculatedCells();
        this.getTableModel().fireTableDataChanged();
        this.scrollToCell(nArray[0], nArray2[0]);
        this.setColumnSelectionInterval(nArray2[0], nArray2[nArray2.length - 1]);
        this.setRowSelectionInterval(nArray[0], nArray[nArray.length - 1]);
    }

    public void copyCells() {
        this.stopEditing();
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.getSelectedRow();
        int n2 = this.getSelectedColumn();
        int[] nArray = this.getSelectedRows();
        int[] nArray2 = this.getSelectedColumns();
        int n3 = this.getSelectedColumnCount();
        int n4 = this.getSelectedRowCount();
        if (nArray.length == 0 || nArray2.length == 0) {
            return;
        }
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                Object object = this.getValueAt(nArray[i], nArray2[j]);
                stringBuilder.append(objectutil.convertToString(object));
                if (j >= n3 - 1) continue;
                stringBuilder.append("\t");
            }
            stringBuilder.append("\n");
        }
        StringSelection stringSelection = new StringSelection(stringBuilder.toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, stringSelection);
        this.setSelectedRows(nArray);
        this.setSelectedColumns(nArray2);
        this.scrollToCell(n, n2);
    }

    public void pasteCells() {
        this.stopEditing();
        int n = this.getSelectedRows()[0];
        int n2 = this.getSelectedRows()[0];
        int n3 = this.getSelectedColumns()[0];
        int n4 = 0;
        int n5 = this.getTableModel().getColumnCount();
        int n6 = this.getTableModel().getRowCount();
        int n7 = this.getSelectedRowCount();
        int n8 = this.getSelectedColumnCount();
        int n9 = 0;
        TAppTablesObject tAppTablesObject = this.AspectDriver.AspectDriverFilter.ActiveAppTablesObj;
        if (!tAppTablesObject.CanEdit) {
            JOptionPane.showMessageDialog(null, "This table does not permit editing.", "Information", 1);
            return;
        }
        this.AspectDriver.beginNewUndoOperation("Paste Cells");
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            String string = (String)clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor);
            String[] stringArray = charutil.getSubStringArray(string, '\n', true);
            int n10 = stringArray.length - 1;
            if (n7 > n10) {
                n10 = n7;
            }
            n4 = 0;
            while (n9 < n10 && n2 < n6) {
                if (!this.AspectDriver.isSubtotal(n2)) {
                    String[] stringArray2 = charutil.getSubStringArray(stringArray[n4], '\t', true);
                    if (stringArray2 != null) {
                        int n11 = n3;
                        for (int i = 0; i < stringArray2.length && n11 < n5; ++n11, ++i) {
                            TDriverStructRecord tDriverStructRecord = this.AspectDriver.getDriverStructRecord(n11);
                            if (tDriverStructRecord == null || !tDriverStructRecord.IsEditable || tDriverStructRecord.IsCalculated) continue;
                            Object object = tDriverStructRecord.IsLookup ? this.AspectDriver.convertComboboxStringToFieldValue(tDriverStructRecord.FullID, stringArray2[i], n2) : objectutil.convertStringToFieldType(tDriverStructRecord.FieldType, stringArray2[i], -1);
                            this.AspectDriver.putField(n2, n11, object);
                        }
                    }
                    ++n9;
                    if (++n4 >= stringArray.length - 1) {
                        n4 = 0;
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.getTableModel().updateCalculatedCells();
        this.getTableModel().fireTableDataChanged();
        this.scrollToCell(n, n3);
        this.setColumnSelectionInterval(n3, n3);
        this.setRowSelectionInterval(n, n);
    }

    public void undo() {
        this.stopEditing();
        this.AspectDriver.undo();
        this.getTableModel().fireTableDataChanged();
        this.requestFocus();
    }

    public void redo() {
        this.stopEditing();
        this.AspectDriver.redo();
        this.getTableModel().fireTableDataChanged();
        this.requestFocus();
    }

    public boolean findNextMatch() {
        String string = this.Application.getTokenValue("$Search");
        int n = this.getSelectedRow();
        int n2 = 0;
        int n3 = this.getTableModel().getRowCount();
        int n4 = this.getTableModel().getColumnCount();
        if (n == this.LastFindRow) {
            n2 = this.LastFindCol + 1;
            if (n2 >= n4) {
                ++n;
                n2 = 0;
            }
        } else {
            n = 0;
            n2 = 0;
        }
        if (n < 0) {
            n = 0;
        }
        if (n >= n3) {
            n = 0;
        }
        string = string.toUpperCase();
        while (n < n3) {
            while (n2 < n4) {
                TDriverStructRecord tDriverStructRecord = this.AspectDriver.getDriverStructRecord(n2);
                Object object = this.getValueAt(n, n2);
                String string2 = objectutil.convertFieldTypeToString(tDriverStructRecord.FieldType, object).toUpperCase();
                if (string2.indexOf(string) >= 0) {
                    this.setSelectedRow(n, false);
                    this.setSelectedColumn(n2, false);
                    this.scrollToCell(n, n2);
                    this.LastFindRow = n;
                    this.LastFindCol = n2;
                    return true;
                }
                ++n2;
            }
            n2 = 0;
            ++n;
        }
        return false;
    }

    public void search() {
        this.stopEditing();
        String string = TMainWin.executeDialog("SearchDialog");
        this.requestFocus();
        if (!string.equalsIgnoreCase("ok")) {
            return;
        }
        this.Application.AppCollections.addToSearchHistory(this.Application.getTokenValue("$Search"));
        this.LastFindRow = -1;
        this.LastFindCol = -1;
        if (!this.findNextMatch() && !this.findNextMatch()) {
            JOptionPane.showMessageDialog(null, "Record not found.", "Information...", 1);
        }
    }

    public void searchAgain() {
        if (!this.findNextMatch()) {
            this.LastFindRow = -1;
            this.LastFindCol = -1;
            if (!this.findNextMatch()) {
                JOptionPane.showMessageDialog(null, "Record not found.", "Information...", 1);
            }
        }
    }

    public void replace() {
        this.stopEditing();
        String string = TMainWin.executeDialog("ReplaceDialog");
        if (!string.equalsIgnoreCase("ok")) {
            return;
        }
        this.getTableModel().fireTableDataChanged();
    }

    @Override
    public void selectAll() {
        if (this.AspectDriver.DefaultAppTablesObj.ListSelectionMode < 2) {
            this.setSelectedRows(0, this.getRowCount() - 1);
        } else {
            JOptionPane.showMessageDialog(null, "Multiple selections are not available in this display.", "Information...", 1);
        }
    }

    public void gotoLineStart() {
        this.setSelectedColumn(0, true);
    }

    public void gotoLineEnd() {
        this.setSelectedColumn(this.getColumnCount() - 1, true);
    }

    public void editNote() {
    }

    public boolean getIsRefreshing() {
        return this.IsRefreshing;
    }

    public void refreshTable() {
        if (this.IsRefreshing) {
            return;
        }
        this.IsRefreshing = true;
        this.stopEditing();
        this.AspectDriver.clearBuffer();
        this.AspectDriver.AspectDriverFilter.applyDisplay(true);
        this.InitializeColumnWidths = true;
        this.InitializeEditors = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TScrollTable.this.getTableModel().fireTableStructureChanged();
            }
        });
        this.IsRefreshing = false;
    }

    public void redrawTable() {
        int n = this.getTableModel().getRowCount();
        if (this.AspectDriver != null) {
            n = this.AspectDriver.getRecordCount();
        }
        this.getTableModel().fireTableRowsUpdated(0, n);
        this.getTableHeader().resizeAndRepaint();
    }

    public void editDisplayOptions() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList arrayList = new ArrayList();
        for (n = 0; n < this.AspectDriver.AspectDriverFilter.ColumnList.size(); ++n) {
            arrayList.add(this.AspectDriver.AspectDriverFilter.ColumnList.get(n));
        }
        this.updateDisplayColumnOrder();
        this.AspectDriver.AspectDriverFilter.saveCurrentDisplay(true);
        this.Application.parse_tokens(stringBuilder, "{Driver_Displays_Dialog}");
        TDisplaysFile.ActiveTabelPanel = this.ScrollTablePanel;
        String string = TMainWin.executeDialog(stringBuilder.toString());
        Aspect.MainWin.paintComponents(Aspect.MainWin.getGraphics());
        this.Application.setTokenValue("$ScrollWinUpdateDisplayCollections", "");
        if (string.equalsIgnoreCase("ok")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StringBuilder stringBuilder = new StringBuilder();
                    TScrollTable.this.Application.getTokenValue(stringBuilder, "$ScrollWinDisplayName");
                    TScrollTable.this.AspectDriver.loadDisplay(stringBuilder.toString());
                    TScrollTable.this.InitializeColumnWidths = true;
                    TScrollTable.this.InitializeEditors = true;
                    TScrollTable.this.getTableModel().fireTableStructureChanged();
                }
            });
        } else {
            this.AspectDriver.AspectDriverFilter.ColumnList.clear();
            for (n = 0; n < arrayList.size(); ++n) {
                this.AspectDriver.AspectDriverFilter.ColumnList.add(arrayList.get(n));
            }
        }
    }

    public void loadDisplayOptions() {
        StringBuilder stringBuilder = new StringBuilder();
        this.stopEditing();
        this.Application.getTokenValue(stringBuilder, "$ScrollWinDisplayName");
        this.AspectDriver.loadDisplay(stringBuilder.toString());
        this.InitializeColumnWidths = true;
        this.InitializeEditors = true;
        this.getTableModel().fireTableStructureChanged();
    }

    public void exportToAscii() {
        String string = TMainWin.executeDialog("CommonSelectFile", 0);
        if (string.equalsIgnoreCase("ok")) {
            String string2 = this.Application.getTokenValue("$CommonSelectFileName");
            this.AspectDriver.exportToAscii(string2, this.AspectDriver.AppDriverObj.StructureIndex.toString(), true, true, true, true, 0, true, false);
        }
    }

    public void loadAsSpreadsheet() {
        File file = dosutil.createTempFile("csv");
        this.AspectDriver.exportToAscii(file.getAbsolutePath(), this.AspectDriver.AppDriverObj.StructureIndex.toString(), true, true, true, true, 0, true, false);
        try {
            Launch.launchAssociatedWindowsApp(file.getAbsolutePath());
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    public ArrayList getSupportedDriverCommands() {
        int n;
        TAppTablesObject tAppTablesObject = this.AspectDriver.AspectDriverFilter.ActiveAppTablesObj;
        ArrayList arrayList = this.AspectDriver.getSupportedDriverCommands();
        if (!tAppTablesObject.CanEdit) {
            n = arrayList.indexOf("Edit");
            if (n >= 0) {
                arrayList.remove(n);
            }
            if ((n = arrayList.indexOf("MoveUp")) >= 0) {
                arrayList.remove(n);
            }
            if ((n = arrayList.indexOf("MoveDown")) >= 0) {
                arrayList.remove(n);
            }
            if ((n = arrayList.indexOf("PasteCells")) >= 0) {
                arrayList.remove(n);
            }
            if ((n = arrayList.indexOf("Replace")) >= 0) {
                arrayList.remove(n);
            }
        }
        if (!tAppTablesObject.CanInsert) {
            n = arrayList.indexOf("InsertRecord");
            if (n >= 0) {
                arrayList.remove(n);
            }
            if ((n = arrayList.indexOf("AppendRecord")) >= 0) {
                arrayList.remove(n);
            }
            if ((n = arrayList.indexOf("DuplicateRecords")) >= 0) {
                arrayList.remove(n);
            }
            if ((n = arrayList.indexOf("InsertCopiedRecords")) >= 0) {
                arrayList.remove(n);
            }
        }
        if (!tAppTablesObject.CanDelete) {
            n = arrayList.indexOf("Delete");
            if (n >= 0) {
                arrayList.remove(n);
            }
            if ((n = arrayList.indexOf("CutRecords")) >= 0) {
                arrayList.remove(n);
            }
        }
        if (!(tAppTablesObject.CanEdit || tAppTablesObject.CanInsert || tAppTablesObject.CanDelete)) {
            n = arrayList.indexOf("Undo");
            if (n >= 0) {
                arrayList.remove(n);
            }
            if ((n = arrayList.indexOf("Redo")) >= 0) {
                arrayList.remove(n);
            }
        }
        return arrayList;
    }

    public void executeDriverCommand(String string, String string2) {
        if (string.equalsIgnoreCase("InsertRecord")) {
            this.insertRecord(false, true);
        } else if (string.equalsIgnoreCase("AppendRecord")) {
            this.insertRecord(true, true);
        } else if (string.equalsIgnoreCase("CutRecords")) {
            this.cutRecords();
        } else if (string.equalsIgnoreCase("Delete")) {
            this.deleteRecords();
        } else if (string.equalsIgnoreCase("DuplicateRecords")) {
            this.duplicateRecords();
        } else if (string.equalsIgnoreCase("Edit")) {
            this.editRecord();
        } else if (string.equalsIgnoreCase("InsertCopiedRecords")) {
            this.pasteRecords(true);
        } else if (string.equalsIgnoreCase("MoveUp")) {
            this.moveSelectionUp();
        } else if (string.equalsIgnoreCase("MoveDown")) {
            this.moveSelectionDown();
        } else if (string.equalsIgnoreCase("PasteCells")) {
            this.pasteCells();
        } else if (string.equalsIgnoreCase("PasteRecords")) {
            this.pasteRecords(false);
        } else if (string.equalsIgnoreCase("Search")) {
            this.search();
        } else if (string.equalsIgnoreCase("Replace")) {
            this.replace();
        } else if (string.equalsIgnoreCase("CopyRecords")) {
            this.copyRecords();
        } else if (string.equalsIgnoreCase("CopyCells")) {
            this.copyCells();
        } else if (string.equalsIgnoreCase("CutCells")) {
            this.cutCells();
        } else if (string.equalsIgnoreCase("DeleteCells")) {
            this.deleteCells();
        } else if (string.equalsIgnoreCase("Note")) {
            this.editNote();
        } else if (string.equalsIgnoreCase("Display")) {
            this.editDisplayOptions();
        } else if (string.equalsIgnoreCase("LoadDisplay")) {
            this.loadDisplayOptions();
        } else if (string.equalsIgnoreCase("Undo")) {
            this.undo();
        } else if (string.equalsIgnoreCase("Redo")) {
            this.redo();
        } else if (string.equalsIgnoreCase("RefreshTable")) {
            this.refreshTable();
        } else if (string.equalsIgnoreCase("LoadAsSpreadsheet")) {
            this.loadAsSpreadsheet();
        } else if (string.equalsIgnoreCase("ExportToAscii")) {
            this.exportToAscii();
        } else if (string.equalsIgnoreCase("AddToViews")) {
            this.getTableModel().AspectDriver.addToViews();
        } else {
            this.getTableModel().AspectDriver.executeDriverCommand(this, string, string2);
        }
        this.requestFocus();
    }

    public void sendDriverCmdMsg(String string, String string2) {
        this.getTableModel().AspectDriver.sendDriverCmdMsg(string, string2);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        boolean bl = false;
        if (this.DebugShowEntry) {
            System.out.println("TScrollTable.valueChanged");
        }
        super.valueChanged(listSelectionEvent);
        if (!listSelectionEvent.getValueIsAdjusting() && bl) {
            int[] nArray = this.getSelectedRows();
            System.out.print("Table value changed: ");
            for (int i = 0; i < nArray.length; ++i) {
                System.out.print(nArray[i]);
            }
            System.out.println();
        }
    }

    @Override
    public void doLayout() {
        if (this.DebugShowEntry) {
            System.out.println("TScrollTable.doLayout");
        }
        if (this.InitializeColumnWidths && !TMainWin.InShowGui) {
            this.initColumnWidths();
            this.InitializeColumnWidths = false;
        }
        if (this.InitializeEditors) {
            this.initializeEditors();
            this.InitializeEditors = false;
        }
        super.doLayout();
    }

    public TScrollFilterTree initializeFilterTree() {
        if (this.DebugShowEntry) {
            System.out.println("TScrollTable.initializeFilterTree");
        }
        this.FilterTree = new TScrollFilterTree(new TScrollFilterTreeNode(this.AppDriversObject.Description.toString(), true), this.FilterTreeListener, this.AspectDriver);
        return this.FilterTree;
    }

    public TScrollSubtotalTree initializeSubtotalTree() {
        if (this.DebugShowEntry) {
            System.out.println("TScrollTable.initializeSubtotalTree");
        }
        TScrollSubtotalTreeNode tScrollSubtotalTreeNode = new TScrollSubtotalTreeNode(-1, "Totals by...", -1, false, null, true);
        this.SubtotalTree = new TScrollSubtotalTree(tScrollSubtotalTreeNode, this.SubtotalTreeListener, this.AspectDriver);
        return this.SubtotalTree;
    }

    public void refreshFilterTree() {
        if (this.FilterTree != null) {
            this.FilterTree.initializeTree();
        }
    }

    public void refreshSubtotalTree() {
        if (this.SubtotalTree != null) {
            this.SubtotalTree.initializeTree();
        }
    }

    public void executeTimerCallback() {
        this.AspectDriver.executeTimerEvent(this);
        this.AspectDriver.clearBuffer();
        this.redrawTable();
        --this.cCallbacks;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equalsIgnoreCase("Insert Record") || string.equalsIgnoreCase("Insert")) {
            this.insertRecord(false, true);
        } else if (string.equalsIgnoreCase("Delete Record") || string.equalsIgnoreCase("Delete")) {
            this.deleteRecords();
        } else if (string.equalsIgnoreCase("Edit Record") || string.equalsIgnoreCase("Edit")) {
            this.editRecord();
        } else if (string.equalsIgnoreCase("MoveUp") || string.equalsIgnoreCase("Move Up")) {
            this.moveSelectionUp();
        } else if (string.equalsIgnoreCase("MoveDown") || string.equalsIgnoreCase("Move Down")) {
            this.moveSelectionDown();
        } else if (string.equalsIgnoreCase("Cut Record") || string.equalsIgnoreCase("Cut")) {
            this.cutRecords();
        } else if (string.equalsIgnoreCase("Copy Record") || string.equalsIgnoreCase("CopyRecords") || string.equalsIgnoreCase("Copy")) {
            this.copyRecords();
        } else if (string.equalsIgnoreCase("Paste Over Record")) {
            this.pasteRecords(false);
        } else if (string.equalsIgnoreCase("Copy Cells") || string.equalsIgnoreCase("CopyCells")) {
            this.copyCells();
        } else if (string.equalsIgnoreCase("Paste Cells") || string.equalsIgnoreCase("PasteCells")) {
            this.pasteCells();
        } else if (string.equalsIgnoreCase("Paste Record") || string.equalsIgnoreCase("InsertCopiedRecords") || string.equalsIgnoreCase("Paste")) {
            this.pasteRecords(true);
        } else if (string.equalsIgnoreCase("Close")) {
            this.closeWindow();
        } else if (string.equalsIgnoreCase("Escape")) {
            this.closeWindow();
        } else if (string.equalsIgnoreCase("Display Options") || string.equalsIgnoreCase("DisplayOptions")) {
            this.editDisplayOptions();
        } else if (string.equalsIgnoreCase("Append Record") || string.equalsIgnoreCase("Append")) {
            this.insertRecord(true, true);
        } else if (string.equalsIgnoreCase("Undo")) {
            this.undo();
        } else if (string.equalsIgnoreCase("Redo")) {
            this.redo();
        } else if (string.equalsIgnoreCase("Search")) {
            this.search();
        } else if (!string.equalsIgnoreCase("")) {
            if (string.equalsIgnoreCase("SearchAgain")) {
                this.searchAgain();
            } else if (string.equalsIgnoreCase("CtrlLeft")) {
                this.gotoLineStart();
            } else if (string.equalsIgnoreCase("CtrlRight")) {
                this.gotoLineEnd();
            } else if (!string.equalsIgnoreCase("CtrlHome") && !string.equalsIgnoreCase("CtrlEnd")) {
                if (string.equalsIgnoreCase("Duplicate Record") || string.equalsIgnoreCase("Duplicate")) {
                    this.duplicateRecords();
                } else if (string.equalsIgnoreCase("Cut Cells")) {
                    this.cutCells();
                } else if (string.equalsIgnoreCase("DeleteCells")) {
                    this.deleteCells();
                } else if (string.equalsIgnoreCase("Add To Views")) {
                    this.getTableModel().AspectDriver.addToViews();
                }
            }
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    class TColumnModelListener
    implements TableColumnModelListener {
        TColumnModelListener() {
        }

        @Override
        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        }

        @Override
        public void columnMarginChanged(ChangeEvent changeEvent) {
        }

        @Override
        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        @Override
        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }
    }

    class TSubtotalTreeListener
    implements TScrollSubtotalTreeNodeListenerInterface {
        TSubtotalTreeListener() {
        }

        @Override
        public void subtotalTreeNodeChanged(TScrollSubtotalTreeNodeEvent tScrollSubtotalTreeNodeEvent) {
            TScrollTable.this.stopEditing();
            TScrollSubtotalTreeNode tScrollSubtotalTreeNode = tScrollSubtotalTreeNodeEvent.getSource();
            boolean bl = tScrollSubtotalTreeNode.isSelected();
            if (tScrollSubtotalTreeNode.GroupType == 0) {
                if (bl) {
                    TScrollTable.this.AspectDriver.AspectDriverFilter.initializeFilteredList();
                } else {
                    TScrollTable.this.AspectDriver.AspectDriverFilter.removeFromFilteredList(0);
                }
            } else {
                TScrollTable.this.AspectDriver.AspectDriverFilter.addSubtotalsToFilteredList();
            }
            TScrollTable.this.getTableModel().fireTableDataChanged();
            if (TScrollTable.this.FilterTree != null) {
                TScrollTable.this.FilterTree.initializeTree();
            }
            TScrollTable.this.SaveDisplayOnClose = true;
        }
    }

    class TFilterTreeListener
    implements TScrollFilterTreeNodeListenerInterface {
        TFilterTreeListener() {
        }

        @Override
        public void filterTreeNodeChanged(TScrollFilterTreeNodeEvent tScrollFilterTreeNodeEvent) {
            TScrollFilterTree cfr_ignored_0 = TScrollTable.this.FilterTree;
            if (TScrollFilterTree.cFilterTreeBuilderInstance > 0) {
                return;
            }
            if (TScrollTable.this.FilterTree.InitializingTree) {
                return;
            }
            TScrollTable.this.stopEditing();
            Cursor cursor = TScrollTable.this.getCursor();
            TScrollTable.this.setCursor(Cursor.getPredefinedCursor(3));
            TScrollTable.this.AspectDriver.AspectDriverFilter.initializeFilteredList();
            TScrollTable.this.setCursor(Cursor.getPredefinedCursor(0));
            TScrollTable.this.getTableModel().fireTableDataChanged();
        }
    }

    class ScrollTableTimerListener
    implements ActionListener {
        ScrollTableTimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (TScrollTable.this.DebugShowEntry) {
                System.out.println("TScrollTable.TimerListener.actionPerformed");
            }
            if (TScrollTable.this.cCallbacks > 0) {
                return;
            }
            ++TScrollTable.this.cCallbacks;
            SwingWorker swingWorker = new SwingWorker(){

                @Override
                public Object construct() {
                    return null;
                }

                @Override
                public void finished() {
                    TScrollTable.this.executeTimerCallback();
                }
            };
            swingWorker.start();
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n;
            if (TScrollTable.this.DebugShowEntry) {
                System.out.println("TScrollTable.PopupListener.mousePressed");
            }
            if (mouseEvent.getButton() == 3 && (n = TScrollTable.this.getSelectedRowCount()) <= 1) {
                int n2 = TScrollTable.this.rowAtPoint(mouseEvent.getPoint());
                int n3 = TScrollTable.this.columnAtPoint(mouseEvent.getPoint());
                if (n == 0 || n == 1 && n2 != TScrollTable.this.getSelectedRow()) {
                    TScrollTable.this.setSelectedRow(n2, false);
                    TScrollTable.this.setSelectedColumn(n3, false);
                    TScrollTable.this.scrollToCell(n2, n3);
                }
            }
            this.maybeShowPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (TScrollTable.this.DebugShowEntry) {
                System.out.println("TScrollTable.PopupListener.mouseReleased");
            }
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() && !charutil.nullstr(TScrollTable.this.AppDriversObject.ContextMenu)) {
                TScrollTable.this.requestFocus();
                JPopupMenu jPopupMenu = TScrollTable.this.ScrollTablePanel.Parent instanceof TScrollDialogPanel ? TScrollTable.this.Application.AppMenu.createPopupMenu(TScrollTable.this.AppDriversObject.ContextMenu.toString(), TScrollTable.this) : TScrollTable.this.Application.AppMenu.createPopupMenu(TScrollTable.this.AppDriversObject.ContextMenu.toString(), null);
                if (jPopupMenu != null) {
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }
    }
}

