/*
 * Decompiled with CFR 0.152.
 */
package scrollwin.table;

import aspect.TMainWin;
import controls.TTable;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverStructRecord;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import resources.TAppDriversObject;
import resources.TApplication;
import scrollwin.TScrollDialog;
import scrollwin.dialogpanel.TScrollDialogPanel;
import scrollwin.dialogpanel.TScrollDialogPanelEvent;
import scrollwin.dialogpanel.TScrollDialogPanelListenerInterface;
import scrollwin.table.TScrollTable;
import scrollwin.table.TScrollTableView;
import utility.charutil;

public class TScrollTableModel
extends AbstractTableModel
implements TScrollDialogPanelListenerInterface {
    private TMainWin MainWin;
    private JComponent Parent;
    public TScrollDialog D = null;
    public TScrollTable scrollTable;
    public TAspectDriver AspectDriver;
    private TAppDriversObject AppDriversObject;
    private TApplication Application;
    public int LinesInHeader = 0;
    public ArrayList arScrollTableView = null;
    public TScrollTableModel[] arViewModels = null;
    private boolean Debug = false;
    public boolean WizardTempRecordExists = false;

    public TScrollTableModel(TMainWin tMainWin, JComponent jComponent, TApplication tApplication, TAppDriversObject tAppDriversObject, TAspectDriver tAspectDriver) {
        this.MainWin = tMainWin;
        this.Parent = jComponent;
        this.Application = tApplication;
        this.AppDriversObject = tAppDriversObject;
        this.AspectDriver = tAspectDriver;
        this.Debug = this.Application.getTokenValueAsBool("DebugTScrollTableModel");
        this.LinesInHeader = this.getMaxLinesInHeader();
        this.addTableModelListener(new TableModelHandler());
    }

    public synchronized void setTable(TScrollTable tScrollTable) {
        this.scrollTable = tScrollTable;
    }

    public synchronized void addScrollTableView(TScrollTableView tScrollTableView) {
        if (this.arScrollTableView == null) {
            this.arScrollTableView = new ArrayList();
        }
        this.arScrollTableView.add(tScrollTableView);
        this.arViewModels = new TScrollTableModel[this.arScrollTableView.size()];
        for (int i = 0; i < this.arScrollTableView.size(); ++i) {
            this.arViewModels[i] = ((TScrollTableView)this.arScrollTableView.get(i)).getTableModel();
        }
    }

    @Override
    public synchronized int getColumnCount() {
        return this.AspectDriver.getFieldCount();
    }

    @Override
    public synchronized int getRowCount() {
        int n = 0;
        if (this.AspectDriver == null) {
            n = 0;
        } else {
            n = this.AspectDriver.getRecordCount();
            if (this.WizardTempRecordExists) {
                --n;
            }
        }
        if (this.Debug) {
            String string = "Row count = " + n;
            if (this.AspectDriver == null) {
                string = string + " (Driver=null)";
            }
            this.MainWin.appendToLog("TScrollTableModel", "getRowCount", Thread.currentThread(), null, 10, string);
        }
        return n;
    }

    @Override
    public synchronized String getColumnName(int n) {
        return this.AspectDriver.getFieldDescription(n).replace('\\', '\n');
    }

    public synchronized Class getColumnClass(int n) {
        Object object = this.getValueAt(0, n);
        if (object != null) {
            return object.getClass();
        }
        return null;
    }

    public synchronized int getMaxLinesInHeader() {
        int n = 1;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            String string = this.getColumnName(i);
            int n2 = 1;
            for (int j = 0; j < string.length(); ++j) {
                if (string.charAt(j) != '\n') continue;
                ++n2;
            }
            n = Math.max(n, n2);
        }
        return n;
    }

    @Override
    public synchronized boolean isCellEditable(int n, int n2) {
        if (this.AspectDriver.isSubtotal(n)) {
            return false;
        }
        if (!this.AspectDriver.AspectDriverFilter.ActiveAppTablesObj.CanEdit) {
            return false;
        }
        if (!this.AspectDriver.isWriteable()) {
            return false;
        }
        TDriverStructRecord tDriverStructRecord = this.AspectDriver.getDriverStructRecord(n2);
        if (tDriverStructRecord == null) {
            return false;
        }
        if (!tDriverStructRecord.IsEditable) {
            return false;
        }
        if (tDriverStructRecord.IsCalculated) {
            return tDriverStructRecord.EditorType == 5;
        }
        return true;
    }

    @Override
    public synchronized Object getValueAt(int n, int n2) {
        return this.AspectDriver.getField(n, n2);
    }

    @Override
    public synchronized void setValueAt(Object object, int n, int n2) {
        this.AspectDriver.beginNewUndoOperation("Edit Cell (" + this.getColumnName(n2) + ")");
        if (this.AspectDriver.putField(n, n2, object) >= 0) {
            this.updateCalculatedCells();
            this.fireTableDataChanged();
            TDriverStructRecord tDriverStructRecord = this.AspectDriver.getDriverStructRecord(n2);
            if (this.AspectDriver.isFilterTreeNode(tDriverStructRecord.ID.toUpperCase())) {
                this.scrollTable.refreshFilterTree();
            }
        }
    }

    public synchronized void updateCalculatedCells() {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TDriverStructRecord tDriverStructRecord = this.AspectDriver.getDriverStructRecord(i);
            if (!tDriverStructRecord.IsCalculated) continue;
            for (int j = 0; j < this.getRowCount(); ++j) {
                if (this.arScrollTableView == null) continue;
                for (int k = 0; k < this.arViewModels.length; ++k) {
                }
            }
        }
    }

    public synchronized void initializeDialog() {
        if (charutil.nullstr(this.AppDriversObject.DialogIDStart)) {
            return;
        }
        this.D = new TScrollDialog(this.MainWin, "Test Dialog", this.Application, this.AspectDriver, this.AppDriversObject.DialogIDStart.toString(), this.AppDriversObject, 1);
        this.D.createGui();
        this.D.getScrollDialogPanel().addScrollDialogPanelListener(this);
    }

    public synchronized void disposeDialog() {
        if (this.D != null) {
            this.D.dispose();
        }
    }

    public synchronized boolean isDialogDefined() {
        return this.D != null;
    }

    public synchronized String executeDialog(int n, TTable tTable) {
        if (this.D == null) {
            this.initializeDialog();
        }
        if (this.D == null) {
            return "ok";
        }
        this.D.transferValues(n, 0);
        this.D.execute();
        String string = this.D.getReturnValue();
        if (string.equalsIgnoreCase("ok")) {
            // empty if block
        }
        return string;
    }

    @Override
    public synchronized void ok() {
    }

    @Override
    public synchronized void cancel() {
    }

    @Override
    public synchronized void close(String string) {
    }

    @Override
    public synchronized void beginTransferValues(TScrollDialogPanel tScrollDialogPanel, int n) {
    }

    @Override
    public synchronized void endTransferValues(TScrollDialogPanel tScrollDialogPanel, int n) {
    }

    @Override
    public synchronized void scrollDialogPanelEventOccurred(TScrollDialogPanelEvent tScrollDialogPanelEvent) {
    }

    @Override
    public synchronized void nextRecord() {
        int n = this.D.getRecordNumber();
        if (n < this.getRowCount() - 1) {
            this.D.transferValues(n, 1);
            this.scrollTable.setSelectedRow(++n, true);
            this.D.transferValues(n, 0);
        }
    }

    @Override
    public synchronized void previousRecord() {
        int n = this.D.getRecordNumber();
        if (n > 0) {
            this.D.transferValues(n, 1);
            this.scrollTable.setSelectedRow(--n, true);
            this.D.transferValues(n, 0);
        }
    }

    @Override
    public synchronized void firstRecord() {
        int n = this.D.getRecordNumber();
        if (n > 0) {
            this.D.transferValues(n, 1);
            n = 0;
            this.scrollTable.setSelectedRow(n, true);
            this.D.transferValues(n, 0);
        }
    }

    @Override
    public synchronized void lastRecord() {
        int n = this.D.getRecordNumber();
        if (n < this.getRowCount() - 1) {
            this.D.transferValues(n, 1);
            n = this.getRowCount() - 1;
            this.scrollTable.setSelectedRow(n, true);
            this.D.transferValues(n, 0);
        }
    }

    @Override
    public synchronized void gotoRecord(int n) {
        int n2 = this.AspectDriver.getFilteredIndex(n);
        if (n2 >= 0) {
            this.scrollTable.setSelectedRow(n2, true);
            this.D.transferValues(n2, 0);
        } else {
            this.MainWin.appendToLog("TScrollTableModel", "gotoRecord", Thread.currentThread(), null, 4, "Invalid absolute record number - " + n);
        }
    }

    private class TableModelHandler
    implements TableModelListener {
        private TableModelHandler() {
        }

        @Override
        public synchronized void tableChanged(TableModelEvent tableModelEvent) {
            TScrollTableModel.this.LinesInHeader = TScrollTableModel.this.getMaxLinesInHeader();
        }
    }
}

