/*
 * Decompiled with CFR 0.152.
 */
package scrollwin.table;

import aspect.TMainWin;
import drivers.aspect.TAbstractDriver;
import drivers.aspect.TAspectDriver;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import resources.TAppDriversObject;
import resources.TAppTablesObject;
import resources.TApplication;
import scrollwin.TScrollWin;
import scrollwin.table.TScrollTable;
import scrollwin.table.TScrollTableHeader;
import scrollwin.table.TScrollTableModel;
import scrollwin.table.TScrollTableView;
import utility.charutil;

public class TScrollTablePanel
extends JPanel
implements ComponentListener {
    public JComponent Parent;
    public SplitTablePane MainPane;
    public SplitTablePane LeftPane;
    public SplitTablePane RightPane;
    private TMainWin MainWin;
    private TApplication Application;
    private TAppDriversObject AppDriversObject;
    public TAspectDriver AspectDriver;
    private TScrollTableModel ScrollTableModel;
    public TScrollTable Table;
    public TScrollTableView[] ScrollTableView = new TScrollTableView[3];
    private int[] LastDividerLocation = new int[3];
    private boolean DividersInitialized = false;
    JScrollPane[] scrollPane = new JScrollPane[4];
    boolean scrollPanesInitialized = false;

    public TScrollTablePanel(TMainWin tMainWin, JComponent jComponent, TApplication tApplication, TAppDriversObject tAppDriversObject, TAspectDriver tAspectDriver) {
        super(new BorderLayout());
        this.Parent = jComponent;
        this.MainWin = tMainWin;
        this.Application = tApplication;
        this.AppDriversObject = tAppDriversObject;
        this.AspectDriver = tAspectDriver;
        this.MainPane = new SplitTablePane(1, true, 0);
        this.MainPane.setResizeWeight(1.0);
        this.add((Component)this.MainPane, "Center");
        this.LeftPane = new SplitTablePane(0, true, 1);
        this.LeftPane.setResizeWeight(1.0);
        this.RightPane = new SplitTablePane(0, true, 2);
        this.RightPane.setResizeWeight(1.0);
        this.RightPane.setMinimumSize(new Dimension(0, 0));
        this.RightPane.setPreferredSize(new Dimension(300, 0));
        this.MainPane.setLeftComponent(this.LeftPane);
        this.MainPane.setRightComponent(this.RightPane);
        this.MainPane.setOneTouchExpandable(true);
        this.LeftPane.setOneTouchExpandable(true);
        this.ScrollTableModel = new TScrollTableModel(tMainWin, jComponent, this.Application, this.AppDriversObject, this.AspectDriver);
        this.Table = new TScrollTable(tApplication, this.AppDriversObject, this.AspectDriver, this);
        this.Table.setModel(this.ScrollTableModel);
        this.ScrollTableModel.setTable(this.Table);
        this.setOpaque(false);
        TAbstractDriver tAbstractDriver = (TAbstractDriver)this.AspectDriver.F;
        tAbstractDriver.FormulaEvaluator.setTableModel(this.ScrollTableModel);
        this.Table.setTableHeader(new TScrollTableHeader(this.Table.getTableHeader().getColumnModel(), this.Table));
        this.Table.getTableHeader().setToolTipText(charutil.wrapAsHtml("Click to sort; Ctrl-Click for secondary sorting"));
        TAppTablesObject tAppTablesObject = this.AspectDriver.getAppTablesObject();
        this.scrollPane[3] = new TableScrollPane(this.Table);
        this.scrollPane[3].getViewport().setBackground(new Color(tAppTablesObject.TableBackground));
        this.scrollPane[3].setPreferredSize(new Dimension(100, 100));
        this.LeftPane.setTopComponent(this.scrollPane[3]);
        this.ScrollTableView[0] = new TScrollTableView(this.Table, 0, tMainWin, this);
        this.scrollPane[0] = new TableScrollPane(this.ScrollTableView[0]);
        this.scrollPane[0].getViewport().setBackground(new Color(tAppTablesObject.TableBackground));
        this.scrollPane[0].setMinimumSize(new Dimension(0, 0));
        this.scrollPane[0].setPreferredSize(new Dimension(100, 100));
        this.LeftPane.setBottomComponent(this.scrollPane[0]);
        this.Table.addScrollTableView(this.ScrollTableView[0]);
        this.ScrollTableView[1] = new TScrollTableView(this.Table, 1, tMainWin, this);
        this.scrollPane[1] = new TableScrollPane(this.ScrollTableView[1]);
        this.scrollPane[1].getViewport().setBackground(new Color(tAppTablesObject.TableBackground));
        this.scrollPane[1].setPreferredSize(new Dimension(100, 100));
        this.RightPane.setTopComponent(this.scrollPane[1]);
        this.Table.addScrollTableView(this.ScrollTableView[1]);
        this.ScrollTableView[2] = new TScrollTableView(this.Table, 2, tMainWin, this);
        this.scrollPane[2] = new TableScrollPane(this.ScrollTableView[2]);
        this.scrollPane[2].getViewport().setBackground(new Color(tAppTablesObject.TableBackground));
        this.scrollPane[2].setMinimumSize(new Dimension(0, 0));
        this.scrollPane[2].setPreferredSize(new Dimension(100, 100));
        this.RightPane.setBottomComponent(this.scrollPane[2]);
        this.Table.addScrollTableView(this.ScrollTableView[2]);
        this.scrollPane[0].getHorizontalScrollBar().setModel(this.scrollPane[3].getHorizontalScrollBar().getModel());
        this.scrollPane[2].getHorizontalScrollBar().setModel(this.scrollPane[1].getHorizontalScrollBar().getModel());
        this.scrollPane[1].getVerticalScrollBar().setModel(this.scrollPane[3].getVerticalScrollBar().getModel());
        this.scrollPane[2].getVerticalScrollBar().setModel(this.scrollPane[0].getVerticalScrollBar().getModel());
        this.scrollPane[3].setHorizontalScrollBarPolicy(30);
        this.scrollPane[1].setHorizontalScrollBarPolicy(30);
        this.scrollPane[3].setVerticalScrollBarPolicy(20);
        this.scrollPane[0].setVerticalScrollBarPolicy(20);
        this.scrollPane[3].addMouseListener(this.Table.popupListener);
        this.scrollPane[1].addMouseListener(this.Table.popupListener);
        this.scrollPane[0].addMouseListener(this.Table.popupListener);
        this.scrollPane[2].addMouseListener(this.Table.popupListener);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(155, 0, false);
        this.scrollPane[3].registerKeyboardAction(this.Table, "Insert", keyStroke, 2);
        this.scrollPane[1].registerKeyboardAction(this.Table, "Insert", keyStroke, 2);
        this.scrollPane[0].registerKeyboardAction(this.Table, "Insert", keyStroke, 2);
        this.scrollPane[2].registerKeyboardAction(this.Table, "Insert", keyStroke, 2);
        this.scrollPane[0].setHorizontalScrollBarPolicy(30);
        this.scrollPanesInitialized = true;
    }

    public void closeWindow() {
        if (this.Parent != null && this.Parent instanceof TScrollWin) {
            ((TScrollWin)this.Parent).dispose();
        }
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        this.MainPane.setPreferredSize(dimension);
    }

    @Override
    public void setMinimumSize(Dimension dimension) {
        this.MainPane.setMinimumSize(dimension);
    }

    @Override
    public void setMaximumSize(Dimension dimension) {
        this.MainPane.setMaximumSize(dimension);
    }

    public void initializeDividers() {
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
    }

    @Override
    public void setOpaque(boolean bl) {
        int n;
        super.setOpaque(bl);
        if (!this.scrollPanesInitialized) {
            return;
        }
        this.Table.setOpaque(bl);
        this.MainPane.setOpaque(bl);
        this.LeftPane.setOpaque(bl);
        this.RightPane.setOpaque(bl);
        for (n = 0; n < this.scrollPane.length; ++n) {
            if (this.scrollPane[n] == null) continue;
            this.scrollPane[n].setOpaque(bl);
            this.scrollPane[n].getViewport().setOpaque(bl);
            if (this.scrollPane[n].getColumnHeader() == null) continue;
            this.scrollPane[n].getColumnHeader().setOpaque(bl);
        }
        TScrollTableModel tScrollTableModel = this.Table.getTableModel();
        if (tScrollTableModel != null && tScrollTableModel.arScrollTableView != null) {
            for (n = 0; n < tScrollTableModel.arScrollTableView.size(); ++n) {
                ((TScrollTableView)tScrollTableModel.arScrollTableView.get(n)).setOpaque(bl);
            }
        }
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (this.LeftPane.getDividerLocation() == this.LeftPane.getMaximumDividerLocation() || this.RightPane.getDividerLocation() == this.RightPane.getMaximumDividerLocation()) {
            this.LeftPane.setDividerLocation(this.LeftPane.getMaximumDividerLocation() + 30);
        }
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        if (this.LastDividerLocation[1] > this.LeftPane.getMaximumDividerLocation()) {
            if (this.LeftPane.getDividerLocation() < this.LastDividerLocation[1]) {
                this.RightPane.setDividerLocation(this.LeftPane.getDividerLocation());
            }
        } else if (this.LeftPane.getDividerLocation() > this.LeftPane.getMaximumDividerLocation()) {
            this.RightPane.setDividerLocation(this.LeftPane.getDividerLocation());
        }
        this.updateScrollBars();
        this.LastDividerLocation[0] = this.MainPane.getDividerLocation();
        this.LastDividerLocation[1] = this.LeftPane.getDividerLocation();
        this.LastDividerLocation[2] = this.RightPane.getDividerLocation();
    }

    public void updateScrollBars() {
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
    }

    @Override
    public void update(Graphics graphics) {
        super.update(graphics);
    }

    public class MyDivider
    extends BasicSplitPaneDivider {
        MySplitPaneUI Parent;
        boolean lock;

        public MyDivider(MySplitPaneUI mySplitPaneUI) {
            super(mySplitPaneUI);
            this.lock = false;
            this.Parent = mySplitPaneUI;
            this.addComponentListener(TScrollTablePanel.this);
        }

        @Override
        protected void dragDividerTo(int n) {
            if (!this.lock) {
                super.dragDividerTo(n);
            }
        }

        @Override
        protected void finishDraggingTo(int n) {
            if (!this.lock) {
                super.finishDraggingTo(n);
            }
            this.Parent.doneDragging(n);
        }
    }

    public class MySplitPaneUI
    extends BasicSplitPaneUI {
        SplitTablePane Parent;
        int location = 100;

        public MySplitPaneUI(SplitTablePane splitTablePane) {
            this.Parent = splitTablePane;
        }

        @Override
        public BasicSplitPaneDivider createDefaultDivider() {
            return new MyDivider(this);
        }

        protected void doneDragging(int n) {
            this.Parent.doneDragging(n);
        }
    }

    public class SplitTablePane
    extends JSplitPane {
        BasicSplitPaneDivider Divider;
        MySplitPaneUI BasicUI;
        int PaneType;

        public SplitTablePane(int n, boolean bl, int n2) {
            super(n, bl);
            this.PaneType = n2;
            ((TScrollTablePanel)TScrollTablePanel.this).LastDividerLocation[this.PaneType] = -1;
            this.BasicUI = new MySplitPaneUI(this);
            this.setUI(this.BasicUI);
            this.Divider = this.BasicUI.getDivider();
            this.setDividerSize(7);
            this.setDividerLocation(5000);
        }

        public void doneDragging(int n) {
            switch (this.PaneType) {
                case 1: {
                    TScrollTablePanel.this.RightPane.setDividerLocation(TScrollTablePanel.this.LeftPane.getDividerLocation());
                    break;
                }
                case 2: {
                    TScrollTablePanel.this.LeftPane.setDividerLocation(TScrollTablePanel.this.RightPane.getDividerLocation());
                }
            }
            TScrollTablePanel.this.updateScrollBars();
        }

        @Override
        public void setDividerLocation(int n) {
            int n2 = n;
            super.setDividerLocation(n2);
            switch (this.PaneType) {
                case 1: {
                    if (TScrollTablePanel.this.RightPane == null || TScrollTablePanel.this.RightPane.getDividerLocation() == n2) break;
                    TScrollTablePanel.this.RightPane.setDividerLocation(TScrollTablePanel.this.LeftPane.getDividerLocation());
                    break;
                }
                case 2: {
                    if (TScrollTablePanel.this.LeftPane == null || TScrollTablePanel.this.LeftPane.getDividerLocation() == n2) break;
                    TScrollTablePanel.this.LeftPane.setDividerLocation(TScrollTablePanel.this.RightPane.getDividerLocation());
                }
            }
        }

        @Override
        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, n2, n3, n4);
        }
    }

    public class TableScrollPane
    extends JScrollPane {
        public TableScrollPane(Component component) {
            super(component);
        }

        @Override
        public void paint(Graphics graphics) {
            if (this.getColumnHeader() != null) {
                this.getColumnHeader().setOpaque(TScrollTablePanel.this.isOpaque());
            }
            super.paint(graphics);
        }

        @Override
        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        @Override
        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, n2, n3, n4);
        }
    }
}

