/*
 * Decompiled with CFR 0.152.
 */
package scrollwin.toolbar;

import aspect.Aspect;
import aspect.TMainWin;
import controls.TToolBar;
import extensions.SwingWorker;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import resources.TAppActionObject;
import resources.TAppToolbarObject;
import resources.TApplication;
import resources.TApplicationListenerEvent;
import resources.TApplicationListenerInterface;
import scripts.TExecScript;
import scrollwin.dialogpanel.TScrollDialogPanel;
import scrollwin.dialogpanel.TScrollDialogPanelAbstractListener;
import scrollwin.dialogpanel.TScrollDialogPanelEvent;
import scrollwin.toolbar.TScrollToolbarComboBox;
import scrollwin.toolbar.TScrollToolbarControlInterface;
import scrollwin.toolbar.TScrollToolbarDisplaySelection;
import scrollwin.toolbar.TScrollToolbarDriverCmdButton;
import scrollwin.toolbar.TScrollToolbarScriptButton;
import scrollwin.toolbar.TScrollToolbarTextBox;
import scrollwin.toolbar.TScrollToolbarTokenButton;
import scrollwin.toolbar.TScrollToolbarTokenColor;
import scrollwin.toolbar.TScrollToolbarTokenIcon;
import scrollwin.toolbar.TScrollToolbarTokenLabel;
import utility.charutil;

public class TScrollToolbar
extends TToolBar
implements TApplicationListenerInterface {
    private TMainWin MainWin = Aspect.MainWin;
    private boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTScrollToolbar");
    private static TToolbarListener ToolbarListener = null;
    private static TToolbarScrollDialogPanelListener ScrollDialogPanelListener = null;
    private static int cCallbacks = 0;
    private static boolean IgnoreApplicationEvent = false;
    private Timer ToolbarCallbackTimer = null;
    private Component Parent = null;
    private TApplication Application = null;
    public String ID = "";
    private Component[] arComponents = null;
    private boolean ContainsTokenControls = false;
    private boolean CheckForTokens = true;

    public TScrollToolbar(Component component, TApplication tApplication, String string, String string2, int n) {
        super(string2, n);
        this.Application = tApplication;
        this.Parent = component;
        this.ID = string;
    }

    @Override
    public void dispose() {
        if (TMainWin.IsClosing) {
            return;
        }
        if (this.ToolbarCallbackTimer != null) {
            this.ToolbarCallbackTimer.stop();
        }
        this.Application.removeListener(this);
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] instanceof TScrollDialogPanel) {
                ((TScrollDialogPanel)componentArray[i]).getAspectDriver().dispose();
                ((TScrollDialogPanel)componentArray[i]).dispose();
            }
            this.remove(componentArray[i]);
        }
    }

    @Override
    public Component add(Component component) {
        this.arComponents = null;
        if (!(component instanceof JSeparator)) {
            if (((TScrollToolbarControlInterface)((Object)component)).isTokenControl()) {
                this.ContainsTokenControls = true;
            }
            if (component instanceof JComponent) {
                // empty if block
            }
        }
        return super.add(component);
    }

    @Override
    public Object notifyApplicationEvent(TApplicationListenerEvent tApplicationListenerEvent) {
        if (IgnoreApplicationEvent) {
            return null;
        }
        Object var3_2 = null;
        String string = tApplicationListenerEvent.getTokenValue();
        String string2 = tApplicationListenerEvent.getTokenID();
        if (this.arComponents == null) {
            this.arComponents = this.getComponents();
        }
        if (tApplicationListenerEvent.getEventType() == 0 && this.arComponents != null) {
            for (int i = 0; i < this.arComponents.length; ++i) {
                if (this.arComponents[i] instanceof JSeparator) continue;
                if (this.arComponents[i] instanceof TScrollToolbarDisplaySelection) {
                    if (string2.charAt(0) != '$' || !string2.toUpperCase().startsWith("$SCROLLWIN")) continue;
                    if (string2.equalsIgnoreCase("$ScrollWinDisplayAdvancedFilter") || string2.equalsIgnoreCase("$ScrollWinDisplayAutoResize")) {
                        return null;
                    }
                    IgnoreApplicationEvent = true;
                    ((TScrollToolbarControlInterface)((Object)this.arComponents[i])).update(string2, string);
                    IgnoreApplicationEvent = false;
                    continue;
                }
                String string3 = ((TScrollToolbarControlInterface)((Object)this.arComponents[i])).getTokenID();
                if (!string3.equalsIgnoreCase(string2)) continue;
                ((TScrollToolbarControlInterface)((Object)this.arComponents[i])).update(string2, string);
            }
        }
        return null;
    }

    public TToolbarListener getToolbarListener() {
        if (ToolbarListener == null) {
            ToolbarListener = new TToolbarListener();
        }
        return ToolbarListener;
    }

    public TToolbarScrollDialogPanelListener getScrollDialogPanelListener() {
        if (ScrollDialogPanelListener == null) {
            ScrollDialogPanelListener = new TToolbarScrollDialogPanelListener();
        }
        return ScrollDialogPanelListener;
    }

    public void installAndStartTimer(int n) {
        if (n > 0) {
            if (this.ToolbarCallbackTimer == null) {
                this.ToolbarCallbackTimer = new Timer(n, new TScrollToolbarTimerListener());
            } else {
                this.ToolbarCallbackTimer.setDelay(n);
            }
            this.ToolbarCallbackTimer.start();
        }
    }

    public synchronized void refresh() {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] instanceof TScrollToolbarTokenLabel) {
                ((TScrollToolbarTokenLabel)componentArray[i]).update();
                continue;
            }
            if (componentArray[i] instanceof TScrollToolbarTokenColor) {
                ((TScrollToolbarTokenColor)componentArray[i]).update();
                continue;
            }
            if (!(componentArray[i] instanceof TScrollToolbarTokenIcon)) continue;
            ((TScrollToolbarTokenIcon)componentArray[i]).update();
        }
    }

    public void executeTimerCallback() {
        this.refresh();
    }

    class TScrollToolbarTimerListener
    implements ActionListener {
        TScrollToolbarTimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (cCallbacks > 0) {
                return;
            }
            cCallbacks++;
            SwingWorker swingWorker = new SwingWorker(){

                @Override
                public Object construct() {
                    return null;
                }

                @Override
                public void finished() {
                    TScrollToolbar.this.executeTimerCallback();
                    cCallbacks--;
                }
            };
            swingWorker.start();
        }
    }

    public class TToolbarScrollDialogPanelListener
    extends TScrollDialogPanelAbstractListener {
        @Override
        public void scrollDialogPanelEventOccurred(TScrollDialogPanelEvent tScrollDialogPanelEvent) {
            if (tScrollDialogPanelEvent.getEventType() == 3) {
                tScrollDialogPanelEvent.getScrollDialogPanel().transferValues(0, 1);
            }
        }

        @Override
        public void close(String string) {
            final String string2 = string;
            Thread thread = new Thread(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String string;
                            String[] stringArray;
                            if (string2.toUpperCase().startsWith("ACTION.")) {
                                String string2 = string2.substring(7);
                                TAppActionObject tAppActionObject = ((TScrollToolbar)TScrollToolbar.this).Application.AppAction.getAppActionObject(string2);
                                if (tAppActionObject != null) {
                                    Aspect.MainWin.executeActionObject(tAppActionObject.ActionObject, null);
                                } else {
                                    TScrollToolbar.this.MainWin.appendToLog("TDesktopPane", "close", Thread.currentThread(), null, 3, "Unable to locate an action with the ID of '" + string2 + "'");
                                }
                            } else if (string2.toUpperCase().startsWith("SCRIPT.")) {
                                String string3 = string2.substring(7);
                                Aspect.MainWin.executeScript(string3);
                            } else if (string2.toUpperCase().startsWith("VIEW.")) {
                                String string4 = string2.substring(5);
                                System.out.println("TDesktopPane.close() Description=" + string4);
                                TExecScript tExecScript = new TExecScript("Aspect_Common_selectView", null, null);
                                String[] stringArray2 = new String[]{"THtmlViewer", "", "Description=" + string4};
                                tExecScript.setParameters(stringArray2);
                                tExecScript.start();
                            } else if (string2.toUpperCase().startsWith("DIALOG.")) {
                                String string5 = string2.substring(7);
                                String[] stringArray3 = charutil.getSubStringArray(string5, '?', true);
                                if (stringArray3 != null && stringArray3.length > 0) {
                                    String string6 = stringArray3[0];
                                    int n = 0;
                                    if (stringArray3.length > 1) {
                                        n = charutil.ival(stringArray3[1]);
                                    }
                                    TMainWin.executeDialog(string6, n);
                                }
                            } else if (string2.toUpperCase().startsWith("DRIVERCMD.") && (stringArray = charutil.getSubStringArray(string = string2.substring(10), ',', true)) != null) {
                                if (stringArray.length == 1) {
                                    Aspect.MainWin.executeDriverCommand(stringArray[0], "");
                                } else {
                                    Aspect.MainWin.executeDriverCommand(stringArray[0], stringArray[1]);
                                }
                            }
                        }
                    });
                }
            };
            thread.setPriority(1);
            thread.start();
        }
    }

    public class TToolbarListener
    implements ItemListener,
    ActionListener,
    FocusListener {
        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (!(itemEvent.getSource() instanceof TScrollToolbarComboBox) || itemEvent.getStateChange() == 1) {
                // empty if block
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!(actionEvent.getSource() instanceof TScrollToolbarControlInterface)) {
                return;
            }
            if (actionEvent.getSource() instanceof TScrollToolbarDriverCmdButton) {
                TAppToolbarObject tAppToolbarObject = ((TScrollToolbarControlInterface)actionEvent.getSource()).getAppToolbarObject();
                TScrollToolbar.this.MainWin.executeDriverCommand(tAppToolbarObject.DriverCmd, tAppToolbarObject.DriverCmdParams);
                return;
            }
            if (actionEvent.getSource() instanceof TScrollToolbarScriptButton) {
                TAppToolbarObject tAppToolbarObject = ((TScrollToolbarControlInterface)actionEvent.getSource()).getAppToolbarObject();
                TScrollToolbar.this.MainWin.executeScript(tAppToolbarObject.ScriptID);
                return;
            }
            String string = ((TScrollToolbarControlInterface)actionEvent.getSource()).getTokenID();
            if (string.length() > 0) {
                String string2 = TScrollToolbar.this.Application.getTokenValue(string);
                if (actionEvent.getSource() instanceof TScrollToolbarTokenButton) {
                    TAppActionObject tAppActionObject = ((TScrollToolbar)TScrollToolbar.this).Application.AppAction.getAppActionObject(string2);
                    if (tAppActionObject != null) {
                        ((TScrollToolbar)TScrollToolbar.this).Application.MainWin.executeActionObject(tAppActionObject.ActionObject, null);
                    }
                } else {
                    String string3 = ((TScrollToolbarControlInterface)actionEvent.getSource()).getControlValue();
                    if (string3 != null && !string2.equalsIgnoreCase(string3)) {
                        TScrollToolbar.this.Application.setTokenValue(string, string3);
                    }
                }
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent.getSource() instanceof TScrollToolbarTextBox) {
                String string = ((TScrollToolbarControlInterface)focusEvent.getSource()).getControlValue();
                String string2 = ((TScrollToolbarControlInterface)focusEvent.getSource()).getTokenID();
                if (string2.length() > 0) {
                    TScrollToolbar.this.Application.setTokenValue(string2, string);
                }
            }
        }
    }
}

