/*
 * Decompiled with CFR 0.152.
 */
package scrollwin.toolbar;

import aspect.TMainWin;
import java.awt.Dimension;
import java.awt.Image;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.border.Border;
import resources.TActionObject;
import resources.TAppToolbarObject;
import resources.TApplication;
import scrollwin.toolbar.TScrollToolbar;
import scrollwin.toolbar.TScrollToolbarControlInterface;
import utility.imageutil;

public class TScrollToolbarTokenIcon
extends JLabel
implements TScrollToolbarControlInterface {
    private TApplication Application = TMainWin.Application;
    private TAppToolbarObject AppToolbarObject;
    private TActionObject ActionObject = null;
    private Hashtable HashedIcons = new Hashtable();
    private String CurrentIcon = null;

    public TScrollToolbarTokenIcon(TScrollToolbar tScrollToolbar, TAppToolbarObject tAppToolbarObject, TActionObject tActionObject) {
        Serializable serializable;
        this.setOpaque(false);
        this.AppToolbarObject = tAppToolbarObject;
        this.ActionObject = tActionObject;
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
        if (this.AppToolbarObject.Width != 0 && this.AppToolbarObject.Height != 0) {
            serializable = new Dimension(this.AppToolbarObject.Width, this.AppToolbarObject.Height);
            this.setPreferredSize((Dimension)serializable);
            this.setMaximumSize((Dimension)serializable);
        }
        if (this.AppToolbarObject.LeftMargin > 0) {
            serializable = BorderFactory.createMatteBorder(0, this.AppToolbarObject.LeftMargin, 0, 0, tScrollToolbar.getBackground());
            this.setBorder(BorderFactory.createCompoundBorder((Border)((Object)serializable), this.getBorder()));
        }
        this.update();
    }

    @Override
    public boolean isTokenControl() {
        return true;
    }

    public synchronized void update() {
        this.update("", this.Application.getTokenValue(this.AppToolbarObject.AssociatedToken));
    }

    @Override
    public synchronized void update(String string, String string2) {
        Image image;
        if (this.getIcon() != null && this.CurrentIcon != null && this.CurrentIcon.equals(string2)) {
            return;
        }
        super.setText("");
        if (string2.length() == 0) {
            this.setIcon(null);
            return;
        }
        ImageIcon imageIcon = (ImageIcon)this.HashedIcons.get(string2);
        if (imageIcon == null && (image = imageutil.getScaledImage(this.getClass(), string2, -1, -1)) != null) {
            imageIcon = new ImageIcon(image);
            imageIcon.setImageObserver(this);
            this.HashedIcons.put(string2, imageIcon);
        }
        if (imageIcon != null) {
            this.setIcon(imageIcon);
        }
        this.CurrentIcon = string2;
    }

    @Override
    public synchronized String getTokenID() {
        return this.AppToolbarObject.AssociatedToken;
    }

    @Override
    public String getControlValue() {
        return "";
    }

    @Override
    public TAppToolbarObject getAppToolbarObject() {
        return this.AppToolbarObject;
    }
}

