/*
 * Decompiled with CFR 0.152.
 */
package utility;

import aspect.Aspect;
import aspect.TMainWin;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.net.URLConnection;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import pub.TExecListenerThread;
import resources.TApplication;
import utility.TFile;
import utility.asciifiles.TAsciiInput;
import utility.charutil;
import utility.netutil;
import utility.security.TEncryptedInputStream;
import utility.security.TEncryptedOutputStream;
import utility.tregex;
import utility.ziputil;

public class dosutil {
    public static final int DRIVE = 0;
    public static final int DIR = 1;
    public static final int NAME = 2;
    public static final int EXT = 3;
    public static final int LIST_FILES = 0;
    public static final int LIST_DIRECTORIES = 1;
    public static final int LIST_FILES_AND_DIRECTORIES = 2;
    public static final int OVERWRITE_ALWAYS = 0;
    public static final int OVERWRITE_NEVER = 1;
    public static final int OVERWRITE_OLDER = 2;

    public static String get_current_dir(StringBuilder stringBuilder) {
        String string = System.getProperty("user.dir");
        stringBuilder.setLength(0);
        stringBuilder.append(string);
        return string;
    }

    public static boolean isDirectory(String string) {
        return new File(string).isDirectory();
    }

    public static String[] splitPath(String string) {
        String[] stringArray = new String[4];
        if (string == null || string.length() < 1) {
            return stringArray;
        }
        String string2 = string.replace('/', '\\');
        if (string2.indexOf("\\") < 0) {
            stringArray[0] = null;
            stringArray[1] = null;
            if (string2.indexOf(".") < 0) {
                stringArray[2] = string2;
                stringArray[3] = null;
            } else {
                int n = string2.lastIndexOf(46);
                stringArray[2] = string2.substring(0, n);
                stringArray[3] = string2.substring(n);
            }
            return stringArray;
        }
        int n = string2.indexOf(35);
        if (n >= 0 && n < string2.length() - 1 && (string2.toUpperCase().startsWith("WWW.") || string2.toUpperCase().startsWith("HTTP:") || string2.toUpperCase().startsWith("HTTPS:"))) {
            string2 = string2.substring(0, n);
        }
        if ((n = string2.indexOf(63)) >= 0 && n < string2.length() - 1) {
            string2 = string2.substring(0, n);
        }
        if ((n = string2.indexOf(58)) >= 0) {
            stringArray[0] = string2.substring(0, ++n);
        } else {
            n = 0;
        }
        int n2 = string2.lastIndexOf(46);
        if (n2 >= 0) {
            stringArray[3] = string2.substring(n2);
        } else {
            n2 = string2.length() - 1;
        }
        int n3 = string2.indexOf(92);
        int n4 = string2.lastIndexOf(92);
        if (n3 != n4) {
            stringArray[1] = string2.substring(n, n4 + 1);
        } else if (n == 0 && n3 > 0) {
            stringArray[1] = string2.substring(n, n3 + 1);
        }
        if (n4 >= 0 && n4 < string2.length() - 1) {
            if (string2.indexOf(".") < 0) {
                stringArray[2] = string2.substring(n4 + 1);
            } else if (n4 + 1 <= n2) {
                stringArray[2] = string2.substring(n4 + 1, n2);
            }
        }
        return stringArray;
    }

    public static String getFileDrive(String string) {
        String[] stringArray = dosutil.splitPath(string);
        return stringArray[0];
    }

    public static String getFileDir(String string) {
        String[] stringArray = dosutil.splitPath(string);
        return stringArray[1];
    }

    public static String getFileName(String string) {
        String[] stringArray = dosutil.splitPath(string);
        return stringArray[2];
    }

    public static String getFileExt(String string) {
        String[] stringArray = dosutil.splitPath(string);
        return stringArray[3];
    }

    public static String add_trailing_slash(StringBuilder stringBuilder, StringBuilder stringBuilder2, String string) {
        String string2 = dosutil.addTrailingSlash(stringBuilder2.toString());
        stringBuilder.setLength(0);
        stringBuilder.append(string2);
        return string2;
    }

    public static String addTrailingSlash(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        charutil.replace_char(stringBuilder, stringBuilder, '\\', '/');
        if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) != '/') {
            stringBuilder.append("/");
        }
        return stringBuilder.toString();
    }

    public static String removeTrailingSlash(String string) {
        if (string.length() < 1) {
            return string;
        }
        if (string.endsWith("\\") || string.endsWith("/")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static boolean isIPAddress(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() < 8) {
            return false;
        }
        String[] stringArray = charutil.getSubStringArray(string, '.', false);
        if (stringArray.length != 4) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public static boolean isArchiveEntry(String string) {
        int n = string.toUpperCase().indexOf(".ZIP");
        if (n < 0) {
            n = string.toUpperCase().indexOf(".JAR");
        }
        return n > 0 && n < string.length() - 4;
    }

    public static boolean fileExists(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        boolean bl = false;
        try {
            File file = new File(dosutil.removeTrailingSlash(string));
            if (file.exists()) {
                bl = true;
            } else {
                TAsciiInput tAsciiInput = new TAsciiInput(dosutil.formatURL(string), ',', true);
                if (tAsciiInput.isValid()) {
                    bl = true;
                }
                tAsciiInput.dispose();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static Date fileModified(String string) {
        File file = new File(string);
        if (file.exists()) {
            return new Date(file.lastModified());
        }
        return null;
    }

    public static int fileSize(String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        int n = 0;
        if (dosutil.isArchiveEntry(string)) {
            TAsciiInput tAsciiInput = new TAsciiInput(dosutil.formatURL(string), ',', true);
            if (tAsciiInput.isValid()) {
                n = tAsciiInput.getSize();
            }
            tAsciiInput.dispose();
        } else {
            File file = new File(string);
            if (file.exists()) {
                n = (int)file.length();
            } else {
                try {
                    URL uRL = new URL(dosutil.formatURL(string));
                    URLConnection uRLConnection = uRL.openConnection();
                    n = uRLConnection.getContentLength();
                    if (n < 0) {
                        InputStream inputStream = uRLConnection.getInputStream();
                        n = inputStream.available();
                        inputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return n;
    }

    public static String formatURL(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        return dosutil.formatURL(stringBuilder, new StringBuilder(string));
    }

    public static String formatURL(StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        if (stringBuilder2 == null || charutil.nullstr(stringBuilder2)) {
            return null;
        }
        StringBuilder stringBuilder3 = new StringBuilder();
        StringBuilder stringBuilder4 = new StringBuilder();
        String string = stringBuilder2.toString().toUpperCase();
        stringBuilder3.setLength(0);
        if (string.startsWith("WWW.")) {
            stringBuilder3.append("HTTP://");
            stringBuilder3.append((CharSequence)stringBuilder2);
        } else if (string.startsWith("HTTP://")) {
            stringBuilder3.append((CharSequence)stringBuilder2);
        } else if (string.startsWith("HTTPS://")) {
            stringBuilder3.append((CharSequence)stringBuilder2);
        } else if (string.startsWith("FTP://")) {
            stringBuilder3.append((CharSequence)stringBuilder2);
        } else if (string.startsWith("FTP.")) {
            stringBuilder3.append("FTP://");
            stringBuilder3.append((CharSequence)stringBuilder2);
        } else if (string.startsWith("FILE:")) {
            stringBuilder3.append((CharSequence)stringBuilder2);
        } else if (string.startsWith("\\") || string.startsWith("/")) {
            stringBuilder3.append("FILE://");
            stringBuilder3.append((CharSequence)stringBuilder2);
        } else if (dosutil.isIPAddress(stringBuilder2.toString())) {
            stringBuilder3.append("HTTP://");
            stringBuilder3.append((CharSequence)stringBuilder2);
        } else {
            string = charutil.removeQuotes(stringBuilder2.toString());
            if (string.length() > 1 && string.charAt(1) == ':') {
                stringBuilder3.append("FILE:///");
            } else {
                stringBuilder3.append("FILE://");
            }
            stringBuilder3.append(string);
        }
        charutil.replace_char(stringBuilder3, stringBuilder3, '\\', '/');
        if (stringBuilder3.toString().toUpperCase().startsWith("FILE://") && stringBuilder3.length() > 8 && stringBuilder3.charAt(8) == ':') {
            stringBuilder3.insert(7, '/');
        }
        stringBuilder.setLength(0);
        stringBuilder.append((CharSequence)stringBuilder3);
        return stringBuilder.toString();
    }

    public static URL makeURL(String string) {
        URL uRL = null;
        try {
            uRL = new URL(dosutil.formatURL(string));
        }
        catch (Exception exception) {
            System.out.println("dosutil.makeURL(" + string + ") exception :" + exception.toString());
        }
        return uRL;
    }

    public static InputStream getInputStream(String string) {
        URL uRL = null;
        InputStream inputStream = null;
        String string2 = dosutil.formatURL(string);
        String string3 = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            Object object;
            uRL = new URL(string2);
            int n = string.toUpperCase().indexOf(".JAR");
            if (n >= 0) {
                bl = true;
            } else {
                n = string.toUpperCase().indexOf(".ZIP");
                if (n >= 0) {
                    bl2 = true;
                }
            }
            if (bl || bl2) {
                while (string.charAt(n) != '/' && string.charAt(n) != '\\') {
                    ++n;
                }
                string2 = string.substring(0, n);
                string3 = string.substring(string2.length() + 1, string.length());
                if (string.toUpperCase().startsWith("FILE:")) {
                    n = 5;
                    object = charutil.replaceChar(string, '\\', '/');
                    while (string.charAt(n) == '/') {
                        ++n;
                    }
                    string2 = string2.substring(n, string2.length());
                }
            }
            if (bl) {
                if (new File(string2).exists()) {
                    object = new JarFile(string2);
                    JarEntry jarEntry = ((JarFile)object).getJarEntry(string3);
                    inputStream = ((JarFile)object).getInputStream(jarEntry);
                } else {
                    inputStream = Aspect.MainWin.getClass().getResourceAsStream("/" + string3);
                }
            } else if (bl2) {
                object = new ZipFile(string2);
                ZipEntry zipEntry = ((ZipFile)object).getEntry(string3);
                inputStream = ((ZipFile)object).getInputStream(zipEntry);
            } else {
                inputStream = new BufferedInputStream(uRL.openStream());
            }
        }
        catch (Exception exception) {
            Aspect.MainWin.appendToLog("dosutil", "parseFileName", Thread.currentThread(), exception, 4, "Error opening file: " + string2);
            exception.printStackTrace();
        }
        return inputStream;
    }

    public static boolean findFile(StringBuilder stringBuilder, TApplication tApplication, String string) {
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        File file = new File(string);
        if (file.exists()) {
            stringBuilder.setLength(0);
            stringBuilder.append(string);
            dosutil.formatURL(stringBuilder, stringBuilder);
            return true;
        }
        stringBuilder2.setLength(0);
        stringBuilder2.append("c:\\");
        dosutil.get_current_dir(stringBuilder3);
        stringBuilder2.append((CharSequence)stringBuilder3);
        stringBuilder2.append(string);
        charutil.replaceAllSubstrings(stringBuilder2, stringBuilder2, "\\/", "/");
        file = new File(stringBuilder2.toString());
        if (file.exists()) {
            stringBuilder.setLength(0);
            stringBuilder.append((CharSequence)stringBuilder2);
            dosutil.formatURL(stringBuilder, stringBuilder);
            return true;
        }
        stringBuilder.setLength(0);
        TAsciiInput tAsciiInput = new TAsciiInput();
        StringBuilder stringBuilder4 = new StringBuilder();
        boolean bl = false;
        boolean bl2 = true;
        stringBuilder2.setLength(0);
        charutil.strcpy(stringBuilder2, string);
        if (!charutil.nullstr(stringBuilder2)) {
            dosutil.formatURL(stringBuilder2, stringBuilder2);
            if (bl2) {
                // empty if block
            }
            tAsciiInput.open(stringBuilder2.toString());
            if (tAsciiInput.isValid()) {
                bl = true;
                tAsciiInput.close();
                charutil.strcpy(stringBuilder, stringBuilder2);
            }
        }
        if (!bl) {
            dosutil.get_current_dir(stringBuilder2);
            dosutil.add_trailing_slash(stringBuilder2, stringBuilder2, "/");
            if (string.startsWith("/") || string.startsWith("\\")) {
                charutil.strcat(stringBuilder2, string.substring(1));
            } else {
                charutil.strcat(stringBuilder2, string);
            }
            dosutil.formatURL(stringBuilder2, stringBuilder2);
            tAsciiInput.open(stringBuilder2.toString());
            if (tAsciiInput.isValid()) {
                bl = true;
                tAsciiInput.close();
                charutil.strcpy(stringBuilder, stringBuilder2);
            }
        }
        if (!bl && tApplication != null) {
            tApplication.parse_tokens(stringBuilder4, "{classpath}");
            if (bl2) {
                System.out.println("Classpath = " + stringBuilder4);
            }
            while (!bl && !charutil.nullstr(stringBuilder4)) {
                charutil.getsubstring(stringBuilder2, stringBuilder4, 0, ',', true);
                dosutil.add_trailing_slash(stringBuilder2, stringBuilder2, "/");
                charutil.strcat(stringBuilder2, string);
                dosutil.formatURL(stringBuilder2, stringBuilder2);
                if (bl2) {
                    System.out.println("Find file3: " + stringBuilder2);
                }
                tAsciiInput.open(stringBuilder2.toString());
                if (!tAsciiInput.isValid()) continue;
                bl = true;
                tAsciiInput.close();
                charutil.strcpy(stringBuilder, stringBuilder2);
            }
        }
        return bl;
    }

    public static String copyFile(String string, String string2, int n, boolean bl, String string3, String string4, String string5) {
        Object object;
        Serializable serializable;
        if (string2.toUpperCase().startsWith("HTTP:")) {
            System.out.println("Cannot copy ");
            System.out.println("\t" + string);
            System.out.println("\tto " + string2);
            new Throwable().printStackTrace();
            return "Cannot copy file to " + string2;
        }
        NumberFormat numberFormat = NumberFormat.getInstance();
        StringBuilder stringBuilder = new StringBuilder();
        String string6 = charutil.replaceChar(string, '\\', '/');
        String string7 = charutil.replaceChar(string2, '\\', '/');
        File file = new File(string7);
        String string8 = "ok";
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        boolean bl2 = true;
        TAsciiInput tAsciiInput = new TAsciiInput(string6, ',');
        if (!tAsciiInput.isValid()) {
            tAsciiInput.dispose();
            return "Invalid source file1: " + string;
        }
        String[] stringArray = dosutil.splitPath(string6);
        if (stringArray == null) {
            return "Invalid source file2: " + string;
        }
        if (string7.endsWith("/") || file.exists() && file.isDirectory()) {
            string7 = dosutil.addTrailingSlash(string7) + stringArray[2] + stringArray[3];
            file = new File(string7);
        }
        if (string6.equalsIgnoreCase(string7)) {
            return "Source and destination are the same";
        }
        l3 = file.lastModified();
        l4 = file.length();
        if (tAsciiInput.getFilename().toUpperCase().startsWith("FILE://")) {
            serializable = new File(tAsciiInput.getFilename().substring(7));
            l = ((File)serializable).lastModified();
            l2 = ((File)serializable).length();
        } else {
            try {
                serializable = tAsciiInput.getURL();
                object = ((URL)serializable).openConnection();
                l = ((URLConnection)object).getDate();
                l2 = ((URLConnection)object).getContentLength();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (n == 1 ? file.exists() : n == 2 && l > 0L && l < l3) {
            return "ok";
        }
        stringArray = dosutil.splitPath(string7);
        String string9 = "";
        string9 = stringArray[0] != null ? string9 + stringArray[0] : string9 + "\\";
        if (stringArray[1] != null) {
            string9 = string9 + stringArray[1];
        }
        if (string9.startsWith("\\\\\\")) {
            string9 = string9.substring(1);
        } else if (string9.startsWith("\\\\")) {
            string9 = string9.substring(1);
        }
        serializable = new File(charutil.replaceChar(dosutil.removeTrailingSlash(string9), '\\', '/'));
        if (!((File)serializable).exists()) {
            try {
                if (!((File)serializable).mkdirs()) {
                    Aspect.MainWin.appendToLog("dosutil", "copyFile", Thread.currentThread(), null, 4, "Util: Unable to create directory: " + string9);
                    Aspect.MainWin.appendToLog("dosutil", "copyFile", Thread.currentThread(), null, 4, "Util: Error copying file:");
                    Aspect.MainWin.appendToLog("dosutil", "copyFile", Thread.currentThread(), null, 4, "Util: Src:" + string);
                    Aspect.MainWin.appendToLog("dosutil", "copyFile", Thread.currentThread(), null, 4, "Util: Dest:" + string2);
                    tAsciiInput.dispose();
                    return "Cannot create directory named " + ((File)serializable).getAbsolutePath();
                }
            }
            catch (Exception exception) {
                Aspect.MainWin.appendToLog("dosutil", "copyFile", Thread.currentThread(), exception, 4, "Exception creating directory: " + ((File)serializable).getAbsolutePath());
                tAsciiInput.dispose();
                return "Exception creating directory named " + ((File)serializable).getAbsolutePath();
            }
        }
        try {
            int n2;
            TEncryptedInputStream tEncryptedInputStream = new TEncryptedInputStream(new BufferedInputStream(tAsciiInput.getInputStream()), string3);
            TEncryptedOutputStream tEncryptedOutputStream = new TEncryptedOutputStream(new BufferedOutputStream(new FileOutputStream(string7, bl)), string4);
            object = new byte[1024];
            int n3 = 0;
            do {
                if ((n2 = tEncryptedInputStream.read((byte[])object)) <= 0) continue;
                tEncryptedOutputStream.write((byte[])object, 0, n2);
                n3 += n2;
            } while (n2 >= 0);
            tEncryptedInputStream.close();
            tEncryptedOutputStream.close();
        }
        catch (Exception exception) {
            tAsciiInput.dispose();
            return exception.toString();
        }
        tAsciiInput.dispose();
        object = new File(string);
        if (((File)object).lastModified() > 0L) {
            File file2 = new File(string2);
            file2.setLastModified(((File)object).lastModified());
        }
        return "ok";
    }

    public static int copyFile(String string, String string2, boolean bl) {
        byte[] byArray = new byte[1024];
        try {
            int n;
            TAsciiInput tAsciiInput = new TAsciiInput(string, ',');
            BufferedInputStream bufferedInputStream = new BufferedInputStream(tAsciiInput.getInputStream());
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2, false));
            long l = 0L;
            do {
                n = bufferedInputStream.read(byArray);
                l += (long)n;
                if (n <= 0) continue;
                bufferedOutputStream.write(byArray, 0, n);
            } while (n > 0);
            bufferedInputStream.close();
            bufferedOutputStream.close();
            tAsciiInput.dispose();
            return 1;
        }
        catch (Exception exception) {
            System.out.println("Exception in copyFile(2): " + exception.toString());
            return 0;
        }
    }

    public static int copyFile(String string, String string2, int n) {
        try {
            TAsciiInput tAsciiInput = new TAsciiInput(string, ',');
            BufferedInputStream bufferedInputStream = new BufferedInputStream(tAsciiInput.getInputStream());
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2, false));
            long l = 0L;
            byte[] byArray = new byte[1024];
            int n2 = 0;
            do {
                if ((n2 = bufferedInputStream.read(byArray)) <= 0) continue;
                int n3 = (int)Math.min((long)n2, (long)n - l);
                bufferedOutputStream.write(byArray, 0, n3);
                l += (long)n3;
            } while (n2 > 0 && l < (long)n);
            bufferedInputStream.close();
            bufferedOutputStream.close();
            tAsciiInput.dispose();
            return 1;
        }
        catch (Exception exception) {
            System.out.println("Exception in copyFile(3): " + exception.toString());
            return 0;
        }
    }

    public static File createTempFile(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        TMainWin.Application.getTokenValue(stringBuilder, "Temporary_Files");
        dosutil.add_trailing_slash(stringBuilder, stringBuilder, "/");
        try {
            File file = File.createTempFile("$$$", "." + string, new File(stringBuilder.toString()));
            return file;
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            return null;
        }
    }

    public static File createTempFile(String string, String string2) {
        try {
            String string3 = "";
            if (string2.length() > 0) {
                string3 = "." + string2;
            }
            File file = File.createTempFile("$$$", string3, new File(dosutil.addTrailingSlash(string)));
            return file;
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            return null;
        }
    }

    public static String getTempFilename(String string, String string2, String string3) {
        String string4;
        String string5 = dosutil.addTrailingSlash(string);
        TFile tFile = new TFile(string5);
        String string6 = string2;
        if (string6 == null) {
            string6 = "";
        }
        if ((string4 = string3) == null) {
            string4 = "";
        } else if (string4.length() > 0 && !string4.startsWith(".")) {
            string4 = "." + string4;
        }
        do {
            Double d = new Double(Math.random() * 1000000.0);
            String string7 = Integer.toString(d.intValue()) + string6 + string4;
            tFile = new TFile(string5 + string7);
            tFile.validatePathToFile(true);
        } while (tFile.exists());
        return tFile.getName();
    }

    public static void deleteTempFiles() {
        StringBuilder stringBuilder = new StringBuilder();
        TMainWin.Application.getTokenValue(stringBuilder, "HomeDir");
        dosutil.add_trailing_slash(stringBuilder, stringBuilder, "/");
        File file = new File(stringBuilder.toString());
        String[] stringArray = file.list();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].startsWith("$$$") || !stringArray[i].endsWith(".tmp")) continue;
                File file2 = new File(stringArray[i]);
                file2.delete();
            }
        }
    }

    public static void sleep(Thread thread, int n) {
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String removeRelativeDirectories(String string, char c) {
        StringBuilder stringBuilder = new StringBuilder(string);
        String string2 = string;
        charutil.replace_char(stringBuilder, stringBuilder, '\\', '/');
        charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "//", "$$");
        String[] stringArray = charutil.getSubStringArray(stringBuilder, '/', false);
        if (stringArray != null) {
            int n;
            for (n = 1; n < stringArray.length; ++n) {
                if (!stringArray[n].equals("..")) continue;
                stringArray[n] = "";
                stringArray[n - 1] = "";
            }
            string2 = "";
            if (stringArray[0].length() > 0) {
                string2 = stringArray[0];
            }
            string2 = string2 + c;
            for (n = 1; n < stringArray.length; ++n) {
                if (stringArray[n].length() <= 0) continue;
                string2 = string2 + stringArray[n] + c;
            }
        }
        string2 = charutil.replaceAllSubstrings(string2, "$$", "//");
        return string2;
    }

    public static String listFiles(String string, int n, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = dosutil.addTrailingSlash(string);
        boolean bl3 = false;
        String string3 = string.toUpperCase();
        int n2 = string3.indexOf(".ZIP");
        if (n2 < 0) {
            n2 = string3.indexOf(".JAR");
        }
        if (bl2 && n2 >= 0) {
            String[] stringArray;
            String string4 = string.substring(0, n2 + 4);
            String string5 = "";
            if (string.length() > n2 + 3 && (string5 = string.substring(n2 + 4).toUpperCase()).startsWith("/")) {
                string5 = string5.substring(1);
            }
            if ((stringArray = ziputil.getZipContents(string4, false)) != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    bl3 = true;
                    String string6 = stringArray[i].substring(0, stringArray[i].indexOf(10));
                    if (string5.length() > 0 && !string6.toUpperCase().startsWith(string5)) {
                        bl3 = false;
                    }
                    if (!bl3) continue;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("|");
                    }
                    stringBuilder.append(string6);
                }
            }
            return stringBuilder.toString();
        }
        try {
            File file = new File(string2);
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                bl3 = false;
                switch (n) {
                    case 0: {
                        if (fileArray[i].isDirectory()) break;
                        bl3 = true;
                        break;
                    }
                    case 1: {
                        if (!fileArray[i].isDirectory()) break;
                        bl3 = true;
                        break;
                    }
                    case 2: {
                        bl3 = true;
                    }
                }
                if (!bl3) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("|");
                }
                if (bl) {
                    stringBuilder.append(string2);
                }
                stringBuilder.append(fileArray[i].getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    public static String[] listRecursedFiles(String string) {
        String[] stringArray;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            stringArray = new File(string);
            File[] fileArray = stringArray.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    stringBuilder.append(dosutil.listRecursedFiles(fileArray[i].getName()));
                    continue;
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("|");
                }
                stringBuilder.append(fileArray[i].getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringArray = charutil.getSubStringArray(stringBuilder, '|', true);
        return stringArray;
    }

    public static String listMatchingFiles(String string, int n, boolean bl, boolean bl2, int n2, String string2) {
        Comparable<StringBuilder> comparable;
        boolean bl3 = false;
        if (string.indexOf(59) < 0) {
            comparable = new File(string);
            bl3 = ((File)comparable).isDirectory();
        }
        comparable = new StringBuilder();
        if (!bl3 && string.indexOf("*") < 0 && string.indexOf("?") < 0 && string2.length() == 0 && !bl) {
            String[] stringArray = charutil.getSubStringArray(string, ';', false);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    File file = new File(stringArray[i]);
                    if (!file.exists()) continue;
                    ((StringBuilder)comparable).append("|" + stringArray[i]);
                }
                if (((StringBuilder)comparable).length() > 0) {
                    ((StringBuilder)comparable).deleteCharAt(0);
                }
                charutil.replace_char(comparable, comparable, '\\', '/');
            }
        } else {
            ((StringBuilder)comparable).append(dosutil.listMatchingFilesWithWildcards(string, n, bl, bl2, n2, string2));
        }
        return ((StringBuilder)comparable).toString();
    }

    public static String listMatchingFilesWithWildcards(String string, int n, boolean bl, boolean bl2, int n2, String string2) {
        String[] stringArray;
        Comparable<File> comparable;
        Object object;
        int n3;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray2 = charutil.getSubStringArray(string, ';', false);
        if (stringArray2 != null) {
            for (n3 = 0; n3 < stringArray2.length; ++n3) {
                String string3;
                object = charutil.replaceChar(stringArray2[n3], '\\', '/');
                comparable = new File(dosutil.addTrailingSlash((String)object));
                if (((File)comparable).isDirectory()) {
                    object = dosutil.addTrailingSlash((String)object) + "*.*";
                }
                if ((stringArray = dosutil.splitPath((String)object))[1] != null && stringArray[1].length() > 0) {
                    String string4;
                    string3 = "";
                    if (stringArray[0] != null) {
                        string3 = string3 + stringArray[0];
                    }
                    if (!arrayList.contains(string4 = (string3 + stringArray[1]).toUpperCase())) {
                        arrayList.add(string4);
                    }
                }
                if ((string3 = dosutil.listMatchingFiles(0, (String)object, n, bl, bl2, n2)).length() <= 0) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("|");
                }
                stringBuilder.append(string3);
            }
        }
        if (string2.trim().length() == 0) {
            return stringBuilder.toString();
        }
        stringArray2 = charutil.getSubStringArray(string2, ';', false);
        if (stringArray2 != null) {
            for (n3 = 0; n3 < stringArray2.length; ++n3) {
                object = charutil.replaceChar(stringArray2[n3], '\\', '/');
                comparable = new File(dosutil.addTrailingSlash((String)object));
                if (((File)comparable).isDirectory()) {
                    object = dosutil.addTrailingSlash((String)object) + "*.*";
                }
                if ((stringArray = dosutil.splitPath((String)object))[1] == null || stringArray[1].length() == 0) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        String string5;
                        String string6 = (String)arrayList.get(i) + (String)object;
                        comparable = new File(dosutil.addTrailingSlash(string6));
                        if (((File)comparable).isDirectory()) {
                            string6 = dosutil.addTrailingSlash(string6) + "*.*";
                        }
                        if ((string5 = dosutil.listMatchingFiles(0, string6, n, bl, bl2, n2)).length() <= 0) continue;
                        if (stringBuilder2.length() > 0) {
                            stringBuilder2.append("|");
                        }
                        stringBuilder2.append(string5);
                    }
                    continue;
                }
                String string7 = "";
                boolean bl3 = false;
                if (stringArray[0] != null) {
                    string7 = string7 + stringArray[0];
                    bl3 = true;
                }
                string7 = (string7 + stringArray[1]).toUpperCase();
                if (bl3 || arrayList.contains(string7)) {
                    String string8 = dosutil.listMatchingFiles(0, (String)object, n, bl, bl2, n2);
                    if (string8.length() <= 0) continue;
                    if (stringBuilder2.length() > 0) {
                        stringBuilder2.append("|");
                    }
                    stringBuilder2.append(string8);
                    continue;
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string9;
                    String string10 = (String)arrayList.get(i) + (String)object;
                    comparable = new File(dosutil.addTrailingSlash(string10));
                    if (((File)comparable).isDirectory()) {
                        string10 = dosutil.addTrailingSlash(string10) + "*.*";
                    }
                    if ((string9 = dosutil.listMatchingFiles(0, string10, n, bl, bl2, n2)).length() <= 0) continue;
                    if (stringBuilder2.length() > 0) {
                        stringBuilder2.append("|");
                    }
                    stringBuilder2.append(string9);
                }
            }
        }
        String string11 = stringBuilder2.toString().toUpperCase() + "|";
        object = charutil.getSubStringArray(stringBuilder, '|', false);
        comparable = new StringBuilder();
        if (object != null) {
            for (int i = 0; i < ((String[])object).length; ++i) {
                if (string11.indexOf(object[i].toUpperCase() + "|") >= 0) continue;
                if (((StringBuilder)comparable).length() > 0) {
                    ((StringBuilder)comparable).append("|");
                }
                ((StringBuilder)comparable).append(object[i]);
            }
        }
        return ((StringBuilder)comparable).toString();
    }

    public static String listMatchingFiles(int n, String string, int n2, boolean bl, boolean bl2, int n3) {
        String string2;
        String[] stringArray;
        String string3;
        String[] stringArray2;
        int n4;
        int n5;
        String[] stringArray3;
        File file;
        if (n3 > 0 && n > n3) {
            return "";
        }
        tregex tregex2 = new tregex();
        StringBuilder stringBuilder = new StringBuilder();
        String string4 = string;
        String string5 = "";
        String string6 = "";
        if (string.indexOf(42) < 0 && string.indexOf(63) < 0 && (file = new File(string4)).isDirectory()) {
            string4 = dosutil.addTrailingSlash(string4) + "*.*";
        }
        if ((stringArray3 = charutil.getSubStringArray(string4 = charutil.replaceChar(string4, '\\', '/'), '/', false)) == null || stringArray3.length == 0) {
            return "";
        }
        for (n5 = 0; n5 < stringArray3.length - 1; ++n5) {
            string5 = string5 + stringArray3[n5] + "/";
        }
        string5 = dosutil.addTrailingSlash(string5);
        string6 = stringArray3[stringArray3.length - 1];
        tregex2.setPattern(string6.toUpperCase(), n2);
        int n6 = n4 = bl2 ? 2 : 0;
        if (bl2) {
            // empty if block
        }
        if ((stringArray2 = charutil.getSubStringArray(string3 = dosutil.listFiles(string5, n4, false, false), '|', true)) != null && stringArray2.length > 0 && (stringArray = tregex2.getMatch(stringArray2)) != null && stringArray.length > 0) {
            for (n5 = 0; n5 < stringArray.length; ++n5) {
                stringArray[n5] = string5 + stringArray[n5];
            }
            string2 = charutil.makeDelimitedString(stringArray, '|', false);
            if (string2.length() > 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('|');
                }
                stringBuilder.append(string2);
            }
        }
        if (bl && (stringArray2 = charutil.getSubStringArray(string3 = dosutil.listFiles(string5, 1, true, false), '|', true)) != null && stringArray2.length > 0) {
            for (n5 = 0; n5 < stringArray2.length; ++n5) {
                string2 = dosutil.addTrailingSlash(stringArray2[n5]) + string6;
                if ((string2 = dosutil.listMatchingFiles(n + 1, string2, n2, bl, bl2, n3)).length() <= 0) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('|');
                }
                stringBuilder.append(string2);
            }
        }
        return stringBuilder.toString();
    }

    public static int getWinPID() {
        String string = ManagementFactory.getRuntimeMXBean().getName();
        int n = string.indexOf("@");
        if (n >= 0) {
            string = string.substring(0, n);
            return Integer.parseInt(string);
        }
        return 0;
    }

    public static String getPID() {
        Properties properties = System.getProperties();
        String string = (String)properties.get("java.home");
        string = "c:\\jdk1.6.0_11\\";
        File file = new File(string + "bin");
        byte[] byArray = new byte[100];
        try {
            String[] stringArray = new String[]{string + "bin/jps.exe"};
            Process process = Runtime.getRuntime().exec(stringArray, null, file);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string2 = "";
            while ((string2 = bufferedReader.readLine()) != null) {
                System.out.println("Reading PID line: " + string2);
                if (string2.indexOf("Aspect.jar") <= 0) continue;
                String string3 = string2.substring(0, string2.indexOf(" "));
                bufferedReader.close();
                return string3;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.out.println("exception in getPID: " + exception.toString());
        }
        return "0";
    }

    public static ArrayList getJavaPIDs() {
        String string = dosutil.listProcesses();
        if (string.trim().length() == 0) {
            return null;
        }
        String[] stringArray = charutil.getSubStringArray(string = charutil.removeChar(string, '\r'), '\n', false);
        if (stringArray != null && stringArray.length > 0) {
            int n = -1;
            int n2 = -1;
            String string2 = stringArray[0].trim();
            if (string2.length() == 0 && stringArray.length > 1) {
                string2 = stringArray[1].trim();
            }
            String[] stringArray2 = charutil.getSubStringArray(string2, ',', true);
            for (int i = 0; i < stringArray2.length; ++i) {
                if (stringArray2[i].equalsIgnoreCase("Image Name")) {
                    n = i;
                }
                if (!stringArray2[i].equalsIgnoreCase("PID")) continue;
                n2 = i;
            }
            if (n >= 0 && n2 >= 0) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (int i = 1; i < stringArray.length; ++i) {
                    String string3;
                    stringArray2 = charutil.getSubStringArray(stringArray[i], ',', true);
                    if (stringArray2 == null || stringArray2.length <= Math.max(n, n2) || !(string3 = stringArray2[n]).equalsIgnoreCase("JAVA.EXE") && !string3.equalsIgnoreCase("JAVAW.EXE") && !string3.equalsIgnoreCase("JP2LAUNCHER.EXE")) continue;
                    arrayList.add(new Integer(charutil.ival(stringArray2[n2])));
                }
                return arrayList;
            }
            Aspect.MainWin.appendToLog("dosutil", "compareFiles", Thread.currentThread(), null, 4, "getProcessPIDs cannot get index of Image Name and PID");
        }
        return null;
    }

    public static String listProcesses() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string;
            Process process = Runtime.getRuntime().exec("tasklist.exe /v /fo csv");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string + "\r\n");
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuilder.toString();
    }

    public static String listServices() {
        try {
            String string;
            Process process = Runtime.getRuntime().exec("net.exe start");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).length() <= 0 || string.toUpperCase().indexOf("THESE WINDOWS") >= 0 || string.toUpperCase().indexOf("THE COMMAND") >= 0) continue;
                stringBuilder.append(string + "\r\n");
            }
            bufferedReader.close();
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            System.out.println("listServices: " + exception.toString());
            return null;
        }
    }

    public static boolean deleteFile(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return true;
        }
        return dosutil.deleteFile(file);
    }

    public static boolean deleteFile(File file) {
        boolean bl = true;
        if (file.exists()) {
            bl = file.delete();
            if (file.exists()) {
                System.gc();
                bl = file.delete();
            }
        }
        return bl;
    }

    public static long getChecksum(String string) {
        long l = -1L;
        String string2 = charutil.replaceChar(string, '/', '\\');
        if (string2.toUpperCase().startsWith("FILE:\\")) {
            string2 = string2.substring(6);
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(string2);
            CheckedInputStream checkedInputStream = new CheckedInputStream(fileInputStream, new CRC32());
            BufferedInputStream bufferedInputStream = new BufferedInputStream(checkedInputStream);
            byte[] byArray = new byte[8192];
            while (bufferedInputStream.read(byArray) != -1) {
            }
            l = checkedInputStream.getChecksum().getValue();
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    public static int compareFiles(String string, String string2) {
        Date date = new Date();
        File file = new File(string);
        File file2 = new File(string2);
        if (!file.exists()) {
            return -1;
        }
        if (!file2.exists()) {
            return -2;
        }
        if (file.length() != file2.length()) {
            return -3;
        }
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(file.toURL().openStream());
            BufferedInputStream bufferedInputStream2 = new BufferedInputStream(file2.toURL().openStream());
            byte[] byArray = new byte[8192];
            byte[] byArray2 = new byte[8192];
            long l = 0L;
            boolean bl = true;
            do {
                int n = bufferedInputStream.read(byArray);
                int n2 = bufferedInputStream2.read(byArray2);
                l += (long)(n + n2);
                if (n == n2 && n >= 0 && n2 >= 0) {
                    for (int i = 0; i < n; ++i) {
                        if (byArray[i] == byArray2[i]) continue;
                        bufferedInputStream.close();
                        bufferedInputStream2.close();
                        return -4;
                    }
                } else {
                    bl = false;
                }
            } while (bl);
            bufferedInputStream.close();
            bufferedInputStream2.close();
        }
        catch (Exception exception) {
            Aspect.MainWin.appendToLog("dosutil", "compareFiles", Thread.currentThread(), exception, 4, "Error in fileCompare(" + string + "," + string2 + ")");
        }
        return 0;
    }

    public static String xCopy(String string, String string2, boolean bl, int n, String string3, boolean bl2, boolean bl3) {
        String[] stringArray = charutil.getSubStringArray(string, ';', true);
        String[] stringArray2 = charutil.getSubStringArray(string2, ';', true);
        Hashtable<String, String> hashtable = null;
        if (stringArray == null) {
            String string4 = "Error in xCopy.  Source filespec is invalid: " + string;
            Aspect.MainWin.appendToLog("dosutil", "xCopy", Thread.currentThread(), null, 4, string4);
            return string4;
        }
        if (stringArray2 == null) {
            String string5 = "Error in xCopy.  Destination filespec is invalid: " + string2;
            Aspect.MainWin.appendToLog("dosutil", "xCopy", Thread.currentThread(), null, 4, string5);
            return string5;
        }
        if (stringArray.length != stringArray2.length) {
            String string6 = "Error in xCopy.  Filespecs contain different number of elements: Src=" + string;
            Aspect.MainWin.appendToLog("dosutil", "xCopy", Thread.currentThread(), null, 4, string6);
            return string6;
        }
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            String string7;
            String string8 = dosutil.listMatchingFiles(stringArray[i], 1, bl, false, n, string3);
            if (string8.length() <= 0) continue;
            String[] stringArray3 = charutil.getSubStringArray(string8, '|', true);
            String string9 = dosutil.getFileDrive(stringArray[i]);
            String string10 = dosutil.getFileDir(stringArray[i]);
            String string11 = string9 == null ? "" : string9;
            string11 = string11 + (string10 == null ? "" : string10);
            string11 = charutil.replaceChar(string11, '/', '\\');
            String string12 = stringArray2[i];
            if ((string12 = charutil.replaceChar(string12, '/', '\\')).length() > 0 && string12.charAt(string12.length() - 1) != '\\') {
                string12 = string12 + "\\";
            }
            boolean bl4 = true;
            if (hashtable != null && hashtable.containsKey(string12.toUpperCase())) {
                bl4 = false;
            } else {
                File file = new File(string12);
                if (!file.exists()) {
                    file.mkdirs();
                }
                if (!file.exists()) {
                    if (hashtable == null) {
                        hashtable = new Hashtable<String, String>();
                    }
                    hashtable.put(string12.toUpperCase(), string12.toUpperCase());
                    string7 = "Error in xCopy.  Invalid destination: " + string12;
                    if (Aspect.MainWin != null) {
                        Aspect.MainWin.appendToLog("dosutil", "xCopy", Thread.currentThread(), null, 4, string7);
                    }
                    bl4 = false;
                } else if (!file.isDirectory()) {
                    if (hashtable == null) {
                        hashtable = new Hashtable();
                    }
                    hashtable.put(string12.toUpperCase(), string12.toUpperCase());
                    string7 = "Error in xCopy.  Destination is not a directory: " + string12;
                    if (Aspect.MainWin != null) {
                        Aspect.MainWin.appendToLog("dosutil", "xCopy", Thread.currentThread(), null, 4, string7);
                    }
                    bl4 = false;
                }
            }
            if (!bl4) continue;
            for (int j = 0; j < stringArray3.length; ++j) {
                String string13;
                string7 = charutil.replaceChar(stringArray3[j], '/', '\\');
                String string14 = charutil.replaceAllSubstrings(string7, string11, string12);
                File file = new File(string7);
                File file2 = new File(string14);
                string9 = dosutil.getFileDrive(string14);
                string10 = dosutil.getFileDir(string14);
                String string15 = string9 == null ? "" : string9;
                string15 = string15 + (string10 == null ? "" : string10);
                File file3 = new File(string15);
                file3.mkdirs();
                int n3 = 1;
                if (file2.exists() && !bl2) {
                    n3 = -1;
                } else if (file2.exists()) {
                    if (bl3) {
                        if (file.lastModified() <= file2.lastModified()) {
                            n3 = -2;
                        }
                    } else if (file.length() == file2.length() && dosutil.getChecksum(string7) == dosutil.getChecksum(string14)) {
                        n3 = -3;
                    }
                }
                if (n3 != 1) continue;
                int n4 = dosutil.copyFile(string7, string14, false);
                file2.setLastModified(file.lastModified());
                if (n4 == 1) {
                    string13 = "xcopy " + string7 + " -> " + string14 + " [ok]";
                    if (Aspect.MainWin != null) {
                        Aspect.MainWin.appendToLog("dosutil", "xCopy", Thread.currentThread(), null, 3, string13);
                    } else {
                        System.out.println(string13);
                    }
                } else {
                    string13 = "xcopy Error copying " + string7 + " -> " + string14 + " [" + n4 + "]";
                    if (Aspect.MainWin != null) {
                        Aspect.MainWin.appendToLog("dosutil", "xCopy", Thread.currentThread(), null, 4, string13);
                    } else {
                        System.out.println(string13);
                    }
                }
                ++n2;
            }
        }
        return "Ok.  " + Integer.toString(n2) + " files copied.";
    }

    public static boolean isServiceRunning(String string) {
        String string2 = dosutil.listServices();
        string2 = charutil.removeChar(string2, '\r');
        String[] stringArray = charutil.getSubStringArray(string2, '\n', false);
        boolean bl = false;
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length && !bl; ++i) {
                if (!stringArray[i].equalsIgnoreCase(string)) continue;
                bl = true;
            }
        }
        return bl;
    }

    public static String getOSName() {
        return System.getProperty("os.name");
    }

    public static boolean execServiceCommand(String string) {
        String string2;
        String[] stringArray;
        if (string.equalsIgnoreCase("start") && dosutil.isServiceRunning("AspectService")) {
            return true;
        }
        String string3 = "c:\\aspect7\\";
        String string4 = string3 + "bin\\service\\";
        if (dosutil.getOSName().equalsIgnoreCase("Windows XP")) {
            stringArray = new String[]{string4 + "service.bat", string};
        } else {
            string2 = System.getenv("ProgramFiles(X86)");
            String string5 = string2 == null ? "elevate32.exe" : "elevate64.exe";
            stringArray = new String[]{string4 + string5, string4 + "service.bat", string};
        }
        try {
            string2 = "";
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = string2 + stringArray[i] + " ";
            }
            System.out.println("Starting UAC prompt: " + string2);
            Process process = Runtime.getRuntime().exec(stringArray, null, new File(string3));
            if (process != null) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                long l = new Date().getTime();
                string2 = null;
                long l2 = 0L;
                while (l2 < 60000L && (string2 = bufferedReader.readLine()) != null) {
                    System.out.println("Output: " + string2);
                    Thread.yield();
                    l2 = new Date().getTime() - l;
                }
                if (l2 >= 60000L) {
                    return false;
                }
                System.out.println("UAC prompt has terminated");
                return true;
            }
            System.out.println("Unable to start process");
            return false;
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            return false;
        }
    }

    public static String mapDrive(String string, String string2, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String[] stringArray = string3.trim().length() == 0 ? new String[]{"net", "use", string, string2} : new String[]{"net", "use", string, string2, "/user:" + netutil.getLocalHostName() + "\\" + string3, string4};
            String string5 = "";
            for (int i = 0; i < stringArray.length; ++i) {
                string5 = string5 + stringArray[i] + " ";
            }
            Aspect.MainWin.appendToLog("dosutil", "mapDrive", Thread.currentThread(), null, 3, "Execute: " + string5);
            Process process = Runtime.getRuntime().exec(stringArray, null, new File(System.getenv("windir")));
            TExecListenerThread tExecListenerThread = new TExecListenerThread("ExecOutput", process.getInputStream());
            tExecListenerThread.start();
            TExecListenerThread tExecListenerThread2 = new TExecListenerThread("ExecError", process.getErrorStream());
            tExecListenerThread2.start();
            while (!tExecListenerThread.terminated() || !tExecListenerThread2.terminated()) {
                Thread.yield();
            }
            stringBuilder.append(tExecListenerThread.getOutput() + tExecListenerThread2.getOutput());
            if (stringBuilder.toString().toUpperCase().indexOf("SUCCESS") < 0 && string3.trim().length() > 0) {
                stringArray = new String[]{"net", "use", string, string2, "/user:" + string3, string4};
                string5 = "";
                for (int i = 0; i < stringArray.length; ++i) {
                    string5 = string5 + stringArray[i] + " ";
                }
                Aspect.MainWin.appendToLog("dosutil", "mapDrive", Thread.currentThread(), null, 3, "Execute: " + string5);
                process = Runtime.getRuntime().exec(stringArray, null, new File(System.getenv("windir")));
                tExecListenerThread = new TExecListenerThread("ExecOutput", process.getInputStream());
                tExecListenerThread.start();
                tExecListenerThread2 = new TExecListenerThread("ExecError", process.getErrorStream());
                tExecListenerThread2.start();
                while (!tExecListenerThread.terminated() || !tExecListenerThread2.terminated()) {
                    Thread.yield();
                }
                stringBuilder.append(tExecListenerThread.getOutput() + tExecListenerThread2.getOutput());
            }
        }
        catch (Exception exception) {
            Aspect.MainWin.appendToLog("dosutil", "mapDrive", Thread.currentThread(), exception, 4, exception.toString());
            stringBuilder.append(exception.toString());
        }
        String string6 = stringBuilder.toString();
        Aspect.MainWin.appendToLog("dosutil", "mapDrive", Thread.currentThread(), null, 3, "MapDrive: " + string6);
        if (string6.toUpperCase().indexOf("SUCCESS") >= 0) {
            return "Ok: " + string6;
        }
        return "Error: " + string6;
    }

    public static String unMapDrive(String string) {
        String string2;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string3 = "net.exe use " + string + " /d /y";
            Process process = Runtime.getRuntime().exec(string3);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string2 = bufferedReader.readLine()) != null) {
                string2 = string2.trim();
                stringBuilder.append(string2 + "\r\n");
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            stringBuilder.append(exception.toString());
        }
        string2 = stringBuilder.toString();
        if (string2.toUpperCase().indexOf("SUCCESS") >= 0) {
            return "Ok: " + string2;
        }
        return "Error: " + string2;
    }

    public static long getFilespecSize(String string, boolean bl) {
        String string2 = dosutil.listMatchingFiles(string, 1, bl, false, 0, "");
        String[] stringArray = charutil.getSubStringArray(string2, '|', false);
        long l = 0L;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File(stringArray[i]);
                if (!file.exists()) continue;
                l += (long)((int)file.length());
            }
        }
        return l;
    }

    public static Date getFilespecModified(String string, boolean bl) {
        String string2 = dosutil.listMatchingFiles(string, 1, bl, false, 0, "");
        String[] stringArray = charutil.getSubStringArray(string2, '|', false);
        long l = 0L;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File(stringArray[i]);
                if (!file.exists()) continue;
                l = Math.max(l, file.lastModified());
            }
        }
        return new Date(l);
    }

    public static void main(String[] stringArray) {
        String string = "c:\\aspect7\\temporary_files\\emailtaskKROD.eml";
        String string2 = dosutil.listMatchingFiles(0, string, 1, false, false, 0);
        System.out.println("String1=" + string2);
        System.exit(0);
    }
}

