/*
 * Decompiled with CFR 0.152.
 */
package utility.http;

import aspect.Aspect;
import aspect.TMainWin;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import utility.charutil;

public class THttpRequest {
    private static TMainWin MainWin = Aspect.MainWin;
    private boolean Debug = false;
    private static final String[] arMethodText = new String[]{"UNDEFINED", "GET", "POST", "HEAD"};
    private String strURI = "";
    private String strHttpVersion = "HTTP/1.0";
    private int intMethod = 0;
    private Hashtable hashHeaders = new Hashtable();
    private Hashtable hashArgs = new Hashtable();
    private Hashtable hashArgContentType = new Hashtable();
    private byte[] arContent = null;
    public Socket socket;

    public THttpRequest(Socket socket) {
        this.socket = socket;
    }

    public int getMethod() {
        return this.intMethod;
    }

    public String getMethodText() {
        if (this.intMethod >= 0 && this.intMethod <= 3) {
            return arMethodText[this.intMethod];
        }
        return "Invalid";
    }

    public void setMethod(int n) {
        this.intMethod = n;
    }

    public String getHeaderValue(String string) {
        Object object = this.hashHeaders.get(string.toUpperCase());
        if (object == null) {
            return "";
        }
        if (string.equalsIgnoreCase("user-agent")) {
            object = charutil.replaceChar((String)object, '\"', '\'');
            object = charutil.replaceChar((String)object, ',', ' ');
        }
        return (String)object;
    }

    public void setHeaderValue(String string, String string2) {
        Object v = this.hashHeaders.get(string);
        if (v != null) {
            this.hashHeaders.remove(v);
        }
        this.hashHeaders.put(string.toUpperCase(), string2);
    }

    public String getHeaders() {
        String string = "";
        Enumeration enumeration = this.hashHeaders.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = this.hashHeaders.get(k);
            if (string.length() > 0) {
                string = string + "|";
            }
            string = string + (String)k + ":" + (String)v;
        }
        return string;
    }

    public void setHeaders(String string) {
        String[] stringArray = charutil.getSubStringArray(string, '|', true);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                int n = stringArray[i].indexOf(58);
                String string2 = stringArray[i].substring(n);
                String string3 = stringArray[i].substring(n + 1);
                this.setHeaderValue(string2, string3);
            }
        }
    }

    public String getArgumentValue(String string) {
        Enumeration enumeration = this.hashArgs.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.equalsIgnoreCase(string)) continue;
            Object v = this.hashArgs.get(string2);
            if (v instanceof String) {
                return charutil.tokenizeForPost((String)v, false);
            }
            return ((StringBuilder)v).toString();
        }
        return "";
    }

    public void setArgumentValue(String string, String string2) {
        Enumeration enumeration = this.hashArgs.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (!string3.equalsIgnoreCase(string)) continue;
            this.hashArgs.remove(string3);
        }
        this.hashArgs.put(string, string2);
    }

    public void setArgumentValue(String string, Object object) {
        Enumeration enumeration = this.hashArgs.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.equalsIgnoreCase(string)) continue;
            this.hashArgs.remove(string2);
        }
        this.hashArgs.put(string, object);
    }

    public void setArgumentContentType(String string, String string2) {
        String string3 = string.toUpperCase();
        Object v = this.hashArgs.get(string3);
        if (v != null) {
            this.hashArgs.remove(v);
        }
        this.hashArgContentType.put(string3, string2);
    }

    public String getArguments() {
        String string = "";
        Enumeration enumeration = this.hashArgs.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = this.hashArgContentType.get(k);
            if (v != null && !((String)v).equalsIgnoreCase("text/plain")) continue;
            Object v2 = this.hashArgs.get(k);
            if (string.length() > 0) {
                string = string + "&";
            }
            if (!(v2 instanceof String)) continue;
            String string2 = charutil.replaceAllSubstrings(charutil.tokenizeForPost((String)v2, false), "&", "%26");
            string = string + (String)k + "=" + string2;
        }
        return string;
    }

    public void setArguments(String string) {
        String[] stringArray = charutil.getSubStringArray(string, '&', true);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = charutil.getSubStringArray(stringArray[i], '=', false);
                if (stringArray2 == null || stringArray2.length <= 0) continue;
                String string2 = stringArray2[0];
                String string3 = "";
                if (stringArray2.length > 1) {
                    for (int j = 1; j < stringArray2.length; ++j) {
                        if (j > 1) {
                            string3 = string3 + "=";
                        }
                        string3 = string3 + stringArray2[j];
                    }
                }
                this.setArgumentValue(string2, string3);
            }
        }
    }

    public void setHttpVersion(String string) {
        this.strHttpVersion = string.trim();
    }

    public String getURI() {
        return this.strURI;
    }

    public void setURI(String string) {
        this.strURI = string.trim();
    }

    public byte[] getContent() {
        return this.arContent;
    }

    public int getContentLength() {
        if (this.arContent == null) {
            return 0;
        }
        return this.arContent.length;
    }

    public void setContent(byte[] byArray) {
        this.arContent = byArray;
    }

    public void reset() {
        this.intMethod = 0;
        this.strURI = "";
        this.strHttpVersion = "HTTP/1.0";
        this.arContent = null;
        this.hashArgs.clear();
        this.hashHeaders.clear();
    }

    public String readLine(DataInputStream dataInputStream) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            char c;
            do {
                if ((c = (char)dataInputStream.readByte()) == '\n' || c == '\r') continue;
                stringBuilder.append(c);
            } while (c != '\n' && dataInputStream.available() > 0);
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String send() {
        String string = "";
        String string2 = "";
        String string3 = "Ok";
        if (this.intMethod < 1 || this.intMethod > 3) {
            string3 = "No method specified for http request";
            MainWin.appendToLog("THttpRequest", "send", Thread.currentThread(), null, 4, string3);
            return string3;
        }
        if (this.strURI.length() == 0) {
            this.strURI = "/";
        }
        if (this.strHttpVersion.length() == 0) {
            string3 = "No HTTP version specified for http request";
            MainWin.appendToLog("THttpRequest", "send", Thread.currentThread(), null, 4, string3);
            return string3;
        }
        try {
            Object object;
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            string = this.getMethodText() + " " + this.strURI;
            if (this.hashArgs.size() > 0) {
                string2 = "";
                Enumeration enumeration = this.hashArgs.keys();
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    object = this.hashArgs.get(k);
                    if (string2.length() > 0) {
                        string2 = string2 + "&";
                    }
                    string2 = string2 + (String)k + "=" + (String)object;
                }
                if (this.getMethod() == 1) {
                    string = string + "?" + charutil.tokenizeForPost(string2, true);
                } else {
                    this.arContent = new byte[string2.length()];
                    for (int i = 0; i < string2.length(); ++i) {
                        this.arContent[i] = (byte)string2.charAt(i);
                    }
                    this.setHeaderValue("Content-Length", Integer.toString(this.arContent.length));
                }
            }
            if (this.Debug) {
                this.outputForDebugging("Sending HTTP Request");
            }
            string = string + " " + this.strHttpVersion + "\r\n";
            dataOutputStream.writeBytes(string);
            boolean bl = false;
            Enumeration enumeration = this.hashHeaders.keys();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                Object v = this.hashHeaders.get(object);
                if (!((String)object).equalsIgnoreCase("host")) {
                    bl = true;
                }
                string = (String)object + ": " + (String)v + "\r\n";
                dataOutputStream.writeBytes(string);
            }
            if (!bl) {
                string = "Host:" + this.socket.getInetAddress().getHostName() + "\r\n";
                dataOutputStream.writeBytes(string);
            }
            dataOutputStream.writeBytes("\r\n");
            if (this.arContent != null) {
                dataOutputStream.write(this.arContent);
            }
            dataOutputStream.flush();
        }
        catch (Exception exception) {
            string3 = "Error in THttpRequest.send " + this.getMethodText() + " " + this.strURI;
            Enumeration enumeration = this.hashArgs.keys();
            while (enumeration.hasMoreElements()) {
                String string4 = charutil.tokenizeForPost((String)enumeration.nextElement(), false);
                String string5 = charutil.tokenizeForPost((String)this.hashArgs.get(string4), false);
                string3 = string3 + "&" + string4 + "=" + string5;
            }
            MainWin.appendToLog("THttpRequest", "send", Thread.currentThread(), exception, 3, string3);
            string3 = string3 + " " + exception.toString();
        }
        return string3;
    }

    public String receive() {
        String string;
        this.reset();
        try {
            String string2;
            String string3;
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            while ((string3 = this.readLine(dataInputStream)).trim().length() == 0 && dataInputStream.available() > 0) {
            }
            String[] stringArray = charutil.getSubStringArray(string3, ' ', true);
            if (stringArray == null || stringArray.length < 2) {
                String string4 = "Error in THttpRequest.receive.  Status line is invalid: [" + string3 + "] len=" + string3.length();
                return string4;
            }
            if (stringArray[0].equalsIgnoreCase("GET")) {
                this.intMethod = 1;
            }
            if (stringArray[0].equalsIgnoreCase("POST")) {
                this.intMethod = 2;
            }
            if (stringArray[0].equalsIgnoreCase("HEAD")) {
                this.intMethod = 3;
            }
            this.strURI = charutil.tokenizeForPost(stringArray[1], false);
            this.strURI = charutil.replaceAllSubstrings(this.strURI, "&amp;", "&");
            this.strURI = charutil.replaceAllSubstrings(this.strURI, "&lt;", "<");
            this.strURI = charutil.replaceAllSubstrings(this.strURI, "&gt;", ">");
            this.strURI = charutil.replaceAllSubstrings(this.strURI, "&apos;", "'");
            this.strURI = charutil.replaceAllSubstrings(this.strURI, "&quot;", "\"");
            int n = this.strURI.indexOf(63);
            if (this.intMethod == 1 && n >= 0) {
                string3 = this.strURI.substring(n + 1);
                this.strURI = this.strURI.substring(0, n);
                this.setArguments(string3);
            }
            if (stringArray.length > 2) {
                this.strHttpVersion = stringArray[2];
            }
            do {
                if ((n = (string3 = this.readLine(dataInputStream)).indexOf(58)) <= 0) continue;
                string2 = string3.substring(0, n);
                String string5 = string3.substring(n + 1);
                this.hashHeaders.put(string2.toUpperCase().trim(), string5.trim());
            } while (string3.length() > 0);
            string2 = this.hashHeaders.get("CONTENT-LENGTH");
            if (string2 != null) {
                n = charutil.ival(string2);
                this.arContent = new byte[n];
                int n2 = 0;
                do {
                    int n3 = dataInputStream.read(this.arContent, n2, n - n2);
                    n2 += n3;
                    Thread.yield();
                    if (!(Math.random() < 0.1)) continue;
                    try {
                        Thread.sleep(1L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                } while (n2 < n);
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < this.arContent.length; ++i) {
                    stringBuilder.append((char)this.arContent[i]);
                }
                string2 = this.hashHeaders.get("CONTENT-TYPE");
                if (string2 != null && string2.toUpperCase().startsWith("MULTIPART/FORM-DATA")) {
                    String string6 = "";
                    n = string2.indexOf("boundary=");
                    if (n >= 0) {
                        int n4;
                        string6 = "--" + string2.substring(n + 9);
                        ArrayList<String> arrayList = new ArrayList<String>();
                        ArrayList<StringBuilder> arrayList2 = new ArrayList<StringBuilder>();
                        ArrayList<String> arrayList3 = new ArrayList<String>();
                        String string7 = "";
                        n = 0;
                        int n5 = 0;
                        do {
                            if ((n = stringBuilder.indexOf(string6, n)) < 0) continue;
                            n5 = stringBuilder.indexOf(string6, n + 1);
                            string7 = n5 >= 0 ? stringBuilder.substring(n, n5) : stringBuilder.substring(n);
                            n4 = string7.indexOf("\r\n");
                            int n6 = string7.indexOf("\r\n", n4 + 1);
                            int n7 = string7.indexOf("\r\n", n6 + 1);
                            int n8 = string7.indexOf("\r\n\r\n") + 4;
                            if (n6 <= n4 + 2) continue;
                            String string8 = string7.substring(n4 + 2, n6);
                            String[] stringArray2 = charutil.getSubStringArray(string8, ';', true);
                            for (int i = 0; i < stringArray2.length; ++i) {
                                String[] stringArray3 = charutil.getSubStringArray(stringArray2[i], '=', true);
                                if (stringArray3.length <= 1 || !stringArray3[0].equalsIgnoreCase("name")) continue;
                                arrayList.add(stringArray3[1]);
                                if (n7 > n6 + 2) {
                                    string8 = string7.substring(n6 + 2, n7);
                                    stringArray3 = charutil.getSubStringArray(string8, ':', true);
                                    if (stringArray3.length > 1) {
                                        arrayList3.add(stringArray3[1]);
                                    } else {
                                        arrayList3.add("");
                                    }
                                } else {
                                    arrayList3.add("");
                                }
                                StringBuilder stringBuilder2 = new StringBuilder();
                                for (int j = n + n8; j < n5 - 2; ++j) {
                                    stringBuilder2.append(stringBuilder.charAt(j));
                                }
                                arrayList2.add(stringBuilder2);
                            }
                        } while ((n = n5) >= 0);
                        for (n4 = 0; n4 < arrayList.size(); ++n4) {
                            String string9 = ((String)arrayList3.get(n4)).trim();
                            String string10 = (String)arrayList.get(n4);
                            if (string9.length() == 0) {
                                string9 = "text/plain";
                            }
                            this.setArgumentContentType(string10, string9);
                            if (string9.equalsIgnoreCase("text/plain")) {
                                this.setArgumentValue(string10, ((StringBuilder)arrayList2.get(n4)).toString());
                                continue;
                            }
                            this.setArgumentValue(string10, arrayList2.get(n4));
                        }
                    }
                } else {
                    this.setArguments(stringBuilder.toString());
                }
            }
            if (this.Debug) {
                this.outputForDebugging("HTTP Request Received");
            }
            string = "Ok";
        }
        catch (Exception exception) {
            string = "Error in THttpRequest.receive:";
            string = string + " " + exception.toString();
        }
        return string;
    }

    public void outputForDebugging(String string) {
        Object object;
        Object object2;
        System.out.println("========================================");
        System.out.println(string);
        System.out.println("========================================");
        System.out.println("Socket      : " + this.socket.getClass().getName());
        System.out.println("Host        : " + this.socket.getInetAddress());
        System.out.println("Method      : " + this.getMethodText());
        System.out.println("URI         : " + this.strURI);
        System.out.println("HttpVersion : " + this.strHttpVersion);
        Enumeration enumeration = this.hashArgs.keys();
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            object = this.hashArgs.get(object2);
            System.out.println("Argument    : " + (String)object2 + "= " + (String)object);
        }
        object2 = this.hashHeaders.keys();
        while (object2.hasMoreElements()) {
            object = object2.nextElement();
            Object v = this.hashHeaders.get(object);
            System.out.println("Header      : " + (String)object + ": " + (String)v);
        }
        if (this.arContent == null) {
            System.out.println("Content     : [No content]");
        } else {
            object = new StringBuilder();
            for (int i = 0; i < this.arContent.length; ++i) {
                ((StringBuilder)object).append((char)this.arContent[i]);
            }
            System.out.println("Content     :" + object);
        }
        System.out.println("========================================");
    }
}

