/*
 * Decompiled with CFR 0.152.
 */
package utility.http;

import aspect.Aspect;
import aspect.TMainWin;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import utility.charutil;

public class THttpResponse {
    private static TMainWin MainWin = Aspect.MainWin;
    private boolean Debug = false;
    private int intResponseCode = 0;
    private String strResponseCodeText = "";
    private String strHttpVersion = "HTTP/1.0";
    private Hashtable hashHeaders = new Hashtable();
    private byte[] arContent = null;
    private Socket socket;

    public THttpResponse(Socket socket) {
        this.socket = socket;
    }

    public void setHttpVersion(String string) {
        this.strHttpVersion = string.trim();
    }

    public int getResponseCode() {
        return this.intResponseCode;
    }

    public void setResponseCode(int n) {
        this.intResponseCode = n;
    }

    public String getResponseCodeText() {
        return this.strResponseCodeText;
    }

    public void setResponseCodeText(String string) {
        this.strResponseCodeText = string;
    }

    public String getHeaderValue(String string) {
        Object v = this.hashHeaders.get(string.toUpperCase());
        if (v == null) {
            return "";
        }
        return (String)v;
    }

    public void setHeaderValue(String string, String string2) {
        Object v = this.hashHeaders.get("AHeaderName");
        if (v != null) {
            this.hashHeaders.remove(v);
        }
        this.hashHeaders.put(string.toUpperCase(), string2);
    }

    public String getHeaders() {
        StringBuilder stringBuilder = new StringBuilder();
        Enumeration enumeration = this.hashHeaders.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = this.hashHeaders.get(k);
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append((String)k + ":" + (String)v);
        }
        return stringBuilder.toString();
    }

    public byte[] getContent() {
        return this.arContent;
    }

    public int getContentLength() {
        if (this.arContent == null) {
            return 0;
        }
        return this.arContent.length;
    }

    public void setContent(byte[] byArray) {
        this.arContent = byArray;
    }

    public void reset() {
        this.strHttpVersion = "HTTP/1.0";
        this.intResponseCode = 0;
        this.strResponseCodeText = "";
        this.arContent = null;
        this.hashHeaders.clear();
    }

    public String readLine(DataInputStream dataInputStream) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            char c;
            do {
                if ((c = (char)dataInputStream.readByte()) == '\n' || c == '\r') continue;
                stringBuilder.append(c);
            } while (c != '\n' && dataInputStream.available() > 0);
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String send() {
        String string = "";
        if (this.Debug) {
            this.outputForDebugging("Sending HTTP Response");
        }
        if (this.strHttpVersion.length() == 0) {
            string = "No HTTP version specified for http response";
            MainWin.appendToLog("THttpResponse", "send", Thread.currentThread(), null, 4, string);
            return string;
        }
        if (this.intResponseCode == 0) {
            string = "Invalid reponse code in http response";
            MainWin.appendToLog("THttpResponse", "send", Thread.currentThread(), null, 4, string);
            return string;
        }
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            String string2 = this.strHttpVersion + " " + Integer.toString(this.intResponseCode) + " " + this.strResponseCodeText + "\r\n";
            dataOutputStream.writeBytes(string2);
            Enumeration enumeration = this.hashHeaders.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Object v = this.hashHeaders.get(k);
                string2 = (String)k + ": " + (String)v + "\r\n";
                dataOutputStream.writeBytes(string2);
            }
            dataOutputStream.writeBytes("\r\n");
            long l = new Date().getTime();
            if (this.arContent != null) {
                int n;
                int n2 = this.socket.getSendBufferSize();
                int n3 = this.arContent.length;
                int n4 = 0;
                do {
                    n = Math.min(n3 - n4, n2 - 4);
                    dataOutputStream.write(this.arContent, n4, n);
                } while ((n4 += n) < n3);
            }
            dataOutputStream.flush();
        }
        catch (Exception exception) {
            string = "Error in THttpResponse.send: " + exception.toString();
            MainWin.appendToLog("THttpResponse", "send", Thread.currentThread(), null, 3, string);
        }
        return string;
    }

    public String receive() {
        String string;
        this.reset();
        if (this.Debug) {
            MainWin.appendToLog("THttpResponse", "receive", Thread.currentThread(), null, 3, "Reading http response...");
        }
        try {
            int n;
            String string2;
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            while ((string2 = this.readLine(dataInputStream)).length() == 0 && dataInputStream.available() > 0) {
            }
            String[] stringArray = charutil.getSubStringArray(string2, ' ', true);
            if (stringArray == null || stringArray.length < 3) {
                String string3 = "Error in THttpResponse.receive.  Status line is invalid: " + string2;
                return string3;
            }
            this.strHttpVersion = stringArray[0];
            this.intResponseCode = charutil.ival(stringArray[1]);
            for (int i = 2; i < stringArray.length; ++i) {
                this.strResponseCodeText = this.strResponseCodeText + stringArray[i];
            }
            do {
                if ((n = (string2 = this.readLine(dataInputStream)).indexOf(58)) <= 0) continue;
                String string4 = string2.substring(0, n);
                String string5 = string2.substring(n + 1);
                this.hashHeaders.put(string4.toUpperCase().trim(), string5.trim());
            } while (string2.length() > 0);
            if (this.getResponseCode() != 302) {
                Object v = this.hashHeaders.get("CONTENT-LENGTH");
                if (v != null) {
                    int n2 = 0;
                    int n3 = charutil.ival((String)v);
                    int n4 = 0;
                    byte[] byArray = new byte[n3];
                    this.arContent = new byte[0];
                    do {
                        n = dataInputStream.read(byArray, 0, n3 - n4);
                        this.arContent = (byte[])charutil.arrayGrow(this.arContent, this.arContent.length + n);
                        System.arraycopy(byArray, 0, this.arContent, n2, n);
                        n2 += n;
                    } while (n > 0 && (n4 += n) < n3);
                } else {
                    v = this.hashHeaders.get("TRANSFER-ENCODING");
                    if (v != null && ((String)v).toUpperCase().indexOf("CHUNKED") >= 0) {
                        int n5 = 0;
                        int n6 = 0;
                        this.arContent = new byte[0];
                        do {
                            n6 = 0;
                            string2 = this.readLine(dataInputStream).trim();
                            if (string2.length() <= 0) continue;
                            try {
                                n6 = Integer.parseInt(string2.toUpperCase(), 16);
                            }
                            catch (Exception exception) {
                                MainWin.appendToLog("THttpResponse", "receive", Thread.currentThread(), null, 3, "Error reading http response.  Invalid chunk size: " + string2);
                                n6 = 0;
                            }
                            if (this.Debug) {
                                MainWin.appendToLog("THttpResponse", "receive", Thread.currentThread(), null, 3, "Chunk size (hex)=[" + string2 + "] = " + Integer.toString(n6));
                            }
                            if (n6 <= 0) continue;
                            byte[] byArray = new byte[n6];
                            int n7 = 0;
                            do {
                                n = dataInputStream.read(byArray, 0, n6 - n7);
                                this.arContent = (byte[])charutil.arrayGrow(this.arContent, this.arContent.length + n);
                                System.arraycopy(byArray, 0, this.arContent, n5, n);
                                n5 += n;
                            } while (n > 0 && (n7 += n) < n6);
                            string2 = this.readLine(dataInputStream);
                        } while (n6 > 0);
                        if (dataInputStream.available() > 0) {
                            string2 = this.readLine(dataInputStream);
                        }
                    }
                }
            }
            if (this.Debug) {
                this.outputForDebugging("Http Response Received");
            }
            string = "Ok";
        }
        catch (Exception exception) {
            string = "Error in THttpResponse.receive:";
            MainWin.appendToLog("THttpResponse", "receive", Thread.currentThread(), exception, 4, string);
            string = string + " " + exception.toString();
        }
        return string;
    }

    public void outputForDebugging(String string) {
        Object object;
        System.out.println("========================================");
        System.out.println(string);
        System.out.println("========================================");
        System.out.println("HttpVersion  : " + this.strHttpVersion);
        System.out.println("ResponseCode : " + this.intResponseCode);
        System.out.println("ResponseText : " + this.strResponseCodeText);
        Enumeration enumeration = this.hashHeaders.keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            Object v = this.hashHeaders.get(object);
            System.out.println("Header       : " + (String)object + ": " + (String)v);
        }
        if (this.arContent == null) {
            System.out.println("Content      : [No content]");
        } else {
            object = new StringBuilder();
            for (int i = 0; i < this.arContent.length; ++i) {
                ((StringBuilder)object).append((char)this.arContent[i]);
            }
            if (this.arContent.length < 256) {
                System.out.println("Content      : " + object);
            } else {
                System.out.println("Content      : " + ((StringBuilder)object).length() + "bytes");
            }
        }
        System.out.println("========================================");
    }
}

