/*
 * Decompiled with CFR 0.152.
 */
package utility.notifications;

import aspect.Aspect;
import aspect.TMainWin;
import aspect.TSystemTrayIcon;
import drivers.aspect.TDriverStructRecord;
import drivers.files.TBinaryFile;
import java.io.File;
import java.io.RandomAccessFile;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import resources.TAppDriversObject;
import resources.TApplication;
import utility.TFile;
import utility.TFormulaEvaluator;
import utility.asciifiles.TAsciiInput;
import utility.asciifiles.TAsciiOutput;
import utility.charutil;
import utility.dateutil;
import utility.dosutil;
import utility.notifications.TNotification;
import utility.security.TPasswordService;

public class TNotification_ClientSide {
    private static TMainWin MainWin = Aspect.MainWin;
    private static TApplication Application = TMainWin.Application;
    public static TBinaryFile drvClientNotification = null;
    private static boolean LogNotifications = true;
    private static TDriverStructRecord DSRecNotificationUsed = null;
    private static TDriverStructRecord DSRecNotificationID = null;
    private static TDriverStructRecord DSRecNotificationTime = null;
    private static TDriverStructRecord DSRecNotificationDelivered = null;
    private static TDriverStructRecord DSRecNotificationTo = null;
    private static TDriverStructRecord DSRecNotificationFrom = null;
    private static TDriverStructRecord DSRecNotificationToName = null;
    private static TDriverStructRecord DSRecNotificationFromName = null;
    private static TDriverStructRecord DSRecNotificationDiskIndex = null;
    private static TDriverStructRecord DSRecNotificationType = null;
    private static TDriverStructRecord DSRecNotificationData = null;
    private static TDriverStructRecord DSRecNotificationDeliveryConfirmed = null;
    private static TDriverStructRecord DSRecNotificationDeliveryTime = null;
    private static TDriverStructRecord DSRecNotificationDeliveryTimeLocal = null;
    private static TDriverStructRecord DSRecNotificationOutgoing = null;
    private static TDriverStructRecord DSRecNotificationReplyTo = null;
    private static TDriverStructRecord DSRecNotificationPostedToServer = null;
    private static TDriverStructRecord DSRecNotificationParentID = null;
    private static TDriverStructRecord DSRecNotificationParentTime = null;
    private static TDriverStructRecord DSRecNotificationEncryptedPassword = null;
    private static TDriverStructRecord DSRecNotificationTimeToLive = null;
    private static TDriverStructRecord DSRecNotificationExternalFilename = null;
    private static TDriverStructRecord DSRecNotificationAttachedFilename = null;
    private static TDriverStructRecord DSRecNotificationOriginalFilename = null;
    private static TDriverStructRecord DSRecNotificationUserExternalDataFilename = null;
    private static TDriverStructRecord DSRecNotificationServerTime = null;
    private static TDriverStructRecord DSRecNotificationServerDate = null;
    private static TDriverStructRecord DSRecNotificationIsExpired = null;
    private static TDriverStructRecord DSRecNotificationprofile_Created = null;
    private static TDriverStructRecord DSRecNotificationprofile_QueuedForSend = null;
    private static TDriverStructRecord DSRecNotificationprofile_Sent = null;
    private static TDriverStructRecord DSRecNotificationprofile_ReceiptReceived = null;
    private static TDriverStructRecord DSRecNotificationprofile_DeliveryConfirmed = null;
    private static TDriverStructRecord DSRecNotificationprofile_ResponseReceived = null;
    private static TDriverStructRecord DSRecNotificationClient_Processed = null;
    private static TDriverStructRecord DSRecNotificationLast_Attempt = null;
    private static TDriverStructRecord DSRecNotificationDelivery_Attempts = null;
    public static ArrayList arPendingNotifications = new ArrayList();

    public TNotification_ClientSide() {
        TNotification_ClientSide.openClientNotificationDriver();
    }

    public void dispose() {
        drvClientNotification.dispose();
    }

    public static void openClientNotificationDriver() {
        Comparable comparable;
        if (MainWin.isRunningOnServer()) {
            if (TMainWin.IsRestart && ((File)(comparable = new File(Application.getHomeDir() + "client_notifications.dta"))).exists()) {
                File file = new File("c:\\aspect7\\aspectlogs\\client_notifications_" + dateutil.formatDate(new Date(), "MMddyyyy_HHmmss") + ".dta");
                ((File)comparable).renameTo(file);
            }
        }
        comparable = TNotification_ClientSide.Application.AppDrivers.getAppDriversObject("GreenLight_Notification_Client");
        drvClientNotification = new TBinaryFile(Application, (TAppDriversObject)comparable, 1, false);
        try {
            drvClientNotification.makeEditableFile();
        }
        catch (Exception exception) {
            System.out.println("Error in openClientNotificationDriver: " + exception.toString());
        }
        DSRecNotificationUsed = TNotification_ClientSide.drvClientNotification.DriverStruct.getField("used");
        DSRecNotificationID = TNotification_ClientSide.drvClientNotification.DriverStruct.getField("ID");
        DSRecNotificationTime = TNotification_ClientSide.drvClientNotification.DriverStruct.getField("Time");
        DSRecNotificationDelivered = TNotification_ClientSide.drvClientNotification.DriverStruct.getField("delivered");
        DSRecNotificationTo = TNotification_ClientSide.drvClientNotification.DriverStruct.getField("to");
        DSRecNotificationFrom = TNotification_ClientSide.drvClientNotification.DriverStruct.getField("from");
        DSRecNotificationToName = TNotification_ClientSide.drvClientNotification.DriverStruct.getField("to_name");
        DSRecNotificationFromName = TNotification_ClientSide.drvClientNotification.DriverStruct.getField("from_name");
        DSRecNotificationDiskIndex = TNotification_ClientSide.drvClientNotification.DriverStruct.getField("diskindex");
        DSRecNotificationType = TNotification_ClientSide.drvClientNotification.DriverStruct.getField("type");
        DSRecNotificationData = TNotification_ClientSide.drvClientNotification.DriverStruct.getField("data");
        DSRecNotificationDeliveryConfirmed = TNotification_ClientSide.drvClientNotification.DriverStruct.getField("Delivery_Confirmed");
        DSRecNotificationDeliveryTime = TNotification_ClientSide.drvClientNotification.DriverStruct.getField("Delivery_Time");
        DSRecNotificationDeliveryTimeLocal = TNotification_ClientSide.drvClientNotification.DriverStruct.getField("Delivery_Time_Local");
        DSRecNotificationOutgoing = TNotification_ClientSide.drvClientNotification.DriverStruct.getField("IsOutgoing");
        DSRecNotificationReplyTo = TNotification_ClientSide.drvClientNotification.DriverStruct.getField("ReplyTo");
        DSRecNotificationPostedToServer = TNotification_ClientSide.drvClientNotification.DriverStruct.getField("Posted_To_Server");
        DSRecNotificationParentID = TNotification_ClientSide.drvClientNotification.DriverStruct.getField("ParentID");
        DSRecNotificationParentTime = TNotification_ClientSide.drvClientNotification.DriverStruct.getField("ParentTime");
        DSRecNotificationEncryptedPassword = TNotification_ClientSide.drvClientNotification.DriverStruct.getField("Encrypted_Password");
        DSRecNotificationTimeToLive = TNotification_ClientSide.drvClientNotification.DriverStruct.getField("Time_To_Live");
        DSRecNotificationExternalFilename = TNotification_ClientSide.drvClientNotification.DriverStruct.getField("External_Filename");
        DSRecNotificationAttachedFilename = TNotification_ClientSide.drvClientNotification.DriverStruct.getField("Attached_Filename");
        DSRecNotificationOriginalFilename = TNotification_ClientSide.drvClientNotification.DriverStruct.getField("Original_Filename");
        DSRecNotificationUserExternalDataFilename = TNotification_ClientSide.drvClientNotification.DriverStruct.getField("User_External_DataFilename");
        DSRecNotificationServerTime = TNotification_ClientSide.drvClientNotification.DriverStruct.getField("Server_Time");
        DSRecNotificationServerDate = TNotification_ClientSide.drvClientNotification.DriverStruct.getField("Server_Date");
        DSRecNotificationIsExpired = TNotification_ClientSide.drvClientNotification.DriverStruct.getField("isExpired");
        DSRecNotificationprofile_Created = TNotification_ClientSide.drvClientNotification.DriverStruct.getField("profile_Created");
        DSRecNotificationprofile_QueuedForSend = TNotification_ClientSide.drvClientNotification.DriverStruct.getField("profile_QueuedForSend");
        DSRecNotificationprofile_Sent = TNotification_ClientSide.drvClientNotification.DriverStruct.getField("profile_Sent");
        DSRecNotificationprofile_ReceiptReceived = TNotification_ClientSide.drvClientNotification.DriverStruct.getField("profile_ReceiptReceived");
        DSRecNotificationprofile_DeliveryConfirmed = TNotification_ClientSide.drvClientNotification.DriverStruct.getField("profile_DeliveryConfirmed");
        DSRecNotificationprofile_ResponseReceived = TNotification_ClientSide.drvClientNotification.DriverStruct.getField("profile_ResponseReceived");
        DSRecNotificationClient_Processed = TNotification_ClientSide.drvClientNotification.DriverStruct.getField("Client_Processed");
        DSRecNotificationLast_Attempt = TNotification_ClientSide.drvClientNotification.DriverStruct.getField("Last_Attempt");
        DSRecNotificationDelivery_Attempts = TNotification_ClientSide.drvClientNotification.DriverStruct.getField("Delivery_Attempts");
        int n = drvClientNotification.getRecordCount();
        for (int i = 0; i < n; ++i) {
            boolean bl = (Boolean)drvClientNotification.getField(DSRecNotificationUsed, i);
            boolean bl2 = (Boolean)drvClientNotification.getField(DSRecNotificationPostedToServer, i);
            boolean bl3 = (Boolean)drvClientNotification.getField(DSRecNotificationOutgoing, i);
            if (!bl || !bl3 || bl2) continue;
            String string = (String)drvClientNotification.getField(DSRecNotificationID, i);
            Date date = (Date)drvClientNotification.getField(DSRecNotificationTime, i);
            String string2 = (String)drvClientNotification.getField(DSRecNotificationTo, i);
            String string3 = (String)drvClientNotification.getField(DSRecNotificationFrom, i);
            int n2 = (Integer)drvClientNotification.getField(DSRecNotificationType, i);
            String string4 = (String)drvClientNotification.getField(DSRecNotificationData, i);
            String string5 = (String)drvClientNotification.getField(DSRecNotificationReplyTo, i);
            String string6 = (String)drvClientNotification.getField(DSRecNotificationParentID, i);
            String string7 = (String)drvClientNotification.getField(DSRecNotificationEncryptedPassword, i);
            int n3 = (Integer)drvClientNotification.getField(DSRecNotificationTimeToLive, i);
            Date date2 = (Date)drvClientNotification.getField(DSRecNotificationServerTime, i);
            TNotification tNotification = new TNotification(string, string3, string2, n2, string4, i, string5, string6, date, string7, n3);
            tNotification.Server_Time = date2;
            if (tNotification.isExpired()) continue;
            tNotification.ExternalFilename = (String)drvClientNotification.getField(DSRecNotificationExternalFilename, i);
            String string8 = (String)drvClientNotification.getField(DSRecNotificationAttachedFilename, i);
            if (string8.trim().length() > 0) {
                tNotification.AttachedFilename = string8;
                tNotification.OriginalFilename = (String)drvClientNotification.getField(DSRecNotificationOriginalFilename, i);
            }
            tNotification.UserExternalDataFilename = (String)drvClientNotification.getField(DSRecNotificationUserExternalDataFilename, i);
            arPendingNotifications.add(tNotification);
            MainWin.appendToLog("TNotification_ClientSide", "openClientNotificationDriver", Thread.currentThread(), null, 3, "Notification Client: Read pending notification: " + tNotification.toString());
        }
    }

    public static TNotification sendNotification(String string, int n, String string2, int n2) {
        return TNotification_ClientSide.sendNotification(string, n, string2, "", n2, "", "");
    }

    public static TNotification sendNotification(String string, int n, String string2, String string3, int n2, String string4, String string5) {
        return TNotification_ClientSide.sendNotification(string, n, string2, string3, n2, string4, string5, "");
    }

    public static TNotification sendNotification(String string, int n, String string2, String string3, int n2, String string4, String string5, String string6) {
        String string7 = string;
        if (string7.equalsIgnoreCase("Development")) {
            string7 = Application.getTokenValue("AspectDevelopmentNotificationID");
        }
        TNotification tNotification = new TNotification(TPasswordService.generateSalt(16), Application.getAspectHashID(), string7, n, string2, -1, "", string3, new Date(), TNotification.encryptPassword(), n2);
        tNotification.setUserExternalDataFilename(string6);
        if (string4.trim().length() > 0) {
            tNotification.setAttachedFilename(string4);
            tNotification.OriginalFilename = string5;
        }
        return TNotification_ClientSide.sendNotification(tNotification);
    }

    public static TNotification sendNotification(TNotification tNotification) {
        if (drvClientNotification == null) {
            TNotification_ClientSide.openClientNotificationDriver();
        }
        if (tNotification.Type != TNotification.NOTIFICATION_PING) {
            if (tNotification.Data.length() >= 1024) {
                tNotification.ExternalFilename = Application.getHomeDir() + "greenlight/notifications/" + TPasswordService.generateSalt(16) + ".$$$";
                TAsciiOutput.writeContent(tNotification.ExternalFilename, tNotification.Data);
            }
            int n = drvClientNotification.initializeNewRecord(true);
            drvClientNotification.putField(DSRecNotificationTime, n, (Object)tNotification.Time);
            drvClientNotification.putField(DSRecNotificationID, n, (Object)tNotification.ID);
            drvClientNotification.putField(DSRecNotificationFrom, n, (Object)tNotification.From);
            drvClientNotification.putField(DSRecNotificationTo, n, (Object)tNotification.To);
            drvClientNotification.putField(DSRecNotificationFromName, n, (Object)tNotification.FromName);
            drvClientNotification.putField(DSRecNotificationToName, n, (Object)tNotification.ToName);
            drvClientNotification.putField(DSRecNotificationType, n, (Object)tNotification.Type);
            drvClientNotification.putField(DSRecNotificationData, n, (Object)tNotification.Data.toString());
            drvClientNotification.putField(DSRecNotificationParentID, n, (Object)tNotification.ParentID);
            drvClientNotification.putField(DSRecNotificationOutgoing, n, (Object)Boolean.TRUE);
            drvClientNotification.putField(DSRecNotificationTimeToLive, n, (Object)tNotification.TimeToLive);
            drvClientNotification.putField(DSRecNotificationExternalFilename, n, (Object)tNotification.ExternalFilename);
            drvClientNotification.putField(DSRecNotificationAttachedFilename, n, (Object)tNotification.AttachedFilename);
            drvClientNotification.putField(DSRecNotificationOriginalFilename, n, (Object)(dosutil.getFileName(tNotification.OriginalFilename) + dosutil.getFileExt(tNotification.OriginalFilename)));
            drvClientNotification.putField(DSRecNotificationUserExternalDataFilename, n, (Object)tNotification.UserExternalDataFilename);
            drvClientNotification.putField(DSRecNotificationprofile_QueuedForSend, n, (Object)new Date());
            if (tNotification.ParentID.length() > 0) {
                int n2 = drvClientNotification.getMatchingRecord("ID=\"" + tNotification.ParentID + "\"", 0);
                if (n2 >= 0) {
                    drvClientNotification.putField(DSRecNotificationParentTime, n, drvClientNotification.getField(DSRecNotificationTime, n2));
                }
            } else {
                drvClientNotification.putField(DSRecNotificationParentTime, n, (Object)tNotification.Time);
            }
            if (tNotification.From.equalsIgnoreCase(tNotification.To)) {
                drvClientNotification.putField(DSRecNotificationDeliveryConfirmed, n, (Object)Boolean.TRUE);
                Date date = new Date();
                drvClientNotification.putField(DSRecNotificationDeliveryTime, n, (Object)date);
                drvClientNotification.putField(DSRecNotificationDeliveryTimeLocal, n, (Object)date);
            }
            drvClientNotification.clearWriteBuffer();
            TNotification_ClientSide.setModifiedToken();
            tNotification.DiskIndex = n;
        }
        arPendingNotifications.add(tNotification);
        return tNotification;
    }

    public void recordTimeSent(TNotification tNotification) {
        int n = drvClientNotification.getMatchingRecord("ID=\"" + tNotification.ID + "\"", 0);
        if (n >= 0) {
            drvClientNotification.putField(DSRecNotificationprofile_Sent, n, (Object)new Date());
            drvClientNotification.putField(DSRecNotificationLast_Attempt, n, (Object)tNotification.dtLastAttempt);
            drvClientNotification.putField(DSRecNotificationDelivery_Attempts, n, (Object)new Integer(tNotification.Attempts));
        } else {
            MainWin.appendToLog("TNotification_ClientSide", "recordTimeSent", Thread.currentThread(), null, 3, "Notification Client: Could not locate notification to record time sent: " + tNotification.ID);
        }
    }

    public void recordTimeResponseReceived(String string) {
        int n = drvClientNotification.getMatchingRecord("ID=\"" + string + "\"", 0);
        if (n >= 0) {
            drvClientNotification.putField(DSRecNotificationprofile_ResponseReceived, n, (Object)new Date());
        } else {
            MainWin.appendToLog("TNotification_ClientSide", "recordTimeResponseReceived", Thread.currentThread(), null, 3, "Notification Client: Could not locate notification to record time response received: " + string);
        }
    }

    public void removeNotification(TNotification tNotification, int n) {
        if (tNotification.DiskIndex >= 0) {
            drvClientNotification.putField(DSRecNotificationPostedToServer, tNotification.DiskIndex, (Object)Boolean.TRUE);
            drvClientNotification.putField(DSRecNotificationprofile_ReceiptReceived, tNotification.DiskIndex, (Object)new Date());
            drvClientNotification.clearWriteBuffer();
            if (tNotification.isDiagnostic()) {
                MainWin.appendToLog("TNotification_ClientSide", "addNotification", Thread.currentThread(), null, 3, "Notification Client+: Removed from queue: " + tNotification.ID);
            }
        }
        arPendingNotifications.remove(n);
    }

    public TNotification addNotification(String string) {
        TNotification tNotification = new TNotification(string);
        return this.addNotification(tNotification);
    }

    public TNotification addNotification(TNotification tNotification) {
        if (tNotification.Type == TNotification.NOTIFICATION_SERVER_RECEIPT) {
            for (int i = 0; i < arPendingNotifications.size(); ++i) {
                TNotification tNotification2 = (TNotification)arPendingNotifications.get(i);
                if (!tNotification2.ID.equalsIgnoreCase(tNotification.ID)) continue;
                if (tNotification2.DiskIndex >= 0) {
                    drvClientNotification.putField(DSRecNotificationPostedToServer, tNotification2.DiskIndex, (Object)Boolean.TRUE);
                    drvClientNotification.putField(DSRecNotificationprofile_ReceiptReceived, tNotification2.DiskIndex, (Object)new Date());
                    drvClientNotification.clearWriteBuffer();
                    if (LogNotifications) {
                        // empty if block
                    }
                    if (tNotification.isDiagnostic()) {
                        MainWin.appendToLog("TNotification_ClientSide", "addNotification", Thread.currentThread(), null, 3, "Notification Client+: Removed from queue: " + tNotification2.ID);
                    }
                }
                arPendingNotifications.remove(i);
                return null;
            }
            TNotification_ClientSide.setModifiedToken();
            MainWin.appendToLog("TNotification_ClientSide", "addNotification", Thread.currentThread(), null, 3, "Notification Client: Could not find object to record server receipt: " + tNotification.toString());
            return null;
        }
        if (tNotification.IsValid) {
            if (tNotification.Type == TNotification.NOTIFICATION_GET_RECIPIENT_LIST) {
                MainWin.appendToLog("TNotification_ClientSide", "addNotification", Thread.currentThread(), null, 3, "Notification Client: Recipient list. " + tNotification.Data);
                int n = drvClientNotification.getMatchingRecord("ID=\"" + tNotification.ID + "\"", 0);
                if (n >= 0) {
                    drvClientNotification.putField(DSRecNotificationData, n, (Object)tNotification.Data);
                    drvClientNotification.putField(DSRecNotificationPostedToServer, n, (Object)true);
                }
                String string = Application.getHomeDir() + "recipient_list.csv";
                try {
                    TFile tFile = new TFile(string);
                    tFile.validatePathToFile(true);
                    if (tFile.exists()) {
                        tFile.delete();
                    }
                    RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rwd");
                    randomAccessFile.writeBytes(charutil.replaceAllSubstrings(tNotification.Data, "\t", "\r\n"));
                    randomAccessFile.close();
                }
                catch (Exception exception) {
                    System.out.println("Error writing recipient list to " + string + " " + exception.toString());
                }
                return tNotification;
            }
            if (tNotification.Data.toUpperCase().indexOf("RESTARTED NOTIFICATION SERVER") >= 0 || tNotification.Data.toUpperCase().indexOf("RESTARTED SOCKET QUEUE") >= 0) {
                return tNotification;
            }
            if (tNotification.Type == TNotification.NOTIFICATION_DELIVERY_CONFIRMED) {
                int n;
                int n2 = drvClientNotification.getMatchingRecord("ID=\"" + tNotification.ID + "\"", 0);
                if (n2 >= 0) {
                    drvClientNotification.putField(DSRecNotificationDeliveryConfirmed, n2, (Object)Boolean.TRUE);
                    drvClientNotification.putField(DSRecNotificationDeliveryTime, n2, (Object)dateutil.parseDate(tNotification.Data, "MMddyyyy HHmmss"));
                    drvClientNotification.putField(DSRecNotificationDeliveryTimeLocal, n2, (Object)new Date());
                    drvClientNotification.putField(DSRecNotificationprofile_DeliveryConfirmed, n2, (Object)new Date());
                    if (tNotification.ParentID.length() > 0) {
                        drvClientNotification.putField(DSRecNotificationprofile_ResponseReceived, n2, (Object)new Date());
                    }
                    drvClientNotification.putField(DSRecNotificationPostedToServer, n2, (Object)Boolean.TRUE);
                    if (tNotification.ParentID.length() > 0 && !tNotification.ParentID.equalsIgnoreCase(tNotification.ID) && (n = drvClientNotification.getMatchingRecord("ID=\"" + tNotification.ParentID + "\"", 0)) >= 0) {
                        drvClientNotification.putField(DSRecNotificationParentTime, n2, drvClientNotification.getField(DSRecNotificationTime, n));
                    }
                    drvClientNotification.clearWriteBuffer();
                }
                TNotification_ClientSide.setModifiedToken();
                for (n = 0; n < arPendingNotifications.size(); ++n) {
                    TNotification tNotification3 = (TNotification)arPendingNotifications.get(n);
                    if (!tNotification3.ID.equalsIgnoreCase(tNotification.ID) || tNotification3.DiskIndex < 0) continue;
                    arPendingNotifications.remove(n);
                }
            } else {
                int n;
                Object object;
                int n3 = drvClientNotification.getMatchingRecord("ID=\"" + tNotification.ID + "\"", 0);
                if (n3 < 0) {
                    n3 = drvClientNotification.initializeNewRecord(true);
                    String string = tNotification.Data;
                    if (tNotification.Data.length() >= 1024) {
                        tNotification.ExternalFilename = Application.getHomeDir() + "greenlight/notifications/" + TPasswordService.generateSalt(16) + ".$$$";
                        TAsciiOutput.writeContent(tNotification.ExternalFilename, tNotification.Data);
                        object = charutil.getParamValue(tNotification.Data, "Subject", '&');
                        string = ((String)object).length() > 0 ? "Subject=" + (String)object : tNotification.Data.substring(0, Math.min(128, tNotification.Data.length()));
                        if (LogNotifications) {
                            MainWin.appendToLog("TNotification_ClientSide", "addNotification", Thread.currentThread(), null, 3, "Notification Client: Saved notification to file: " + tNotification.ID + " Filename=" + tNotification.ExternalFilename);
                        }
                    }
                    drvClientNotification.putField(DSRecNotificationID, n3, (Object)tNotification.ID);
                    drvClientNotification.putField(DSRecNotificationTime, n3, (Object)tNotification.Time);
                    drvClientNotification.putField(DSRecNotificationServerTime, n3, (Object)tNotification.Server_Time);
                    drvClientNotification.putField(DSRecNotificationFrom, n3, (Object)tNotification.From);
                    drvClientNotification.putField(DSRecNotificationTo, n3, (Object)tNotification.To);
                    drvClientNotification.putField(DSRecNotificationFromName, n3, (Object)tNotification.FromName);
                    drvClientNotification.putField(DSRecNotificationToName, n3, (Object)tNotification.ToName);
                    drvClientNotification.putField(DSRecNotificationType, n3, (Object)tNotification.Type);
                    drvClientNotification.putField(DSRecNotificationData, n3, (Object)string);
                    drvClientNotification.putField(DSRecNotificationOutgoing, n3, (Object)Boolean.FALSE);
                    drvClientNotification.putField(DSRecNotificationReplyTo, n3, (Object)tNotification.ReplyTo);
                    drvClientNotification.putField(DSRecNotificationParentID, n3, (Object)tNotification.ParentID);
                    drvClientNotification.putField(DSRecNotificationParentTime, n3, (Object)tNotification.Time);
                    drvClientNotification.putField(DSRecNotificationExternalFilename, n3, (Object)tNotification.ExternalFilename);
                    drvClientNotification.putField(DSRecNotificationAttachedFilename, n3, (Object)tNotification.AttachedFilename);
                    drvClientNotification.putField(DSRecNotificationOriginalFilename, n3, (Object)tNotification.OriginalFilename);
                    if (TNotification.DebugNotifications) {
                        MainWin.appendToLog("TNotification_ClientSide", "addNotification", Thread.currentThread(), null, 3, "Notification Client: Saved notification to file: " + tNotification.ID);
                    }
                    object = tNotification;
                    Thread thread = new Thread((TNotification)object){
                        final /* synthetic */ TNotification val$finalNotification;
                        {
                            this.val$finalNotification = tNotification;
                        }

                        @Override
                        public void run() {
                            if (TNotification.DebugNotifications) {
                                MainWin.appendToLog("TNotification_ClientSide", "addNotification", Thread.currentThread(), null, 3, "Notification Client: Calling processNotification() for ID=" + this.val$finalNotification.ID);
                            }
                            this.val$finalNotification.processNotification();
                        }
                    };
                    thread.setName("ProcessNotification1");
                    thread.setPriority(1);
                    try {
                        TFormulaEvaluator.waitForThreadCount();
                        thread.start();
                    }
                    catch (Exception exception) {
                        MainWin.appendToLog("TNotification_ClientSide", "addNotification", Thread.currentThread(), exception, 4, "Notification Client: Could not start thread to process notification.");
                    }
                } else {
                    drvClientNotification.putField(DSRecNotificationAttachedFilename, n3, (Object)tNotification.AttachedFilename);
                    drvClientNotification.putField(DSRecNotificationOriginalFilename, n3, (Object)tNotification.OriginalFilename);
                    boolean bl = (Boolean)drvClientNotification.getField(DSRecNotificationClient_Processed, n3);
                    if (!bl) {
                        drvClientNotification.putField(DSRecNotificationClient_Processed, n3, (Object)true);
                        object = tNotification;
                        if (TNotification.DebugNotifications) {
                            MainWin.appendToLog("TNotification_ClientSide", "addNotification", Thread.currentThread(), null, 3, "Notification Client: Creating thread to process notification for ID=" + ((TNotification)object).ID);
                        }
                        Thread thread = new Thread((TNotification)object){
                            final /* synthetic */ TNotification val$finalNotification;
                            {
                                this.val$finalNotification = tNotification;
                            }

                            @Override
                            public void run() {
                                if (TNotification.DebugNotifications) {
                                    MainWin.appendToLog("TNotification_ClientSide", "addNotification", Thread.currentThread(), null, 3, "Notification Client: Calling processNotification for ID=" + this.val$finalNotification.ID);
                                }
                                this.val$finalNotification.processNotification();
                                if (TNotification.DebugNotifications) {
                                    MainWin.appendToLog("TNotification_ClientSide", "addNotification", Thread.currentThread(), null, 3, "Notification Client: Finished processNotification for ID=" + this.val$finalNotification.ID);
                                }
                            }
                        };
                        thread.setName("ProcessNotification2");
                        thread.setPriority(1);
                        try {
                            thread.start();
                        }
                        catch (Exception exception) {
                            MainWin.appendToLog("TNotification_ClientSide", "addNotification", Thread.currentThread(), exception, 4, "Notification Client: Could not start thread to process notification.");
                        }
                    }
                }
                if (tNotification.ParentID.length() > 0 && (n = drvClientNotification.getMatchingRecord("ID=\"" + tNotification.ParentID + "\"", 0)) >= 0) {
                    drvClientNotification.putField(DSRecNotificationParentTime, n3, drvClientNotification.getField(DSRecNotificationTime, n));
                    drvClientNotification.putField(DSRecNotificationParentTime, n3, drvClientNotification.getField(DSRecNotificationTime, n));
                    object = (String)drvClientNotification.getField(DSRecNotificationUserExternalDataFilename, n);
                    if (((String)object).trim().length() > 0) {
                        if (tNotification.ExternalFilename.trim().length() > 0) {
                            dosutil.copyFile(tNotification.ExternalFilename, (String)object, false);
                        } else {
                            TAsciiOutput.writeContent((String)object, tNotification.Data);
                        }
                    }
                }
                drvClientNotification.clearWriteBuffer();
                TNotification_ClientSide.setModifiedToken();
                String string = charutil.getParamValue(tNotification.Data, "balloon", '&');
                if (charutil.boolval(string)) {
                    object = charutil.getParamValue(tNotification.Data, "text", '&');
                    TSystemTrayIcon.showBalloon("", (String)object, "");
                }
            }
            return tNotification;
        }
        MainWin.appendToLog("TNotification_ClientSide", "addNotification", Thread.currentThread(), null, 3, "Notification Client: Ignored invalid notification.");
        return null;
    }

    public void outputProfileInfo(String string) {
        int n = drvClientNotification.getMatchingRecord("ID=\"" + string + "\"", 0);
        if (n >= 0) {
            Date date = (Date)drvClientNotification.getField(DSRecNotificationprofile_Created, n);
            Date date2 = (Date)drvClientNotification.getField(DSRecNotificationprofile_QueuedForSend, n);
            Date date3 = (Date)drvClientNotification.getField(DSRecNotificationprofile_Sent, n);
            Date date4 = (Date)drvClientNotification.getField(DSRecNotificationprofile_ReceiptReceived, n);
            Date date5 = (Date)drvClientNotification.getField(DSRecNotificationprofile_DeliveryConfirmed, n);
            Date date6 = (Date)drvClientNotification.getField(DSRecNotificationprofile_ResponseReceived, n);
            DateFormat dateFormat = DateFormat.getInstance();
            ((SimpleDateFormat)dateFormat).applyPattern("HH:mm:ss:SSS");
            int n2 = (int)(date6.getTime() - date.getTime());
            int n3 = (int)(date2.getTime() - date.getTime());
            int n4 = (int)(date3.getTime() - date2.getTime());
            int n5 = (int)(date4.getTime() - date3.getTime());
            int n6 = (int)(date5.getTime() - date4.getTime());
            int n7 = (int)(date6.getTime() - date5.getTime());
            String string2 = "============================================================\n";
            string2 = string2 + "Profile Notification ID: " + string + "\n";
            string2 = string2 + "============================================================\n";
            string2 = string2 + "Created \t" + dateFormat.format(date) + "\n";
            string2 = string2 + "Queued  \t" + dateFormat.format(date2) + "\t" + n3 + "\t" + charutil.formatNumber((float)n3 / (float)n2, "#.##%") + "\n";
            string2 = string2 + "Sent    \t" + dateFormat.format(date3) + "\t" + n4 + "\t" + charutil.formatNumber((float)n4 / (float)n2, "#.##%") + "\n";
            string2 = string2 + "Receipt \t" + dateFormat.format(date4) + "\t" + n5 + "\t" + charutil.formatNumber((float)n5 / (float)n2, "#.##%") + "\n";
            string2 = string2 + "Delivery\t" + dateFormat.format(date5) + "\t" + n6 + "\t" + charutil.formatNumber((float)n6 / (float)n2, "#.##%") + "\n";
            string2 = string2 + "Response\t" + dateFormat.format(date6) + "\t" + n7 + "\t" + charutil.formatNumber((float)n7 / (float)n2, "#.##%") + "\n";
            string2 = string2 + "        \t            \t" + n2;
            System.out.println(string2);
        } else {
            MainWin.appendToLog("TNotification_ClientSide", "outputProfileInfo", Thread.currentThread(), null, 3, "Notification Client: Cannot locate notification to output profile info: " + string);
        }
    }

    public String getNotificationContent(String string) {
        int n = drvClientNotification.getRecordCount();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)drvClientNotification.getField(DSRecNotificationParentID, i);
            if (!string2.equalsIgnoreCase(string)) continue;
            String string3 = (String)drvClientNotification.getField(DSRecNotificationExternalFilename, i);
            if (string3.length() > 0) {
                return TAsciiInput.getContent(string3);
            }
            return (String)drvClientNotification.getField(DSRecNotificationData, i);
        }
        return null;
    }

    public static void setModifiedToken() {
        Application.setTokenValue("ClientNotificationModified", dateutil.formatDate(new Date(), "HH:mm:ss:SSS"));
    }

    public int deleteNotification(String string) {
        Object object;
        int n;
        int n2 = 0;
        int n3 = drvClientNotification.getRecordCount();
        for (n = 0; n < n3; ++n) {
            object = (String)drvClientNotification.getField(DSRecNotificationID, n);
            String string2 = (String)drvClientNotification.getField(DSRecNotificationParentID, n);
            if (!((String)object).equalsIgnoreCase(string) && !string2.equalsIgnoreCase(string)) continue;
            drvClientNotification.putField(DSRecNotificationUsed, n, (Object)Boolean.FALSE);
            ++n2;
        }
        drvClientNotification.clearWriteBuffer();
        TNotification_ClientSide.setModifiedToken();
        n = 0;
        while (n < arPendingNotifications.size()) {
            object = (TNotification)arPendingNotifications.get(n);
            if (((TNotification)object).ID.equalsIgnoreCase(string) || ((TNotification)object).ParentID.equalsIgnoreCase(string)) {
                arPendingNotifications.remove(n);
                continue;
            }
            ++n;
        }
        return n2;
    }

    public int archiveNotifications() {
        int n = 0;
        long l = new Date().getTime();
        ArrayList<Date> arrayList = new ArrayList<Date>();
        int n2 = drvClientNotification.getRecordCount();
        for (int i = 0; i < n2; ++i) {
            Date date;
            if (!((Boolean)drvClientNotification.getField(DSRecNotificationUsed, i)).booleanValue() || arrayList.contains(date = (Date)drvClientNotification.getField(DSRecNotificationServerDate, i))) continue;
            arrayList.add(date);
        }
        TAppDriversObject tAppDriversObject = TNotification_ClientSide.Application.AppDrivers.getAppDriversObject("GreenLight_Notification_By_Filename");
        for (int i = 0; i < arrayList.size(); ++i) {
            Date date = (Date)arrayList.get(i);
            TAppDriversObject tAppDriversObject2 = new TAppDriversObject(tAppDriversObject);
            tAppDriversObject2.FileName.setLength(0);
            tAppDriversObject2.FileName.append(Application.getHomeDir() + "Greenlight/notifications/archive/client/client_notifications_" + dateutil.formatDate(date, "MMddyyyy") + ".dta");
            TBinaryFile tBinaryFile = new TBinaryFile(Application, tAppDriversObject2, 1, false);
            try {
                tBinaryFile.makeEditableFile();
                for (int j = 0; j < n2; ++j) {
                    if (!((Boolean)drvClientNotification.getField(DSRecNotificationUsed, j)).booleanValue() || ((Date)drvClientNotification.getField(DSRecNotificationServerDate, j)).getTime() != date.getTime() || !((Boolean)drvClientNotification.getField(DSRecNotificationDelivered, j)).booleanValue() && !((Boolean)drvClientNotification.getField(DSRecNotificationIsExpired, j)).booleanValue() && ((Boolean)drvClientNotification.getField(DSRecNotificationOutgoing, j)).booleanValue()) continue;
                    byte[] byArray = drvClientNotification.getRecord(j);
                    tBinaryFile.putRecord(tBinaryFile.initializeNewRecord(false), byArray);
                    drvClientNotification.putField(DSRecNotificationUsed, j, (Object)Boolean.FALSE);
                    ++n;
                }
                tBinaryFile.dispose();
                continue;
            }
            catch (Exception exception) {
                MainWin.appendToLog("TNofification_ClientSide", "archiveNotifications", Thread.currentThread(), null, 3, "Notification Client: Error archiving notifications: " + exception.toString());
            }
        }
        drvClientNotification.clearBuffer();
        arrayList.clear();
        return n;
    }
}

