/*
 * Decompiled with CFR 0.152.
 */
package utility.security;

import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverStructRecord;
import java.util.ArrayList;
import java.util.Collections;
import utility.security.TPasswordService;

public class TUserAuthenticator {
    private static TUserAuthenticator instance = null;
    private static ArrayList arUser = null;
    private static TAspectDriver FUser = null;
    private static TDriverStructRecord DSRecUser_Name = null;
    private static TDriverStructRecord DSRecPassword = null;
    private static TDriverStructRecord DSRecSalt = null;
    private static TDriverStructRecord DSRecPassword_Group = null;
    private static TDriverStructRecord DSRecPassword_Level = null;
    private static TDriverStructRecord DSRecApproved_Access_Point = null;
    private TUser LastUser = null;

    public TUserAuthenticator() {
        arUser = new ArrayList();
        FUser = new TAspectDriver("Aspect_Security_User", 1, true, false, "");
        FUser.setActiveFilter("true", true);
        DSRecUser_Name = FUser.getDriverStructRecord("User_Name");
        DSRecPassword = FUser.getDriverStructRecord("Password");
        DSRecSalt = FUser.getDriverStructRecord("Salt");
        DSRecPassword_Group = FUser.getDriverStructRecord("Password_Group");
        DSRecPassword_Level = FUser.getDriverStructRecord("Password_Level");
        DSRecApproved_Access_Point = FUser.getDriverStructRecord("Approved_Access_Point");
    }

    public void reset() {
        FUser.clearBuffer();
        arUser.clear();
        this.LastUser = null;
    }

    public static void clearCache() {
        TUserAuthenticator.getInstance().reset();
    }

    public static TUserAuthenticator getInstance() {
        if (instance == null) {
            instance = new TUserAuthenticator();
        }
        return instance;
    }

    public TUser findUser(String string, String string2, String string3) {
        String string4;
        int n = -1;
        if (this.LastUser != null) {
            string4 = TPasswordService.encrypt(string3, this.LastUser.Salt, 1000);
            if (this.LastUser.User_Name.equalsIgnoreCase(string2) && this.LastUser.Password.equalsIgnoreCase(string4) && (this.LastUser.Password_Group.equalsIgnoreCase("all") || this.LastUser.Password_Group.equalsIgnoreCase(string))) {
                return this.LastUser;
            }
        }
        try {
            n = Collections.binarySearch(arUser, new TUser(string, string2, string3));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n >= 0) {
            this.LastUser = (TUser)arUser.get(n);
            return this.LastUser;
        }
        int n2 = FUser.getRecordCount();
        for (int i = 0; i < n2; ++i) {
            int n3;
            String string5 = (String)FUser.getField(DSRecUser_Name, i);
            String string6 = (String)FUser.getField(DSRecPassword, i);
            String string7 = (String)FUser.getField(DSRecSalt, i);
            String string8 = (String)FUser.getField(DSRecPassword_Group, i);
            if (!string5.equalsIgnoreCase(string2) || !string6.equalsIgnoreCase(string4 = TPasswordService.encrypt(string3, string7, 1000)) || !string8.equalsIgnoreCase("all") && !string8.equalsIgnoreCase(string)) continue;
            int n4 = (Integer)FUser.getField(DSRecPassword_Level, i);
            TUser tUser = new TUser(string8, string5, string6, string7, n4, n3 = ((Integer)FUser.getField(DSRecApproved_Access_Point, i)).intValue());
            n = Collections.binarySearch(arUser, tUser);
            if (n < 0) {
                arUser.add(Math.abs(n + 1), tUser);
            }
            this.LastUser = tUser;
            return tUser;
        }
        return null;
    }

    public int getPasswordLevel(String string, String string2, String string3) {
        TUser tUser = this.findUser(string, string2, string3);
        if (tUser == null) {
            return -1;
        }
        return tUser.Password_Level;
    }

    public int getApprovedAccessPoint(String string, String string2, String string3) {
        TUser tUser = this.findUser(string, string2, string3);
        if (tUser == null) {
            return -1;
        }
        return tUser.Approved_Access_Point;
    }

    private class TUser
    implements Comparable {
        String User_Name = "";
        String Password = "";
        String Salt = "";
        String Password_Group = "";
        int Password_Level = 0;
        int Approved_Access_Point = 0;

        public TUser(String string, String string2, String string3) {
            this.Password_Group = string;
            this.User_Name = string2;
            this.Password = string3;
        }

        public TUser(String string, String string2, String string3, String string4, int n, int n2) {
            this.User_Name = string2;
            this.Password = string3;
            this.Salt = string4;
            this.Password_Group = string;
            this.Password_Level = n;
            this.Approved_Access_Point = n2;
        }

        public int compareTo(Object object) {
            int n;
            if (!this.Password_Group.equalsIgnoreCase("all") && (n = this.Password_Group.compareToIgnoreCase(((TUser)object).Password_Group)) != 0) {
                return n;
            }
            n = this.User_Name.compareToIgnoreCase(((TUser)object).User_Name);
            if (n != 0) {
                return n;
            }
            if (((TUser)object).Salt.length() == 0) {
                String string = TPasswordService.encrypt(((TUser)object).Password, this.Salt, 1000);
                n = this.Password.compareToIgnoreCase(string);
            } else if (this.Salt.length() == 0) {
                String string = TPasswordService.encrypt(this.Password, ((TUser)object).Salt, 1000);
                n = string.compareToIgnoreCase(((TUser)object).Password);
            } else {
                n = this.Password.compareToIgnoreCase(((TUser)object).Password);
            }
            return n;
        }
    }
}

