/*
 * Decompiled with CFR 0.152.
 */
package utility.sql;

import aspect.Aspect;
import aspect.TMainWin;
import drivers.aspect.TAspectDriver;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import utility.TFormulaEvaluator;
import utility.charutil;
import utility.netutil;
import utility.sql.TSqlField;
import utility.sql.TSqlTable;

public class TSqlDatabase {
    private static TMainWin MainWin = Aspect.MainWin;
    String dbName = "";
    int dbType = -1;
    String dbUser = "";
    String dbPass = "";
    String dbOverrideUrl = null;
    String dbEng = "";
    String dbDriver = "";
    String dbLog = "";
    String dbCred = "";
    String dbHost = "";
    String dbPort = "";
    String dbFilename = "";
    boolean IsValid = false;
    Date dtConnect = null;
    Connection connection = null;
    String ConnectMsg = "Undefined";
    private static Hashtable hashDatabaseExists = new Hashtable();

    public TSqlDatabase(String string, int n, String string2, String string3) {
        this.dbName = string;
        this.dbType = n;
        this.dbUser = string2;
        this.dbPass = string3;
        this.IsValid = this.initClass();
        if (this.IsValid) {
            this.IsValid = this.connect();
        }
    }

    public TSqlDatabase(String string, int n, String string2, String string3, String string4) {
        this.dbName = string;
        this.dbType = n;
        this.dbUser = string2;
        this.dbPass = string3;
        this.dbOverrideUrl = string4;
        this.IsValid = this.initClass();
        if (this.IsValid) {
            this.IsValid = this.connect();
        }
    }

    public TSqlDatabase(String string, String string2, String string3, int n, String string4, String string5, String string6) {
        this.dbHost = string;
        this.dbPort = string2;
        this.dbName = string3;
        this.dbType = n;
        this.dbUser = string4;
        this.dbPass = string5;
        this.dbOverrideUrl = string6;
        this.IsValid = this.initClass();
        if (this.IsValid) {
            this.IsValid = this.connect();
        }
    }

    public TSqlDatabase(int n, String string) {
        MainWin.appendToLog("TSqlDatabase", "init3", Thread.currentThread(), null, 3, "Params=" + string);
        this.dbType = n;
        this.dbCred = charutil.getParamValue(string, "Cred", '|');
        if (this.dbCred.length() > 0) {
            TAspectDriver tAspectDriver = new TAspectDriver(this.dbCred, 0, true, false, "");
            if (tAspectDriver.isValid()) {
                this.dbName = (String)tAspectDriver.getField("dbName", 0);
                this.dbHost = (String)tAspectDriver.getField("dbHost", 0);
                this.dbPort = (String)tAspectDriver.getField("dbPort", 0);
                this.dbUser = (String)tAspectDriver.getField("dbUser", 0);
                this.dbPass = (String)tAspectDriver.getField("dbPass", 0);
                this.dbOverrideUrl = (String)tAspectDriver.getField("dbUrl", 0);
                this.dbEng = (String)tAspectDriver.getField("dbEng", 0);
                this.dbDriver = (String)tAspectDriver.getField("dbDriver", 0);
                this.dbLog = (String)tAspectDriver.getField("dbLog", 0);
                tAspectDriver.dispose();
            } else {
                MainWin.appendToLog("TSqlDatabase", "init", Thread.currentThread(), null, 4, "Error reading credentials: " + this.dbCred);
            }
        } else {
            this.dbName = charutil.getParamValue(string, "Name", '|');
            this.dbHost = charutil.getParamValue(string, "Host", '|');
            this.dbPort = charutil.getParamValue(string, "Port", '|');
            this.dbUser = charutil.getParamValue(string, "User", '|');
            this.dbPass = charutil.getParamValue(string, "Pass", '|');
            this.dbOverrideUrl = charutil.getParamValue(string, "Url", '|');
            this.dbEng = charutil.getParamValue(string, "Eng", '|');
            this.dbDriver = charutil.getParamValue(string, "Driver", '|');
            this.dbLog = charutil.getParamValue(string, "Log", '|');
        }
        if (this.dbDriver.equalsIgnoreCase("Adaptive Server Anywhere 9.0")) {
            this.dbType = 3;
        }
        this.IsValid = this.initClass();
        if (this.IsValid) {
            this.IsValid = this.connect();
        }
    }

    public boolean initClass() {
        String string = "";
        try {
            switch (this.dbType) {
                case 0: {
                    string = "sun.jdbc.odbc.JdbcOdbcDriver";
                    break;
                }
                case 1: {
                    string = "org.gjt.mm.mysql.Driver";
                    break;
                }
                case 2: {
                    string = "ianywhere.ml.jdbcodbc.jdbc3.IDriver";
                    break;
                }
                case 3: {
                    string = "com.sybase.jdbc3.jdbc.SybDriver";
                }
            }
            Class.forName(string);
        }
        catch (Exception exception) {
            MainWin.appendToLog("TSqlDatabase", "initClass", Thread.currentThread(), exception, 4, "Error initializing ODBC driver.");
            this.ConnectMsg = exception.toString();
            return false;
        }
        return true;
    }

    public boolean isValid() {
        return this.IsValid;
    }

    public void dispose() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                long l = 0L;
                if (this.dtConnect != null) {
                    l = new Date().getTime() - this.dtConnect.getTime();
                }
                MainWin.appendToLog("TSqlDatabase", "dispose", Thread.currentThread(), exception, 4, "Error closing connection to database: " + this.dbName + " Connect time: " + l + " ms " + exception.toString());
                new Throwable().printStackTrace();
            }
        }
    }

    public boolean connect() {
        String string;
        String string2 = "";
        if (this.dbType == 0) {
            string2 = "jdbc:odbc:" + this.dbName;
        } else if (this.dbType == 1) {
            string2 = "jdbc:mysql:";
            if (this.dbHost.trim().length() > 0) {
                if (!this.dbHost.startsWith("//")) {
                    string2 = string2 + "//";
                }
                string2 = string2 + this.dbHost;
                if (this.dbHost.indexOf(":") < 0) {
                    string2 = this.dbPort.trim().length() == 0 ? string2 + ":3306" : string2 + ":" + this.dbPort;
                }
                string2 = string2 + "/" + this.dbName;
            } else {
                string2 = string2 + this.dbName;
            }
        } else if (this.dbType == 2) {
            string = this.dbDriver.trim().length() > 0 ? this.dbDriver : "SQL Anywhere 11";
            String string3 = this.dbEng.trim().length() > 0 ? this.dbEng : "sql" + netutil.getLocalHostName();
            string2 = "jdbc:ianywhere:driver=" + this.dbDriver + ";DSN=" + this.dbName + ";ENG=" + this.dbEng;
            if (this.dbUser.trim().length() > 0) {
                string2 = string2 + ";UID=" + this.dbUser + ";PWD=" + this.dbPass;
            }
            if (this.dbLog.trim().length() > 0) {
                string2 = string2 + ";log=" + this.dbLog;
            }
        } else if (this.dbType == 3) {
            string2 = "jdbc:sybase:Tds:localhost:2638";
        }
        if (this.dbOverrideUrl != null && this.dbOverrideUrl.trim().length() > 0) {
            string2 = this.dbOverrideUrl;
        }
        string = (String)new TFormulaEvaluator().getFormulaValue("setElementValue(\"" + string2 + "\",\"PWD\",\"[hidden]\",\";\")");
        if (string2.length() == 0) {
            MainWin.appendToLog("TSqlDatabase", "connect", Thread.currentThread(), null, 4, "Error connecting to database. No Url");
            return false;
        }
        MainWin.appendToLog("TSqlDatabase", "connect", Thread.currentThread(), null, 3, "Database url: " + string);
        try {
            this.connection = this.dbType == 2 ? DriverManager.getConnection(string2) : (this.dbType == 3 ? DriverManager.getConnection(string2, this.dbUser, this.dbPass) : DriverManager.getConnection(string2, this.dbUser, this.dbPass));
            MainWin.appendToLog("TSqlDatabase", "connect", Thread.currentThread(), null, 3, "Connected to database.");
            this.dtConnect = new Date();
            this.ConnectMsg = "Connected.";
        }
        catch (Exception exception) {
            if (MainWin != null) {
                MainWin.appendToLog("TSqlDatabase", "connect", Thread.currentThread(), exception, 4, "Error connecting to database. " + string2);
            } else {
                System.out.println(exception);
            }
            this.ConnectMsg = exception.toString();
            return false;
        }
        return true;
    }

    public String getConnectMsg() {
        return this.ConnectMsg;
    }

    public Statement createStatement() {
        try {
            return this.connection.createStatement();
        }
        catch (Exception exception) {
            MainWin.appendToLog("TSqlDatabase", "createStatement", Thread.currentThread(), exception, 4, "Error in createStatement in database: " + this.dbName);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String string) {
        try {
            return this.connection.prepareStatement(string);
        }
        catch (Exception exception) {
            MainWin.appendToLog("TSqlDatabase", "prepareStatement", Thread.currentThread(), exception, 4, "Error in prepareStatement in database: " + this.dbName);
            return null;
        }
    }

    public TSqlTable[] getTables() {
        TSqlTable[] tSqlTableArray = null;
        try {
            DatabaseMetaData databaseMetaData = this.connection.getMetaData();
            String[] stringArray = new String[]{"TABLE", "VIEW"};
            ResultSet resultSet = databaseMetaData.getTables(null, null, "%", stringArray);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            ArrayList<TSqlTable> arrayList = new ArrayList<TSqlTable>();
            while (resultSet.next()) {
                arrayList.add(new TSqlTable(resultSet.getString("TABLE_CAT"), resultSet.getString("TABLE_SCHEM"), resultSet.getString("TABLE_NAME"), resultSet.getString("TABLE_TYPE"), resultSet.getString("REMARKS")));
            }
            tSqlTableArray = new TSqlTable[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                tSqlTableArray[i] = (TSqlTable)arrayList.get(i);
            }
            arrayList.clear();
        }
        catch (Exception exception) {
            if (MainWin != null) {
                MainWin.appendToLog("TSqlDatabase", "getTables", Thread.currentThread(), exception, 4, "Error connecting to database. " + this.dbName);
            } else {
                System.out.println(exception);
            }
            return null;
        }
        return tSqlTableArray;
    }

    public String[] getTableNames() {
        TSqlTable[] tSqlTableArray = this.getTables();
        if (tSqlTableArray == null) {
            return null;
        }
        String[] stringArray = new String[tSqlTableArray.length];
        for (int i = 0; i < tSqlTableArray.length; ++i) {
            stringArray[i] = tSqlTableArray[i].Name;
        }
        return stringArray;
    }

    public boolean tableExists(String string) {
        if (string.toUpperCase().indexOf("V_R_") >= 0) {
            return true;
        }
        String string2 = string;
        int n = string.indexOf(".");
        if (n >= 0) {
            string2 = string.substring(n + 1);
        }
        MainWin.appendToLog("TSqlDatabase", "tableExists", Thread.currentThread(), null, 3, "Checking for table: " + string2);
        TSqlTable[] tSqlTableArray = this.getTables();
        if (tSqlTableArray != null) {
            for (int i = 0; i < tSqlTableArray.length; ++i) {
                if (!tSqlTableArray[i].getTableName().equalsIgnoreCase(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public String getSqlFieldType(int n, int n2) {
        String string = null;
        switch (n) {
            case 1: 
            case 19: 
            case 25: {
                string = "varchar(5)";
                break;
            }
            case 2: {
                string = "smallint";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "int";
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                switch (this.dbType) {
                    case 0: {
                        string = "float";
                        break;
                    }
                    case 1: {
                        string = "double";
                        break;
                    }
                    case 2: {
                        string = "float";
                        break;
                    }
                    case 3: {
                        string = "float";
                    }
                }
                break;
            }
            case 3: 
            case 11: 
            case 24: 
            case 26: {
                string = "varchar(" + Integer.toString(n2) + ")";
                break;
            }
            case 10: 
            case 13: 
            case 18: 
            case 21: {
                switch (this.dbType) {
                    case 0: {
                        string = "datetime";
                        break;
                    }
                    case 1: {
                        string = "datetime";
                        break;
                    }
                    case 2: {
                        string = "datetime";
                        break;
                    }
                    case 3: {
                        string = "datetime";
                    }
                }
                break;
            }
            case 15: 
            case 16: 
            case 20: 
            case 22: 
            case 23: {
                string = null;
            }
        }
        return string;
    }

    public boolean addColumn(String string, String string2, int n, int n2) {
        if (this.connection == null) {
            return false;
        }
        String string3 = this.getSqlFieldType(n, n2);
        if (string3 != null) {
            try {
                Statement statement = this.connection.createStatement();
                String string4 = "ALTER TABLE " + string + " ADD " + string2 + " " + string3;
                int n3 = statement.executeUpdate(string4);
                System.out.println("Result [" + n3 + "] for " + string4);
                statement.close();
                return true;
            }
            catch (Exception exception) {
                if (MainWin != null) {
                    MainWin.appendToLog("TSqlDatabase", "addColumn", Thread.currentThread(), exception, 4, "Error getting record count");
                }
                System.out.println("Error in addColumn: " + exception.toString());
            }
        }
        return false;
    }

    public boolean addRecord(String string, String[] stringArray, Object[] objectArray) {
        if (this.connection == null) {
            return false;
        }
        int n = stringArray.length;
        try {
            int n2;
            int n3;
            String string2 = "INSERT INTO " + string + " (";
            for (n3 = 0; n3 < n; ++n3) {
                string2 = string2 + stringArray[n3];
                if (n3 >= n - 1) continue;
                string2 = string2 + ",";
            }
            string2 = string2 + ") VALUES (";
            for (n3 = 0; n3 < n; ++n3) {
                string2 = string2 + (n3 < n - 1 ? "?," : "?");
            }
            string2 = string2 + ")";
            PreparedStatement preparedStatement = this.connection.prepareStatement(string2);
            for (n2 = 0; n2 < n; ++n2) {
                preparedStatement.setObject(n2 + 1, objectArray[n2]);
            }
            n2 = preparedStatement.executeUpdate();
            preparedStatement.close();
            return true;
        }
        catch (Exception exception) {
            if (MainWin != null) {
                MainWin.appendToLog("TSqlDatabase", "execStatement", Thread.currentThread(), exception, 4, "Error in addRecord");
            } else {
                System.out.println("Error in addRecord: " + exception.toString());
            }
            return false;
        }
    }

    public boolean deleteRecord(String string, String[] stringArray, String[] stringArray2) {
        if (this.connection == null) {
            return false;
        }
        try {
            int n;
            Statement statement = this.connection.createStatement();
            String string2 = "DELETE FROM " + string + " WHERE ";
            for (n = 0; n < stringArray.length; ++n) {
                if (n > 0) {
                    string2 = string2 + " AND ";
                }
                string2 = string2 + "(" + stringArray[n] + "='" + stringArray2[n] + "')";
            }
            n = statement.executeUpdate(string2);
            statement.close();
            return true;
        }
        catch (Exception exception) {
            if (MainWin != null) {
                MainWin.appendToLog("TSqlDatabase", "deleteRecord", Thread.currentThread(), exception, 4, "Error deleting record");
            } else {
                System.out.println("Error in deleteRecord: " + exception.toString());
            }
            return false;
        }
    }

    public TSqlField[] getFields(String string) {
        if (this.connection == null) {
            return null;
        }
        TSqlField[] tSqlFieldArray = null;
        try {
            ResultSetMetaData resultSetMetaData;
            Statement statement = this.connection.createStatement();
            String string2 = "select * from \"" + string + "\"";
            if (this.dbType == 2 || this.dbType == 3 || this.dbType == 1) {
                string2 = "select * from " + string;
            }
            statement.executeQuery(string2);
            ResultSet resultSet = statement.getResultSet();
            if (resultSet != null && (resultSetMetaData = resultSet.getMetaData()) != null) {
                tSqlFieldArray = new TSqlField[resultSetMetaData.getColumnCount()];
                for (int i = 0; i < tSqlFieldArray.length; ++i) {
                    tSqlFieldArray[i] = new TSqlField();
                    tSqlFieldArray[i].setName(resultSetMetaData.getColumnName(i + 1));
                    tSqlFieldArray[i].setLabel(resultSetMetaData.getColumnLabel(i + 1));
                    tSqlFieldArray[i].setSqlType(resultSetMetaData.getColumnType(i + 1));
                    tSqlFieldArray[i].setPrecision(resultSetMetaData.getPrecision(i + 1));
                    tSqlFieldArray[i].setScale(resultSetMetaData.getScale(i + 1));
                }
            }
            statement.close();
        }
        catch (Exception exception) {
            MainWin.appendToLog("TSqlDatabase", "getFields", Thread.currentThread(), exception, 4, "Error getting fields in table");
        }
        return tSqlFieldArray;
    }

    public String[] getFieldNames(String string) {
        TSqlField[] tSqlFieldArray = this.getFields(string);
        if (tSqlFieldArray == null) {
            MainWin.appendToLog("TSqlDatabase", "getFieldNames", Thread.currentThread(), null, 3, "getFieldNames result is null");
            return null;
        }
        String[] stringArray = new String[tSqlFieldArray.length];
        for (int i = 0; i < tSqlFieldArray.length; ++i) {
            stringArray[i] = tSqlFieldArray[i].getName();
        }
        return stringArray;
    }

    public String dumpToHtml(String string, int n) {
        if (!this.tableExists(string)) {
            return "Cannot dumpRecords for " + string + " because table does not exist";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<table>");
        try {
            String string2 = "select * from \"" + string + "\"";
            if (this.dbType == 2 || this.dbType == 3 || this.dbType == 1) {
                string2 = "select * from " + string;
            }
            MainWin.appendToLog("TSqlDatabase", "dumpToHtml", Thread.currentThread(), null, 3, "Select statement: " + string2);
            Statement statement = this.createStatement();
            statement.executeQuery(string2);
            ResultSet resultSet = statement.getResultSet();
            if (resultSet != null) {
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                if (resultSetMetaData != null) {
                    int n2;
                    int n3 = resultSetMetaData.getColumnCount();
                    stringBuilder.append("<tr>");
                    for (n2 = 0; n2 < n3; ++n2) {
                        stringBuilder.append("<th align='left'>" + resultSetMetaData.getColumnLabel(n2 + 1) + "</th>");
                    }
                    stringBuilder.append("</tr>");
                    for (n2 = 0; resultSet.next() && (n < 0 || n2 < n); ++n2) {
                        stringBuilder.append("<tr>");
                        for (int i = 0; i < n3; ++i) {
                            Object object = resultSet.getObject(i + 1);
                            if (object == null) {
                                stringBuilder.append("<td>&nbsp;</td>");
                                continue;
                            }
                            stringBuilder.append("<td>" + object.toString() + "</td>");
                        }
                        stringBuilder.append("</tr>");
                    }
                } else {
                    MainWin.appendToLog("TSqlDatabase", "dumpToHtml", Thread.currentThread(), null, 4, "Resultset metadata is null");
                    stringBuilder.setLength(0);
                    stringBuilder.append("Error: Resultset metadata is null");
                }
            } else {
                MainWin.appendToLog("TSqlDatabase", "dumpToHtml", Thread.currentThread(), null, 4, "Resultset is null");
                stringBuilder.setLength(0);
                stringBuilder.append("Error: Resultset is null");
            }
            statement.close();
        }
        catch (Exception exception) {
            MainWin.appendToLog("TSqlDatabase", "dumpToHtml", Thread.currentThread(), exception, 4, "Error in dumpToHtml");
            stringBuilder.setLength(0);
            stringBuilder.append("Error in dumpToHtml" + exception.toString());
        }
        return stringBuilder.toString();
    }

    public static boolean databaseExists(String string, int n, String string2, String string3) {
        TDatabaseExists tDatabaseExists = null;
        if (hashDatabaseExists.containsKey(string.toUpperCase())) {
            tDatabaseExists = (TDatabaseExists)hashDatabaseExists.get(string.toUpperCase());
        } else {
            tDatabaseExists = new TDatabaseExists(string, n, string2, string3);
            hashDatabaseExists.put(string.toUpperCase(), tDatabaseExists);
        }
        return tDatabaseExists.exists();
    }

    private static class TDatabaseExists {
        String Name = "";
        String User = "";
        String Pass = "";
        long dtLastCheck = 0L;
        int Type = 0;
        boolean Exists = false;

        TDatabaseExists(String string, int n, String string2, String string3) {
            this.Name = string;
            this.Type = n;
            this.User = string2;
            this.Pass = string3;
        }

        long getTimeSinceCheck() {
            return new Date().getTime() - this.dtLastCheck;
        }

        boolean exists() {
            long l;
            long l2 = l = this.Exists ? 600000L : 60000L;
            if (this.getTimeSinceCheck() > l) {
                TSqlDatabase tSqlDatabase = new TSqlDatabase(this.Name, this.Type, this.User, this.Pass);
                this.Exists = new Boolean(tSqlDatabase.isValid());
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                tSqlDatabase.dispose();
                this.dtLastCheck = new Date().getTime();
            }
            return this.Exists;
        }
    }
}

