/*
 * Decompiled with CFR 0.152.
 */
package utility;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import org.apache.commons.math3.distribution.NormalDistribution;
import utility.charutil;

public class statistics {
    private static Hashtable hashcalcStrikeProbability = new Hashtable();

    public static double[] toArray(ArrayList arrayList) {
        double[] dArray = new double[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            dArray[i] = (Double)arrayList.get(i);
        }
        return dArray;
    }

    public static double sum(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
        }
        return d;
    }

    public static double sum(double[] dArray, long l) {
        double d = 0.0;
        int n = 0;
        while ((long)n < Math.min((long)dArray.length, l)) {
            d += dArray[n];
            ++n;
        }
        return d;
    }

    public static double max(double[] dArray) {
        if (dArray.length == 0) {
            return 0.0;
        }
        double d = dArray[0];
        for (int i = 0; i < dArray.length; ++i) {
            if (Double.isInfinite(dArray[i])) continue;
            d = Math.max(d, dArray[i]);
        }
        return d;
    }

    public static double max(double[] dArray, long l) {
        if (dArray.length == 0) {
            return 0.0;
        }
        double d = dArray[0];
        int n = 0;
        while ((long)n < Math.min((long)dArray.length, l)) {
            if (!Double.isInfinite(dArray[n])) {
                d = Math.max(d, dArray[n]);
            }
            ++n;
        }
        return d;
    }

    public static double min(double[] dArray) {
        if (dArray.length == 0) {
            return 0.0;
        }
        double d = dArray[0];
        for (int i = 0; i < dArray.length; ++i) {
            if (Double.isInfinite(dArray[i])) continue;
            d = Math.min(d, dArray[i]);
        }
        return d;
    }

    public static double min(double[] dArray, long l) {
        if (dArray.length == 0) {
            return 0.0;
        }
        double d = dArray[0];
        int n = 0;
        while ((long)n < Math.min((long)dArray.length, l)) {
            if (!Double.isInfinite(dArray[n])) {
                d = Math.min(d, dArray[n]);
            }
            ++n;
        }
        return d;
    }

    public static double mean(double[] dArray) {
        return statistics.mean(dArray, dArray.length);
    }

    public static double mean(double[] dArray, long l) {
        long l2 = Math.min((long)dArray.length, l);
        double d = 0.0;
        int n = 0;
        while ((long)n < l2) {
            d += dArray[n];
            ++n;
        }
        return d / (double)l2;
    }

    public static double median(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        Arrays.sort(dArray2);
        double d = 0.0;
        if (dArray2.length == 1) {
            d = dArray2[0];
        }
        if (dArray2.length % 2 == 0) {
            int n = dArray2.length / 2;
            d = (dArray2[n - 1] + dArray2[n]) / 2.0;
        } else {
            int n = (int)Math.floor(dArray2.length / 2);
            d = dArray2[n];
        }
        return d;
    }

    public static double stddev(double[] dArray) {
        return statistics.stddev(dArray, dArray.length);
    }

    public static double stddev(double[] dArray, long l) {
        long l2 = Math.min((long)dArray.length, l);
        double d = statistics.mean(dArray, l2);
        double d2 = 0.0;
        int n = 0;
        while ((long)n < l2) {
            d2 += Math.pow(dArray[n] - d, 2.0);
            ++n;
        }
        return Math.pow(d2 /= (double)l2, 0.5);
    }

    public static double[] normalize(double[] dArray) {
        int n;
        double[] dArray2 = new double[dArray.length];
        double d = statistics.min(dArray);
        double d2 = statistics.max(dArray);
        double d3 = d2 - d;
        for (n = 0; n < dArray.length; ++n) {
            if (Double.isInfinite(dArray[n])) {
                dArray2[n] = 0.0;
                continue;
            }
            dArray2[n] = (dArray[n] - d) / d3;
            dArray2[n] = dArray2[n] * 2.0 - 1.0;
        }
        for (n = 0; n < dArray.length; ++n) {
            System.out.println("normal\t" + dArray[n] + "\t" + dArray2[n] + "\tMin:" + d + "\tMax:" + d2);
        }
        return dArray2;
    }

    public static double correlation(double[] dArray, double[] dArray2) {
        return statistics.correlation(dArray, dArray2, dArray.length);
    }

    public static double correlation(double[] dArray, double[] dArray2, int n) {
        return statistics.correlation(dArray, dArray2, n, false);
    }

    public static double correlation(double[] dArray, double[] dArray2, int n, boolean bl) {
        if (bl) {
            return statistics.correlation2(dArray, dArray2, n);
        }
        double d = statistics.mean(dArray, n);
        double d2 = statistics.mean(dArray2, n);
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i < n; ++i) {
            d3 += (dArray[i] - d) * (dArray2[i] - d2);
            d4 += (dArray[i] - d) * (dArray[i] - d);
            d5 += (dArray2[i] - d2) * (dArray2[i] - d2);
        }
        return d3 / Math.pow(d4 * d5, 0.5);
    }

    public static double correlation2(double[] dArray, double[] dArray2, int n) {
        double d = 0.0;
        double d2 = dArray[0];
        double d3 = n - 1;
        double d4 = dArray[n - 1];
        double d5 = statistics.calcDegreesToRotate(d3, d4, d, d2);
        double d6 = 0.0;
        double d7 = dArray2[0];
        double d8 = n - 1;
        double d9 = dArray2[n - 1];
        double d10 = statistics.calcDegreesToRotate(d8, d9, d6, d7);
        for (int i = 0; i < n; ++i) {
            dArray[i] = statistics.rotate(i, dArray[i], d5, d, d2)[1];
            dArray2[i] = statistics.rotate(i, dArray2[i], d10, d6, d7)[1];
        }
        double d11 = statistics.mean(dArray, n);
        double d12 = statistics.mean(dArray2, n);
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = 0.0;
        for (int i = 0; i < n; ++i) {
            d13 += (dArray[i] - d11) * (dArray2[i] - d12);
            d14 += Math.pow(dArray[i] - d11, 2.0);
            d15 += Math.pow(dArray2[i] - d12, 2.0);
        }
        return d13 / Math.pow(d14 * d15, 0.5);
    }

    public static double[] montecarlo(double d, double d2, int n, int n2) {
        NormalDistribution normalDistribution = null;
        if (d2 != 0.0) {
            normalDistribution = new NormalDistribution(d, d2);
        }
        double[] dArray = new double[n2];
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < n2; ++i) {
            dArray[i] = 0.0;
            if (d2 != 0.0) {
                for (int j = 0; j < n; ++j) {
                    if (Math.random() < 0.5) {
                        int n3 = i;
                        dArray[n3] = dArray[n3] + normalDistribution.sample();
                        continue;
                    }
                    int n4 = i;
                    dArray[n4] = dArray[n4] + normalDistribution.sample();
                }
            }
            if (i == 0) {
                d3 = dArray[i];
                d4 = dArray[i];
                continue;
            }
            d3 = Math.min(d3, dArray[i]);
            d4 = Math.max(d4, dArray[i]);
        }
        double d5 = statistics.mean(dArray);
        double d6 = statistics.stddev(dArray);
        double[] dArray2 = new double[]{d5, d6};
        return dArray2;
    }

    public static String calcStrikeProbabilitiesText(double d, double d2, int n, int n2, boolean bl, boolean bl2, double d3) {
        double[][] dArray = statistics.calcStrikeProbabilities(d, d2, n, n2, d3);
        StringBuilder stringBuilder = new StringBuilder();
        if (bl2) {
            if (bl) {
                stringBuilder.append("Value,Cumulative Max/Min,Cumulative Final\r\n");
            } else {
                stringBuilder.append("Index,Value,Prob Max,Prob Min,Prob Final,Cumulative Max,Cumulative Min,Cumulative Max/Min,Cumulative Final\r\n");
            }
        }
        for (int i = 0; i < dArray.length; ++i) {
            if (bl) {
                stringBuilder.append(charutil.formatNumber(dArray[i][0], "0.00"));
                stringBuilder.append("," + charutil.formatNumber(dArray[i][6], "0.00"));
                stringBuilder.append("," + charutil.formatNumber(dArray[i][7], "0.00"));
            } else {
                stringBuilder.append(i);
                stringBuilder.append("," + charutil.formatNumber(dArray[i][0], "0.00"));
                stringBuilder.append("," + charutil.formatNumber(dArray[i][1], "0.00"));
                stringBuilder.append("," + charutil.formatNumber(dArray[i][2], "0.00"));
                stringBuilder.append("," + charutil.formatNumber(dArray[i][3], "0.00"));
                stringBuilder.append("," + charutil.formatNumber(dArray[i][4], "0.00"));
                stringBuilder.append("," + charutil.formatNumber(dArray[i][5], "0.00"));
                stringBuilder.append("," + charutil.formatNumber(dArray[i][6], "0.00"));
                stringBuilder.append("," + charutil.formatNumber(dArray[i][7], "0.00"));
            }
            stringBuilder.append("\r\n");
        }
        return stringBuilder.toString();
    }

    public static double[][] calcStrikeProbabilities(double d, double d2, int n, int n2, double d3) {
        int n3;
        double d4 = 0.5;
        double d5 = 1000.0;
        int n4 = (int)Math.floor(d5 / d4);
        int n5 = (int)Math.floor(d5 / d4 * 2.0 + 1.0);
        NormalDistribution normalDistribution = null;
        if (d2 != 0.0) {
            normalDistribution = new NormalDistribution(d, d2);
        }
        double[] dArray = new double[n5];
        double[] dArray2 = new double[n5];
        double[] dArray3 = new double[n5];
        int n6 = 0;
        int n7 = 0;
        for (int i = 0; i < n2; ++i) {
            int n8;
            if (d2 == 0.0) continue;
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            for (n8 = 0; n8 < n; ++n8) {
                d8 += normalDistribution.sample();
                if (n8 == 0) {
                    d6 = d8;
                    d7 = d8;
                    continue;
                }
                d6 = Math.min(d6, d8);
                d7 = Math.max(d7, d8);
            }
            n8 = d6 < 0.0 ? (int)Math.floor((double)n4 + d6 / d4) : (int)Math.ceil((double)n4 + d6 / d4);
            int n9 = n8 = n4 + (n4 - n8);
            dArray[n9] = dArray[n9] + 1.0;
            int n10 = d7 < 0.0 ? (int)Math.floor((double)n4 + d7 / d4) : (int)Math.ceil((double)n4 + d7 / d4);
            int n11 = n10 = n4 + (n4 - n10);
            dArray2[n11] = dArray2[n11] + 1.0;
            int n12 = d8 < 0.0 ? (int)Math.floor((double)n4 + d8 / d4) : (int)Math.ceil((double)n4 + d8 / d4);
            int n13 = n12 = n4 + (n4 - n12);
            dArray3[n13] = dArray3[n13] + 1.0;
            if (i == 0) {
                n6 = n8;
                n7 = n8;
            }
            n6 = Math.min(n6, n8);
            n6 = Math.min(n6, n10);
            n6 = Math.min(n6, n12);
            n7 = Math.max(n7, n8);
            n7 = Math.max(n7, n10);
            n7 = Math.max(n7, n12);
        }
        double[] dArray4 = new double[n5];
        double[] dArray5 = new double[n5];
        double[] dArray6 = new double[n5];
        double[] dArray7 = new double[n5];
        double[] dArray8 = new double[n5];
        double[] dArray9 = new double[n5];
        for (n3 = 0; n3 < n4; ++n3) {
            dArray4[n3] = dArray[n3] / (double)n2 * 100.0;
            dArray5[n3] = dArray2[n3] / (double)n2 * 100.0;
            dArray6[n3] = dArray3[n3] / (double)n2 * 100.0;
            if (n3 == 0) {
                dArray7[n3] = dArray4[n3];
                dArray8[n3] = dArray5[n3];
                dArray9[n3] = dArray6[n3];
                continue;
            }
            dArray7[n3] = dArray4[n3] + dArray7[n3 - 1];
            dArray8[n3] = dArray5[n3] + dArray8[n3 - 1];
            dArray9[n3] = dArray6[n3] + dArray9[n3 - 1];
        }
        for (n3 = n5 - 1; n3 >= n4; --n3) {
            dArray4[n3] = dArray[n3] / (double)n2 * 100.0;
            dArray5[n3] = dArray2[n3] / (double)n2 * 100.0;
            dArray6[n3] = dArray3[n3] / (double)n2 * 100.0;
            if (n3 == n5 - 1) {
                dArray7[n3] = dArray4[n3];
                dArray8[n3] = dArray5[n3];
                dArray9[n3] = dArray6[n3];
                continue;
            }
            dArray7[n3] = dArray4[n3] + dArray7[n3 + 1];
            dArray8[n3] = dArray5[n3] + dArray8[n3 + 1];
            dArray9[n3] = dArray6[n3] + dArray9[n3 + 1];
        }
        double d9 = d5;
        double d10 = Math.floor(d3 * 2.0 + 0.49) / 2.0;
        double[][] dArray10 = new double[n7 - n6 + 1][8];
        int n14 = 0;
        for (int i = 0; i <= n7; ++i) {
            if (i >= n6) {
                dArray10[n14][0] = d9 + d10;
                dArray10[n14][1] = dArray5[i];
                dArray10[n14][2] = dArray4[i];
                dArray10[n14][3] = dArray6[i];
                dArray10[n14][4] = dArray8[i];
                dArray10[n14][5] = dArray7[i];
                dArray10[n14][6] = i < n4 ? dArray8[i] : dArray7[i];
                dArray10[n14][7] = dArray9[i];
                ++n14;
            }
            d9 -= d4;
        }
        return dArray10;
    }

    public static double calcStrikeProbability(double d, double d2, double d3, double d4, int n, int n2, int n3) {
        double d5 = d2 * Math.pow(n, 0.5);
        NormalDistribution normalDistribution = new NormalDistribution(d3, d5);
        if (n2 == 0) {
            return normalDistribution.cumulativeProbability(d4) * 100.0;
        }
        return (1.0 - normalDistribution.cumulativeProbability(d4)) * 100.0;
    }

    public static double radians(double d) {
        return d * Math.PI / 180.0;
    }

    public static double degrees(double d) {
        return d * 180.0 / Math.PI;
    }

    public static double[] rotate(double d, double d2, double d3, double d4, double d5) {
        double d6 = statistics.degrees(Math.sin(statistics.radians(d3)));
        double d7 = statistics.degrees(Math.cos(statistics.radians(d3)));
        double d8 = d4 - statistics.radians((d4 - d) * d7 - (d5 - d2) * d6);
        double d9 = d5 - statistics.radians((d5 - d2) * d7 + (d4 - d) * d6);
        double[] dArray = new double[]{d8, d9};
        return dArray;
    }

    public static double calcDegreesToRotate(double d, double d2, double d3, double d4) {
        double d5;
        for (d5 = -(d4 - d2) / (d3 - d); d5 > 60.0; d5 -= 60.0) {
        }
        while (d5 < -60.0) {
            d5 += 60.0;
        }
        double d6 = 0.0;
        double d7 = -1.0;
        for (int i = -80; i < 90; i += 10) {
            double d8 = Math.toRadians(i);
            double d9 = Math.toDegrees(Math.sin(d8)) / Math.toDegrees(Math.sin(d8 + 1.5707963267948966));
            double d10 = Math.abs(d9 - d5);
            if (i != -80 && !(d10 < d6)) continue;
            d6 = d10;
            d7 = i;
        }
        double d11 = d7 - 1.0;
        double d12 = d7 + 1.0;
        double d13 = Math.toDegrees(Math.sin(Math.toRadians(d11))) / Math.toDegrees(Math.sin(Math.toRadians(d11) + 1.5707963267948966));
        double d14 = Math.toDegrees(Math.sin(Math.toRadians(d12))) / Math.toDegrees(Math.sin(Math.toRadians(d12) + 1.5707963267948966));
        double d15 = (d14 - d13) / (d12 - d11);
        double d16 = d13 - d15 * d11;
        double d17 = (d5 - d16) / d15;
        d11 = d17 - Math.abs(d17) * 0.001;
        d12 = d17 + Math.abs(d17) * 0.001;
        d13 = Math.toDegrees(Math.sin(Math.toRadians(d11))) / Math.toDegrees(Math.sin(Math.toRadians(d11) + 1.5707963267948966));
        d14 = Math.toDegrees(Math.sin(Math.toRadians(d12))) / Math.toDegrees(Math.sin(Math.toRadians(d12) + 1.5707963267948966));
        d15 = (d14 - d13) / (d12 - d11);
        d16 = d13 - d15 * d11;
        d17 = (d5 - d16) / d15;
        d11 = d17 - Math.abs(d17) * 0.001;
        d12 = d17 + Math.abs(d17) * 0.001;
        d13 = Math.toDegrees(Math.sin(Math.toRadians(d11))) / Math.toDegrees(Math.sin(Math.toRadians(d11) + 1.5707963267948966));
        d14 = Math.toDegrees(Math.sin(Math.toRadians(d12))) / Math.toDegrees(Math.sin(Math.toRadians(d12) + 1.5707963267948966));
        d15 = (d14 - d13) / (d12 - d11);
        d16 = d13 - d15 * d11;
        d17 = (d5 - d16) / d15;
        d11 = d17 - Math.abs(d17) * 0.001;
        d12 = d17 + Math.abs(d17) * 0.001;
        d13 = Math.toDegrees(Math.sin(Math.toRadians(d11))) / Math.toDegrees(Math.sin(Math.toRadians(d11) + 1.5707963267948966));
        d14 = Math.toDegrees(Math.sin(Math.toRadians(d12))) / Math.toDegrees(Math.sin(Math.toRadians(d12) + 1.5707963267948966));
        d15 = (d14 - d13) / (d12 - d11);
        d16 = d13 - d15 * d11;
        d17 = (d5 - d16) / d15;
        return d17;
    }

    public static double[] createSeries(double d, double d2, int n) {
        if (d2 == 0.0) {
            return new double[0];
        }
        NormalDistribution normalDistribution = new NormalDistribution(d, d2);
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = normalDistribution.sample();
        }
        return dArray;
    }

    public static double[] createRandomWalk(double d, double d2, int n, double d3) {
        if (d2 == 0.0) {
            return new double[0];
        }
        NormalDistribution normalDistribution = new NormalDistribution(d, d2);
        double[] dArray = new double[n];
        dArray[0] = d3;
        for (int i = 1; i < n; ++i) {
            dArray[i] = dArray[i - 1] + normalDistribution.sample();
        }
        return dArray;
    }

    public static double getWalkEndpoint(double d, double d2, int n, double d3) {
        if (d2 == 0.0) {
            return 0.0;
        }
        double d4 = d2 / Math.pow(1.0 / (double)n, 0.5);
        double d5 = d * (double)n;
        NormalDistribution normalDistribution = new NormalDistribution(d5, d4);
        double d6 = d3 + normalDistribution.sample();
        return d6;
    }

    public static double getSin(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        return d2 / 2.0 * Math.sin(Math.PI * 2 / d3 * (d + d4)) + d6 * d + d5 + (Math.random() * d7 * 2.0 - d7);
    }

    public static double[] sampleSin(int n, double d, double d2, double d3, double d4, double d5, double d6) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = d2 / 2.0 * Math.sin(Math.PI * 2 / d * ((double)i + d3)) + d5 * (double)i + d4 + (Math.random() * d6 * 2.0 - d6);
        }
        return dArray;
    }

    public static String arrayToString(double[] dArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < dArray.length; ++i) {
            stringBuilder.append("," + charutil.formatNumber(dArray[i], "0.00"));
        }
        stringBuilder.deleteCharAt(0);
        return stringBuilder.toString();
    }

    public static String linearRegression(double[] dArray, int n, int n2) {
        int n3 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        boolean bl = false;
        for (int i = n; i <= n2; ++i) {
            double d5 = dArray[i];
            d += d5;
            d2 += (double)(++n3);
            d4 += (double)n3 * d5;
            d3 += (double)(n3 * n3);
        }
        double d6 = (double)n3 * d4 - d2 * d;
        double d7 = (double)n3 * d3 - d2 * d2;
        double d8 = d7 == 0.0 ? 0.0 : d6 / d7;
        double d9 = n3 == 0 ? 0.0 : (d * d3 - d2 * d4) / ((double)n3 * d3 - d2 * d2);
        return d8 + "," + d9;
    }
}

