/*
 * Decompiled with CFR 0.152.
 */
package utility.transport;

import aspect.Aspect;
import aspect.TMainWin;
import drivers.aspect.TAspectDriver;
import java.util.ArrayList;
import java.util.Date;
import resources.TAppDriversObject;
import resources.TApplication;
import utility.TFormulaEvaluator;
import utility.charutil;
import utility.dateutil;
import utility.dosutil;
import utility.objectutil;

public class TTransportRecord {
    private static TMainWin MainWin = Aspect.MainWin;
    private static TApplication Application = TMainWin.Application;
    private static boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTTransportRecord");
    public static int MaxResult = 3;
    public static String[] arResultString = new String[]{"Pending", "Success", "Fail", "Expired"};
    public String Description = "";
    public String ID = "";
    public int TransportMethod = 0;
    public String EmailAccount = "";
    public String Destination = "";
    public String EmailSubject = "";
    public String EmailBody = "";
    public String EmailBodyFileName = "";
    public String Source = "";
    public int Maximum_Attempts = 0;
    public int Minutes_Between_Attempts = 0;
    public boolean Delete_Source_After_Execute = false;
    public boolean isLibraryDocument = false;
    public String Library_Client_ID = "";
    public String FTPAccount = "";
    public String FTPHost = "";
    public String FTPUserName = "";
    public String FTPPassword = "";
    public boolean FTPPassive = false;
    public int OverwriteOption = 0;
    TAspectDriver driver;
    int RecordNumber = 0;
    TFormulaEvaluator FormulaEvaluator = null;

    public TTransportRecord(TAspectDriver tAspectDriver, String string) {
        this.driver = tAspectDriver;
        this.FormulaEvaluator = new TFormulaEvaluator();
        if (string.length() > 0) {
            this.FormulaEvaluator.setConstant("Params", string);
            String[] stringArray = charutil.getSubStringArray(string, '|', false);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String[] stringArray2 = charutil.getSubStringArray(stringArray[i], '=', false);
                    if (stringArray2 == null || stringArray2.length != 2) continue;
                    this.FormulaEvaluator.setConstant("#" + stringArray2[0], stringArray2[1]);
                }
            }
        }
    }

    public void setRecord(int n) {
        this.RecordNumber = n;
    }

    public String getID() {
        return (String)this.driver.getField("ID", this.RecordNumber);
    }

    public String getTransportID() {
        return (String)this.driver.getField("TransportID", this.RecordNumber);
    }

    public String getDescription() {
        return (String)this.driver.getField("Description", this.RecordNumber);
    }

    public int getTransportMethod() {
        return (Integer)this.driver.getField("TransportMethod", this.RecordNumber);
    }

    public boolean getRecurseDirectories() {
        return (Boolean)this.driver.getField("RecurseDirectories", this.RecordNumber);
    }

    public boolean getMove() {
        return (Boolean)this.driver.getField("Move", this.RecordNumber);
    }

    public boolean getAppend() {
        return (Boolean)this.driver.getField("Append", this.RecordNumber);
    }

    public String getSource() {
        return Application.parse_tokens((String)this.driver.getField("Source", this.RecordNumber));
    }

    public String getSourceBaseFilename() {
        String string = this.getSource();
        TAppDriversObject tAppDriversObject = TTransportRecord.Application.AppDrivers.getAppDriversObject(string);
        if (tAppDriversObject != null) {
            string = tAppDriversObject.FileName.toString();
        }
        if (string.startsWith("=")) {
            Object object = new TFormulaEvaluator().getFormulaValue(string, 0, 0);
            return Application.parse_tokens(objectutil.convertToString(object));
        }
        return Application.parse_tokens(string);
    }

    public String[] getFileList(String string) {
        TAppDriversObject tAppDriversObject = TTransportRecord.Application.AppDrivers.getAppDriversObject(string);
        String[] stringArray = null;
        boolean bl = this.getRecurseDirectories();
        boolean bl2 = false;
        System.out.println("TTransportRecord ASource=" + string);
        if (tAppDriversObject != null) {
            Object object = new TFormulaEvaluator().getFormulaValue(tAppDriversObject.FileName, 0, 0);
            stringArray = new String[]{Application.parse_tokens(objectutil.convertToString(object))};
            System.out.println("Returning source from AppDriversObj: " + stringArray[0]);
        } else {
            String string2;
            String[] stringArray2;
            if (string.startsWith("=")) {
                stringArray2 = new TFormulaEvaluator().getFormulaValue(string, 0, 0);
                string2 = Application.parse_tokens(objectutil.convertToString(stringArray2));
            } else {
                string2 = Application.parse_tokens(string);
            }
            stringArray2 = charutil.getSubStringArray(string2, ';', true);
            if (stringArray2 != null && stringArray2.length > 0) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    int n;
                    String[] stringArray3;
                    System.out.println("TTransportRecord arSource[i]=" + stringArray2[i]);
                    System.out.println("TTransportRecord formatURL=" + dosutil.formatURL(stringArray2[i]));
                    if (dosutil.formatURL(stringArray2[i].toUpperCase()).startsWith("FILE")) {
                        stringArray2[i] = charutil.replaceChar(stringArray2[i], '/', '\\');
                        String string3 = dosutil.listMatchingFiles(0, stringArray2[i], 1, bl, bl2, 0);
                        System.out.println("TTransportRecord listMatchingFiles=" + string3);
                        stringArray3 = charutil.getSubStringArray(string3, '|', true);
                    } else {
                        stringArray3 = new String[]{stringArray2[i]};
                        System.out.println("TTransportRecord source is a URL");
                    }
                    if (stringArray3 == null || stringArray3.length <= 0) continue;
                    if (stringArray == null) {
                        n = 0;
                        stringArray = new String[stringArray3.length];
                    } else {
                        n = stringArray.length;
                        stringArray = (String[])charutil.arrayGrow(stringArray, stringArray.length + stringArray3.length);
                    }
                    System.arraycopy(stringArray3, 0, stringArray, n, stringArray3.length);
                }
            } else {
                System.out.println("TTranspotrRecord arSource=null");
            }
        }
        return stringArray;
    }

    public String[] getSourceFilename() {
        int n;
        String string = this.getSource();
        String string2 = this.getExclude();
        String[] stringArray = this.getFileList(string);
        System.out.println("TTransportRecord Source=" + string + " Exclude=" + string2);
        if (stringArray == null) {
            System.out.println("TTransportRecord arSource=null");
        } else {
            System.out.println("TTransportRecord arSource len=" + stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.print(i + "\t" + stringArray[i]);
            }
            System.out.println();
        }
        if (stringArray == null) {
            return null;
        }
        String[] stringArray2 = this.getFileList(string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray2 != null) {
            for (int i = 0; i < stringArray2.length; ++i) {
                arrayList.add(stringArray2[i]);
            }
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (arrayList.contains(stringArray[i])) continue;
            arrayList2.add(stringArray[i]);
        }
        String[] stringArray3 = new String[arrayList2.size()];
        for (n = 0; n < arrayList2.size(); ++n) {
            stringArray3[n] = (String)arrayList2.get(n);
        }
        System.out.println("TTransportRecord arReturn len=" + stringArray3.length);
        for (n = 0; n < stringArray3.length; ++n) {
            System.out.print(n + "\t" + stringArray3[n]);
        }
        System.out.println();
        return stringArray3;
    }

    public String getExclude() {
        return (String)this.driver.getField("Exclude", this.RecordNumber);
    }

    public String getDestination() {
        return Application.parse_tokens((String)this.driver.getField("Destination", this.RecordNumber));
    }

    public String getDestinationFilename() {
        String string = this.getDestination();
        TAppDriversObject tAppDriversObject = TTransportRecord.Application.AppDrivers.getAppDriversObject(string);
        if (tAppDriversObject != null) {
            string = tAppDriversObject.FileName.toString();
        }
        if (string.startsWith("=")) {
            Object object = new TFormulaEvaluator().getFormulaValue(string, 0, 0);
            return Application.parse_tokens(objectutil.convertToString(object));
        }
        return string;
    }

    public String getAspectServer() {
        return (String)this.driver.getField("Aspect_Server", this.RecordNumber);
    }

    public String getFTPAccount() {
        return (String)this.driver.getField("FTPAccount", this.RecordNumber);
    }

    public String getFTPHost() {
        return (String)this.driver.getField("FTPHost", this.RecordNumber);
    }

    public String getFTPUserName() {
        return (String)this.driver.getField("FTPUserName", this.RecordNumber);
    }

    public String getFTPPassword() {
        return (String)this.driver.getField("FTPPassword", this.RecordNumber);
    }

    public boolean getFTPPassive() {
        return (Boolean)this.driver.getField("FTPPassive", this.RecordNumber);
    }

    public int getOverwriteOptions() {
        return (Integer)this.driver.getField("TransportOverwriteOptions", this.RecordNumber);
    }

    public void setFtpTransferDuration(int n) {
        this.driver.putField("FtpTransferDuration", this.RecordNumber, (Object)n);
    }

    public void appendMessage(String string) {
        Date date = new Date();
        String string2 = "<tr><td valign='top'>" + dateutil.formatDate(date, "MM-dd-yy") + "&nbsp;" + dateutil.formatDate(date, "HH:mm:ss") + "</td><td valign='top'>" + string + "</td></tr>";
        string2 = (String)this.driver.getField("Message", this.RecordNumber) + string2;
        this.driver.putField("Message", this.RecordNumber, (Object)string2);
    }

    public String getEmailAccount() {
        return (String)this.driver.getField("EmailAccount", this.RecordNumber);
    }

    public String getEmailSubject() {
        return (String)this.driver.getField("EmailSubject", this.RecordNumber);
    }

    public String getEmailBody() {
        return (String)this.driver.getField("EmailBody", this.RecordNumber);
    }

    public String getEmailBodyFileName() {
        return (String)this.driver.getField("EmailBodyFileName", this.RecordNumber);
    }

    public String getEmailToAddress() {
        return this.getDestination();
    }

    public boolean getZipIncludePaths() {
        return (Boolean)this.driver.getField("ZipIncludePaths", this.RecordNumber);
    }

    public String getZipBaseDirectory() {
        return (String)this.driver.getField("ZipBaseDirectory", this.RecordNumber);
    }

    public String getExecScriptBefore() {
        return (String)this.driver.getField("ExecScriptBefore", this.RecordNumber);
    }

    public String getExecScriptBeforeArgs() {
        return (String)this.driver.getField("ExecScriptBeforeArgs", this.RecordNumber);
    }

    public String getExecScriptAfter() {
        return (String)this.driver.getField("ExecScriptAfter", this.RecordNumber);
    }

    public String getExecScriptAfterArgs() {
        return (String)this.driver.getField("ExecScriptAfter", this.RecordNumber);
    }

    public String getMergeSourceFilter() {
        return (String)this.driver.getField("MergeSourceFilter", this.RecordNumber);
    }

    public String getMergeDestFilter() {
        return (String)this.driver.getField("MergeDestFilter", this.RecordNumber);
    }

    public String getMergeKeyFields() {
        return (String)this.driver.getField("MergeKeyFields", this.RecordNumber);
    }

    public String getMergeFieldsToMerge() {
        return (String)this.driver.getField("MergeFieldsToMerge", this.RecordNumber);
    }

    public String getMergeAliasFields() {
        return (String)this.driver.getField("MergeAliasFields", this.RecordNumber);
    }

    public int getDelimiter() {
        return (Integer)this.driver.getField("AsciiDelimiter", this.RecordNumber);
    }

    public String getExportStructure() {
        return (String)this.driver.getField("ExportStructure", this.RecordNumber);
    }

    public boolean getExportFieldDescriptions() {
        return (Boolean)this.driver.getField("ExportFieldDescriptions", this.RecordNumber);
    }

    public boolean getExportFieldIDs() {
        return (Boolean)this.driver.getField("ExportFieldIDs", this.RecordNumber);
    }

    public boolean getExportFieldDataTypes() {
        return (Boolean)this.driver.getField("ExportFieldDataTypes", this.RecordNumber);
    }

    public boolean getExportVirtualFields() {
        return (Boolean)this.driver.getField("ExportVirtualFields", this.RecordNumber);
    }

    public String getSourcePassword() {
        return Application.parse_tokens((String)this.driver.getField("SrcPassword", this.RecordNumber));
    }

    public String getDestinationPassword() {
        return Application.parse_tokens((String)this.driver.getField("DestPassword", this.RecordNumber));
    }

    public int getMaximumAttempts() {
        return (Integer)this.driver.getField("Maximum_Attempts", this.RecordNumber);
    }

    public int getAttemptsMade() {
        return (Integer)this.driver.getField("Attempts_Made", this.RecordNumber);
    }

    public int getHoursBetweenAttempts() {
        return (Integer)this.driver.getField("Hours_Between_Attempts", this.RecordNumber);
    }

    public int getMinutesBetweenAttempts() {
        return (Integer)this.driver.getField("Minutes_Between_Attempts", this.RecordNumber);
    }

    public void setAttemptsMade(int n) {
        this.driver.putField("Attempts_Made", this.RecordNumber, (Object)n);
    }

    public int getResult() {
        return (Integer)this.driver.getField("Result", this.RecordNumber);
    }

    public void setResult(int n) {
        this.driver.putField("Result", this.RecordNumber, (Object)n);
    }

    public boolean getDeleteSourceAfterExecute() {
        return (Boolean)this.driver.getField("Delete_Source_After_Execute", this.RecordNumber);
    }

    public boolean getisLibraryDocument() {
        return (Boolean)this.driver.getField("isLibraryDocument", this.RecordNumber);
    }

    public Date getTimeOfLastAttempt() {
        return (Date)this.driver.getField("Time_Of_Last_Attempt", this.RecordNumber);
    }

    public void setTimeOfLastAttempt(Date date) {
        this.driver.putField("Time_Of_Last_Attempt", this.RecordNumber, (Object)date);
    }
}

