/*
 * Decompiled with CFR 0.152.
 */
package utility.whois;

import aspect.Aspect;
import aspect.TMainWin;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import utility.charutil;
import utility.netutil;

public class TWhoIs {
    private static TMainWin MainWin = Aspect.MainWin;
    private static boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTWhoIs");
    private static Hashtable hashProperties = null;

    public static Properties getWhoIs(String string) {
        Object object;
        Properties properties = null;
        if (hashProperties != null && (object = hashProperties.get(string)) != null) {
            return (Properties)object;
        }
        properties = TWhoIs.getLocalWhoIs(string);
        if (properties == null && (properties = TWhoIs.getArinWhoIs(string)) != null) {
            String string2 = properties.getProperty("WHOISORGID");
            String string3 = properties.getProperty("WHOISORGNAME");
            if (string2 != null && string2.equalsIgnoreCase("APNIC")) {
                Properties properties2;
                String string4;
                object = TWhoIs.getApnicWhoIs(string);
                if (object != null && ((string4 = (properties = object).getProperty("WHOISORGID")) != null && string4.equalsIgnoreCase("KORNET") || string4.equalsIgnoreCase("KRNIC-KR")) && (properties2 = TWhoIs.getKornetWhoIs(string)) != null) {
                    properties = properties2;
                }
            } else if (string2 != null && (string2.equalsIgnoreCase("RIPE") || string3.equalsIgnoreCase("RIPE NCC")) && (object = TWhoIs.getRipeWhoIs(string)) != null) {
                properties = object;
            }
        }
        if (hashProperties == null) {
            hashProperties = new Hashtable();
        }
        if (properties != null) {
            hashProperties.put(string, properties);
        }
        return properties;
    }

    private static String[] getDataFromServer(String string, int n, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string3;
            Socket socket = new Socket(string, 43);
            PrintStream printStream = new PrintStream(socket.getOutputStream());
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            printStream.print(string2 + "\r\n");
            while ((string3 = bufferedReader.readLine()) != null) {
                arrayList.add(string3);
            }
        }
        catch (UnknownHostException unknownHostException) {
            MainWin.appendToLog("TWhoIs", "getDataFromServer", Thread.currentThread(), unknownHostException, 4, "Unknown host");
        }
        catch (ConnectException connectException) {
            MainWin.appendToLog("TWhoIs", "getDataFromServer", Thread.currentThread(), connectException, 4, "Cannot connect to: " + string);
        }
        catch (IOException iOException) {
            MainWin.appendToLog("TWhoIs", "getDataFromServer", Thread.currentThread(), iOException, 4, "IOException");
        }
        if (arrayList.size() == 0) {
            return null;
        }
        if (Debug) {
            for (int i = 0; i < arrayList.size(); ++i) {
                MainWin.appendToLog("TWhoIs", "getDataFromServer", Thread.currentThread(), null, 3, "getDataFromServer[" + i + "] = " + (String)arrayList.get(i));
            }
        }
        while (arrayList.size() > 0 && ((String)arrayList.get(0)).trim().length() == 0) {
            arrayList.remove(0);
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    private static Properties getLocalWhoIs(String string) {
        Properties properties = null;
        if (netutil.isValidIPAddress(string)) {
            if (netutil.isLocalNetworkIPAddress(string)) {
                properties = new Properties();
                properties.put("WHOISORGNAME", "Local Connection");
                properties.put("WHOISORGID", "Local Connection");
                return properties;
            }
            if (netutil.isBroadcastIPAddress(string) || netutil.isMulticastIPAddress(string)) {
                properties = new Properties();
                properties.put("WHOISORGNAME", "Broadcast");
                properties.put("WHOISORGID", "Broadcast");
                return properties;
            }
        }
        return properties;
    }

    private static Properties getArinWhoIs(String string) {
        int n;
        if (Debug) {
            MainWin.appendToLog("TWhoIs", "getArinWhoIs", Thread.currentThread(), null, 3, "Doing ARIN WhoIs for " + string);
        }
        if (string.trim().length() == 0) {
            new Throwable().printStackTrace();
            return null;
        }
        String[] stringArray = TWhoIs.getDataFromServer("whois.arin.net", 43, string);
        if (stringArray == null) {
            return null;
        }
        Properties properties = new Properties();
        StringBuilder stringBuilder = new StringBuilder();
        for (n = 0; n < stringArray.length; ++n) {
            stringBuilder.append(stringArray[n] + "\r\n");
        }
        properties.put("WhoIsDetails", stringBuilder.toString());
        if (stringArray[0].indexOf("OrgName") >= 0) {
            if (Debug) {
                MainWin.appendToLog("TWhoIs", "getArinWhoIs", Thread.currentThread(), null, 3, "Parsing full reply");
            }
            for (n = 0; n < stringArray.length; ++n) {
                String[] stringArray2;
                if (stringArray[n].trim().length() <= 0 || stringArray[n].charAt(0) == '#' || stringArray[n].startsWith("Process completed") || (stringArray2 = charutil.getSubStringArray(stringArray[n], ':', true)) == null || stringArray2.length <= 1) continue;
                String string2 = "WhoIs" + stringArray2[0];
                properties.put(string2.toUpperCase(), stringArray2[1]);
                if (!Debug) continue;
                MainWin.appendToLog("TWhoIs", "getArinWhoIs", Thread.currentThread(), null, 3, "Adding property: " + string2 + ", " + stringArray2[1]);
            }
        } else {
            if (Debug) {
                MainWin.appendToLog("TWhoIs", "getArinWhoIs", Thread.currentThread(), null, 3, "Parsing summary reply");
            }
            for (n = 1; n < stringArray.length; ++n) {
                String[] stringArray3;
                if (stringArray[n].trim().length() <= 0 || stringArray[n].charAt(0) == '#' || stringArray[n].startsWith("Process completed") || (stringArray3 = charutil.getSubStringArray(stringArray[n], '-', true)) == null || !netutil.isValidIPAddress(stringArray3[0])) continue;
                String string3 = stringArray3.length == 1 ? stringArray3[0] : stringArray3[0] + " - " + stringArray3[1];
                properties.put("WHOISNETRANGE", string3);
                if (Debug) {
                    MainWin.appendToLog("TWhoIs", "getArinWhoIs", Thread.currentThread(), null, 3, "Adding property: WhoIsNetRange, " + string3);
                }
                stringArray3 = charutil.getSubStringArray(stringArray[n - 1], '(', true);
                properties.put("WHOISORGNAME", stringArray3[0]);
                if (!Debug) continue;
                MainWin.appendToLog("TWhoIs", "getArinWhoIs", Thread.currentThread(), null, 3, "Adding property: WhoIsOrgName, " + stringArray3[1]);
            }
        }
        return properties;
    }

    private static Properties getApnicWhoIs(String string) {
        int n;
        String[] stringArray;
        if (Debug) {
            MainWin.appendToLog("TWhoIs", "getApnicWhoIs", Thread.currentThread(), null, 3, "Doing APNIC WhoIs");
        }
        if ((stringArray = TWhoIs.getDataFromServer("whois.apnic.net", 43, string)) == null) {
            return null;
        }
        Properties properties = new Properties();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        StringBuilder stringBuilder = new StringBuilder();
        for (n = 0; n < stringArray.length; ++n) {
            stringBuilder.append(stringArray[n] + "\r\n");
        }
        properties.put("WhoIsDetails", stringBuilder.toString());
        hashtable.put("DESCR", "OrgName");
        hashtable.put("NETNAME", "OrgID");
        hashtable.put("INETNUM", "NetRange");
        hashtable.put("PHONE", "RTechPhone");
        hashtable.put("E-MAIL", "RTechEmail");
        for (n = 0; n < stringArray.length; ++n) {
            String[] stringArray2;
            if (stringArray[n].trim().length() <= 0 || stringArray[n].charAt(0) == '#' || stringArray[n].startsWith("Process completed") || (stringArray2 = charutil.getSubStringArray(stringArray[n], ':', true)) == null || stringArray2.length <= 1) continue;
            String string2 = stringArray2[0];
            String string3 = (String)hashtable.get(string2.toUpperCase());
            if (string3 != null) {
                string2 = string3;
            }
            if (properties.getProperty((string2 = "WhoIs" + string2).toUpperCase()) == null) {
                properties.put(string2.toUpperCase(), stringArray2[1]);
            }
            if (!Debug) continue;
            MainWin.appendToLog("TWhoIs", "getApnicWhoIs", Thread.currentThread(), null, 3, "Adding property: " + string2 + ", " + stringArray2[1]);
        }
        return properties;
    }

    private static Properties getKornetWhoIs(String string) {
        int n;
        String[] stringArray;
        if (Debug) {
            MainWin.appendToLog("TWhoIs", "getKornetWhoIs", Thread.currentThread(), null, 3, "Doing Kornet WhoIs");
        }
        if ((stringArray = TWhoIs.getDataFromServer("whois.nic.or.kr", 43, string)) == null) {
            return null;
        }
        Properties properties = new Properties();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        StringBuilder stringBuilder = new StringBuilder();
        for (n = 0; n < stringArray.length; ++n) {
            stringBuilder.append(stringArray[n] + "\r\n");
        }
        properties.put("WhoIsDetails", stringBuilder.toString());
        hashtable.put("ORG NAME", "OrgName");
        hashtable.put("CONNECT ISP NAME", "OrgID");
        hashtable.put("IPV4 ADDRESS", "NetRange");
        hashtable.put("PHONE", "RTechPhone");
        hashtable.put("E-MAIL", "RTechEmail");
        for (n = 0; n < stringArray.length; ++n) {
            String[] stringArray2;
            if (stringArray[n].trim().length() <= 0 || stringArray[n].charAt(0) == '#' || stringArray[n].startsWith("Process completed") || (stringArray2 = charutil.getSubStringArray(stringArray[n], ':', true)) == null || stringArray2.length <= 1) continue;
            String string2 = stringArray2[0];
            String string3 = (String)hashtable.get(string2.toUpperCase());
            if (string3 != null) {
                string2 = string3;
            }
            if (properties.getProperty((string2 = "WhoIs" + string2).toUpperCase()) == null) {
                properties.put(string2.toUpperCase(), stringArray2[1]);
            }
            if (!Debug) continue;
            MainWin.appendToLog("TWhoIs", "getKornetWhoIs", Thread.currentThread(), null, 3, "Adding property: " + string2 + ", " + stringArray2[1]);
        }
        return properties;
    }

    private static Properties getRipeWhoIs(String string) {
        int n;
        String[] stringArray;
        if (Debug) {
            MainWin.appendToLog("TWhoIs", "getRipeWhoIs", Thread.currentThread(), null, 3, "Doing Ripe WhoIs");
        }
        if ((stringArray = TWhoIs.getDataFromServer("whois.ripe.net", 43, string)) == null) {
            return null;
        }
        Properties properties = new Properties();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        StringBuilder stringBuilder = new StringBuilder();
        for (n = 0; n < stringArray.length; ++n) {
            stringBuilder.append(stringArray[n] + "\r\n");
        }
        properties.put("WhoIsDetails", stringBuilder.toString());
        hashtable.put("DESCR", "OrgName");
        hashtable.put("NETNAME", "OrgID");
        hashtable.put("INETNUM", "NetRange");
        for (n = 0; n < stringArray.length; ++n) {
            String[] stringArray2;
            if (stringArray[n].trim().length() <= 0 || stringArray[n].charAt(0) == '#' || stringArray[n].startsWith("Process completed") || (stringArray2 = charutil.getSubStringArray(stringArray[n], ':', true)) == null || stringArray2.length <= 1) continue;
            String string2 = stringArray2[0];
            String string3 = (String)hashtable.get(string2.toUpperCase());
            if (string3 != null) {
                string2 = string3;
            }
            if (properties.getProperty((string2 = "WhoIs" + string2).toUpperCase()) == null) {
                properties.put(string2.toUpperCase(), stringArray2[1]);
            }
            if (!Debug) continue;
            MainWin.appendToLog("TWhoIs", "getRipeWhoIs", Thread.currentThread(), null, 3, "Adding property: " + string2 + ", " + stringArray2[1]);
        }
        return properties;
    }
}

