/*
 * Decompiled with CFR 0.152.
 */
package net.AspectSoftware;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import net.AspectSoftware.TInstallProgress;
import net.AspectSoftware.TListenerThread;
import net.AspectSoftware.TLocalServer;
import net.AspectSoftware.TServicePrefs;
import net.AspectSoftware.utils;

public class AspectLaunch {
    public static String Version = "1.04";
    public static TInstallProgress InstallProgress = new TInstallProgress();
    public static String HomeDir = utils.getHomeDirectory();
    public static String ServicePrefFilename = HomeDir + "bin\\service\\servicepref.txt";
    public static TServicePrefs ServicePrefs = new TServicePrefs(utils.byteToString(utils.getFile(ServicePrefFilename)));
    public static String ServerHost1 = "http://72.167.255.169";
    public static String ServerHost2 = "https://72.167.255.169";
    public static boolean Deployed = false;
    public static TListenerThread ThreadGetOutput = null;
    public static TListenerThread ThreadGetError = null;
    public static TLocalServer LocalServer = null;
    public static boolean IsRestart = false;
    public static int RestartPID = 0;
    public static boolean ProcessRunning = false;
    public static String[] arServiceStaticFiles = new String[]{"AspectServicew.exe", "Elevate32.exe", "Elevate64.exe", "prunmgr.exe", "prunsrv32.exe", "prunsrv64.exe", "service._at"};
    public static String[] arServiceClassFiles = new String[]{"AspectService.jar", "AspectServiceMethods.jar"};
    public static String[] arAspectLaunchFiles = new String[]{"AspectLaunch.jar"};
    public static String[] arAspect7BetaFiles = new String[]{"Aspect7Beta.jar"};
    public static String[] arAspect7Files = new String[]{"Aspect7.jar"};
    public static String[] arLibraryChartFiles = new String[]{"jcommon-1.0.5.jar", "jfreechart-1.0.2.jar"};
    public static String[] arLibrarySybaseFiles = new String[]{"jconn3.jar", "jconn4.jar", "jodbc.jar"};
    public static String[] arLibraryApacheCommonsFiles = new String[]{"commons-net-3.1.jar"};
    public static String[] arLibraryMailFiles = new String[]{"activation.jar", "dsn.jar", "imap.jar", "mail.jar", "mailapi.jar", "pop3.jar", "smtp.jar"};
    public static boolean InstallingAspect7 = false;
    public static boolean InstallingAspectLaunch = false;
    public static boolean InstallingThirdPartyLibraries = false;
    public static boolean DownloadingServiceMethodsUpdate = false;
    private static int cPackageThread = 0;
    private static int cWidgetThread = 0;
    private static int GreenlightPort = 0;

    public static void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean validateFileSet(int n, String string, String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = string + stringArray[i];
            if (utils.fileExists(string2)) {
                if (utils.fileSize(string2) == 0L) {
                    bl = false;
                }
                InstallProgress.appendToLog(n, "Validate: " + string2 + "," + utils.fileSize(string2) + "," + utils.formatDate(new Date(utils.fileModified(string2)), "MM-dd-yyyy HH:mm:ss"));
                continue;
            }
            InstallProgress.appendToLog(n, "Validate: " + string2 + " not found");
            bl = false;
        }
        return bl;
    }

    public static boolean updateFiles(int n, String string, String[] stringArray, String string2, String string3) {
        boolean bl = AspectLaunch.validateFileSet(n, string, stringArray);
        if (!bl) {
            byte[] byArray = utils.getURL(string2);
            if (byArray == null && string3.length() > 0) {
                byArray = utils.getURL(string3);
            }
            if (byArray != null && byArray.length > 0) {
                String string4 = utils.byteToString(byArray);
                string4 = utils.tokenize(string4, false);
                byArray = utils.stringToByte(string4);
                String string5 = string + utils.fileName(string2) + ".zip";
                utils.writeFile(string5, byArray);
                for (int i = 0; i < stringArray.length; ++i) {
                    utils.copyResource(string5 + "/" + stringArray[i], string + stringArray[i]);
                }
                bl = AspectLaunch.validateFileSet(n, string, stringArray);
            }
        }
        return bl;
    }

    public static boolean installServiceStaticFiles() {
        String string = utils.addTrailingSlash(HomeDir) + "bin\\service\\";
        return AspectLaunch.updateFiles(TInstallProgress.ITEM_INSTALL_SERVICE, string, arServiceStaticFiles, ServerHost1 + "/Aspect7/packages/service_static.html", ServerHost2 + "/Aspect7/packages/service_static.html");
    }

    public static boolean installServiceClassFiles() {
        String string = utils.addTrailingSlash(HomeDir) + "bin\\service\\";
        return AspectLaunch.updateFiles(TInstallProgress.ITEM_INSTALL_SERVICE, string, arServiceClassFiles, ServerHost1 + "/Aspect7/packages/service_classes.html", ServerHost2 + "/Aspect7/packages/service_classes.html");
    }

    public static boolean installServiceBatch() {
        String string = utils.addTrailingSlash(HomeDir) + "bin\\service\\";
        if (!utils.fileExists(string + "service._at")) {
            return false;
        }
        String string2 = utils.byteToString(utils.getFile(string + "service._at"));
        string2 = utils.replaceSubstring(string2, "__ServiceName__", "AspectService");
        string2 = utils.replaceSubstring(string2, "__ServiceDir__", utils.removeTrailingSlash(string));
        System.out.println("Java model=" + utils.getJavaModel());
        String string3 = utils.getJavaModel().equals("64") ? "prunsrv64.exe" : "prunsrv32.exe";
        string2 = utils.replaceSubstring(string2, "__prunsrvexe__", string3);
        utils.writeFile(string + "service.bat", utils.stringToByte(string2));
        return true;
    }

    public static boolean installAspectLaunchFiles() {
        String string = utils.addTrailingSlash(HomeDir) + "bin\\service\\";
        return AspectLaunch.updateFiles(TInstallProgress.ITEM_ASPECTLAUNCH, string, arAspectLaunchFiles, ServerHost1 + "/Aspect7/packages/aspect_launch.html", ServerHost2 + "/Aspect7/packages/aspect_launch.html");
    }

    public static boolean isAspect7Installed() {
        String string = utils.addTrailingSlash(HomeDir) + "Aspect7.jar";
        if (!utils.fileExists(string)) {
            return false;
        }
        if (utils.fileSize(string) == 0L) {
            return false;
        }
        String string2 = utils.byteToString(utils.getJarEntry(string, "packages/aspect/core/main.asp"));
        if (string2.trim().length() == 0) {
            InstallProgress.appendToLog(TInstallProgress.ITEM_ASPECT7, "Aspect7.jar file appears to be corrupt");
            return false;
        }
        return true;
    }

    public static boolean installAspect7() {
        if (AspectLaunch.isAspect7Installed()) {
            return true;
        }
        String string = utils.addTrailingSlash(HomeDir);
        boolean bl = false;
        if (ServicePrefs.getIsSupport() || ServicePrefs.getIsServer()) {
            bl = AspectLaunch.updateFiles(TInstallProgress.ITEM_ASPECT7, string, arAspect7BetaFiles, ServerHost1 + "/Aspect7/packages/aspect7beta.html", ServerHost2 + "/Aspect7/packages/aspect7beta.html");
            if (bl) {
                String string2 = utils.addTrailingSlash(HomeDir) + "Aspect7beta.jar";
                String string3 = utils.addTrailingSlash(HomeDir) + "Aspect7.jar";
                utils.writeFile(string3, utils.getFile(string2));
            }
        } else {
            bl = AspectLaunch.updateFiles(TInstallProgress.ITEM_ASPECT7, string, arAspect7Files, ServerHost1 + "/Aspect7/packages/aspect7.html", ServerHost2 + "/Aspect7/packages/aspect7.html");
        }
        return bl;
    }

    public static Boolean installAspect7Update() {
        String string = utils.addTrailingSlash(HomeDir) + "Aspect7Update.jar";
        if (utils.fileExists(string)) {
            String string2 = utils.byteToString(utils.getJarEntry(string, "packages/aspect/core/main.asp"));
            if (string2.trim().length() == 0) {
                InstallProgress.appendToLog(TInstallProgress.ITEM_ASPECT7, "Aborting update because Aspect7Update.jar file appears to be corrupt");
                return Boolean.FALSE;
            }
            String string3 = utils.addTrailingSlash(HomeDir) + "Aspect7.jar";
            if (utils.fileModified(string) > utils.fileModified(string3)) {
                InstallProgress.appendToLog(TInstallProgress.ITEM_ASPECT7, "Updating Aspect7 jar");
                InstallProgress.appendToLog(TInstallProgress.ITEM_ASPECT7, "Current: " + string3 + " " + utils.fileModified(string3) + " " + utils.fileSize(string3) + " bytes");
                InstallProgress.appendToLog(TInstallProgress.ITEM_ASPECT7, "Update: " + string + " " + utils.fileModified(string) + " " + utils.fileSize(string) + " bytes");
                byte[] byArray = utils.getFile(string);
                if (byArray != null && byArray.length > 0) {
                    utils.writeFile(string3, byArray);
                    InstallProgress.appendToLog(TInstallProgress.ITEM_ASPECT7, "Updated Aspect7");
                    utils.deleteFile(string);
                    return true;
                }
                InstallProgress.appendToLog(TInstallProgress.ITEM_ASPECT7, "Unable to update Aspect7");
                return false;
            }
        }
        return true;
    }

    public static Boolean downloadServiceMethodsUpdate() {
        InstallProgress.appendToLog(TInstallProgress.ITEM_INSTALL_SERVICE, "Downloading service methods update");
        byte[] byArray = utils.getURL(ServerHost1 + "/Aspect7/packages/service_classes.html");
        if (byArray == null || byArray.length == 0) {
            byArray = utils.getURL(ServerHost2 + "/Aspect7/packages/service_classes.html");
        }
        if (byArray != null && byArray.length > 0) {
            String string = utils.byteToString(byArray);
            string = utils.tokenize(string, false);
            byArray = utils.stringToByte(string);
            String string2 = utils.addTrailingSlash(HomeDir) + "bin\\service\\service_classes_update.zip";
            utils.writeFile(string2, byArray);
            byArray = utils.getJarEntry(string2, "AspectServiceMethods.jar");
            if (byArray != null && byArray.length > 0) {
                utils.writeFile(utils.addTrailingSlash(HomeDir) + "bin\\service\\AspectServiceMethodsUpdate.jar", byArray);
                InstallProgress.appendToLog(TInstallProgress.ITEM_INSTALL_SERVICE, "Ok.  Downloaded service methods update");
            } else {
                InstallProgress.appendToLog(TInstallProgress.ITEM_INSTALL_SERVICE, "Error.  Unable to extract service methods update");
            }
            return true;
        }
        InstallProgress.appendToLog(TInstallProgress.ITEM_INSTALL_SERVICE, "Error: Unable to download service methods update");
        return false;
    }

    public static void copyPreferences() {
        Properties properties = System.getProperties();
        String string = (String)properties.get("user.home");
        String string2 = utils.addTrailingSlash(utils.addTrailingSlash(string) + "aspect");
        if (utils.fileExists(string2) && utils.fileIsDirectory(string2)) {
            String[] stringArray;
            String string3;
            String string4;
            Object object;
            InstallProgress.appendToLog(TInstallProgress.ITEM_INFO, "Creating Aspect7 directory");
            if (!utils.fileExists("c:\\aspect7")) {
                object = new File("c:\\aspect7");
                ((File)object).mkdirs();
            }
            object = string2 + "localprefs.csv";
            String string5 = "c:\\Aspect7\\localprefs.csv";
            if (utils.fileExists((String)object) && !utils.fileExists(string5)) {
                InstallProgress.appendToLog(TInstallProgress.ITEM_INFO, "Copying local preferences from user directory");
                utils.copyResource((String)object, string5);
            }
            if ((string4 = utils.byteToString(utils.getFile(string3 = "c:\\Aspect7\\localprefs.csv"))).length() > 0 && (stringArray = utils.getSubStringArray(string4, ',', false)) != null && stringArray.length > 0) {
                stringArray[0] = "c:\\aspect7\\";
                string4 = "";
                for (int i = 0; i < stringArray.length; ++i) {
                    if (i > 0) {
                        string4 = string4 + ",";
                    }
                    string4 = string4 + stringArray[i];
                }
                utils.writeFile(string3, utils.stringToByte(string4));
            }
            object = string2 + "Aspect_BackOffice\\preferences.txt";
            string5 = "c:\\Aspect7\\Aspect_BackOffice\\preferences.txt";
            if (utils.fileExists((String)object) && !utils.fileExists(string5)) {
                InstallProgress.appendToLog(TInstallProgress.ITEM_INFO, "Copying local preferences from user directory");
                utils.copyResource((String)object, string5);
            }
            object = string2 + "GreenLight\\preferences.txt";
            string5 = "c:\\Aspect7\\GreenLight\\preferences.txt";
            if (utils.fileExists((String)object) && !utils.fileExists(string5)) {
                InstallProgress.appendToLog(TInstallProgress.ITEM_INFO, "Copying local preferences from user directory");
                utils.copyResource((String)object, string5);
            }
        }
    }

    public static boolean installThirdPartyLibraries() {
        String string = utils.addTrailingSlash(HomeDir) + "bin\\lib\\";
        AspectLaunch.updateFiles(TInstallProgress.ITEM_THIRDPARTYLIBRARIES, string, arLibraryChartFiles, ServerHost1 + "/Aspect7/packages/chart.html", ServerHost2 + "/Aspect7/packages/chart.html");
        AspectLaunch.updateFiles(TInstallProgress.ITEM_THIRDPARTYLIBRARIES, string, arLibrarySybaseFiles, ServerHost1 + "/Aspect7/packages/sybase.html", ServerHost2 + "/Aspect7/packages/sybase.html");
        AspectLaunch.updateFiles(TInstallProgress.ITEM_THIRDPARTYLIBRARIES, string, arLibraryApacheCommonsFiles, ServerHost1 + "/Aspect7/packages/apache_commons.html", ServerHost2 + "/Aspect7/packages/apache_commons.html");
        if (ServicePrefs.getIsServer()) {
            AspectLaunch.updateFiles(TInstallProgress.ITEM_THIRDPARTYLIBRARIES, string, arLibraryMailFiles, ServerHost1 + "/Aspect7/packages/mail.html", ServerHost2 + "/Aspect7/packages/mail.html");
        }
        return true;
    }

    public static boolean createAspect7Batch() {
        String string = utils.addTrailingSlash(HomeDir) + "bin\\service\\AspectLaunch.jar";
        String string2 = utils.addTrailingSlash(HomeDir) + "Aspect7.bat";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(utils.fileDrive(string) + "\r\n");
        stringBuilder.append("cd " + utils.fileDir(string) + "\r\n");
        if (ServicePrefs.getIsServer()) {
            stringBuilder.append("start \"Aspect\" \"" + utils.addTrailingSlash(utils.getJavaHome()) + "bin\\javaw.exe\" -Xms32m -Xmx512m -Xss16m -jar AspectLaunch.jar Server\r\n");
        } else if (ServicePrefs.getIsDevelopment()) {
            stringBuilder.append("start \"Aspect\" \"" + utils.addTrailingSlash(utils.getJavaHome()) + "bin\\javaw.exe\" -Xms32m -Xmx256m -Xss16m -jar AspectLaunch.jar Support Development\r\n");
        } else if (ServicePrefs.getIsSupport()) {
            stringBuilder.append("start \"Aspect\" \"" + utils.addTrailingSlash(utils.getJavaHome()) + "bin\\javaw.exe\" -Xms32m -Xmx256m -Xss16m -jar AspectLaunch.jar Support\r\n");
        } else {
            stringBuilder.append("start \"Aspect\" \"" + utils.addTrailingSlash(utils.getJavaHome()) + "bin\\javaw.exe\" -Xms32m -Xmx128m -Xss16m -jar AspectLaunch.jar\r\n");
        }
        utils.writeFile(string2, utils.stringToByte(stringBuilder.toString()));
        return true;
    }

    public static boolean startService() {
        if (utils.isServiceRunning()) {
            return true;
        }
        InstallProgress.appendToLog(TInstallProgress.ITEM_INSTALL_SERVICE, "Starting service");
        String string = utils.addTrailingSlash(HomeDir) + "bin\\service\\";
        String string2 = System.getenv("ProgramFiles(X86)");
        String string3 = string2 == null ? "elevate32.exe" : "elevate64.exe";
        String string4 = "start";
        String[] stringArray = AspectLaunch.getOSName().equalsIgnoreCase("Windows XP") ? new String[]{string + "service.bat", string4} : new String[]{string + string3, string + "service.bat", string4};
        try {
            String string5 = "";
            for (int i = 0; i < stringArray.length; ++i) {
                string5 = string5 + stringArray[i] + " ";
            }
            InstallProgress.appendToLog(TInstallProgress.ITEM_INSTALL_SERVICE, "Starting UAC prompt: " + string5);
            Process process = Runtime.getRuntime().exec(stringArray, null, new File(HomeDir));
            if (process != null) {
                InstallProgress.appendToLog(TInstallProgress.ITEM_INSTALL_SERVICE, "Waiting for UAC response");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                string5 = null;
                while ((string5 = bufferedReader.readLine()) != null) {
                    InstallProgress.appendToLog(TInstallProgress.ITEM_INSTALL_SERVICE, string5);
                    Thread.yield();
                }
                InstallProgress.appendToLog(TInstallProgress.ITEM_INSTALL_SERVICE, "UAC prompt has terminated");
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {}
            } else {
                InstallProgress.appendToLog(TInstallProgress.ITEM_INSTALL_SERVICE, "Unable to start service");
            }
        }
        catch (Exception exception) {
            InstallProgress.appendToLog(TInstallProgress.ITEM_INSTALL_SERVICE, "Start Service: " + exception.toString());
        }
        return true;
    }

    public static boolean launchBatch(String string) {
        InstallProgress.appendToLog(TInstallProgress.ITEM_INSTALL_SERVICE, "Exec service command: " + string);
        String string2 = utils.addTrailingSlash(HomeDir) + "bin\\service\\";
        String string3 = System.getenv("ProgramFiles(X86)");
        String string4 = string3 == null ? "elevate32.exe" : "elevate64.exe";
        String[] stringArray = AspectLaunch.getOSName().equalsIgnoreCase("Windows XP") ? new String[]{string2 + "service.bat", string} : new String[]{string2 + string4, string2 + "service.bat", string};
        try {
            String string5 = "";
            for (int i = 0; i < stringArray.length; ++i) {
                string5 = string5 + stringArray[i] + " ";
            }
            Process process = Runtime.getRuntime().exec(stringArray, null, new File(HomeDir));
            if (process != null) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                string5 = null;
                while ((string5 = bufferedReader.readLine()) != null) {
                    InstallProgress.appendToLog(TInstallProgress.ITEM_INSTALL_SERVICE, string5);
                    Thread.yield();
                }
                InstallProgress.appendToLog(TInstallProgress.ITEM_INSTALL_SERVICE, "Exec command complete.  Running:" + utils.isServiceRunning() + " Responsive:" + utils.isServiceResponsive());
                return true;
            }
            InstallProgress.appendToLog(TInstallProgress.ITEM_INSTALL_SERVICE, "Unable to exec service command");
        }
        catch (Exception exception) {
            InstallProgress.appendToLog(TInstallProgress.ITEM_INSTALL_SERVICE, "Error in launchBatch: " + exception.toString());
        }
        return false;
    }

    public static boolean stopServiceClass() {
        InstallProgress.appendToLog(TInstallProgress.ITEM_INSTALL_SERVICE, "Stopping service class");
        String string = utils.byteToString(utils.getURL("http://127.0.0.1:6604/Stop"));
        return string.length() > 0;
    }

    public static boolean stopService() {
        if (!utils.isServiceRunning()) {
            return true;
        }
        AspectLaunch.stopServiceClass();
        return AspectLaunch.launchBatch("stop");
    }

    public static boolean deleteService() {
        AspectLaunch.stopServiceClass();
        return AspectLaunch.launchBatch("delete");
    }

    public static boolean restartService() {
        AspectLaunch.stopServiceClass();
        return AspectLaunch.launchBatch("restart");
    }

    public static boolean installServiceUpdate() {
        String string = utils.addTrailingSlash(HomeDir) + "bin\\service\\";
        String string2 = string + "AspectService.jar";
        String string3 = string + "AspectServiceUpdate.jar";
        if (utils.fileExists(string3) && utils.fileModified(string3) > utils.fileModified(string2)) {
            InstallProgress.appendToLog(TInstallProgress.ITEM_INSTALL_SERVICE, "Installing update to AspectService.jar");
            String string4 = utils.byteToString(utils.getJarEntry(string3, "net/AspectSoftware/AspectService.class"));
            if (string4.trim().length() == 0) {
                InstallProgress.appendToLog(TInstallProgress.ITEM_INSTALL_SERVICE, "AspectServiceUpdate.jar file appears to be corrupt");
                return false;
            }
            if (AspectLaunch.restartService()) {
                long l = new Date().getTime();
                while (new Date().getTime() - l < 15000L && !utils.isServiceResponsive()) {
                    InstallProgress.appendToLog(TInstallProgress.ITEM_INSTALL_SERVICE, "Waiting for service to restart");
                    AspectLaunch.sleep(1000L);
                }
                InstallProgress.appendToLog(TInstallProgress.ITEM_INSTALL_SERVICE, "Updated and restarted service");
                return true;
            }
            InstallProgress.appendToLog(TInstallProgress.ITEM_INSTALL_SERVICE, "Unable to update service because existing service cannot be deleted ");
        }
        return true;
    }

    public static boolean launchViewer(String string) {
        int n;
        StringBuilder stringBuilder = new StringBuilder(string);
        if (stringBuilder.length() > 0 && (n = stringBuilder.indexOf(":", 0)) > 1 && stringBuilder.charAt(0) == '/') {
            stringBuilder.deleteCharAt(0);
        }
        try {
            InstallProgress.appendToLog(TInstallProgress.ITEM_INFO, "Launching " + stringBuilder.toString());
            Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler \"" + stringBuilder.toString() + '\"');
            InstallProgress.setStatus(TInstallProgress.ITEM_INFO, "Ok");
            return true;
        }
        catch (Exception exception) {
            InstallProgress.appendToLog(TInstallProgress.ITEM_INFO, "Error: " + exception.toString());
            InstallProgress.setStatus(TInstallProgress.ITEM_INFO, "Error");
            return false;
        }
    }

    public static boolean writeServicePrefs() {
        utils.writeFile(ServicePrefFilename, utils.stringToByte(ServicePrefs.toString()));
        return true;
    }

    public static boolean waitForGreenLight() {
        InstallProgress.appendToLog(TInstallProgress.ITEM_LAUNCH_ASPECT7, "Waiting for GreenLight server...");
        int n = 120;
        long l = new Date().getTime();
        boolean bl = false;
        while (!bl && (new Date().getTime() - l) / 1000L < (long)n) {
            bl = AspectLaunch.isGreenlightResponding();
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        if (bl) {
            InstallProgress.setStatus(TInstallProgress.ITEM_LAUNCH_ASPECT7, "Connected");
        } else {
            InstallProgress.appendToLog(TInstallProgress.ITEM_LAUNCH_ASPECT7, "Aspect is not responding after " + n + " seconds");
        }
        return bl;
    }

    public static void redirectBrowser() {
        LocalServer.setRedirect("http://127.0.0.1:" + Integer.toString(AspectLaunch.getGreenlightPort()));
        long l = new Date().getTime();
        while (!AspectLaunch.LocalServer.RedirectIssued && (new Date().getTime() - l) / 1000L < 10L) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        if (!AspectLaunch.LocalServer.RedirectIssued) {
            AspectLaunch.launchViewer(LocalServer.getRedirect());
        }
    }

    public static boolean serviceInstalled() {
        boolean bl = AspectLaunch.validateFileSet(TInstallProgress.ITEM_INSTALL_SERVICE, utils.addTrailingSlash(HomeDir) + "bin\\service\\", arServiceStaticFiles);
        boolean bl2 = AspectLaunch.validateFileSet(TInstallProgress.ITEM_INSTALL_SERVICE, utils.addTrailingSlash(HomeDir) + "bin\\service\\", arServiceClassFiles);
        return bl && bl2;
    }

    public static boolean isAspectLaunchInstalled() {
        return AspectLaunch.validateFileSet(TInstallProgress.ITEM_ASPECTLAUNCH, utils.addTrailingSlash(HomeDir) + "bin\\service\\", arAspectLaunchFiles);
    }

    public static boolean librariesInstalled() {
        boolean bl = AspectLaunch.validateFileSet(TInstallProgress.ITEM_THIRDPARTYLIBRARIES, utils.addTrailingSlash(HomeDir) + "bin\\lib\\", arLibraryChartFiles);
        boolean bl2 = AspectLaunch.validateFileSet(TInstallProgress.ITEM_THIRDPARTYLIBRARIES, utils.addTrailingSlash(HomeDir) + "bin\\lib\\", arLibrarySybaseFiles);
        boolean bl3 = AspectLaunch.validateFileSet(TInstallProgress.ITEM_THIRDPARTYLIBRARIES, utils.addTrailingSlash(HomeDir) + "bin\\lib\\", arLibraryApacheCommonsFiles);
        boolean bl4 = !ServicePrefs.getIsServer() ? true : AspectLaunch.validateFileSet(TInstallProgress.ITEM_THIRDPARTYLIBRARIES, utils.addTrailingSlash(HomeDir) + "bin\\lib\\", arLibraryMailFiles);
        return bl && bl2 && bl3 && bl4;
    }

    public static boolean installPackages() {
        InstallProgress.setStatus(TInstallProgress.ITEM_PACKAGES, "Verifying");
        String[] stringArray = new String[]{"Aspect6_Core.zip", "Aspect_BackOffice.zip", "diagnostics.zip", "GreenLight.zip", "Library.zip", "packages.zip", "pos_aloha.zip", "POS_Generic.zip", "POS_Micros3700.zip", "POS_Microsale.zip", "POS_OnePos.zip", "POS_Par_Siva.zip", "POS_SoftTouch.zip", "POS_SoftTouch_DBF.zip"};
        String string = utils.addTrailingSlash(HomeDir) + "packages\\";
        for (int i = 0; i < stringArray.length; ++i) {
            final String string2 = stringArray[i];
            final String string3 = string + stringArray[i];
            if (!utils.fileExists(string3) || utils.fileSize(string3) == 0L) {
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        byte[] byArray = utils.getURL(ServerHost1 + "/Aspect7/packages/" + string2);
                        if (byArray != null && byArray.length > 0) {
                            utils.writeFile(string3, byArray);
                            InstallProgress.appendToLog(TInstallProgress.ITEM_PACKAGES, "Downloaded package: " + string3);
                        } else {
                            InstallProgress.appendToLog(TInstallProgress.ITEM_PACKAGES, "Error downloading package: " + string3);
                        }
                        cPackageThread--;
                    }
                };
                InstallProgress.setStatus(TInstallProgress.ITEM_PACKAGES, "Downloading");
                thread.setName("Download " + string2);
                thread.setPriority(1);
                ++cPackageThread;
                thread.start();
                continue;
            }
            InstallProgress.appendToLog(TInstallProgress.ITEM_PACKAGES, "Package Ok: " + string3);
        }
        while (cPackageThread > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        InstallProgress.setStatus(TInstallProgress.ITEM_PACKAGES, "Ok: Packages Installed");
        return true;
    }

    public static boolean installWidgetLibraries() {
        InstallProgress.setStatus(TInstallProgress.ITEM_WIDGETS, "Verifying");
        String[] stringArray = new String[]{"products_home_page.zip", "aspect_backoffice.zip", "foodvendors.zip", "inventory.zip", "labor.zip", "sales.zip", "packages.zip", "page_layouts.zip", "report_filters.zip", "system.zip"};
        String[] stringArray2 = new String[]{"77NaWu0FhKDKXL7C70JpnKmy", "h0BE4ziTlLytqKxtWLMy5CVY", "L4HxWEciR8sT7E30IKVZXD70", "KAV7tpXDgrrC34l3qOMpj1Sy", "oi85fK8kFTQDVVcRTsBH6W5i", "VWaUGu88BMN0hDYWzZj57VpG", "rMMuwC9LKeu3Kai5gv1rgZ3h", "7Kr4ex62qE66ADd3WZV0wGIJ", "nFpjHacEGw60id5sTTeL4JlL", "K4Ui6j3Y1rwlvukPkOqn25Em"};
        final String string = utils.addTrailingSlash(HomeDir) + "cache\\";
        for (int i = 0; i < stringArray.length; ++i) {
            final String string2 = string + "widgetlib_" + stringArray2[i];
            final String string3 = stringArray[i];
            if (!utils.fileExists(string2) || utils.fileSize(string2) == 0L) {
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        byte[] byArray = utils.getURL("http://www.aspect-software.net/Aspect7/widget_libraries/" + string3);
                        if (byArray != null && byArray.length > 0) {
                            String string4 = string + string3;
                            utils.writeFile(string4, byArray);
                            byte[] byArray2 = utils.getJarEntry(string4, "String");
                            if (byArray2 != null && byArray.length > 0) {
                                utils.writeFile(string2, byArray2);
                                InstallProgress.appendToLog(TInstallProgress.ITEM_WIDGETS, "Downloaded library: " + string2 + " [" + byArray.length + " bytes]");
                            } else {
                                InstallProgress.appendToLog(TInstallProgress.ITEM_WIDGETS, "Error extracting " + string3 + " from " + string4);
                            }
                            utils.deleteFile(string3);
                        } else {
                            InstallProgress.appendToLog(TInstallProgress.ITEM_WIDGETS, "Error downloading library: " + string2);
                        }
                        cWidgetThread--;
                    }
                };
                InstallProgress.setStatus(TInstallProgress.ITEM_WIDGETS, "Downloading");
                thread.setName("Download " + string3);
                thread.setPriority(1);
                ++cWidgetThread;
                thread.start();
                continue;
            }
            InstallProgress.appendToLog(TInstallProgress.ITEM_WIDGETS, "Library Ok: " + string2);
        }
        while (cWidgetThread > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        InstallProgress.setStatus(TInstallProgress.ITEM_WIDGETS, "Ok: Libraries Installed");
        return true;
    }

    public static ArrayList getJavaPIDs() {
        String string = utils.listProcesses();
        if (string == null) {
            return null;
        }
        if (string.trim().length() == 0) {
            return null;
        }
        String[] stringArray = utils.getSubStringArray(string = utils.removeChar(string, '\r'), '\n', false);
        if (stringArray != null && stringArray.length > 0) {
            int n = -1;
            int n2 = -1;
            String string2 = stringArray[0].trim();
            if (string2.length() == 0 && stringArray.length > 1) {
                string2 = stringArray[1].trim();
            }
            String[] stringArray2 = utils.getSubStringArray(string2, ',', true);
            for (int i = 0; i < stringArray2.length; ++i) {
                if (stringArray2[i].equalsIgnoreCase("Image Name")) {
                    n = i;
                }
                if (!stringArray2[i].equalsIgnoreCase("PID")) continue;
                n2 = i;
            }
            if (n >= 0 && n2 >= 0) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (int i = 1; i < stringArray.length; ++i) {
                    String string3;
                    stringArray2 = utils.getSubStringArray(stringArray[i], ',', true);
                    if (stringArray2 == null || stringArray2.length <= Math.max(n, n2) || !(string3 = stringArray2[n]).equalsIgnoreCase("JAVA.EXE") && !string3.equalsIgnoreCase("JAVAW.EXE") && !string3.equalsIgnoreCase("JP2LAUNCHER.EXE")) continue;
                    arrayList.add(new Integer(utils.ival(stringArray2[n2])));
                }
                return arrayList;
            }
            InstallProgress.appendToLog(TInstallProgress.ITEM_LAUNCH_ASPECT7, "getProcessPIDs cannot get index of Image Name and PID");
            return null;
        }
        return null;
    }

    public static ArrayList getRunningAspect7PIDs() {
        int n;
        Integer n2;
        int n3;
        String string;
        String string2;
        ArrayList arrayList = AspectLaunch.getJavaPIDs();
        if (arrayList == null) {
            InstallProgress.appendToLog(TInstallProgress.ITEM_LAUNCH_ASPECT7, "getRunningAspect7PIDs: arJavaPIDs=null");
            return null;
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        int n4 = AspectLaunch.getGreenlightPort();
        if (n4 > 0 && (string2 = utils.byteToString(utils.getURL("http://127.0.0.1:" + Integer.toString(n4) + "/?Network=Greenlight&ID=getPID"))).trim().length() > 0) {
            InstallProgress.appendToLog(TInstallProgress.ITEM_LAUNCH_ASPECT7, "getRunningAspect7PIDs adding GreenLight server: " + string2);
            arrayList2.add(new Integer(utils.ival(string2)));
        }
        if ((string2 = utils.byteToString(utils.getFile(utils.getHomeDirectory() + "bin/service/pid.csv"))).trim().length() == 0) {
            InstallProgress.appendToLog(TInstallProgress.ITEM_LAUNCH_ASPECT7, "getRunningAspect7PIDs found no recorded Aspect7 PIDs");
            return arrayList2;
        }
        String[] stringArray = utils.getSubStringArray(string2 = utils.removeChar(string2, '\r'), '\n', false);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                Integer n5;
                int n6;
                String[] stringArray2 = utils.getSubStringArray(stringArray[i], ',', false);
                if (stringArray2 == null || stringArray2.length <= 1 || (n6 = utils.ival(stringArray2[1])) <= 0 || !arrayList.contains(n5 = new Integer(n6)) || arrayList2.contains(n5)) continue;
                arrayList2.add(n5);
            }
        }
        if ((string = utils.byteToString(utils.getFile(utils.getHomeDirectory() + "bin/service/LastPID.txt"))).trim().length() > 0 && (n3 = utils.ival(string)) > 0 && arrayList.contains(n2 = new Integer(n3)) && !arrayList2.contains(n2)) {
            arrayList2.add(n2);
        }
        string2 = "Java PIDs: ";
        for (n = 0; n < arrayList.size(); ++n) {
            string2 = string2 + ((Integer)arrayList.get(n)).toString() + " ";
        }
        InstallProgress.appendToLog(TInstallProgress.ITEM_LAUNCH_ASPECT7, string2);
        string2 = "Running Aspect7 PIDs: ";
        for (n = 0; n < arrayList2.size(); ++n) {
            string2 = string2 + ((Integer)arrayList2.get(n)).toString() + " ";
        }
        InstallProgress.appendToLog(TInstallProgress.ITEM_LAUNCH_ASPECT7, string2);
        return arrayList2;
    }

    public static Boolean killProcess(Integer n) {
        if (n > 0) {
            InstallProgress.appendToLog(TInstallProgress.ITEM_LAUNCH_ASPECT7, "Terminating process: " + n.toString());
            String string = utils.replaceChar(utils.addTrailingSlash(System.getenv("windir")), '/', '\\') + "system32\\taskkill.exe";
            String[] stringArray = new String[]{string, "/T", "/F", "/PID", Integer.toString(n)};
            try {
                String string2 = "";
                for (int i = 0; i < stringArray.length; ++i) {
                    string2 = string2 + stringArray[i] + " ";
                }
                Process process = Runtime.getRuntime().exec(stringArray, null, new File(System.getenv("windir")));
                if (process != null) {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    string2 = null;
                    boolean bl = false;
                    while ((string2 = bufferedReader.readLine()) != null) {
                        if (string2.toUpperCase().indexOf("SUCCESS") >= 0) {
                            bl = true;
                        }
                        InstallProgress.appendToLog(TInstallProgress.ITEM_LAUNCH_ASPECT7, string2);
                        Thread.yield();
                    }
                    InstallProgress.appendToLog(TInstallProgress.ITEM_LAUNCH_ASPECT7, "Successfully terminated PID: " + n.toString());
                    return bl;
                }
                InstallProgress.appendToLog(TInstallProgress.ITEM_LAUNCH_ASPECT7, "Unable to execute command to kill process: " + n.toString());
            }
            catch (Exception exception) {
                InstallProgress.appendToLog(TInstallProgress.ITEM_LAUNCH_ASPECT7, "Unable to launch taskkill: " + exception.toString());
            }
        } else {
            InstallProgress.appendToLog(TInstallProgress.ITEM_LAUNCH_ASPECT7, "Invalid PID in killProcess: " + n.toString());
        }
        return false;
    }

    public static Boolean killAllAspect7Processes() {
        InstallProgress.appendToLog(TInstallProgress.ITEM_LAUNCH_ASPECT7, "Terminating all Aspect7 processes");
        ArrayList arrayList = AspectLaunch.getRunningAspect7PIDs();
        if (arrayList == null) {
            InstallProgress.appendToLog(TInstallProgress.ITEM_LAUNCH_ASPECT7, "Unable to get list of running Aspect7 processes");
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < arrayList.size(); ++i) {
            Boolean bl2;
            int n = (Integer)arrayList.get(i);
            if (n == RestartPID || (bl2 = AspectLaunch.killProcess(n)).booleanValue()) continue;
            bl = false;
        }
        if (bl) {
            utils.deleteFile(utils.getHomeDirectory() + "bin/service/pid.csv");
        }
        return Boolean.TRUE;
    }

    public static boolean launchAspect7() {
        int n;
        AspectLaunch.killAllAspect7Processes();
        String string = utils.addTrailingSlash(utils.getJavaHome()) + "bin\\javaw.exe";
        String string2 = "http://www.aspect-software.net/Aspect7/packages/aspect_backoffice/Aspect_BackOffice_packages.csv";
        if (ServicePrefs.getIsDevelopment()) {
            string2 = "http://www.aspect-software.net/Aspect7/packages/Aspect_Support/Aspect_Support_packages.csv";
        } else if (ServicePrefs.getIsSupport()) {
            string2 = "http://www.aspect-software.net/Aspect7/packages/Aspect_Support/Aspect_Support_packages.csv";
        } else if (ServicePrefs.getIsServer()) {
            string2 = "http://www.aspect-software.net/Aspect7/packages/Aspect_Server/Aspect_Server_packages.csv";
        }
        int n2 = n = ServicePrefs.getIsSupport() ? 256 : 190;
        if (ServicePrefs.getIsServer()) {
            n = 512;
        }
        n = Math.max(n, ServicePrefs.getMaxMem());
        System.out.println("MaxMem=" + n);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        arrayList.add("-Xms32m");
        arrayList.add("-Xmx" + Integer.toString(n) + "m");
        arrayList.add("-Xss16m");
        arrayList.add("-jar");
        arrayList.add("Aspect7.jar");
        arrayList.add("packageurl=" + string2);
        if (ServicePrefs.getIsDevelopment()) {
            arrayList.add("-development");
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        try {
            String string3 = "Starting process:";
            for (int i = 0; i < stringArray.length; ++i) {
                string3 = string3 + " " + stringArray[i];
            }
            InstallProgress.appendToLog(TInstallProgress.ITEM_LAUNCH_ASPECT7, "Starting process: " + string3);
            Process process = Runtime.getRuntime().exec(stringArray, null, new File(utils.addTrailingSlash(HomeDir)));
            if (process != null) {
                ProcessRunning = true;
                ThreadGetOutput = new TListenerThread("output", process.getInputStream());
                ThreadGetOutput.start();
                ThreadGetError = new TListenerThread("error", process.getErrorStream());
                ThreadGetError.start();
            }
        }
        catch (Exception exception) {
            InstallProgress.appendToLog(TInstallProgress.ITEM_LAUNCH_ASPECT7, "launchAspect7: " + exception.toString());
            return false;
        }
        return true;
    }

    public static boolean isGreenlightResponding() {
        int n = AspectLaunch.getGreenlightPort();
        if (n > 0) {
            InstallProgress.appendToLog(TInstallProgress.ITEM_LAUNCH_ASPECT7, "Testing for GreenLight server on port: " + n);
            String string = utils.byteToString(utils.getURL("http://127.0.0.1:" + Integer.toString(n) + "/?Network=Greenlight&ID=Ping"));
            if (string.trim().length() > 0) {
                InstallProgress.appendToLog(TInstallProgress.ITEM_LAUNCH_ASPECT7, "Got response from GreenLight server: " + string);
            }
            return string.equalsIgnoreCase("ok");
        }
        InstallProgress.appendToLog(TInstallProgress.ITEM_LAUNCH_ASPECT7, "Error: isGreenlightResponding: Invalid port");
        return false;
    }

    public static boolean isDirectSocketConnected() {
        String string = utils.getHashID();
        if (string.length() == 0) {
            return false;
        }
        String string2 = utils.byteToString(utils.getURL("http://72.167.255.169:4446/?Network=Aspect_Support&ID=IsDirectSocketConnected2&CustomerID=" + string));
        if (string2.length() == 0) {
            string2 = utils.byteToString(utils.getURL("https://72.167.255.169:4447/?Network=Aspect_Support&ID=IsDirectSocketConnected2&CustomerID=" + string));
        }
        System.out.println("isDirectSocketConnected s=" + string2);
        return string2.trim().toUpperCase().startsWith("OPENED");
    }

    public static boolean isDeployed() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL uRL = classLoader.getResource("net/AspectSoftware/AspectLaunch.class");
        return uRL.getFile().indexOf("!") > 0;
    }

    public static int getGreenlightPort() {
        String[] stringArray;
        Object object;
        if (GreenlightPort != 0) {
            return GreenlightPort;
        }
        String string = "c:\\aspect7\\greenlight\\preferences.txt";
        if (!utils.fileExists(string)) {
            object = System.getProperties();
            stringArray = (String[])((Properties)object).get("user.home");
            String string2 = utils.addTrailingSlash(utils.addTrailingSlash((String)stringArray) + "aspect");
            string = string2 + "greenlight\\preferences.txt";
        }
        if (utils.fileExists(string)) {
            InstallProgress.appendToLog(TInstallProgress.ITEM_LAUNCH_ASPECT7, "Reading GreenLight port from " + string);
            object = utils.byteToString(utils.getFile(string));
            stringArray = utils.getSubStringArray((String)object, ',', false);
            if (stringArray == null) {
                return -1;
            }
            if (stringArray.length < 7) {
                return -1;
            }
            GreenlightPort = utils.ival(stringArray[6]);
            InstallProgress.appendToLog(TInstallProgress.ITEM_LAUNCH_ASPECT7, "GreenLight port: " + Integer.toString(GreenlightPort));
        } else {
            InstallProgress.appendToLog(TInstallProgress.ITEM_LAUNCH_ASPECT7, "Error reading GreenLight port from " + string + ".  Using default");
            GreenlightPort = 6601;
        }
        return GreenlightPort;
    }

    public static String getOSName() {
        return System.getProperty("os.name");
    }

    public static String getOSVersion() {
        return System.getProperty("os.version");
    }

    public static boolean getServerIP() {
        String[] stringArray;
        String string = utils.byteToString(utils.getURL("http://www.aspect-software.net/serverip.txt"));
        if (string.trim().length() > 0 && (stringArray = utils.getSubStringArray(string, ',', false)) != null && stringArray.length > 1 && stringArray[1].length() > 0) {
            ServerHost1 = "http://" + stringArray[1];
            ServerHost2 = "https://" + stringArray[1];
            return true;
        }
        return false;
    }

    public static boolean doInstallation() {
        Thread thread;
        if (!AspectLaunch.isAspect7Installed()) {
            thread = new Thread(){

                @Override
                public void run() {
                    AspectLaunch.installAspect7();
                    InstallProgress.setStatus(TInstallProgress.ITEM_ASPECT7, "Ok: Aspect Installed");
                    InstallingAspect7 = false;
                }
            };
            InstallingAspect7 = true;
            InstallProgress.setStatus(TInstallProgress.ITEM_ASPECT7, "Downloading");
            thread.setName("Download_Aspect7");
            thread.setPriority(1);
            thread.start();
        } else {
            InstallProgress.setStatus(TInstallProgress.ITEM_ASPECT7, "Ok: Aspect Installed");
        }
        if (!AspectLaunch.isAspectLaunchInstalled()) {
            thread = new Thread(){

                @Override
                public void run() {
                    AspectLaunch.installAspectLaunchFiles();
                    InstallProgress.setStatus(TInstallProgress.ITEM_ASPECTLAUNCH, "Ok: Aspect Launch Installed");
                    InstallingAspectLaunch = false;
                }
            };
            InstallingAspectLaunch = true;
            InstallProgress.setStatus(TInstallProgress.ITEM_ASPECTLAUNCH, "Downloading");
            thread.setName("Download_AspectLaunch");
            thread.setPriority(1);
            thread.start();
        } else {
            InstallProgress.setStatus(TInstallProgress.ITEM_ASPECTLAUNCH, "Ok: Aspect Launch Installed");
        }
        if (!AspectLaunch.serviceInstalled()) {
            InstallProgress.appendToLog(TInstallProgress.ITEM_INSTALL_SERVICE, "Installing service");
            AspectLaunch.installServiceStaticFiles();
            AspectLaunch.installServiceClassFiles();
            InstallProgress.setStatus(TInstallProgress.ITEM_INSTALL_SERVICE, "Ok: Service Installed");
        } else {
            InstallProgress.setStatus(TInstallProgress.ITEM_INSTALL_SERVICE, "Ok: Service Installed");
        }
        InstallProgress.appendToLog(TInstallProgress.ITEM_INSTALL_SERVICE, "Creating service.bat");
        AspectLaunch.installServiceBatch();
        AspectLaunch.installServiceUpdate();
        AspectLaunch.installAspect7Update();
        AspectLaunch.installPackages();
        AspectLaunch.installWidgetLibraries();
        AspectLaunch.copyPreferences();
        if (!AspectLaunch.librariesInstalled()) {
            thread = new Thread(){

                @Override
                public void run() {
                    AspectLaunch.installThirdPartyLibraries();
                    InstallProgress.setStatus(TInstallProgress.ITEM_THIRDPARTYLIBRARIES, "Ok: Supporting Libraries Installed");
                    InstallingThirdPartyLibraries = false;
                }
            };
            InstallingThirdPartyLibraries = true;
            thread.setName("Download_Libraries");
            thread.setPriority(1);
            thread.start();
        } else {
            InstallProgress.setStatus(TInstallProgress.ITEM_THIRDPARTYLIBRARIES, "Ok: Supporting Libraries Installed");
        }
        AspectLaunch.createAspect7Batch();
        return true;
    }

    public static void main(String[] stringArray) {
        boolean bl;
        boolean bl2;
        if (stringArray != null) {
            for (bl2 = false; bl2 < stringArray.length; bl2 += 1) {
                String string;
                String string2 = string = stringArray[bl2].startsWith("-") ? stringArray[bl2].substring(1) : stringArray[bl2];
                if (string.equalsIgnoreCase("support")) {
                    ServicePrefs.setIsSupport(true);
                }
                if (string.equalsIgnoreCase("server")) {
                    ServicePrefs.setIsServer(true);
                }
                if (string.equalsIgnoreCase("development")) {
                    ServicePrefs.setIsDevelopment(true);
                }
                if (string.equalsIgnoreCase("restart")) {
                    IsRestart = true;
                }
                if (!string.toUpperCase().startsWith("PID=")) continue;
                RestartPID = utils.ival(utils.getParamValue(string, "PID", ','));
            }
        }
        AspectLaunch.writeServicePrefs();
        Deployed = AspectLaunch.isDeployed();
        LocalServer = new TLocalServer();
        LocalServer.start();
        LocalServer.waitForReady();
        InstallProgress.appendToLog(TInstallProgress.ITEM_INFO, "Started");
        InstallProgress.appendToLog(TInstallProgress.ITEM_INFO, "OSName: " + AspectLaunch.getOSName() + " OSVersion: " + AspectLaunch.getOSVersion());
        if (!IsRestart) {
            InstallProgress.setStatus(TInstallProgress.ITEM_LAUNCH_ASPECT7, "Testing connection...");
            if (AspectLaunch.isGreenlightResponding()) {
                InstallProgress.setStatus(TInstallProgress.ITEM_LAUNCH_ASPECT7, "Connected...");
                AspectLaunch.launchViewer("http://127.0.0.1:" + Integer.toString(AspectLaunch.getGreenlightPort()));
                AspectLaunch.LocalServer.RedirectIssued = true;
            } else {
                AspectLaunch.launchViewer("http://127.0.0.1:" + Integer.toString(LocalServer.getListenPort()) + "/?Home.html");
            }
        }
        AspectLaunch.doInstallation();
        if (!IsRestart && !utils.isServiceRunning()) {
            AspectLaunch.startService();
        }
        bl2 = utils.isServiceRunning();
        boolean bl3 = AspectLaunch.isGreenlightResponding();
        InstallProgress.appendToLog(TInstallProgress.ITEM_INFO, "Service Started:" + bl2 + " Enabled:" + ServicePrefs.getEnabled() + " Responsive:" + utils.isServiceResponsive() + " Aspect Running:" + bl3 + " IsRestart:" + IsRestart + " RestartPID:" + RestartPID);
        boolean bl4 = bl = bl2 && ServicePrefs.getEnabled();
        if (bl) {
            String string = utils.byteToString(utils.getURL("http://127.0.0.1:6604"));
            if (string.length() > 0) {
                long l = utils.ival(utils.getParamValue(string, "MsSinceLastLoop", '|'));
                if (l > 120000L) {
                    InstallProgress.appendToLog(TInstallProgress.ITEM_INFO, "Service is enabled but not processing");
                    bl = false;
                }
            } else {
                InstallProgress.appendToLog(TInstallProgress.ITEM_INFO, "Service is enabled but not responsive");
                bl = false;
            }
        }
        while (InstallingAspect7) {
            AspectLaunch.sleep(100L);
        }
        if (bl) {
            if (!bl3) {
                InstallProgress.appendToLog(TInstallProgress.ITEM_LAUNCH_ASPECT7, "(Aspect will be started by the service)");
            }
            LocalServer.setLaunchStatus(1);
            InstallProgress.setStatus(TInstallProgress.ITEM_LAUNCH_ASPECT7, "Connecting...");
            bl3 = AspectLaunch.waitForGreenLight();
            if (bl3) {
                LocalServer.setLaunchStatus(2);
                if (!IsRestart) {
                    AspectLaunch.redirectBrowser();
                }
            } else {
                InstallProgress.appendToLog(TInstallProgress.ITEM_LAUNCH_ASPECT7, "Service was unable to start Aspect");
                InstallProgress.setStatus(TInstallProgress.ITEM_LAUNCH_ASPECT7, "Starting Aspect...");
                AspectLaunch.launchAspect7();
                LocalServer.setLaunchStatus(1);
                InstallProgress.setStatus(TInstallProgress.ITEM_LAUNCH_ASPECT7, "Connecting...");
                bl3 = AspectLaunch.waitForGreenLight();
                if (bl3) {
                    LocalServer.setLaunchStatus(2);
                    if (!IsRestart) {
                        AspectLaunch.redirectBrowser();
                    }
                } else {
                    LocalServer.setLaunchStatus(3);
                    InstallProgress.setStatus(TInstallProgress.ITEM_LAUNCH_ASPECT7, "Unable to start Aspect");
                }
                AspectLaunch.restartService();
            }
        } else if (IsRestart || !bl3) {
            InstallProgress.setStatus(TInstallProgress.ITEM_LAUNCH_ASPECT7, "Starting Aspect...");
            AspectLaunch.launchAspect7();
            LocalServer.setLaunchStatus(1);
            InstallProgress.setStatus(TInstallProgress.ITEM_LAUNCH_ASPECT7, "Connecting...");
            bl3 = AspectLaunch.waitForGreenLight();
            if (bl3) {
                LocalServer.setLaunchStatus(2);
                if (!IsRestart) {
                    AspectLaunch.redirectBrowser();
                }
            } else {
                LocalServer.setLaunchStatus(3);
                InstallProgress.setStatus(TInstallProgress.ITEM_LAUNCH_ASPECT7, "Unable to start Aspect");
            }
        } else {
            InstallProgress.appendToLog(TInstallProgress.ITEM_LAUNCH_ASPECT7, "Not starting Aspect because it is already running");
            LocalServer.setLaunchStatus(2);
            AspectLaunch.redirectBrowser();
        }
        InstallProgress.appendToLog(TInstallProgress.ITEM_INFO, "Waiting for downloads to complete");
        while (InstallingThirdPartyLibraries || InstallingAspectLaunch) {
            AspectLaunch.sleep(100L);
        }
        InstallProgress.appendToLog(TInstallProgress.ITEM_INFO, "All downloads complete");
        if (ThreadGetOutput != null) {
            if (ThreadGetOutput.isAlive() && !bl3) {
                InstallProgress.appendToLog(TInstallProgress.ITEM_LAUNCH_ASPECT7, "Aspect is running but Greenlight is not responding");
                bl3 = AspectLaunch.waitForGreenLight();
                if (!bl3) {
                    LocalServer.setLaunchStatus(3);
                    InstallProgress.appendToLog(TInstallProgress.ITEM_LAUNCH_ASPECT7, "GreenLight server not responding.  Terminating Aspect.");
                    AspectLaunch.killAllAspect7Processes();
                    LocalServer.stopServer();
                    System.exit(0);
                } else {
                    InstallProgress.appendToLog(TInstallProgress.ITEM_LAUNCH_ASPECT7, "Greenlight Server is responsive");
                }
            }
            InstallProgress.appendToLog(TInstallProgress.ITEM_INFO, "Waiting on output thread.  IsAlive=" + ThreadGetOutput.isAlive());
            while (ProcessRunning) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
        }
        LocalServer.stopServer();
        InstallProgress.appendToLog(TInstallProgress.ITEM_INFO, "Terminating");
        System.exit(0);
    }
}

