/*
 * Decompiled with CFR 0.152.
 */
package ianywhere.ml.jdbcodbc;

import ianywhere.ml.jdbcodbc.IConnection;
import ianywhere.ml.jdbcodbc.INative;
import ianywhere.ml.jdbcodbc.IResource;
import ianywhere.ml.jdbcodbc.IResultSetMetaData;
import ianywhere.ml.jdbcodbc.IStatementCancelToken;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.LinkedList;

class IIStatement
extends INative
implements Statement {
    private IStatementCancelToken stmt_cancel_token = null;
    private LinkedList batched_statements = null;
    private int batched_statement_index = 0;
    private static final int CLOSE_CURRENT_RESULT = 1;
    private static final int KEEP_CURRENT_RESULT = 2;
    private static final int CLOSE_ALL_RESULTS = 3;

    protected IIStatement(long l) {
        super(l);
    }

    protected native void nFree();

    public void addBatch(String string) throws SQLException {
        if (this.batched_statements == null) {
            this.batched_statements = new LinkedList();
        }
        this.batched_statements.add(this.batched_statement_index++, string);
    }

    public void clearBatch() throws SQLException {
        if (this.batched_statements != null) {
            this.batched_statements.clear();
        }
        this.batched_statement_index = 0;
    }

    public int[] executeBatch() throws SQLException {
        int n;
        int[] nArray = new int[this.batched_statement_index];
        for (n = 0; n < this.batched_statement_index; ++n) {
            nArray[n] = -1;
        }
        for (n = 0; n < this.batched_statement_index; ++n) {
            try {
                String string = (String)this.batched_statements.get(n);
                this.execute(string);
                ResultSet resultSet = this.getResultSet();
                if (resultSet != null) {
                    throw new BatchUpdateException(IResource.getString("BATCH_RESULT"), nArray);
                }
                nArray[n] = this.getUpdateCount();
                continue;
            }
            catch (SQLException sQLException) {
                throw new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray);
            }
        }
        return nArray;
    }

    public native void cancel() throws SQLException;

    public native void clearWarnings() throws SQLException;

    public native void close() throws SQLException;

    public native void release();

    public native boolean execute(String var1) throws SQLException;

    public native ResultSet executeQuery(String var1) throws SQLException;

    public int executeUpdate(String string) throws SQLException {
        if (IIStatement.isSelectStatement(string)) {
            throw new SQLException(IResource.getString("EXECUTEUPDATE_ON_SELECT"));
        }
        return this.nativeExecuteUpdate(string);
    }

    public native Connection getConnection() throws SQLException;

    public native int getFetchDirection() throws SQLException;

    public native int getFetchSize() throws SQLException;

    public native int getMaxFieldSize() throws SQLException;

    public native int getMaxRows() throws SQLException;

    public native boolean getMoreResults() throws SQLException;

    public native int getQueryTimeout() throws SQLException;

    public native ResultSet getResultSet() throws SQLException;

    public native int getResultSetConcurrency() throws SQLException;

    public native int getResultSetType() throws SQLException;

    public native int getUpdateCount() throws SQLException;

    public native SQLWarning getWarnings() throws SQLException;

    public native void setCursorName(String var1) throws SQLException;

    public native void setEscapeProcessing(boolean var1) throws SQLException;

    public native void setFetchDirection(int var1) throws SQLException;

    public native void setFetchSize(int var1) throws SQLException;

    public native void setMaxFieldSize(int var1) throws SQLException;

    public native void setMaxRows(int var1) throws SQLException;

    public native void setQueryTimeout(int var1) throws SQLException;

    public ResultSetMetaData describe() throws SQLException {
        return new IResultSetMetaData(this);
    }

    public native long getODBCHandle() throws SQLException;

    public native String getColStrAttr(int var1, int var2) throws SQLException;

    public native int getColNumAttr(int var1, int var2) throws SQLException;

    public native int nativeExecuteUpdate(String var1) throws SQLException;

    public static boolean isSelectStatement(String string) {
        int n;
        char[] cArray = new char[]{'s', 'e', 'l', 'e', 'c', 't', ' '};
        if (string == null) {
            return false;
        }
        if (string.length() < 7) {
            return false;
        }
        for (n = 0; string.charAt(n) == ' ' && n < string.length(); ++n) {
        }
        for (int i = 0; i < 7 && n < string.length(); ++i, ++n) {
            if (Character.toLowerCase(string.charAt(n)) == cArray[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isInsertStatement(String string) {
        int n;
        char[] cArray = new char[]{'i', 'n', 's', 'e', 'r', 't', ' '};
        if (string == null) {
            return false;
        }
        if (string.length() < 7) {
            return false;
        }
        for (n = 0; string.charAt(n) == ' ' && n < string.length(); ++n) {
        }
        for (int i = 0; i < 7 && n < string.length(); ++i, ++n) {
            if (Character.toLowerCase(string.charAt(n)) == cArray[i]) continue;
            return false;
        }
        return true;
    }

    public boolean getMoreResults(int n) throws SQLException {
        if (n != 1 && n != 3) {
            throw new SQLException(IResource.getString("MULTIPLE_RESULT_SETS"));
        }
        return this.getMoreResults();
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLException(IResource.getString("GENERATED_KEYS"));
    }

    public int executeUpdate(String string, int n) throws SQLException {
        throw new SQLException(IResource.getString("GENERATED_KEYS"));
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        throw new SQLException(IResource.getString("GENERATED_KEYS"));
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw new SQLException(IResource.getString("GENERATED_KEYS"));
    }

    public boolean execute(String string, int n) throws SQLException {
        throw new SQLException(IResource.getString("GENERATED_KEYS"));
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        throw new SQLException(IResource.getString("GENERATED_KEYS"));
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        throw new SQLException(IResource.getString("GENERATED_KEYS"));
    }

    public int getResultSetHoldability() throws SQLException {
        IConnection iConnection = (IConnection)this.getConnection();
        return iConnection.getHoldability();
    }
}

