/*
 * Decompiled with CFR 0.152.
 */
package ianywhere.ml.jdbcodbc.jdbc3;

import ianywhere.ml.jdbcodbc.IResource;
import ianywhere.ml.jdbcodbc.jdbc3.ASAMessageHandler;
import ianywhere.ml.jdbcodbc.jdbc3.ICallableStatement;
import ianywhere.ml.jdbcodbc.jdbc3.INative;
import ianywhere.ml.jdbcodbc.jdbc3.IPreparedStatement;
import ianywhere.ml.jdbcodbc.jdbc3.ISavepoint;
import ianywhere.ml.jdbcodbc.jdbc3.IStatement;
import ianywhere.ml.jdbcodbc.jdbc3.SAValidateFileTransferCallback;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public final class IConnection
extends INative
implements Connection {
    private Map typeMap;
    private DateFormat dateFormat;
    private DateFormat timeFormat;
    private DateFormat timestampFormat;
    private SimpleDateFormat simpleFormat;
    private Vector trueStrings;
    private String dateFormatString = "yyyy-MM-dd";
    private String timeFormatString = "HH:mm:ss";
    private String timestampFormatString = "yyyy-MM-dd HH:mm:ss.SSS";
    private ASAMessageHandler msgHandler;
    private SAValidateFileTransferCallback validateFileTransferCallback;
    private int savepointLevel = 0;
    private int mustConvertPointToComma = -1;
    public static final int SA_TRANSACTION_SNAPSHOT = 32;
    public static final int SA_TRANSACTION_STATEMENT_SNAPSHOT = 64;
    public static final int SA_TRANSACTION_READONLY_STATEMENT_SNAPSHOT = 128;

    private IConnection(long l) {
        super(l);
        this.nhandle = l;
        this.typeMap = null;
        this.dateFormat = DateFormat.getDateInstance();
        this.timeFormat = DateFormat.getTimeInstance();
        this.timestampFormat = DateFormat.getDateTimeInstance();
        this.simpleFormat = new SimpleDateFormat();
        this.trueStrings = new Vector(3);
        this.trueStrings.add("1");
        this.trueStrings.add("true");
        this.trueStrings.add("TRUE");
    }

    protected synchronized native void nFree();

    public native void clearWarnings() throws SQLException;

    public synchronized native void close() throws SQLException;

    public synchronized native void commit() throws SQLException;

    public native boolean getAutoCommit() throws SQLException;

    public native String getCatalog() throws SQLException;

    public native DatabaseMetaData getMetaData() throws SQLException;

    public native int getTransactionIsolation() throws SQLException;

    public Map getTypeMap() throws SQLException {
        return this.typeMap;
    }

    public native SQLWarning getWarnings() throws SQLException;

    public native boolean isClosed() throws SQLException;

    public native boolean isReadOnly() throws SQLException;

    public native String nativeSQL(String var1) throws SQLException;

    public synchronized Statement createStatement() throws SQLException {
        IStatement iStatement = null;
        Statement statement = this.nativeCreateStatement();
        if (statement != null) {
            iStatement = new IStatement(statement);
            if (iStatement.initFailed) {
                iStatement = null;
            }
        }
        return iStatement;
    }

    public synchronized Statement createStatement(int n, int n2) throws SQLException {
        IStatement iStatement = null;
        Statement statement = this.nativeCreateStatement(n, n2);
        if (statement != null) {
            iStatement = new IStatement(statement);
            if (iStatement.initFailed) {
                iStatement = null;
            }
        }
        return iStatement;
    }

    public synchronized CallableStatement prepareCall(String string) throws SQLException {
        ICallableStatement iCallableStatement = null;
        CallableStatement callableStatement = this.nativePrepareCall(string, IStatement.isSelectStatement(string), IStatement.isInsertStatement(string));
        if (callableStatement != null) {
            iCallableStatement = new ICallableStatement(callableStatement);
            if (iCallableStatement.initFailed) {
                iCallableStatement = null;
            }
        }
        return iCallableStatement;
    }

    public synchronized CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        ICallableStatement iCallableStatement = null;
        CallableStatement callableStatement = this.nativePrepareCall(string, IStatement.isSelectStatement(string), IStatement.isInsertStatement(string), n, n2);
        if (callableStatement != null) {
            iCallableStatement = new ICallableStatement(callableStatement);
            if (iCallableStatement.initFailed) {
                iCallableStatement = null;
            }
        }
        return iCallableStatement;
    }

    public synchronized PreparedStatement prepareStatement(String string) throws SQLException {
        IPreparedStatement iPreparedStatement = null;
        PreparedStatement preparedStatement = this.nativePrepareStatement(string, IStatement.isSelectStatement(string), IStatement.isInsertStatement(string));
        if (preparedStatement != null) {
            iPreparedStatement = new IPreparedStatement(preparedStatement);
            if (iPreparedStatement.initFailed) {
                iPreparedStatement = null;
            }
        }
        return iPreparedStatement;
    }

    public synchronized PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        IPreparedStatement iPreparedStatement = null;
        PreparedStatement preparedStatement = this.nativePrepareStatement(string, IStatement.isSelectStatement(string), IStatement.isInsertStatement(string), n, n2);
        if (preparedStatement != null) {
            iPreparedStatement = new IPreparedStatement(preparedStatement);
            if (iPreparedStatement.initFailed) {
                iPreparedStatement = null;
            }
        }
        return iPreparedStatement;
    }

    public native void rollback() throws SQLException;

    public native void setAutoCommit(boolean var1) throws SQLException;

    public native void setCatalog(String var1) throws SQLException;

    public native void setReadOnly(boolean var1) throws SQLException;

    public native void setTransactionIsolation(int var1) throws SQLException;

    public void setTypeMap(Map map) throws SQLException {
        this.typeMap = map;
    }

    public native String getStrAttr(int var1) throws SQLException;

    public native int getNumAttr(int var1) throws SQLException;

    public native void setAttribute(int var1, String var2) throws SQLException;

    public native void setIsolationOnOpen(int var1) throws SQLException;

    public void setAttributes(Properties properties) throws SQLException {
        if (properties == null) {
            return;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            int n;
            String string = (String)enumeration.nextElement();
            try {
                if (string.equals("licpwd")) {
                    n = 1042;
                } else if (string.equals("licfile")) {
                    n = 1041;
                } else {
                    if (string.equals("timeFormat")) {
                        this.timeFormatString = properties.getProperty(string);
                        continue;
                    }
                    if (string.equals("dateFormat")) {
                        this.dateFormatString = properties.getProperty(string);
                        continue;
                    }
                    if (string.equals("timestampFormat")) {
                        this.timestampFormatString = properties.getProperty(string);
                        continue;
                    }
                    if (string.equals("user") || string.equals("password")) continue;
                    if (string.equals("ASAUseIsolationOnOpen")) {
                        String string2 = properties.getProperty(string);
                        this.setIsolationOnOpen(Integer.valueOf(string2));
                        continue;
                    }
                    n = Integer.valueOf(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            this.setAttribute(n, properties.getProperty(string));
        }
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setTimeFormat(DateFormat dateFormat) {
        this.timeFormat = dateFormat;
    }

    public void setTimestampFormat(DateFormat dateFormat) {
        this.timestampFormat = dateFormat;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public DateFormat getTimeFormat() {
        return this.timeFormat;
    }

    public DateFormat getTimestampFormat() {
        return this.timestampFormat;
    }

    public void callMessageHandler(SQLException sQLException) {
        this.msgHandler.messageHandler(sQLException);
    }

    public int callValidateFileTransferCallback(String string, int n) {
        return this.validateFileTransferCallback.callback(string, n);
    }

    public Calendar parseDate(String string) throws ParseException {
        Date date = null;
        try {
            date = this.dateFormat.parse(string);
        }
        catch (ParseException parseException) {
            Object object;
            String string2 = null;
            try {
                object = this.createStatement();
                ResultSet resultSet = object.executeQuery("select connection_property('date_format')");
                resultSet.next();
                string2 = resultSet.getString(1);
                resultSet.close();
                object.close();
            }
            catch (SQLException sQLException) {
                throw parseException;
            }
            if (string2 == null) {
                throw parseException;
            }
            try {
                string2 = string2.replace('Y', 'y').replace('D', 'd').replace('m', 'M');
                object = new SimpleDateFormat(string2);
                date = ((SimpleDateFormat)object).parse(string, new ParsePosition(0));
                if (date == null) {
                    throw parseException;
                }
            }
            catch (Throwable throwable) {
                throw parseException;
            }
        }
        this.dateFormat.getCalendar().setTime(date);
        return this.dateFormat.getCalendar();
    }

    public Calendar parseTime(String string) throws ParseException {
        Date date = null;
        try {
            date = this.timeFormat.parse(string);
        }
        catch (ParseException parseException) {
            Object object;
            String string2 = null;
            try {
                Statement statement = this.createStatement();
                object = statement.executeQuery("select connection_property('time_format')");
                object.next();
                string2 = object.getString(1);
                object.close();
                statement.close();
            }
            catch (SQLException sQLException) {
                throw parseException;
            }
            if (string2 == null) {
                throw parseException;
            }
            try {
                string2 = string2.replace('h', 'H').replace('N', 'm').replace('S', 's');
                int n = string2.indexOf(46);
                if (n != -1) {
                    object = string2.substring(0, n);
                    String string3 = string2.substring(n).replace('s', 'S');
                    string2 = (String)object + string3;
                }
                if ((date = ((SimpleDateFormat)(object = new SimpleDateFormat(string2))).parse(string, new ParsePosition(0))) == null) {
                    throw parseException;
                }
            }
            catch (Throwable throwable) {
                throw parseException;
            }
        }
        this.timeFormat.getCalendar().setTime(date);
        return this.timeFormat.getCalendar();
    }

    public Calendar parseTimestamp(String string) throws ParseException {
        this.timestampFormat.getCalendar().setTime(Timestamp.valueOf(string));
        return this.timestampFormat.getCalendar();
    }

    public String formatDate(int n, int n2, int n3) {
        Calendar calendar = this.dateFormat.getCalendar();
        calendar.set(n, n2, n3);
        this.simpleFormat.applyPattern(this.dateFormatString);
        return this.simpleFormat.format(calendar.getTime());
    }

    public String formatTime(int n, int n2, int n3) {
        Calendar calendar = this.timeFormat.getCalendar();
        calendar.set(0, 0, 0, n, n2, n3);
        this.simpleFormat.applyPattern(this.timeFormatString);
        return this.simpleFormat.format(calendar.getTime());
    }

    public String formatTimestamp(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Calendar calendar = this.timestampFormat.getCalendar();
        calendar.set(n, n2, n3, n4, n5, n6);
        calendar.set(14, n7);
        this.simpleFormat.applyPattern(this.timestampFormatString);
        return this.simpleFormat.format(calendar.getTime());
    }

    public String formatDate(Object object) {
        return this.dateFormat.format(object);
    }

    public String formatTime(Object object) {
        return this.timeFormat.format(object);
    }

    public String formatTimestamp(Object object) {
        return this.timestampFormat.format(object);
    }

    public boolean isTrue(String string) {
        return this.trueStrings.contains(string.trim());
    }

    public void addTrueString(String string) {
        this.trueStrings.add(string);
    }

    public void removeTrueString(String string) {
        this.trueStrings.removeElement(string);
    }

    public boolean convertPointToComma() {
        if (this.mustConvertPointToComma == -1) {
            NumberFormat numberFormat = NumberFormat.getInstance();
            String string = numberFormat.format(123.456);
            this.mustConvertPointToComma = string.contains(",") ? 1 : 0;
        }
        return this.mustConvertPointToComma != 0;
    }

    public native void setDefaultFetchSize(int var1);

    public native void setAllowTransactionControl(boolean var1);

    public native long getODBCHandle();

    public synchronized native Statement nativeCreateStatement() throws SQLException;

    public synchronized native Statement nativeCreateStatement(int var1, int var2) throws SQLException;

    public synchronized native CallableStatement nativePrepareCall(String var1, boolean var2, boolean var3) throws SQLException;

    public synchronized native CallableStatement nativePrepareCall(String var1, boolean var2, boolean var3, int var4, int var5) throws SQLException;

    public synchronized native PreparedStatement nativePrepareStatement(String var1, boolean var2, boolean var3) throws SQLException;

    public synchronized native PreparedStatement nativePrepareStatement(String var1, boolean var2, boolean var3, int var4, int var5) throws SQLException;

    public native void setASAMessageHandler() throws SQLException;

    public native void setSAValidateFileTransferCallback() throws SQLException;

    public void setASAMessageHandler(ASAMessageHandler aSAMessageHandler) throws SQLException {
        this.msgHandler = aSAMessageHandler;
        this.setASAMessageHandler();
    }

    public void setSAValidateFileTransferCallback(SAValidateFileTransferCallback sAValidateFileTransferCallback) throws SQLException {
        this.validateFileTransferCallback = sAValidateFileTransferCallback;
        this.setSAValidateFileTransferCallback();
    }

    public void setHoldability(int n) throws SQLException {
        boolean bl = this.getMetaData().supportsOpenCursorsAcrossCommit();
        if (n == 1 && bl) {
            return;
        }
        if (n == 2 && !bl) {
            return;
        }
        throw new SQLException(IResource.getString("HOLDABILITY"));
    }

    public int getHoldability() throws SQLException {
        boolean bl = this.getMetaData().supportsOpenCursorsAcrossCommit();
        if (bl) {
            return 1;
        }
        return 2;
    }

    public Savepoint setSavepoint() throws SQLException {
        this.createStatement().executeUpdate("SAVEPOINT");
        ++this.savepointLevel;
        return new ISavepoint(this.savepointLevel, null);
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        this.createStatement().executeUpdate("SAVEPOINT " + string);
        ++this.savepointLevel;
        return new ISavepoint(this.savepointLevel, string);
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        String string = "ROLLBACK TO SAVEPOINT";
        String string2 = savepoint.getSavepointName();
        if (string2 != null) {
            string = string + " " + string2;
        }
        this.createStatement().executeUpdate(string);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        String string = "RELEASE SAVEPOINT";
        String string2 = savepoint.getSavepointName();
        if (string2 != null) {
            string = string + " " + string2;
        }
        this.createStatement().executeUpdate(string);
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        if (n3 != this.getHoldability()) {
            throw new SQLException(IResource.getString("HOLDABILITY"));
        }
        return this.createStatement(n, n2);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        if (n3 != this.getHoldability()) {
            throw new SQLException(IResource.getString("HOLDABILITY"));
        }
        return this.prepareStatement(string, n, n2);
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        if (n3 != this.getHoldability()) {
            throw new SQLException(IResource.getString("HOLDABILITY"));
        }
        return this.prepareCall(string, n, n2);
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        throw new SQLException(IResource.getString("GENERATED_KEYS"));
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw new SQLException(IResource.getString("GENERATED_KEYS"));
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw new SQLException(IResource.getString("GENERATED_KEYS"));
    }
}

