/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.glacier.AmazonGlacierAsync;
import com.amazonaws.services.glacier.AmazonGlacierClient;
import com.amazonaws.services.glacier.model.AbortMultipartUploadRequest;
import com.amazonaws.services.glacier.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.glacier.model.CompleteMultipartUploadResult;
import com.amazonaws.services.glacier.model.CreateVaultRequest;
import com.amazonaws.services.glacier.model.CreateVaultResult;
import com.amazonaws.services.glacier.model.DeleteArchiveRequest;
import com.amazonaws.services.glacier.model.DeleteVaultNotificationsRequest;
import com.amazonaws.services.glacier.model.DeleteVaultRequest;
import com.amazonaws.services.glacier.model.DescribeJobRequest;
import com.amazonaws.services.glacier.model.DescribeJobResult;
import com.amazonaws.services.glacier.model.DescribeVaultRequest;
import com.amazonaws.services.glacier.model.DescribeVaultResult;
import com.amazonaws.services.glacier.model.GetJobOutputRequest;
import com.amazonaws.services.glacier.model.GetJobOutputResult;
import com.amazonaws.services.glacier.model.GetVaultNotificationsRequest;
import com.amazonaws.services.glacier.model.GetVaultNotificationsResult;
import com.amazonaws.services.glacier.model.InitiateJobRequest;
import com.amazonaws.services.glacier.model.InitiateJobResult;
import com.amazonaws.services.glacier.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.glacier.model.InitiateMultipartUploadResult;
import com.amazonaws.services.glacier.model.ListJobsRequest;
import com.amazonaws.services.glacier.model.ListJobsResult;
import com.amazonaws.services.glacier.model.ListMultipartUploadsRequest;
import com.amazonaws.services.glacier.model.ListMultipartUploadsResult;
import com.amazonaws.services.glacier.model.ListPartsRequest;
import com.amazonaws.services.glacier.model.ListPartsResult;
import com.amazonaws.services.glacier.model.ListVaultsRequest;
import com.amazonaws.services.glacier.model.ListVaultsResult;
import com.amazonaws.services.glacier.model.SetVaultNotificationsRequest;
import com.amazonaws.services.glacier.model.UploadArchiveRequest;
import com.amazonaws.services.glacier.model.UploadArchiveResult;
import com.amazonaws.services.glacier.model.UploadMultipartPartRequest;
import com.amazonaws.services.glacier.model.UploadMultipartPartResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonGlacierAsyncClient
extends AmazonGlacierClient
implements AmazonGlacierAsync {
    private ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AmazonGlacierAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonGlacierAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonGlacierAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonGlacierAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonGlacierAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonGlacierAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonGlacierAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonGlacierAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonGlacierAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<ListVaultsResult> listVaultsAsync(final ListVaultsRequest listVaultsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListVaultsResult>(){

            @Override
            public ListVaultsResult call() throws Exception {
                return AmazonGlacierAsyncClient.this.listVaults(listVaultsRequest);
            }
        });
    }

    @Override
    public Future<ListVaultsResult> listVaultsAsync(final ListVaultsRequest listVaultsRequest, final AsyncHandler<ListVaultsRequest, ListVaultsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListVaultsResult>(){

            @Override
            public ListVaultsResult call() throws Exception {
                ListVaultsResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.listVaults(listVaultsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listVaultsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeJobResult> describeJobAsync(final DescribeJobRequest describeJobRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeJobResult>(){

            @Override
            public DescribeJobResult call() throws Exception {
                return AmazonGlacierAsyncClient.this.describeJob(describeJobRequest);
            }
        });
    }

    @Override
    public Future<DescribeJobResult> describeJobAsync(final DescribeJobRequest describeJobRequest, final AsyncHandler<DescribeJobRequest, DescribeJobResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeJobResult>(){

            @Override
            public DescribeJobResult call() throws Exception {
                DescribeJobResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.describeJob(describeJobRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeJobRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListPartsResult> listPartsAsync(final ListPartsRequest listPartsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListPartsResult>(){

            @Override
            public ListPartsResult call() throws Exception {
                return AmazonGlacierAsyncClient.this.listParts(listPartsRequest);
            }
        });
    }

    @Override
    public Future<ListPartsResult> listPartsAsync(final ListPartsRequest listPartsRequest, final AsyncHandler<ListPartsRequest, ListPartsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListPartsResult>(){

            @Override
            public ListPartsResult call() throws Exception {
                ListPartsResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.listParts(listPartsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listPartsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetVaultNotificationsResult> getVaultNotificationsAsync(final GetVaultNotificationsRequest getVaultNotificationsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetVaultNotificationsResult>(){

            @Override
            public GetVaultNotificationsResult call() throws Exception {
                return AmazonGlacierAsyncClient.this.getVaultNotifications(getVaultNotificationsRequest);
            }
        });
    }

    @Override
    public Future<GetVaultNotificationsResult> getVaultNotificationsAsync(final GetVaultNotificationsRequest getVaultNotificationsRequest, final AsyncHandler<GetVaultNotificationsRequest, GetVaultNotificationsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetVaultNotificationsResult>(){

            @Override
            public GetVaultNotificationsResult call() throws Exception {
                GetVaultNotificationsResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.getVaultNotifications(getVaultNotificationsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getVaultNotificationsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListJobsResult> listJobsAsync(final ListJobsRequest listJobsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListJobsResult>(){

            @Override
            public ListJobsResult call() throws Exception {
                return AmazonGlacierAsyncClient.this.listJobs(listJobsRequest);
            }
        });
    }

    @Override
    public Future<ListJobsResult> listJobsAsync(final ListJobsRequest listJobsRequest, final AsyncHandler<ListJobsRequest, ListJobsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListJobsResult>(){

            @Override
            public ListJobsResult call() throws Exception {
                ListJobsResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.listJobs(listJobsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listJobsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateVaultResult> createVaultAsync(final CreateVaultRequest createVaultRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateVaultResult>(){

            @Override
            public CreateVaultResult call() throws Exception {
                return AmazonGlacierAsyncClient.this.createVault(createVaultRequest);
            }
        });
    }

    @Override
    public Future<CreateVaultResult> createVaultAsync(final CreateVaultRequest createVaultRequest, final AsyncHandler<CreateVaultRequest, CreateVaultResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateVaultResult>(){

            @Override
            public CreateVaultResult call() throws Exception {
                CreateVaultResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.createVault(createVaultRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createVaultRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<InitiateMultipartUploadResult> initiateMultipartUploadAsync(final InitiateMultipartUploadRequest initiateMultipartUploadRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<InitiateMultipartUploadResult>(){

            @Override
            public InitiateMultipartUploadResult call() throws Exception {
                return AmazonGlacierAsyncClient.this.initiateMultipartUpload(initiateMultipartUploadRequest);
            }
        });
    }

    @Override
    public Future<InitiateMultipartUploadResult> initiateMultipartUploadAsync(final InitiateMultipartUploadRequest initiateMultipartUploadRequest, final AsyncHandler<InitiateMultipartUploadRequest, InitiateMultipartUploadResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<InitiateMultipartUploadResult>(){

            @Override
            public InitiateMultipartUploadResult call() throws Exception {
                InitiateMultipartUploadResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.initiateMultipartUpload(initiateMultipartUploadRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(initiateMultipartUploadRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> abortMultipartUploadAsync(final AbortMultipartUploadRequest abortMultipartUploadRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonGlacierAsyncClient.this.abortMultipartUpload(abortMultipartUploadRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> abortMultipartUploadAsync(final AbortMultipartUploadRequest abortMultipartUploadRequest, final AsyncHandler<AbortMultipartUploadRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonGlacierAsyncClient.this.abortMultipartUpload(abortMultipartUploadRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(abortMultipartUploadRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteArchiveAsync(final DeleteArchiveRequest deleteArchiveRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonGlacierAsyncClient.this.deleteArchive(deleteArchiveRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteArchiveAsync(final DeleteArchiveRequest deleteArchiveRequest, final AsyncHandler<DeleteArchiveRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonGlacierAsyncClient.this.deleteArchive(deleteArchiveRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteArchiveRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<GetJobOutputResult> getJobOutputAsync(final GetJobOutputRequest getJobOutputRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetJobOutputResult>(){

            @Override
            public GetJobOutputResult call() throws Exception {
                return AmazonGlacierAsyncClient.this.getJobOutput(getJobOutputRequest);
            }
        });
    }

    @Override
    public Future<GetJobOutputResult> getJobOutputAsync(final GetJobOutputRequest getJobOutputRequest, final AsyncHandler<GetJobOutputRequest, GetJobOutputResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetJobOutputResult>(){

            @Override
            public GetJobOutputResult call() throws Exception {
                GetJobOutputResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.getJobOutput(getJobOutputRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getJobOutputRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<InitiateJobResult> initiateJobAsync(final InitiateJobRequest initiateJobRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<InitiateJobResult>(){

            @Override
            public InitiateJobResult call() throws Exception {
                return AmazonGlacierAsyncClient.this.initiateJob(initiateJobRequest);
            }
        });
    }

    @Override
    public Future<InitiateJobResult> initiateJobAsync(final InitiateJobRequest initiateJobRequest, final AsyncHandler<InitiateJobRequest, InitiateJobResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<InitiateJobResult>(){

            @Override
            public InitiateJobResult call() throws Exception {
                InitiateJobResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.initiateJob(initiateJobRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(initiateJobRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<UploadArchiveResult> uploadArchiveAsync(final UploadArchiveRequest uploadArchiveRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UploadArchiveResult>(){

            @Override
            public UploadArchiveResult call() throws Exception {
                return AmazonGlacierAsyncClient.this.uploadArchive(uploadArchiveRequest);
            }
        });
    }

    @Override
    public Future<UploadArchiveResult> uploadArchiveAsync(final UploadArchiveRequest uploadArchiveRequest, final AsyncHandler<UploadArchiveRequest, UploadArchiveResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UploadArchiveResult>(){

            @Override
            public UploadArchiveResult call() throws Exception {
                UploadArchiveResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.uploadArchive(uploadArchiveRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(uploadArchiveRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> setVaultNotificationsAsync(final SetVaultNotificationsRequest setVaultNotificationsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonGlacierAsyncClient.this.setVaultNotifications(setVaultNotificationsRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> setVaultNotificationsAsync(final SetVaultNotificationsRequest setVaultNotificationsRequest, final AsyncHandler<SetVaultNotificationsRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonGlacierAsyncClient.this.setVaultNotifications(setVaultNotificationsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(setVaultNotificationsRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<CompleteMultipartUploadResult> completeMultipartUploadAsync(final CompleteMultipartUploadRequest completeMultipartUploadRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CompleteMultipartUploadResult>(){

            @Override
            public CompleteMultipartUploadResult call() throws Exception {
                return AmazonGlacierAsyncClient.this.completeMultipartUpload(completeMultipartUploadRequest);
            }
        });
    }

    @Override
    public Future<CompleteMultipartUploadResult> completeMultipartUploadAsync(final CompleteMultipartUploadRequest completeMultipartUploadRequest, final AsyncHandler<CompleteMultipartUploadRequest, CompleteMultipartUploadResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CompleteMultipartUploadResult>(){

            @Override
            public CompleteMultipartUploadResult call() throws Exception {
                CompleteMultipartUploadResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.completeMultipartUpload(completeMultipartUploadRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(completeMultipartUploadRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<UploadMultipartPartResult> uploadMultipartPartAsync(final UploadMultipartPartRequest uploadMultipartPartRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UploadMultipartPartResult>(){

            @Override
            public UploadMultipartPartResult call() throws Exception {
                return AmazonGlacierAsyncClient.this.uploadMultipartPart(uploadMultipartPartRequest);
            }
        });
    }

    @Override
    public Future<UploadMultipartPartResult> uploadMultipartPartAsync(final UploadMultipartPartRequest uploadMultipartPartRequest, final AsyncHandler<UploadMultipartPartRequest, UploadMultipartPartResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UploadMultipartPartResult>(){

            @Override
            public UploadMultipartPartResult call() throws Exception {
                UploadMultipartPartResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.uploadMultipartPart(uploadMultipartPartRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(uploadMultipartPartRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeVaultResult> describeVaultAsync(final DescribeVaultRequest describeVaultRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeVaultResult>(){

            @Override
            public DescribeVaultResult call() throws Exception {
                return AmazonGlacierAsyncClient.this.describeVault(describeVaultRequest);
            }
        });
    }

    @Override
    public Future<DescribeVaultResult> describeVaultAsync(final DescribeVaultRequest describeVaultRequest, final AsyncHandler<DescribeVaultRequest, DescribeVaultResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeVaultResult>(){

            @Override
            public DescribeVaultResult call() throws Exception {
                DescribeVaultResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.describeVault(describeVaultRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeVaultRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteVaultNotificationsAsync(final DeleteVaultNotificationsRequest deleteVaultNotificationsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonGlacierAsyncClient.this.deleteVaultNotifications(deleteVaultNotificationsRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteVaultNotificationsAsync(final DeleteVaultNotificationsRequest deleteVaultNotificationsRequest, final AsyncHandler<DeleteVaultNotificationsRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonGlacierAsyncClient.this.deleteVaultNotifications(deleteVaultNotificationsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteVaultNotificationsRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<ListMultipartUploadsResult> listMultipartUploadsAsync(final ListMultipartUploadsRequest listMultipartUploadsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListMultipartUploadsResult>(){

            @Override
            public ListMultipartUploadsResult call() throws Exception {
                return AmazonGlacierAsyncClient.this.listMultipartUploads(listMultipartUploadsRequest);
            }
        });
    }

    @Override
    public Future<ListMultipartUploadsResult> listMultipartUploadsAsync(final ListMultipartUploadsRequest listMultipartUploadsRequest, final AsyncHandler<ListMultipartUploadsRequest, ListMultipartUploadsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListMultipartUploadsResult>(){

            @Override
            public ListMultipartUploadsResult call() throws Exception {
                ListMultipartUploadsResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.listMultipartUploads(listMultipartUploadsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listMultipartUploadsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteVaultAsync(final DeleteVaultRequest deleteVaultRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonGlacierAsyncClient.this.deleteVault(deleteVaultRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteVaultAsync(final DeleteVaultRequest deleteVaultRequest, final AsyncHandler<DeleteVaultRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonGlacierAsyncClient.this.deleteVault(deleteVaultRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteVaultRequest, null);
                return null;
            }
        });
    }
}

