/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.ProtocolResultSet;
import com.sybase.jdbc4.jdbc.SybResultSet;
import com.sybase.jdbc4.jdbc.SybStatement;
import com.sybase.jdbc4.tds.RowFormatToken;
import com.sybase.jdbc4.utils.Debug;
import com.sybase.jdbc4.utils.LogUtil;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SybLiteral
extends SybResultSet
implements PreparedStatement {
    private static Logger LOG = Logger.getLogger(SybLiteral.class.getName());
    private static volatile long _logIdCounter = 0L;
    private static final String LIST_DELIMITER = ",";
    private int _queryType = 0;
    private String _query = null;
    private boolean _atFirstRow = false;
    private String[] _columnList = null;
    RowFormatToken _rowFmt = null;

    public SybLiteral(String string, String string2, int n) throws SQLException {
        super(string, (SybStatement)null, (ProtocolResultSet)null);
        this._logId = string + "_Li" + _logIdCounter++;
        this._query = string2;
        this._queryType = n;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " executeQuery()");
        }
        return this;
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " executeQuery(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " executeQuery(String)");
            }
        }
        return null;
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " executeUpdate()");
        }
        return 0;
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " executeUpdate(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " executeUpdate(String)");
            }
        }
        return 0;
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " executeUpdate(String = [" + string + "], int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " executeUpdate(String, int)");
            }
        }
        Debug.notImplemented(this, "executeUpdate(String, int)");
        return 0;
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " executeUpdate", new Object[]{string, nArray}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " executeUpdate", new Object[]{string, nArray}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " executeUpdate(String, int[])");
            }
        }
        Debug.notImplemented(this, "executeUpdate(String, int[])");
        return 0;
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " executeUpdate", new Object[]{string, stringArray}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " executeUpdate", new Object[]{string, stringArray}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " executeUpdate(String, String[])");
            }
        }
        Debug.notImplemented(this, "executeUpdate(String, String[])");
        return 0;
    }

    @Override
    public boolean execute() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " execute()");
        }
        return false;
    }

    @Override
    public boolean execute(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " execute(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " execute(String)");
            }
        }
        return false;
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " execute(String = [" + string + "], int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " execute(String, int)");
            }
        }
        Debug.notImplemented(this, "execute(String, int)");
        return false;
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " execute", new Object[]{string, nArray}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " execute", new Object[]{string, nArray}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " executeUpdate(String, int[])");
            }
        }
        Debug.notImplemented(this, "execute(String, int[])");
        return false;
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " execute", new Object[]{string, stringArray}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " execute", new Object[]{string, stringArray}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " executeUpdate(String, int[])");
            }
        }
        Debug.notImplemented(this, "execute(String, String[])");
        return false;
    }

    @Override
    public void setNull(int n, int n2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setNull(int = [" + n + "], int = [" + n2 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setNull(int, int)");
            }
        }
    }

    @Override
    public void setNull(int n, int n2, String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setNull(int = [" + n + "], int = [" + n2 + "] , String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setNull(int, int, String)");
            }
        }
    }

    @Override
    public void setBoolean(int n, boolean bl) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setBoolean(int = [" + n + "], boolean = [" + bl + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setBoolean(int, boolean)");
            }
        }
    }

    @Override
    public void setByte(int n, byte by) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setByte(int = [" + n + "], byte = [" + by + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setByte(int, byte)");
            }
        }
    }

    @Override
    public void setShort(int n, short s) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setShort(int = [" + n + "], short = [" + s + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setShort(int, short)");
            }
        }
    }

    @Override
    public void setInt(int n, int n2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setInt(int = [" + n + "], int = [" + n2 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setInt(int, int)");
            }
        }
    }

    @Override
    public void setLong(int n, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setLong(int = [" + n + "], long = [" + l + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setLong(int, long)");
            }
        }
    }

    @Override
    public void setFloat(int n, float f) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setFloat(int = [" + n + "], float = [" + f + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setFloat(int, float)");
            }
        }
    }

    @Override
    public void setDouble(int n, double d) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setDouble(int = [" + n + "], double = [" + d + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setDouble(int, double)");
            }
        }
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setBigDecimal(int = [" + n + "], BigDecimal = [" + bigDecimal + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setBigDecimal(int, BigDecimal)");
            }
        }
    }

    @Override
    public void setString(int n, String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setString(int = [" + n + "], String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setString(int, String)");
            }
        }
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setBytes", new Object[]{n, byArray}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setBytes(int, byte)");
            }
        }
    }

    @Override
    public void setDate(int n, Date date) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setDate", new Object[]{n, date}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setDate(int, java.sql.Date)");
            }
        }
    }

    @Override
    public void setTime(int n, Time time) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setTime", new Object[]{n, time}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setTime(int, java.sql.Time)");
            }
        }
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setTimestamp", new Object[]{n, timestamp}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setTimestamp(int, java.sql.Timestamp)");
            }
        }
    }

    @Override
    public void setURL(int n, URL uRL) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setURL", new Object[]{n, uRL}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setURL(int, URL)");
            }
        }
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " setAsciiStream", new Object[]{n, inputStream, n2}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setAsciiStream", new Object[]{n, inputStream, n2}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setAsciiStream(int, java.io.InputStream, int)");
            }
        }
    }

    @Override
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " setUnicodeStream", new Object[]{n, inputStream, n2}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setUnicodeStream", new Object[]{n, inputStream, n2}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setUnicodeStream(int, java.io.InputStream, int)");
            }
        }
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " setBinaryStream", new Object[]{n, inputStream, n2}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setBinaryStream", new Object[]{n, inputStream, n2}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setBinaryStream(int, java.io.InputStream, int)");
            }
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " clearParameters()");
        }
    }

    @Override
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setObject", new Object[]{n, object, n2, n3}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setObject(int, Object, int, int)");
            }
        }
    }

    @Override
    public void setObject(int n, Object object, int n2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setObject", new Object[]{n, object, n2}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setObject(int, Object, int)");
            }
        }
    }

    @Override
    public void setObject(int n, Object object) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setObject", new Object[]{n, object}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setObject(int, Object)");
            }
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getMaxFielsSize()");
        }
        return 0;
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setMaxFieldSize(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setMaxFieldSize(int)");
            }
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getMaxRows()");
        }
        return 0;
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setMaxRows(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setMaxRows(int)");
            }
        }
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setEscapeProcessing(boolean = [" + bl + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setEscapeProcessing(boolean)");
            }
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getQueryTimeout()");
        }
        return 0;
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setQueryTimeout(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setQueryTimeout(int)");
            }
        }
    }

    @Override
    public void cancel() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " cancel()");
        }
    }

    @Override
    public void setCursorName(String string) throws SQLException {
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getResultSet()");
        }
        return null;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getUpdateCount()");
        }
        return 0;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getMoreResults()");
        }
        return false;
    }

    @Override
    public boolean getMoreResults(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getMoreResults(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getMoreResults(int)");
            }
        }
        Debug.notImplemented(this, "getMoreResults(int)");
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getGeneratedKeys()");
        }
        Debug.notImplemented(this, "getGeneratedKeys()");
        return null;
    }

    @Override
    public boolean next() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " next()");
        }
        if (!this._atFirstRow) {
            this._atFirstRow = true;
            if (this._queryType != 7) {
                this._columnList = SybLiteral.tokenizeList(this._query);
            }
            if (this._columnList != null && this._columnList.length > 0) {
                this._rowFmt = new RowFormatToken(this._columnList.length);
                return true;
            }
        }
        return false;
    }

    @Override
    public void close() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " close()");
        }
        this._atFirstRow = false;
        this._columnList = null;
        this._rowFmt = null;
        this._query = null;
    }

    @Override
    public String getString(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getString(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getString(int)");
            }
        }
        if (this._queryType == 7) {
            return this._query;
        }
        return this.getColumnValue(n);
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getBoolean(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getBoolean(int)");
            }
        }
        return this.getColumnValue(n).trim().equals("1");
    }

    @Override
    public int getInt(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getInt(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getInt(int)");
            }
        }
        return new Integer(this.getColumnValue(n).trim());
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " clearWarnings()");
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getMetaData()");
        }
        return this._rowFmt;
    }

    @Override
    public void addBatch() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " addBatch()");
        }
    }

    @Override
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setCharacterStream", new Object[]{n, reader, n2}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setCharacterStream(int, java.io.Reader, int)");
            }
        }
    }

    @Override
    public void setRef(int n, Ref ref) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setRef", new Object[]{n, ref}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setRef(int, Ref)");
            }
        }
    }

    @Override
    public void setBlob(int n, Blob blob) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " setBlob", new Object[]{n, blob}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setBlob", new Object[]{n, blob}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setBlob(int, Blob)");
            }
        }
    }

    @Override
    public void setClob(int n, Clob clob) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " setClob", new Object[]{n, clob}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setClob", new Object[]{n, clob}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setClob(int, Clob)");
            }
        }
    }

    @Override
    public void setArray(int n, Array array) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " setArray", new Object[]{n, array}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setArray", new Object[]{n, array}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setArray(int, Array)");
            }
        }
    }

    @Override
    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setDate", new Object[]{n, date, calendar}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setDate(int, java.sql.Date, Calendar)");
            }
        }
    }

    @Override
    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setTime", new Object[]{n, time, calendar}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setTime(int, java.sql.Time, Calendar)");
            }
        }
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setTimestamp", new Object[]{n, timestamp, calendar}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setTimestamp(int, java.sql.Timestamp, Calendar)");
            }
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getResultSetHoldability()");
        }
        return 0;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getParameterMetaData()");
        }
        Debug.notImplemented(this, "getParameterMetaData()");
        return null;
    }

    @Override
    public int getResultSetType() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getResultSet()");
        }
        return 0;
    }

    @Override
    public void addBatch(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " addBatch(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " addBatch(String)");
            }
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " clearBatch()");
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " executeBatch()");
        }
        return null;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getConnection()");
        }
        return null;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getResultSetConcurrency()");
        }
        return 0;
    }

    private String getColumnValue(int n) throws SQLException {
        if (!this._atFirstRow) {
            ErrorMessage.raiseError("JZ0R1");
        }
        if (this._columnList == null || n < 0 || this._columnList != null && n > this._columnList.length) {
            ErrorMessage.raiseError("JZ008", "" + n);
        }
        return this._columnList[n - 1];
    }

    private static String[] tokenizeList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, LIST_DELIMITER, false);
        if (stringTokenizer != null) {
            int n = stringTokenizer.countTokens();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = stringTokenizer.nextToken();
            }
            return stringArray;
        }
        return null;
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " setAsciiStream", new Object[]{n, inputStream}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setAsciiStream", new Object[]{n, inputStream}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setAsciiStream(int, InputStream)");
            }
        }
        Debug.notImplemented(this, "public void setAsciiStream(int parameterIndex, InputStream x)");
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " setAsciiStream", new Object[]{n, inputStream, l}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setAsciiStream", new Object[]{n, inputStream, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setAsciiStream(int, InputStream, long)");
            }
        }
        Debug.notImplemented(this, "public void setAsciiStream(int parameterIndex, InputStream x, long length)");
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " setBinaryStream", new Object[]{n, inputStream}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setBinaryStream", new Object[]{n, inputStream}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setBinaryStream(int, InputStream)");
            }
        }
        Debug.notImplemented(this, "public void setBinaryStream(int parameterIndex, InputStream x)");
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " setBinaryStream", new Object[]{n, inputStream, l}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setBinaryStream", new Object[]{n, inputStream, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setBinaryStream(int, InputStream, long)");
            }
        }
        Debug.notImplemented(this, "public void setBinaryStream(int parameterIndex, InputStream x, long length)");
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " setBlob", new Object[]{n, inputStream}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setBlob", new Object[]{n, inputStream}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setBlob(int, InputStream)");
            }
        }
        Debug.notImplemented(this, "public void setBlob(int parameterIndex, InputStream inputStream)");
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " setBlob", new Object[]{n, inputStream, l}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setBlob", new Object[]{n, inputStream, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setBlob(int, InputStream, long)");
            }
        }
        Debug.notImplemented(this, "public void setBlob(int parameterIndex, InputStream inputStream, long length)");
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setCharacterStream", new Object[]{n, reader}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setCharacterStream(int, Reader)");
            }
        }
        Debug.notImplemented(this, "public void setCharacterStream(int parameterIndex, Reader reader)");
    }

    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setCharacterStream", new Object[]{n, reader, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setCharacterStream(int, Reader, long)");
            }
        }
        Debug.notImplemented(this, "public void setCharacterStream(int parameterIndex, Reader reader, long length)");
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setClob", new Object[]{n, reader}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setClob(int, Reader)");
            }
        }
        Debug.notImplemented(this, "public void setClob(int parameterIndex, Reader reader)");
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setClob", new Object[]{n, reader, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setClob(int, Reader, long)");
            }
        }
        Debug.notImplemented(this, "public void setClob(int parameterIndex, Reader reader, long length)");
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setNCharacterStream", new Object[]{n, reader}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setNCharacterStream(int, Reader)");
            }
        }
        Debug.notImplemented(this, "public void setNCharacterStream(int parameterIndex, Reader value)");
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setNCharacterStream", new Object[]{n, reader, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setNCharacterStream(int, Reader, long)");
            }
        }
        Debug.notImplemented(this, "public void setNCharacterStream(int parameterIndex, Reader value, long length)");
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " setNClob", new Object[]{n, nClob}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setNClob", new Object[]{n, nClob}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setNClob(int, NClob)");
            }
        }
        Debug.notImplemented(this, "public void setNClob(int parameterIndex, NClob value)");
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setNClob", new Object[]{n, reader}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setNClob(int, Reader)");
            }
        }
        Debug.notImplemented(this, "public void setNClob(int parameterIndex, Reader reader)");
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setNClob", new Object[]{n, reader, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setNClob(int, Reader, long)");
            }
        }
        Debug.notImplemented(this, "public void setNClob(int parameterIndex, Reader reader, long length)");
    }

    @Override
    public void setNString(int n, String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setNString(int = [" + n + "], String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setNString(int, String)");
            }
        }
        Debug.notImplemented(this, "public void setNString(int parameterIndex, String value)");
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setRowId", new Object[]{n, rowId}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setRowId(int, RowId)");
            }
        }
        Debug.notImplemented(this, "public void setRowId(int parameterIndex, RowId x)");
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " setSQLXML", new Object[]{n, sQLXML}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setSQLXML", new Object[]{n, sQLXML}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setSQLXML(int, SQLXML)");
            }
        }
        Debug.notImplemented(this, "public void setSQLXML(int parameterIndex, SQLXML xmlObject)");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " isPoolable()");
        }
        Debug.notImplemented(this, "public boolean isPoolable()");
        return false;
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        Debug.notImplemented(this, "public void setPoolable(boolean poolable)");
    }
}

