/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.MdaManager;
import com.sybase.jdbc4.jdbc.ProtocolContext;
import com.sybase.jdbc4.utils.HexConverts;
import com.sybase.jdbc4.utils.LogUtil;
import java.io.InputStream;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class SybLob {
    private static Logger LOG = Logger.getLogger(SybLob.class.getName());
    protected String _logId = null;
    protected boolean _freeCalled = false;
    private byte[] _locator;
    private String _locatorHexString;
    private StringBuffer _lobLiteralSql;
    protected LOB_TYPE _lobType;
    protected String _lengthBuiltin;
    protected long _lobLength;
    protected ProtocolContext _context;
    protected MdaManager _mda;
    protected Statement _utilStmt;
    protected static final int OUT_STREAM_BUFFER_SIZE = 16384;
    protected static final int IN_STREAM_BUFFER_SIZE = 16384;

    public SybLob() {
    }

    public SybLob(String string, ProtocolContext protocolContext, byte[] byArray) throws SQLException {
        this._context = protocolContext._conn.initProtocol();
        this._mda = this._context._conn.getMDA(this._context);
        this._utilStmt = this._context._conn.createInternalStatement();
        this._locator = byArray;
        if (byArray != null && byArray.length > 0) {
            this._locatorHexString = "0x" + HexConverts.hexConvert(this._locator);
        }
        this._freeCalled = false;
    }

    protected void setLiteralSQL() {
        this._lobLiteralSql = new StringBuffer("locator_literal(");
        this._lobLiteralSql.append(this._lobType.toString()).append("_locator").append(",").append(this._locatorHexString).append(")");
    }

    protected String getLocatorHexString() {
        return this._locatorHexString;
    }

    public byte[] getLocator() {
        return this._locator;
    }

    protected String getLobLiteralSql() {
        return this._lobLiteralSql.toString();
    }

    public String getString() throws SQLException {
        return (String)this.getObject(RETURN_TYPE.STRING);
    }

    public InputStream getResultSetAsciiStream() throws SQLException {
        return (InputStream)this.getObject(RETURN_TYPE.ASCII_STREAM);
    }

    public Reader getResultSetCharacterStream() throws SQLException {
        return (Reader)this.getObject(RETURN_TYPE.CHAR_STREAM);
    }

    public InputStream getResultSetBinaryStream() throws SQLException {
        return (InputStream)this.getObject(RETURN_TYPE.BIN_STREAM);
    }

    public long getLong() throws SQLException {
        return (Long)this.getObject(RETURN_TYPE.LONG);
    }

    public byte[] getBytes() throws SQLException {
        return (byte[])this.getObject(RETURN_TYPE.BYTEARRAY);
    }

    public Object getObject(RETURN_TYPE rETURN_TYPE) throws SQLException {
        this.checkLocatorValidity();
        if (this._lobLength == 0L) {
            return null;
        }
        Object object = null;
        PreparedStatement preparedStatement = this._mda.getMetaDataAccessor("LOB_GETLOB", this._context);
        preparedStatement.setInt(1, this._lobType.ordinal());
        preparedStatement.setBytes(2, this.getLocator());
        preparedStatement.setInt(3, 0);
        preparedStatement.setInt(4, -1);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            switch (rETURN_TYPE) {
                case STRING: {
                    object = resultSet.getString(1);
                    break;
                }
                case LONG: {
                    object = resultSet.getLong(1);
                    break;
                }
                case BYTEARRAY: {
                    object = resultSet.getBytes(1);
                    break;
                }
                case ASCII_STREAM: {
                    object = resultSet.getAsciiStream(1);
                    break;
                }
                case CHAR_STREAM: {
                    object = resultSet.getCharacterStream(1);
                    break;
                }
                case BIN_STREAM: {
                    object = resultSet.getBinaryStream(1);
                }
            }
        }
        resultSet = null;
        return object;
    }

    public void truncate(long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " truncate(long = [" + l + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " truncate(long)");
            }
        }
        if (l < 0L) {
            ErrorMessage.raiseError("JZ038");
        }
        this.checkLocatorValidity();
        PreparedStatement preparedStatement = this._mda.getMetaDataAccessor("TRUNCATE_LOB", this._context);
        preparedStatement.setBytes(1, this._locator);
        preparedStatement.setLong(2, l);
        preparedStatement.executeUpdate();
    }

    public void free() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " free()");
        }
        if (!this._freeCalled) {
            this.checkLocatorValidity();
            PreparedStatement preparedStatement = this._mda.getMetaDataAccessor("DEALLOCATE_LOCATOR", this._context);
            preparedStatement.setBytes(1, this._locator);
            preparedStatement.executeUpdate();
            this._freeCalled = true;
        }
    }

    protected void checkLocatorValidity() throws SQLException {
        CallableStatement callableStatement = (CallableStatement)this._mda.getMetaDataAccessor("LOCATOR_VALID", this._context);
        callableStatement.setBytes(1, this._locator);
        callableStatement.registerOutParameter(2, 4);
        callableStatement.execute();
        if (callableStatement.getInt(2) != 1) {
            ErrorMessage.raiseError("JZ036");
        }
    }

    protected long searchLocator(SybLob sybLob, long l) throws SQLException {
        this.checkLocatorValidity();
        if (l < 1L) {
            ErrorMessage.raiseError("JZ037");
        }
        long l2 = -1L;
        if (sybLob != null) {
            CallableStatement callableStatement = (CallableStatement)this._mda.getMetaDataAccessor("SEARCH_LOB", this._context);
            callableStatement.setInt(1, this._lobType.ordinal());
            callableStatement.setBytes(2, sybLob.getLocator());
            callableStatement.setBytes(3, this._locator);
            callableStatement.setLong(4, l);
            callableStatement.registerOutParameter(5, -5);
            callableStatement.setInt(6, 0);
            callableStatement.setNull(7, 12);
            callableStatement.execute();
            l2 = callableStatement.getLong(5);
            if (l2 < l) {
                l2 = -1L;
            }
        }
        return l2;
    }

    protected int setData(long l, String string) throws SQLException {
        String string2 = this._lobType == LOB_TYPE.TEXT ? "TEXT_SETDATA" : "UNITEXT_SETDATA";
        CallableStatement callableStatement = (CallableStatement)this._mda.getMetaDataAccessor(string2, this._context);
        callableStatement.setBytes(1, this.getLocator());
        callableStatement.setLong(2, l);
        callableStatement.setString(3, string);
        callableStatement.registerOutParameter(4, 4);
        callableStatement.execute();
        int n = callableStatement.getInt(4);
        if (n == 0 && !string.equals("")) {
            ErrorMessage.raiseError("JZ037");
        }
        return n;
    }

    public long length() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " length()");
        }
        this.checkLocatorValidity();
        CallableStatement callableStatement = (CallableStatement)this._mda.getMetaDataAccessor("LOB_LENGTH", this._context);
        callableStatement.setInt(1, this._lobType.ordinal());
        callableStatement.setBytes(2, this._locator);
        callableStatement.registerOutParameter(3, -5);
        callableStatement.execute();
        return callableStatement.getLong(3);
    }

    public void setLobLength(long l) {
        this._lobLength = l;
    }

    public LOB_TYPE getLobType() {
        return this._lobType;
    }

    public static enum LOB_TYPE {
        IMAGE,
        TEXT,
        UNITEXT;

    }

    private static enum RETURN_TYPE {
        STRING,
        LONG,
        BYTEARRAY,
        ASCII_STREAM,
        CHAR_STREAM,
        BIN_STREAM;

    }
}

