/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.SybDatabaseMetaData;
import com.sybase.jdbc4.jdbc.SybPooledConnection;
import com.sybase.jdbc4.jdbc.SybUrlProvider;
import com.sybase.jdbc4.jdbc.SybUrlProviderImplBase;
import com.sybase.jdbc4.jdbc.SybXADataSource;
import com.sybase.jdbc4.jdbc.SybXAResource;
import com.sybase.jdbc4.jdbc.SybXid;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;

public class SybXAConnection
extends SybPooledConnection
implements XAConnection {
    private final SybXAResource _xaRes;

    protected SybXAConnection(SybXADataSource sybXADataSource, SybUrlProvider sybUrlProvider) throws SQLException {
        super(sybUrlProvider, sybXADataSource.getLoginTimeout());
        String string = null;
        String string2 = null;
        int n = sybXADataSource.getResourceManagerType();
        if (n == 1) {
            String string3 = null;
            string3 = sybUrlProvider.getResourceManagerName() != null ? sybUrlProvider.getResourceManagerName() : ((SybUrlProviderImplBase)sybUrlProvider)._rmNameDefault;
            this._xaRes = SybXAResource.createSybXAResource(n, string3, this, sybXADataSource, sybUrlProvider);
            try {
                SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG", "SUN");
                byte[] byArray = new byte[16];
                secureRandom.nextBytes(byArray);
                byte[] byArray2 = new byte[8];
                secureRandom.nextBytes(byArray2);
                SybXid sybXid = new SybXid(99, byArray, byArray2);
                this._xaRes.start(sybXid, 0);
                super.init();
                this._xaRes.end(sybXid, 0x4000000);
                int n2 = this._xaRes.prepare(sybXid);
                if (n2 == 0) {
                    this._xaRes.commit(sybXid, true);
                }
            }
            catch (XAException xAException) {
                this.close();
                ErrorMessage.raiseError("JZ0XS");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (NoSuchProviderException noSuchProviderException) {
                // empty catch block
            }
            return;
        }
        super.init();
        SybDatabaseMetaData sybDatabaseMetaData = (SybDatabaseMetaData)this.getMetaData();
        ResultSet resultSet = sybDatabaseMetaData.getXACoordinatorType();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n3 = resultSetMetaData.getColumnCount();
        resultSet.next();
        n = resultSet.getInt(1);
        String string4 = resultSet.getString(2);
        int n4 = resultSet.getInt(3);
        String string5 = null;
        String string6 = null;
        if (resultSetMetaData.getColumnCount() > 3) {
            string6 = resultSet.getString(4);
        }
        resultSet.close();
        string5 = sybUrlProvider.getResourceManagerName() != null ? sybUrlProvider.getResourceManagerName() : (string6 != null ? string6 : ((SybUrlProviderImplBase)sybUrlProvider)._rmNameDefault);
        if (n == 0) {
            this._xaRes = null;
            string = "JZ0XS";
        } else if ((n4 & 1) == 0) {
            this._xaRes = null;
            string = "JZ0XU";
            string2 = string4;
        } else {
            this._xaRes = SybXAResource.createSybXAResource(n, string5, this, sybXADataSource, sybUrlProvider);
            if (this._xaRes == null) {
                string = "JZ0XC";
                string2 = String.valueOf(n);
            }
        }
        if (string != null) {
            this.close();
            if (string2 != null) {
                ErrorMessage.raiseError(string, string2);
            } else {
                ErrorMessage.raiseError(string);
            }
        }
    }

    @Override
    public XAResource getXAResource() {
        return this._xaRes;
    }

    @Override
    public void close() throws SQLException {
        if (this._xaRes != null) {
            this._xaRes.close();
        }
        super.close();
    }

    @Override
    protected void init() {
    }

    protected void endLocalTransaction() throws SQLException {
        this.checkConnection();
        boolean bl = false;
        bl = this._props.getBoolean(53);
        try {
            if (this.getAutoCommit()) {
                this._xaRes._localTransactionOK = false;
            } else if (bl) {
                this.rollback();
                this.setAutoCommit(true);
            } else if (!this._protocol.getInTransaction()) {
                this._xaRes._localTransactionOK = false;
            } else {
                this.rollback();
            }
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
    }
}

