/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.SybProperty;
import com.sybase.jdbc4.tds.CapabilitySet;
import com.sybase.jdbc4.tds.TdsInputStream;
import com.sybase.jdbc4.tds.TdsOutputStream;
import com.sybase.jdbc4.tds.Token;
import com.sybase.jdbc4.utils.HexConverts;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;

public class CapabilityToken
extends Token {
    protected CapabilitySet _reqCaps;
    protected CapabilitySet _respCaps;
    protected Vector _allCapSets = new Vector();
    protected int _totalLen;
    protected int _capsTry = 0;
    protected boolean _wideTableOn = false;
    protected static final String[] REQUEST_LABELS = new String[]{"NONE", "REQ_LANG", "REQ_RPC", "REQ_EVT", "REQ_MSTMT", "REQ_BCP", "REQ_CURSOR", "REQ_DYNF", "REQ_MSG", "REQ_PARAM", "DATA_INT1", "DATA_INT2", "DATA_INT4", "DATA_BIT", "DATA_CHAR", "DATA_VCHAR", "DATA_BIN", "DATA_VBIN", "DATA_MNY8", "DATA_MNY4", "DATA_DATE8", "DATA_DATE4", "DATA_FLT4", "DATA_FLT8", "DATA_NUM", "DATA_TEXT", "DATA_IMAGE", "DATA_DEC", "DATA_LCHAR", "DATA_LBIN", "DATA_INTN", "DATA_DATETIMEN", "DATA_MONEYN", "CSR_PREV", "CSR_FIRST", "CSR_LAST", "CSR_ABS", "CSR_REL", "CSR_MULTI", "CON_OOB", "CON_INBAND", "CON_LOGICAL", "PROTO_TEXT", "PROTO_BULK", "REQ_URGEVT", "DATA_SENSITIVITY", "DATA_BOUNDARY", "PROTO_DYNAMIC", "PROTO_DYNPROC", "DATA_FLTN", "DATA_BITN", "DATA_INT8", "DATA_VOID", "DOL_BULK", "OBJECT_JAVA1", "OBJECT_CHAR", "REQ_RESERVED1", "OBJECT_BINARY", "DATA_COLUMNSTATUS", "WIDETABLE", "REQ_RESERVED2", "DATA_UINT2", "DATA_UINT4", "DATA_UINT8", "DATA_UINTN", "CUR_IMPLICIT", "DATA_NLBIN", "IMAGE_NCHAR", "BLOB_NCHAR_16", "BLOB_NCHAR_8", "BLOB_NCHAR_SCSU", "DATA_DATE", "DATA_TIME", "DATA_INTERVAL", "CSR_SCROLL", "CSR_SENSITIVE", "CSR_INSENSITIVE", "CSR_SEMISENSITIVE", "CSR_KEYSETDRIVEN", "REQ_SRVPKTSIZE", "DATA_UNITEXT", "CAP_CLUSTERFAILOVER", "DATA_SINT1", "REQ_LARGEIDENT", "REQ_BLOB_NCHAR_16", "DATA_XML", "REQ_CURINFO3", "REQ_DBRPC2", "REQ_UNUSED", "REQ_MIGRATE", "MULTI_REQUESTS", "REQ_UNUSED", "REQ_UNUSED", "DATA_BIGDATETIME", "DATA_USECS", "RPCPARAM_LOB", "REQ_INSTID", "REQ_GRID", "REQ_DYN_BATCH", "REQ_LANG_BATCH", "REQ_RPC_BATCH", "DATA_LOBLOCATOR", "REQ_UNUSED", "REQ_UNUSED"};
    protected static final String[] RESPONSE_LABELS = new String[]{"NONE", "RES_NOMSG", "RES_NOEED", "RES_NOPARAM", "DATA_NOINT1", "DATA_NOINT2", "DATA_NOINT4", "DATA_NOBIT", "DATA_NOCHAR", "DATA_NOVCHAR", "DATA_NOBIN", "DATA_NOVBIN", "DATA_NOMNY8", "DATA_NOMNY4", "DATA_NODATE8", "DATA_NODATE4", "DATA_NOFLT4", "DATA_NOFLT8", "DATA_NONUM", "DATA_NOTEXT", "DATA_NOIMAGE", "DATA_NODEC", "DATA_NOLCHAR", "DATA_NOLBIN", "DATA_NOINTN", "DATA_NODATETIMEN", "DATA_NOMONEYN", "CON_NOOOB", "CON_NOINBAND", "PROTO_NOTEXT", "PROTO_NOBULK", "DATA_NOSENSITIVITY", "DATA_NOBOUNDARY", "RES_NOTDSDEBUG", "RES_NOSTRIPBLANKS", "DATA_NOINT8", "OBJECT_NOJAVA1", "OBJECT_NOCHAR", "DATA_NOCOLUMNSTATUS", "OBJECT_NOBINARY", "RES_RESERVED1", "DATA_NOUINT2", "DATA_NOUINT4", "DATA_NOUINT8", "DATA_NOUINTN", "NO_WIDETABLES", "DATA_NONLBIN", "IMAGE_NONCHAR", "BLOB_NONCHAR_16", "BLOB_NONCHAR_8", "BLOB_NONCHAR_SCSU", "DATA_NODATE", "DATA_NOTIME", "DATA_NOINTERVAL", "DATA_NOUNITEXT", "DATA_NOSINT1", "RES_NOLARGEIDENT", "RES_NOBLOB_NCHAR_16", "NO_SRVPKTSIZE", "RES_NODATA_XML", "NONINT_RETURN_VALUE", "RES_NOXNLDATA", "RES_SUPPRESS_FMT", "RES_SUPPRESS_DONEINPROC", "RES_FORCE_ROWFMT2", "DATA_NOBIGDATETIME", "DATA_NOUSECS", "RES_NO_TDSCONTROL", "RPCPARAM_NOLOB", "RES_UNUSED", "DATA_NOLOBLOCATOR", "RES_UNUSED"};

    public CapabilityToken() {
        CapabilitySet capabilitySet;
        int n = 14;
        this._reqCaps = capabilitySet = new CapabilitySet(1, n);
        this._allCapSets.addElement(capabilitySet);
        n = 10;
        this._respCaps = capabilitySet = new CapabilitySet(2, n);
        this._allCapSets.addElement(capabilitySet);
        this._totalLen = this._reqCaps._maskLen + this._respCaps._maskLen + 4;
    }

    public CapabilityToken(TdsInputStream tdsInputStream) throws IOException, SQLException {
        try {
            int n;
            int n2;
            this._totalLen = n2;
            for (n2 = tdsInputStream.readShort(); n2 > 0; n2 -= 2 + n) {
                int n3;
                int n4;
                int n5 = tdsInputStream.readUnsignedByte();
                n = tdsInputStream.readUnsignedByte();
                if (n == 0) {
                    ErrorMessage.raiseWarning("010SM");
                }
                CapabilitySet capabilitySet = new CapabilitySet(n5, n);
                this._allCapSets.addElement(capabilitySet);
                for (n4 = 1; n4 <= n; ++n4) {
                    n3 = tdsInputStream.readUnsignedByte();
                    for (int i = 7; i >= 0; --i) {
                        if ((n3 & 1 << i) == 0) {
                            capabilitySet.clear(8 * (n - n4) + i);
                            continue;
                        }
                        capabilitySet.set(8 * (n - n4) + i);
                    }
                }
                n4 = 1;
                switch (n5) {
                    case 1: {
                        n4 += 105;
                        this._reqCaps = capabilitySet;
                        break;
                    }
                    case 2: {
                        n4 += 73;
                        this._respCaps = capabilitySet;
                        break;
                    }
                }
                for (n3 = n4; n3 < 8 * n; ++n3) {
                    capabilitySet.clear(n3);
                }
            }
        }
        catch (IOException iOException) {
            CapabilityToken.readSQE(iOException);
        }
    }

    @Override
    public void send(TdsOutputStream tdsOutputStream) throws IOException {
        try {
            tdsOutputStream.writeByte(226);
            tdsOutputStream.writeShort(this._totalLen);
            for (int i = 0; i < this._allCapSets.size(); ++i) {
                CapabilitySet capabilitySet = (CapabilitySet)this._allCapSets.elementAt(i);
                tdsOutputStream.writeByte(capabilitySet._type);
                tdsOutputStream.writeByte(capabilitySet._maskLen);
                int n = 0;
                for (int j = capabilitySet._bits - 1; j >= 0; --j) {
                    if (capabilitySet.get(j)) {
                        n |= 1 << j % 8;
                    }
                    if (j % 8 != 0) continue;
                    tdsOutputStream.writeByte(n);
                    n = 0;
                }
            }
        }
        catch (IOException iOException) {
            CapabilityToken.writeSQE(iOException);
        }
    }

    protected void setCapabilities(SybProperty sybProperty) throws SQLException {
        ++this._capsTry;
        switch (this._capsTry) {
            case 1: {
                int n;
                int n2;
                int n3;
                float f = sybProperty.getFloat(22);
                if (f >= 7.0f) {
                    n3 = 105;
                    n2 = 73;
                } else if (f >= 6.05f) {
                    n3 = 90;
                    n2 = 59;
                    n = n3 / 8 + 1;
                    this._reqCaps.setMaskSize(n);
                    this._respCaps.setMaskSize(n);
                    this._totalLen = 2 * n + 4;
                } else if (f >= 6.0f) {
                    n3 = 73;
                    n2 = 52;
                    n = n3 / 8 + 1;
                    this._reqCaps.setMaskSize(n);
                    this._respCaps.setMaskSize(n);
                    this._totalLen = 2 * n + 4;
                } else if (f >= 4.0f) {
                    n3 = 57;
                    n2 = 39;
                    n = n3 / 8 + 1;
                    this._reqCaps.setMaskSize(n);
                    this._respCaps.setMaskSize(n);
                    this._totalLen = 2 * n + 4;
                } else {
                    n3 = 57;
                    n2 = 39;
                }
                for (n = 1; n <= n3; ++n) {
                    this._reqCaps.set(n);
                }
                this._reqCaps.clear(0);
                this._reqCaps.clear(3);
                String string = sybProperty.getString(68);
                if (string == null || string.equalsIgnoreCase("NONE") || string.equalsIgnoreCase("FALSE")) {
                    this._reqCaps.clear(5);
                }
                this._reqCaps.clear(39);
                this._reqCaps.clear(41);
                this._reqCaps.clear(43);
                this._reqCaps.clear(44);
                this._reqCaps.clear(52);
                this._reqCaps.clear(56);
                this._reqCaps.clear(60);
                this._reqCaps.clear(65);
                this._reqCaps.clear(67);
                this._reqCaps.clear(69);
                this._reqCaps.clear(70);
                if (!sybProperty.getBoolean(54)) {
                    this._reqCaps.clear(79);
                }
                this._reqCaps.clear(68);
                this._reqCaps.clear(47);
                if (!sybProperty.getBoolean(34)) {
                    this._reqCaps.clear(81);
                }
                if (!sybProperty.getBoolean(72)) {
                    this._reqCaps.clear(89);
                }
                if (!sybProperty.getBoolean(81)) {
                    this._reqCaps.clear(102);
                }
                this._reqCaps.clear(85);
                if (!sybProperty.getBoolean(90)) {
                    this._reqCaps.clear(104);
                }
                if (!sybProperty.getBoolean(98)) {
                    this._reqCaps.clear(105);
                }
                for (int i = 0; i <= n2; ++i) {
                    this._respCaps.clear(i);
                }
                this._respCaps.set(27);
                this._respCaps.set(30);
                this._respCaps.set(33);
                if (!sybProperty.getBoolean(92)) {
                    this._respCaps.set(34);
                }
                if (sybProperty.getFloat(22) < 6.0f) {
                    this._respCaps.set(3);
                }
                this._respCaps.set(47);
                this._respCaps.set(49);
                this._respCaps.set(50);
                if (!sybProperty.getBoolean(54)) {
                    this._respCaps.set(58);
                }
                if (!sybProperty.getBoolean(59)) {
                    this._reqCaps.clear(59);
                    this._respCaps.clear(45);
                }
                if (sybProperty.getBoolean(87)) {
                    this._respCaps.set(67);
                }
                if (sybProperty.getBoolean(88)) {
                    this._respCaps.set(61);
                }
                if (sybProperty.getBoolean(89)) {
                    this._respCaps.set(62);
                }
                if (sybProperty.getBoolean(96)) {
                    this._respCaps.set(73);
                }
                if (!sybProperty.getBoolean(97)) break;
                this._respCaps.set(72);
                break;
            }
            case 2: {
                int n = 7;
                this._reqCaps.setMaskSize(n);
                this._respCaps.setMaskSize(n);
                this._totalLen = 2 * n + 4;
                break;
            }
        }
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Request capabilities:\n");
        for (n = 1; n < REQUEST_LABELS.length; ++n) {
            stringBuffer.append(REQUEST_LABELS[n] + ": " + this._reqCaps.get(n) + "\n");
        }
        stringBuffer.append("\nResponse capabilities:\n");
        for (n = 1; n < RESPONSE_LABELS.length; ++n) {
            stringBuffer.append(RESPONSE_LABELS[n] + ": " + this._respCaps.get(n) + "\n");
        }
        return stringBuffer.toString();
    }

    protected void printMask() {
    }

    protected String maskToVerboseString(CapabilitySet capabilitySet) {
        String string = "\n";
        boolean bl = capabilitySet._type == 1;
        String[] stringArray = bl ? REQUEST_LABELS : RESPONSE_LABELS;
        String string2 = "";
        int n = 0;
        for (int i = stringArray.length - 1; i >= 0; --i) {
            if (i < stringArray.length) {
                if (string2.length() > 0) {
                    string2 = string2 + ", ";
                }
                if (!capabilitySet.get(i)) {
                    string2 = string2 + "(";
                }
                string2 = string2 + stringArray[i];
                if (!capabilitySet.get(i)) {
                    string2 = string2 + ")";
                }
            }
            if (capabilitySet.get(i)) {
                n |= 1 << i % 8;
            }
            if (i % 8 != 0) continue;
            string = string + "0x" + HexConverts.hexConvert(n, 1) + " (" + HexConverts.binaryConvert(n, 1) + "): " + string2 + " \n";
            string2 = "";
            n = 0;
        }
        return string;
    }
}

