/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.charset.SybUTF8Charset;
import com.sybase.jdbc4.jdbc.CharsetToUniInputStream;
import com.sybase.jdbc4.jdbc.Convert;
import com.sybase.jdbc4.jdbc.DateObject;
import com.sybase.jdbc4.jdbc.DynamicClassLoader;
import com.sybase.jdbc4.jdbc.DynamicObjectInputStream;
import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.RawInputStream;
import com.sybase.jdbc4.jdbc.RawToAsciiInputStream;
import com.sybase.jdbc4.jdbc.SybBinaryClientLob;
import com.sybase.jdbc4.jdbc.SybBinaryLob;
import com.sybase.jdbc4.jdbc.SybCharClientLob;
import com.sybase.jdbc4.jdbc.SybCharLob;
import com.sybase.jdbc4.jdbc.SybLob;
import com.sybase.jdbc4.jdbc.TextPointer;
import com.sybase.jdbc4.jdbc.UnicharToAsciiInputStream;
import com.sybase.jdbc4.jdbc.UnicharToUniInputStream;
import com.sybase.jdbc4.tds.CachedTdsJdbcInputStream;
import com.sybase.jdbc4.tds.Tds;
import com.sybase.jdbc4.tds.TdsDataObject;
import com.sybase.jdbc4.tds.TdsProtocolContext;
import com.sybase.jdbc4.utils.CacheManager;
import com.sybase.jdbc4.utils.CacheStream;
import com.sybase.jdbc4.utils.Cacheable;
import com.sybase.jdbc4.utils.HexConverts;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLException;
import java.util.Calendar;

public class TdsJdbcInputStream
extends TdsDataObject
implements Cacheable {
    private static volatile long _logIdCounter = 0L;
    private String _logId = "Ji" + _logIdCounter++;
    private static final String JAVA_LANG_BOOLEAN = "java.lang.Boolean";
    private static final String JAVA_LANG_DOUBLE = "java.lang.Double";
    private static final String JAVA_LANG_FLOAT = "java.lang.Float";
    private static final String JAVA_LANG_INTEGER = "java.lang.Integer";
    private static final String JAVA_LANG_LONG = "java.lang.Long";
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String JAVA_MATH_BIGDECIMAL = "java.math.BigDecimal";
    private static final String JAVA_IO_FILTERINPUTSTREAM = "java.io.FilterInputStream";
    private static final String JAVA_SQL_TIMESTAMP = "java.sql.Timestamp";
    private static final String JAVA_SQL_TIME = "java.sql.Time";
    private static final String JAVA_SQL_DATE = "java.sql.Date";
    private static final int BUFLEN = 512;
    public static final int RAW_TO_ASCII_STREAM = 1;
    public static final int RAW_TO_UNI_STREAM = 2;
    public static final int CHARSET_TO_UNI_STREAM = 3;
    public static final int RAW_STREAM = 4;
    public static final int UNITYPE_TO_UNI_STREAM = 5;
    public static final int UNITYPE_TO_ASCII_STREAM = 6;
    private CacheManager _monitor;
    private RawInputStream _columnInputStream;
    private InputStreamReader _columnInputStreamReader;
    private DynamicClassLoader _classLoader = this._tds.getClassLoader();

    public TdsJdbcInputStream(String string, TdsProtocolContext tdsProtocolContext, Tds tds) throws IOException {
        super(tdsProtocolContext);
    }

    @Override
    protected TdsDataObject createCachedCopy() throws SQLException, IOException {
        return new CachedTdsJdbcInputStream(this);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        InputStream inputStream = null;
        try {
            this.beginRead();
            if (!this._isNull) {
                block1 : switch (this._dataFmt._datatype) {
                    case 36: {
                        switch (this._dataFmt._blobType) {
                            case 3: {
                                this._columnInputStream = this.makeNewRIS(4);
                                return this._columnInputStream;
                            }
                            case 4: {
                                this._columnInputStream = this.makeNewRIS(1);
                                return this._columnInputStream;
                            }
                            case 5: {
                                this._columnInputStream = this.makeNewRIS(6);
                                return this._columnInputStream;
                            }
                            case 6: 
                            case 7: 
                            case 8: {
                                SybLob sybLob = this.readLobInfo();
                                this.endRead();
                                inputStream = sybLob.getResultSetAsciiStream();
                                break block1;
                            }
                        }
                        ErrorMessage.raiseError("JZ0TC");
                        break;
                    }
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        this._columnInputStream = this.makeNewRIS(4);
                        return this._columnInputStream;
                    }
                    case 34: 
                    case 37: 
                    case 45: {
                        this._columnInputStream = this.makeNewRIS(1);
                        return this._columnInputStream;
                    }
                    case 174: 
                    case 225: {
                        this._columnInputStream = this._dataFmt.isUnitype() ? this.makeNewRIS(6) : this.makeNewRIS(1);
                        return this._columnInputStream;
                    }
                    default: {
                        ErrorMessage.raiseError("JZ0TE", "char, varchar, unichar, univarchar, text, unitext, image, binary, long binary, varbinary");
                    }
                }
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        return inputStream;
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        Reader reader = null;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 36: {
                        switch (this._dataFmt._blobType) {
                            case 3: {
                                this._columnInputStream = this.makeNewRIS(4);
                                this._columnInputStreamReader = this._tds._charsetName.equals("x-SybUTF8") ? new InputStreamReader((InputStream)this._columnInputStream, SybUTF8Charset.getInstance()) : new InputStreamReader((InputStream)this._columnInputStream, this._tds._charsetName);
                                return this._columnInputStreamReader;
                            }
                            case 4: {
                                this._columnInputStream = this.makeNewRIS(1);
                                this._columnInputStreamReader = this._tds._charsetName.equals("x-SybUTF8") ? new InputStreamReader((InputStream)this._columnInputStream, SybUTF8Charset.getInstance()) : new InputStreamReader((InputStream)this._columnInputStream, this._tds._charsetName);
                                return this._columnInputStreamReader;
                            }
                            case 5: {
                                this._columnInputStream = this.makeNewRIS(5);
                                String string = null;
                                string = this.getBigEndian() ? "UnicodeBig" : "UnicodeLittle";
                                this._columnInputStreamReader = new InputStreamReader((InputStream)this._columnInputStream, string);
                                return this._columnInputStreamReader;
                            }
                            case 6: 
                            case 7: 
                            case 8: {
                                SybLob sybLob = this.readLobInfo();
                                this.endRead();
                                return sybLob.getResultSetCharacterStream();
                            }
                        }
                        ErrorMessage.raiseError("JZ0TC");
                        break;
                    }
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        this._columnInputStream = this.makeNewRIS(4);
                        this._columnInputStreamReader = this._tds._charsetName.equals("x-SybUTF8") ? new InputStreamReader((InputStream)this._columnInputStream, SybUTF8Charset.getInstance()) : new InputStreamReader((InputStream)this._columnInputStream, this._tds._charsetName);
                        return this._columnInputStreamReader;
                    }
                    case 34: 
                    case 37: 
                    case 45: {
                        this._columnInputStream = this.makeNewRIS(1);
                        this._columnInputStreamReader = this._tds._charsetName.equals("x-SybUTF8") ? new InputStreamReader((InputStream)this._columnInputStream, SybUTF8Charset.getInstance()) : new InputStreamReader((InputStream)this._columnInputStream, this._tds._charsetName);
                        return this._columnInputStreamReader;
                    }
                    case 174: 
                    case 225: {
                        if (this._dataFmt.isUnitype()) {
                            this._columnInputStream = this.makeNewRIS(5);
                            String string = null;
                            string = this.getBigEndian() ? "UnicodeBig" : "UnicodeLittle";
                            this._columnInputStreamReader = new InputStreamReader((InputStream)this._columnInputStream, string);
                        } else {
                            this._columnInputStream = this.makeNewRIS(1);
                            this._columnInputStreamReader = this._tds._charsetName.equals("x-SybUTF8") ? new InputStreamReader((InputStream)this._columnInputStream, SybUTF8Charset.getInstance()) : new InputStreamReader((InputStream)this._columnInputStream, this._tds._charsetName);
                        }
                        return this._columnInputStreamReader;
                    }
                    default: {
                        ErrorMessage.raiseError("JZ0TC");
                    }
                }
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        return reader;
    }

    @Override
    public InputStream getUnicodeStream() throws SQLException {
        InputStream inputStream = null;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 36: {
                        switch (this._dataFmt._blobType) {
                            case 3: {
                                this._columnInputStream = this.makeNewRIS(3);
                                return this._columnInputStream;
                            }
                            case 4: {
                                this._columnInputStream = this.makeNewRIS(2);
                                return this._columnInputStream;
                            }
                            case 5: {
                                this._columnInputStream = this.makeNewRIS(5);
                                return this._columnInputStream;
                            }
                        }
                        ErrorMessage.raiseError("JZ0TC");
                        break;
                    }
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        this._columnInputStream = this.makeNewRIS(3);
                        return this._columnInputStream;
                    }
                    case 34: 
                    case 37: 
                    case 45: {
                        this._columnInputStream = this.makeNewRIS(2);
                        return this._columnInputStream;
                    }
                    case 174: 
                    case 225: {
                        this._columnInputStream = this._dataFmt.isUnitype() ? this.makeNewRIS(5) : this.makeNewRIS(2);
                        return this._columnInputStream;
                    }
                    default: {
                        ErrorMessage.raiseError("JZ0TE", "char, varchar, unichar, univarchar, text, unitext, image, binary, long binary, varbinary");
                    }
                }
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        return inputStream;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 36: {
                        switch (this._dataFmt._blobType) {
                            case 7: {
                                SybLob sybLob = this.readLobInfo();
                                this.endRead();
                                return sybLob.getResultSetBinaryStream();
                            }
                            case 4: {
                                break;
                            }
                            default: {
                                ErrorMessage.raiseError("JZ0TC");
                            }
                        }
                    }
                    case 34: 
                    case 37: 
                    case 45: 
                    case 225: {
                        this._columnInputStream = this.makeNewRIS(4);
                        return this._columnInputStream;
                    }
                }
                ErrorMessage.raiseError("JZ0TE", "image, binary, long binary, varbinary");
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        BigDecimal bigDecimal = null;
        boolean bl = false;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 48: 
                    case 50: {
                        bigDecimal = new BigDecimal((double)this.readUnsignedByte());
                        break;
                    }
                    case 52: {
                        bigDecimal = new BigDecimal((double)this.readShort());
                        break;
                    }
                    case 65: {
                        bigDecimal = new BigDecimal((double)this.readUnsignedShortAsInt());
                        break;
                    }
                    case 56: {
                        bigDecimal = new BigDecimal((double)this.readInt());
                        break;
                    }
                    case 66: {
                        bigDecimal = new BigDecimal((double)this.readUnsignedIntAsLong());
                        break;
                    }
                    case 191: {
                        bigDecimal = new BigDecimal((double)this.readLong());
                        break;
                    }
                    case 67: {
                        bigDecimal = this.readUnsignedLongAsBigDecimal();
                        break;
                    }
                    case 38: {
                        bigDecimal = new BigDecimal((double)this.readINTN());
                        break;
                    }
                    case 68: {
                        if (this._dataLength < 8) {
                            bigDecimal = new BigDecimal((double)this.readUINTN());
                            break;
                        }
                        bigDecimal = this.readUnsignedLongAsBigDecimal();
                        break;
                    }
                    case 59: {
                        bigDecimal = new BigDecimal(this.readFloat());
                        break;
                    }
                    case 62: {
                        bigDecimal = new BigDecimal(this.readDouble());
                        break;
                    }
                    case 109: {
                        bigDecimal = new BigDecimal(this.readFLTN());
                        break;
                    }
                    case 106: 
                    case 108: {
                        bigDecimal = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale);
                        break;
                    }
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        bigDecimal = new BigDecimal(Convert.numString(this.readString()));
                        break;
                    }
                    case 174: 
                    case 225: {
                        if (this._dataFmt.isUnitype()) {
                            bigDecimal = new BigDecimal(Convert.numString(this.readUnicodeString()));
                            break;
                        }
                        bl = true;
                        break;
                    }
                    case 60: 
                    case 110: 
                    case 122: {
                        bigDecimal = this.readMONEYN();
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
                if (bl) {
                    ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, unichar, varchar, univarchar, text, unitext, money, short money");
                }
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMessage.raiseError("JZ009", numberFormatException.toString());
        }
        finally {
            this.endRead();
        }
        bigDecimal = Convert.setScale(bigDecimal, n);
        return bigDecimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean() throws SQLException {
        boolean bl = false;
        boolean bl2 = false;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 48: 
                    case 50: {
                        bl = 0 != this.readUnsignedByte();
                        break;
                    }
                    case 52: {
                        bl = 0 != this.readShort();
                        break;
                    }
                    case 65: {
                        bl = 0 != this.readUnsignedShortAsInt();
                        break;
                    }
                    case 56: {
                        bl = 0 != this.readInt();
                        break;
                    }
                    case 66: {
                        bl = 0L != this.readUnsignedIntAsLong();
                        break;
                    }
                    case 191: {
                        bl = 0L != this.readLong();
                        break;
                    }
                    case 67: {
                        bl = 0L != this.readUnsignedLongAsBigDecimal().longValue();
                        break;
                    }
                    case 38: {
                        bl = 0L != this.readINTN();
                        break;
                    }
                    case 68: {
                        if (this._dataLength < 8) {
                            bl = 0L != this.readUINTN();
                            break;
                        }
                        bl = 0L != this.readUnsignedLongAsBigDecimal().longValue();
                        break;
                    }
                    case 60: 
                    case 110: 
                    case 122: {
                        BigDecimal bigDecimal = this.readMONEYN();
                        bl = 0 != bigDecimal.signum();
                        break;
                    }
                    case 59: 
                    case 62: 
                    case 109: {
                        bl = 0.0 != this.readFLTN();
                        break;
                    }
                    case 106: 
                    case 108: {
                        BigDecimal bigDecimal = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale);
                        bl = 0 != bigDecimal.signum();
                        break;
                    }
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        String string = this.readString();
                        bl = string != null && (string.trim().toLowerCase().equals("true") || string.trim().equals("1"));
                        break;
                    }
                    case 174: 
                    case 225: {
                        if (this._dataFmt.isUnitype()) {
                            String string = this.readUnicodeString();
                            bl = string != null && (string.trim().toLowerCase().equals("true") || string.trim().equals("1"));
                            break;
                        }
                        bl2 = true;
                        break;
                    }
                    default: {
                        bl2 = true;
                    }
                }
                if (bl2) {
                    ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, unichar, varchar, univarchar, text, unitext, money, short money");
                }
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMessage.raiseError("JZ009", numberFormatException.toString());
        }
        finally {
            this.endRead();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByte() throws SQLException {
        long l = 0L;
        boolean bl = false;
        try {
            this.beginRead();
            if (!this._isNull) {
                block3 : switch (this._dataFmt._datatype) {
                    case 48: 
                    case 50: {
                        l = this.readUnsignedByte();
                        break;
                    }
                    case 52: {
                        l = this.readShort();
                        break;
                    }
                    case 65: {
                        l = this.readUnsignedShortAsInt();
                        break;
                    }
                    case 56: {
                        l = this.readInt();
                        break;
                    }
                    case 66: {
                        l = this.readUnsignedIntAsLong();
                        break;
                    }
                    case 191: {
                        l = this.readLong();
                        break;
                    }
                    case 38: {
                        l = this.readINTN();
                        break;
                    }
                    case 67: {
                        l = this.readUnsignedLongAsBigDecimal().longValue();
                        break;
                    }
                    case 68: {
                        if (this._dataLength < 8) {
                            l = this.readUINTN();
                            break;
                        }
                        l = this.readUnsignedLongAsBigDecimal().longValue();
                        break;
                    }
                    case 59: 
                    case 62: 
                    case 109: {
                        l = new Double(this.readFLTN()).longValue();
                        break;
                    }
                    case 106: 
                    case 108: {
                        l = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale).longValue();
                        break;
                    }
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        l = new BigDecimal(Convert.numString(this.readString())).longValue();
                        break;
                    }
                    case 174: 
                    case 225: {
                        if (this._dataFmt.isUnitype()) {
                            l = new BigDecimal(Convert.numString(this.readUnicodeString())).longValue();
                            break;
                        }
                        bl = true;
                        break;
                    }
                    case 36: {
                        switch (this._dataFmt._blobType) {
                            case 6: 
                            case 8: {
                                l = this.readLobInfo().getLong();
                                break block3;
                            }
                        }
                        bl = true;
                        break;
                    }
                    case 60: 
                    case 110: 
                    case 122: {
                        l = this.readMONEYN().longValue();
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
                if (bl) {
                    ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, unichar, varchar, univarchar, text, unitext, money, short money, unsigned bigint");
                }
                Convert.checkByteOflo(l);
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMessage.raiseError("JZ009", numberFormatException.toString());
        }
        finally {
            if (!bl) {
                this.endRead();
            }
        }
        return (byte)l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes() throws SQLException {
        byte[] byArray = null;
        boolean bl = false;
        try {
            this.beginRead();
            if (!this._isNull) {
                block2 : switch (this._dataFmt._datatype) {
                    case 36: {
                        switch (this._dataFmt._blobType) {
                            case 7: 
                            case 8: {
                                byArray = this.readLobInfo().getBytes();
                                break block2;
                            }
                            case 4: {
                                int n;
                                this._columnInputStream = this.makeNewRIS(4);
                                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                                byte[] byArray2 = new byte[512];
                                while ((n = this._columnInputStream.read(byArray2, 0, 512)) != -1) {
                                    byteArrayOutputStream.write(byArray2, 0, n);
                                }
                                byArray = byteArrayOutputStream.toByteArray();
                                byteArrayOutputStream.close();
                                this._columnInputStream.close();
                                this._columnInputStream = null;
                                break block2;
                            }
                        }
                        bl = true;
                        break;
                    }
                    case 34: 
                    case 37: 
                    case 45: 
                    case 174: 
                    case 225: {
                        byArray = this.funkyBinaryReader();
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
                if (bl) {
                    ErrorMessage.raiseError("JZ0TE", "varbinay, long binary, binary, image, unitext");
                }
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        finally {
            if (!bl) {
                this.endRead();
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getRawBytes() throws SQLException {
        byte[] byArray = null;
        try {
            this.beginRead();
            if (!this._isNull) {
                int n;
                this._columnInputStream = this.makeNewRIS(4);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray2 = new byte[512];
                while ((n = this._columnInputStream.read(byArray2, 0, 512)) != -1) {
                    byteArrayOutputStream.write(byArray2, 0, n);
                }
                byArray = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.close();
                this._columnInputStream.close();
                this._columnInputStream = null;
                this._dataLength = byArray.length;
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        finally {
            this.endRead();
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TextPointer getTextPtr() throws SQLException {
        Object object;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 34: 
                    case 35: 
                    case 174: {
                        break;
                    }
                    default: {
                        ErrorMessage.raiseError("JZ0R4");
                        break;
                    }
                }
            } else {
                ErrorMessage.raiseError("JZ0R4");
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        finally {
            this.endRead();
            try {
                if (this._dataFmt._datatype == 34) {
                    this.funkyBinaryReader();
                } else {
                    object = this.readString();
                }
            }
            catch (IOException iOException) {}
        }
        object = new TextPointer(this._context);
        byte[] byArray = new byte[this._textptrlen];
        byte[] byArray2 = new byte[8];
        System.arraycopy(this._textptr, 0, byArray, 0, this._textptrlen);
        System.arraycopy(this._textptr, this._textptrlen, byArray2, 0, 8);
        ((TextPointer)object)._textPtr = byArray;
        ((TextPointer)object)._timeStamp = byArray2;
        ((TextPointer)object)._tableName = this._dataFmt._tableName;
        ((TextPointer)object)._columnName = this._dataFmt.getName();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DateObject getDateObject(int n, Calendar calendar) throws SQLException {
        DateObject dateObject = null;
        boolean bl = false;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        dateObject = Convert.objectToDateObject(this.readString(), n, calendar);
                        break;
                    }
                    case 174: 
                    case 225: {
                        if (this._dataFmt.isUnitype()) {
                            dateObject = Convert.objectToDateObject(this.readUnicodeString(), n, calendar);
                            break;
                        }
                        bl = true;
                        break;
                    }
                    case 58: 
                    case 61: 
                    case 111: {
                        dateObject = this.readDATETIMN().dateObjectValue(calendar);
                        break;
                    }
                    case 187: 
                    case 188: {
                        dateObject = this.readBIGDATETIMN(this._dataFmt._datatype).dateObjectValue(calendar);
                        break;
                    }
                    case 49: 
                    case 123: {
                        if (n == 92) {
                            ErrorMessage.raiseError("JZ0TI", "date", "time");
                            break;
                        }
                        dateObject = this.readDATEN().dateObjectValue(calendar);
                        break;
                    }
                    case 51: 
                    case 147: {
                        if (n == 91) {
                            ErrorMessage.raiseError("JZ0TI", "time", "date");
                            break;
                        }
                        dateObject = this.readTIMEN().dateObjectValue(calendar);
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
                if (bl) {
                    ErrorMessage.raiseError("JZ0TE", "char, unichar, varchar, univarchar, text, unitext, datetime, short datetime, date, time");
                }
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ErrorMessage.raiseError("JZ009", illegalArgumentException.getMessage());
        }
        finally {
            this.endRead();
        }
        return dateObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble() throws SQLException {
        double d = 0.0;
        boolean bl = false;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 48: 
                    case 50: {
                        d = this.readUnsignedByte();
                        break;
                    }
                    case 52: {
                        d = this.readShort();
                        break;
                    }
                    case 65: {
                        d = this.readUnsignedShortAsInt();
                        break;
                    }
                    case 56: {
                        d = this.readInt();
                        break;
                    }
                    case 66: {
                        d = this.readUnsignedIntAsLong();
                        break;
                    }
                    case 191: {
                        d = this.readLong();
                        break;
                    }
                    case 67: {
                        d = this.readUnsignedLongAsBigDecimal().doubleValue();
                        break;
                    }
                    case 38: {
                        d = this.readINTN();
                        break;
                    }
                    case 68: {
                        if (this._dataLength < 8) {
                            d = this.readINTN();
                            break;
                        }
                        d = this.readUnsignedLongAsBigDecimal().doubleValue();
                        break;
                    }
                    case 59: 
                    case 62: 
                    case 109: {
                        d = this.readFLTN();
                        break;
                    }
                    case 106: 
                    case 108: {
                        BigDecimal bigDecimal = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale);
                        if (bigDecimal == null) break;
                        d = bigDecimal.doubleValue();
                        break;
                    }
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        d = Double.valueOf(Convert.numString(this.readString()));
                        break;
                    }
                    case 174: 
                    case 225: {
                        if (this._dataFmt.isUnitype()) {
                            d = Double.valueOf(Convert.numString(this.readUnicodeString()));
                            break;
                        }
                        bl = true;
                        break;
                    }
                    case 60: 
                    case 110: 
                    case 122: {
                        BigDecimal bigDecimal = this.readMONEYN();
                        if (bigDecimal == null) break;
                        d = bigDecimal.doubleValue();
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
                if (bl) {
                    ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, unichar, varchar, univarchar, text, unitext, money, short money");
                }
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMessage.raiseError("JZ009", numberFormatException.toString());
        }
        finally {
            this.endRead();
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat() throws SQLException {
        float f = 0.0f;
        boolean bl = false;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 48: 
                    case 50: {
                        f = this.readUnsignedByte();
                        break;
                    }
                    case 52: {
                        f = this.readShort();
                        break;
                    }
                    case 65: {
                        f = this.readUnsignedShortAsInt();
                        break;
                    }
                    case 56: {
                        f = this.readInt();
                        break;
                    }
                    case 66: {
                        f = this.readUnsignedIntAsLong();
                        break;
                    }
                    case 191: {
                        f = this.readLong();
                        break;
                    }
                    case 38: {
                        f = this.readINTN();
                        break;
                    }
                    case 67: {
                        f = this.readUnsignedLongAsBigDecimal().floatValue();
                        break;
                    }
                    case 68: {
                        if (this._dataLength < 8) {
                            f = this.readUINTN();
                            break;
                        }
                        f = this.readUnsignedLongAsBigDecimal().floatValue();
                        break;
                    }
                    case 59: {
                        f = this.readFloat();
                        break;
                    }
                    case 62: {
                        f = (float)this.readDouble();
                        break;
                    }
                    case 109: {
                        f = (float)this.readFLTN();
                        break;
                    }
                    case 106: 
                    case 108: {
                        BigDecimal bigDecimal = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale);
                        if (bigDecimal == null) break;
                        f = bigDecimal.floatValue();
                        break;
                    }
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        f = Float.valueOf(Convert.numString(this.readString())).floatValue();
                        break;
                    }
                    case 174: 
                    case 225: {
                        if (this._dataFmt.isUnitype()) {
                            f = Float.valueOf(Convert.numString(this.readUnicodeString())).floatValue();
                            break;
                        }
                        bl = true;
                        break;
                    }
                    case 60: 
                    case 110: 
                    case 122: {
                        BigDecimal bigDecimal = this.readMONEYN();
                        if (bigDecimal == null) break;
                        f = bigDecimal.floatValue();
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
                if (bl) {
                    ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, unichar, varchar, univarchar, text, unitext, money, short money, unsigned bigint");
                }
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMessage.raiseError("JZ009", numberFormatException.toString());
        }
        finally {
            this.endRead();
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt() throws SQLException {
        long l = 0L;
        boolean bl = false;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 48: 
                    case 50: {
                        l = this.readUnsignedByte();
                        break;
                    }
                    case 52: {
                        l = this.readShort();
                        break;
                    }
                    case 65: {
                        l = this.readUnsignedShortAsInt();
                        break;
                    }
                    case 56: {
                        l = this.readInt();
                        break;
                    }
                    case 66: {
                        l = this.readUnsignedIntAsLong();
                        break;
                    }
                    case 191: {
                        l = this.readLong();
                        break;
                    }
                    case 38: {
                        l = this.readINTN();
                        break;
                    }
                    case 67: {
                        l = this.readUnsignedLongAsBigDecimal().longValue();
                        break;
                    }
                    case 68: {
                        if (this._dataLength < 8) {
                            l = this.readUINTN();
                            break;
                        }
                        l = this.readUnsignedLongAsBigDecimal().longValue();
                        break;
                    }
                    case 59: 
                    case 62: 
                    case 109: {
                        l = new Double(this.readFLTN()).longValue();
                        break;
                    }
                    case 106: 
                    case 108: {
                        l = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale).longValue();
                        break;
                    }
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        l = new BigDecimal(Convert.numString(this.readString())).longValue();
                        break;
                    }
                    case 174: 
                    case 225: {
                        if (this._dataFmt.isUnitype()) {
                            l = new BigDecimal(Convert.numString(this.readUnicodeString())).longValue();
                            break;
                        }
                        bl = true;
                        break;
                    }
                    case 60: 
                    case 110: 
                    case 122: {
                        l = this.readMONEYN().longValue();
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
                if (bl) {
                    ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, unichar, varchar, univarchar, text, unitext, money, short money,unsigned bigint");
                }
                Convert.checkIntOflo(l);
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMessage.raiseError("JZ009", numberFormatException.toString());
        }
        finally {
            this.endRead();
        }
        return (int)l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong() throws SQLException {
        long l = 0L;
        boolean bl = false;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 48: 
                    case 50: {
                        l = this.readUnsignedByte();
                        break;
                    }
                    case 52: {
                        l = this.readShort();
                        break;
                    }
                    case 65: {
                        l = this.readUnsignedShortAsInt();
                        break;
                    }
                    case 56: {
                        l = this.readInt();
                        break;
                    }
                    case 66: {
                        l = this.readUnsignedIntAsLong();
                        break;
                    }
                    case 191: {
                        l = this.readLong();
                        break;
                    }
                    case 38: {
                        l = this.readINTN();
                        break;
                    }
                    case 67: {
                        l = this.readUnsignedLongAsBigDecimal().longValue();
                        break;
                    }
                    case 68: {
                        if (this._dataLength < 8) {
                            l = this.readUINTN();
                            break;
                        }
                        l = this.readUnsignedLongAsBigDecimal().longValue();
                        break;
                    }
                    case 59: 
                    case 62: 
                    case 109: {
                        l = new Double(this.readFLTN()).longValue();
                        break;
                    }
                    case 106: 
                    case 108: {
                        l = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale).longValue();
                        break;
                    }
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        l = new BigDecimal(Convert.numString(this.readString())).longValue();
                        break;
                    }
                    case 174: 
                    case 225: {
                        if (this._dataFmt.isUnitype()) {
                            l = new BigDecimal(Convert.numString(this.readUnicodeString())).longValue();
                            break;
                        }
                        bl = true;
                        break;
                    }
                    case 60: 
                    case 110: 
                    case 122: {
                        l = this.readMONEYN().longValue();
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
                if (bl) {
                    ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, unichar, varchar, univarchar, text, unitext,  money, short money, unsigned bigint");
                }
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMessage.raiseError("JZ009", numberFormatException.toString());
        }
        finally {
            this.endRead();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getObject() throws SQLException {
        Object object = null;
        try {
            this.beginRead();
            if (this._isNull) return object;
            switch (this._dataFmt._datatype) {
                case 50: {
                    int n = this.readUnsignedByte();
                    object = new Boolean(n != 0);
                    return object;
                }
                case 48: {
                    object = new Integer((byte)this.readUnsignedByte());
                    return object;
                }
                case 52: {
                    object = new Integer(this.readShort());
                    return object;
                }
                case 65: {
                    object = new Integer(this.readUnsignedShortAsInt());
                    return object;
                }
                case 56: {
                    object = new Integer(this.readInt());
                    return object;
                }
                case 66: {
                    object = new Long(this.readUnsignedIntAsLong());
                    return object;
                }
                case 191: {
                    object = new Long(this.readLong());
                    return object;
                }
                case 67: {
                    object = this.readUnsignedLongAsBigDecimal();
                    return object;
                }
                case 38: {
                    if (this._dataLength <= 4) {
                        object = new Integer((int)this.readINTN());
                        return object;
                    } else {
                        object = new Long(this.readINTN());
                        return object;
                    }
                }
                case 68: {
                    if (this._dataLength < 8) {
                        object = new Integer((int)this.readUINTN());
                        return object;
                    } else {
                        object = this.readUnsignedLongAsBigDecimal();
                        return object;
                    }
                }
                case 59: {
                    object = new Float(this.readFloat());
                    return object;
                }
                case 62: 
                case 109: {
                    if (this._dataLength == 4) {
                        object = new Float(this.readFloat());
                        return object;
                    } else {
                        object = new Double(this.readFLTN());
                        return object;
                    }
                }
                case 106: 
                case 108: {
                    object = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale);
                    return object;
                }
                case 39: 
                case 47: {
                    object = this.readString();
                    return object;
                }
                case 60: 
                case 110: 
                case 122: {
                    object = this.readMONEYN();
                    return object;
                }
                case 37: 
                case 45: 
                case 225: {
                    if (this._dataFmt._usertype == 35 || this._dataFmt._usertype == 34) {
                        object = this.readUnicodeString();
                        return object;
                    }
                }
                case 34: {
                    object = this.funkyBinaryReader();
                    return object;
                }
                case 35: 
                case 175: {
                    object = this.readString();
                    return object;
                }
                case 174: {
                    object = this.readUnicodeString();
                    return object;
                }
                case 58: 
                case 61: 
                case 111: {
                    object = Convert.objectToTimestamp(this.readDATETIMN().dateObjectValue());
                    return object;
                }
                case 187: 
                case 188: {
                    object = Convert.objectToTimestamp(this.readBIGDATETIMN(this._dataFmt._datatype).dateObjectValue());
                    return object;
                }
                case 49: 
                case 123: {
                    object = Convert.objectToDate(this.readDATEN().dateObjectValue());
                    return object;
                }
                case 51: 
                case 147: {
                    object = Convert.objectToTime(this.readTIMEN().dateObjectValue());
                    return object;
                }
                case 103: 
                case 104: {
                    byte[] byArray = new byte[this._dataLength];
                    this.in.read(byArray, 0, this._dataLength);
                    object = byArray;
                    return object;
                }
                case 36: {
                    switch (this._dataFmt._blobType) {
                        case 1: {
                            object = this.readObject();
                            return object;
                        }
                        case 3: {
                            this._columnInputStream = this.makeNewRIS(3);
                            object = this._columnInputStream;
                            return object;
                        }
                        case 5: {
                            this._columnInputStream = this.makeNewRIS(5);
                            object = this._columnInputStream;
                            return object;
                        }
                        case 4: {
                            this._columnInputStream = this.makeNewRIS(4);
                            object = this._columnInputStream;
                            return object;
                        }
                        case 2: {
                            return object;
                        }
                        case 6: 
                        case 7: 
                        case 8: {
                            object = this.readLobInfo();
                        }
                    }
                    return object;
                }
                default: {
                    ErrorMessage.raiseError("JZ0TC");
                    return object;
                }
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
            return object;
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMessage.raiseError("JZ009", numberFormatException.toString());
            return object;
        }
        finally {
            if (this._columnInputStream == null) {
                this.endRead();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort() throws SQLException {
        long l = 0L;
        boolean bl = false;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 48: 
                    case 50: {
                        l = this.readUnsignedByte();
                        break;
                    }
                    case 52: {
                        l = this.readShort();
                        break;
                    }
                    case 65: {
                        l = this.readUnsignedShortAsInt();
                        break;
                    }
                    case 56: {
                        l = this.readInt();
                        break;
                    }
                    case 66: {
                        l = this.readUnsignedIntAsLong();
                        break;
                    }
                    case 191: {
                        l = this.readLong();
                        break;
                    }
                    case 38: {
                        l = this.readINTN();
                        break;
                    }
                    case 67: {
                        l = this.readUnsignedLongAsBigDecimal().longValue();
                        break;
                    }
                    case 68: {
                        if (this._dataLength < 8) {
                            l = this.readUINTN();
                            break;
                        }
                        l = this.readUnsignedLongAsBigDecimal().longValue();
                        break;
                    }
                    case 59: 
                    case 62: 
                    case 109: {
                        l = new Double(this.readFLTN()).longValue();
                        break;
                    }
                    case 106: 
                    case 108: {
                        l = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale).longValue();
                        break;
                    }
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        l = new BigDecimal(Convert.numString(this.readString())).longValue();
                        break;
                    }
                    case 174: 
                    case 225: {
                        if (this._dataFmt.isUnitype()) {
                            l = new BigDecimal(Convert.numString(this.readUnicodeString())).longValue();
                            break;
                        }
                        bl = true;
                        break;
                    }
                    case 60: 
                    case 110: 
                    case 122: {
                        l = this.readMONEYN().longValue();
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
                if (bl) {
                    ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, unichar, varchar, univarchar, text, unitext, money, short money, unsigned bigint");
                }
                Convert.checkShortOflo(l);
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMessage.raiseError("JZ009", numberFormatException.toString());
        }
        finally {
            this.endRead();
        }
        return (short)l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getString() throws SQLException {
        String string = null;
        try {
            this.beginRead();
            if (this._isNull) return string;
            switch (this._dataFmt._datatype) {
                case 48: 
                case 50: {
                    string = String.valueOf(this.readUnsignedByte());
                    return string;
                }
                case 52: {
                    string = String.valueOf(this.readShort());
                    return string;
                }
                case 65: {
                    string = String.valueOf(this.readUnsignedShortAsInt());
                    return string;
                }
                case 56: {
                    string = String.valueOf(this.readInt());
                    return string;
                }
                case 66: {
                    string = String.valueOf(this.readUnsignedIntAsLong());
                    return string;
                }
                case 191: {
                    string = String.valueOf(this.readLong());
                    return string;
                }
                case 67: {
                    string = String.valueOf(this.readUnsignedLongAsBigDecimal());
                    return string;
                }
                case 38: {
                    string = String.valueOf(this.readINTN());
                    return string;
                }
                case 68: {
                    if (this._dataLength < 8) {
                        string = String.valueOf(this.readUINTN());
                        return string;
                    } else {
                        string = String.valueOf(this.readUnsignedLongAsBigDecimal());
                        return string;
                    }
                }
                case 59: {
                    string = String.valueOf(this.readFloat());
                    return string;
                }
                case 62: {
                    string = String.valueOf(this.readDouble());
                    return string;
                }
                case 109: {
                    string = String.valueOf(this.readFLTN());
                    return string;
                }
                case 106: 
                case 108: {
                    BigDecimal bigDecimal = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale);
                    if (bigDecimal == null) return string;
                    string = bigDecimal.toString();
                    return string;
                }
                case 35: 
                case 39: 
                case 47: 
                case 175: {
                    string = this.readString();
                    return string;
                }
                case 34: 
                case 37: 
                case 45: 
                case 103: 
                case 104: {
                    if (this._holds0LNN) {
                        string = "";
                        return string;
                    } else {
                        string = HexConverts.hexConvert(this.funkyBinaryReader());
                        return string;
                    }
                }
                case 225: {
                    if (this._dataFmt._usertype == 35 || this._dataFmt._usertype == 34) {
                        string = this.readUnicodeString();
                        return string;
                    } else if (this._holds0LNN) {
                        string = "";
                        return string;
                    } else {
                        string = HexConverts.hexConvert(this.funkyBinaryReader());
                        return string;
                    }
                }
                case 174: {
                    string = this.readUnicodeString();
                    return string;
                }
                case 60: 
                case 110: 
                case 122: {
                    BigDecimal bigDecimal = this.readMONEYN();
                    if (bigDecimal == null) return string;
                    string = bigDecimal.toString();
                    return string;
                }
                case 58: 
                case 61: 
                case 111: {
                    string = this.readDATETIMN().stringValue();
                    return string;
                }
                case 187: 
                case 188: {
                    string = this.readBIGDATETIMN(this._dataFmt._datatype).stringValue();
                    return string;
                }
                case 49: 
                case 123: {
                    string = this.readDATEN().stringValue();
                    return string;
                }
                case 51: 
                case 147: {
                    string = this.readTIMEN().stringValue();
                    return string;
                }
                case 36: {
                    switch (this._dataFmt._blobType) {
                        case 1: {
                            Object object = this.readObject();
                            if (object == null) {
                                string = null;
                                return string;
                            } else {
                                string = object.toString();
                                return string;
                            }
                        }
                        case 3: {
                            int n;
                            this._columnInputStream = this.makeNewRIS(4);
                            InputStreamReader inputStreamReader = null;
                            inputStreamReader = this._tds._charsetName.equals("x-SybUTF8") ? new InputStreamReader((InputStream)this._columnInputStream, SybUTF8Charset.getInstance()) : new InputStreamReader((InputStream)this._columnInputStream, this._tds._charsetName);
                            char[] cArray = new char[512];
                            StringBuffer stringBuffer = new StringBuffer();
                            while ((n = inputStreamReader.read(cArray, 0, 512)) != -1) {
                                stringBuffer.append(cArray, 0, n);
                            }
                            string = stringBuffer.toString();
                            inputStreamReader.close();
                            this._columnInputStream.close();
                            this._columnInputStream = null;
                            return string;
                        }
                        case 5: {
                            int n;
                            this._columnInputStream = this.makeNewRIS(5);
                            String string2 = null;
                            string2 = this.getBigEndian() ? "UnicodeBig" : "UnicodeLittle";
                            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)this._columnInputStream, string2);
                            char[] cArray = new char[512];
                            StringBuffer stringBuffer = new StringBuffer();
                            while ((n = inputStreamReader.read(cArray, 0, 512)) != -1) {
                                stringBuffer.append(cArray, 0, n);
                            }
                            string = stringBuffer.toString();
                            inputStreamReader.close();
                            this._columnInputStream.close();
                            this._columnInputStream = null;
                            return string;
                        }
                        case 4: {
                            int n;
                            this._columnInputStream = this.makeNewRIS(4);
                            byte[] byArray = new byte[512];
                            StringBuffer stringBuffer = new StringBuffer();
                            while ((n = this._columnInputStream.read(byArray, 0, 512)) != -1) {
                                stringBuffer.append(HexConverts.hexConvert(byArray, n));
                            }
                            string = stringBuffer.toString();
                            this._columnInputStream.close();
                            this._columnInputStream = null;
                            return string;
                        }
                        case 6: 
                        case 7: 
                        case 8: {
                            string = this.readLobInfo().getString();
                            return string;
                        }
                    }
                    ErrorMessage.raiseError("JZ0TC");
                    return string;
                }
                default: {
                    ErrorMessage.raiseError("JZ0TC");
                    return string;
                }
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
            return string;
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMessage.raiseError("JZ009", numberFormatException.toString());
            return string;
        }
        finally {
            this.endRead();
        }
    }

    @Override
    public Blob getBlob() throws SQLException {
        SybBinaryClientLob sybBinaryClientLob = null;
        if (this._dataFmt._datatype == 34) {
            try {
                this.beginRead();
                sybBinaryClientLob = this._isNull ? null : new SybBinaryClientLob(this._logId, this._context, this.funkyBinaryReader());
                this.endRead();
                return sybBinaryClientLob;
            }
            catch (IOException iOException) {
                ErrorMessage.raiseErrorCheckDead(iOException);
            }
        }
        return (SybBinaryLob)this.getLob(7, false);
    }

    @Override
    public NClob getNClob() throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "getNClob()");
        return null;
    }

    @Override
    public Clob getClob() throws SQLException {
        SybCharClientLob sybCharClientLob = null;
        if (this._dataFmt._datatype == 35) {
            try {
                this.beginRead();
                sybCharClientLob = this._isNull ? null : new SybCharClientLob(this._logId, this._context, new StringBuilder(this.readString()), SybLob.LOB_TYPE.TEXT);
                this.endRead();
                return sybCharClientLob;
            }
            catch (IOException iOException) {
                ErrorMessage.raiseErrorCheckDead(iOException);
            }
        } else if (this._dataFmt._datatype == 174) {
            try {
                this.beginRead();
                sybCharClientLob = this._isNull ? null : new SybCharClientLob(this._logId, this._context, new StringBuilder(this.readUnicodeString()), SybLob.LOB_TYPE.TEXT);
                this.endRead();
                return sybCharClientLob;
            }
            catch (IOException iOException) {
                ErrorMessage.raiseErrorCheckDead(iOException);
            }
        } else {
            if (this._dataFmt._blobType == 6 || this._dataFmt._blobType == 8) {
                return (SybCharLob)this.getLob(this._dataFmt._blobType, false);
            }
            ErrorMessage.raiseError("JZ0TE", "(text, Clob) (unitext, Clob) (unitext, NClob) (unitext, Clob) (image, Blob)");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SybLob getLob(int n, boolean bl) throws SQLException {
        SybLob sybLob = null;
        boolean bl2 = false;
        try {
            this.beginRead();
            switch (this._dataFmt._datatype) {
                case 36: {
                    if (this._dataFmt._blobType == n) {
                        sybLob = this.readLobInfo();
                        if (this._lobLength != 0L || bl) return sybLob;
                        sybLob = null;
                        return sybLob;
                    }
                }
                default: {
                    bl2 = true;
                    ErrorMessage.raiseError("JZ0TE", "(text, Clob) (unitext, Clob) (unitext, NClob) (unitext, Clob) (image, Blob)");
                    return sybLob;
                }
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
            return sybLob;
        }
        finally {
            if (!bl2) {
                this.endRead();
            }
        }
    }

    protected SybLob readLobInfo() throws IOException, SQLException {
        SybLob sybLob = null;
        RawInputStream rawInputStream = this.makeNewRIS(4);
        ((InputStream)rawInputStream).close();
        switch (this._dataFmt._blobType) {
            case 7: {
                sybLob = new SybBinaryLob(this._logId, this._context, this._locator);
                break;
            }
            case 6: {
                sybLob = new SybCharLob(this._logId, this._context, this._locator, SybLob.LOB_TYPE.TEXT);
                break;
            }
            case 8: {
                sybLob = new SybCharLob(this._logId, this._context, this._locator, SybLob.LOB_TYPE.UNITEXT);
            }
        }
        sybLob.setLobLength(this._lobLength);
        return sybLob;
    }

    @Override
    public boolean isNull() throws SQLException {
        switch (this._dataFmt._datatype) {
            case 36: {
                switch (this._dataFmt._blobType) {
                    case 6: 
                    case 7: 
                    case 8: {
                        return this._lobLength == 0L;
                    }
                }
            }
        }
        return this._isNull;
    }

    @Override
    public void open(boolean bl) {
        this._state = bl ? 2 : 1;
        if (this._context._lastResult == 209) {
            this._context._lastResult = -1;
        }
    }

    @Override
    public int getState() {
        return this._state;
    }

    @Override
    public void setManager(CacheManager cacheManager) {
        this._monitor = cacheManager;
    }

    @Override
    public void cache() throws IOException {
        int n;
        if (this._state == 3) {
            return;
        }
        if (this._monitor == null) {
            this.startRead();
            if (this._context._rereadable && (this._state == 0 || this._columnInputStream == null)) {
                this.openCacheStream();
            }
        }
        this._state = 2;
        if (this._columnInputStream != null) {
            if (this._context._rereadable) {
                this._columnInputStream.cache((CacheStream)this.in);
            } else {
                this._columnInputStream.close();
                this._columnInputStream = null;
            }
            this._state = 3;
            return;
        }
        this.getSize();
        if (this._dataLength == -1 && this._columnInputStream == null) {
            try {
                this._columnInputStream = this.makeNewRIS(4);
            }
            catch (SQLException sQLException) {
                ErrorMessage.raiseIOECheckDead(sQLException);
            }
            this._columnInputStream.cache((CacheStream)this.in);
            this._state = 3;
            this.reset();
            this._columnInputStream = null;
            return;
        }
        byte[] byArray = new byte[512];
        for (int i = this._dataLength; i > 0; i -= n) {
            n = i < 512 ? i : 512;
            this.in.read(byArray, 0, n);
        }
        if (this._monitor != null) {
            this._monitor.doneReading();
        }
        this._state = 3;
        if (this._monitor != null) {
            this.in.reset();
        }
    }

    @Override
    public void clear() throws IOException {
        if (this._columnInputStream != null) {
            this._columnInputStream.close();
            this._columnInputStream = null;
        } else {
            switch (this._state) {
                case 0: {
                    if (this._monitor != null) break;
                    this.skipParam();
                    break;
                }
                case 1: {
                    this.skipParam();
                    if (this._monitor == null) break;
                    this._monitor.doneReading();
                    break;
                }
                case 2: {
                    this.getSize();
                    this.in.skip(this._dataLength);
                    if (this._monitor == null) break;
                    this._monitor.doneReading();
                }
            }
        }
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void skipParam() throws IOException {
        this.getSize();
        if (this._dataLength == -1) {
            try {
                this._columnInputStream = this.makeNewRIS(4);
                this._columnInputStream.close();
            }
            catch (SQLException sQLException) {
                ErrorMessage.raiseIOECheckDead(sQLException);
            }
            finally {
                this._columnInputStream = null;
            }
        } else {
            this.in.skip(this._dataLength);
        }
    }

    @Override
    public void resetInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    @Override
    public int available() throws IOException {
        return this._dataLength != -1 ? this._dataLength : this.in.available();
    }

    @Override
    public void initialize() {
        super.initialize();
        this._columnInputStream = null;
        if (this.in instanceof CacheStream) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.in = this._context._in;
        }
    }

    @Override
    public void reset() throws IOException {
        if (this._state == 3 && !this._isNull) {
            this.in.reset();
            if (this._monitor != null) {
                this._dataLength = -2;
                this.getSize();
            }
        } else {
            ErrorMessage.raiseIOException("JZ0P7");
        }
    }

    @Override
    protected void beginRead() throws IOException {
        if (this._monitor == null && this._state == 0 && this._prev != null && this._prev._state != 3) {
            this._prev.cache();
        }
        if (this._columnInputStream != null) {
            if (this._context._rereadable) {
                this._columnInputStream.cache((CacheStream)this.in);
                this._state = 3;
            } else {
                ErrorMessage.raiseIOException("JZ0R3");
            }
        }
        this.getSize();
        if (this._isNull) {
            return;
        }
        if (this._monitor == null) {
            if (this._state == 0) {
                if (this._context._rereadable) {
                    this.openCacheStream();
                }
                this._state = 1;
            }
        } else if (this._state == 0) {
            ErrorMessage.raiseIOException("JZ0R3");
        }
        if (this._state == 3) {
            if (this._context._rereadable) {
                this.reset();
            } else {
                ErrorMessage.raiseIOException("JZ0R3");
            }
        }
    }

    @Override
    protected void endRead() throws SQLException {
        if (this._state != 3 && this._monitor != null) {
            this._monitor.doneReading();
        }
        this._state = 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RawInputStream makeNewRIS(int n) throws SQLException {
        if (this._columnInputStream != null) {
            if (this._context._rereadable) {
                try {
                    this._columnInputStream.close();
                    this._state = 3;
                    this.reset();
                }
                catch (IOException iOException) {
                    ErrorMessage.raiseErrorCheckDead(iOException);
                }
                finally {
                    this._columnInputStream = null;
                }
            } else {
                ErrorMessage.raiseError("JZ0R3");
            }
        }
        RawInputStream rawInputStream = null;
        CacheManager cacheManager = null;
        int n2 = this._dataLength;
        if (this._dataFmt._datatype == 37 && this._dataFmt._usertype == 3) {
            n2 = this._dataFmt._length;
        }
        if (this._context._maxFieldSize > 0) {
            n2 = Math.min(n2, this._context._maxFieldSize);
        }
        if (this._state != 3) {
            cacheManager = this._monitor;
            this._state = 1;
        }
        try {
            switch (n) {
                case 4: {
                    rawInputStream = new RawInputStream(this, this._dataLength, n2, cacheManager);
                    break;
                }
                case 1: {
                    rawInputStream = new RawToAsciiInputStream(this, this._dataLength, n2, cacheManager);
                    break;
                }
                case 3: {
                    rawInputStream = new CharsetToUniInputStream(this, this._dataLength, n2, cacheManager, this._tds._charsetName);
                    break;
                }
                case 2: {
                    int n3 = this._dataLength == -1 ? -1 : 2 * this._dataLength;
                    int n4 = n2 == -1 ? -1 : 2 * n2;
                    rawInputStream = new CharsetToUniInputStream(new RawToAsciiInputStream(this, this._dataLength, n2, cacheManager), n3, n4, null, "ISO8859_1");
                    break;
                }
                case 5: {
                    if (this.getBigEndian()) {
                        rawInputStream = new UnicharToUniInputStream((InputStream)this, this._dataLength, n2, cacheManager, false);
                        break;
                    }
                    rawInputStream = new UnicharToUniInputStream((InputStream)this, this._dataLength, n2, cacheManager, true);
                    break;
                }
                case 6: {
                    if (n2 != this._dataLength) {
                        n2 = n2 * 2 < this._dataLength ? (n2 *= 2) : this._dataLength;
                    }
                    rawInputStream = new UnicharToAsciiInputStream(this, this._dataLength, n2, this.getBigEndian(), cacheManager);
                    break;
                }
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseError("JZ0I5", iOException.toString());
        }
        rawInputStream.setCached(this._state == 3);
        return rawInputStream;
    }

    protected static String getObjectClassName(int n, int n2, int n3, int n4) throws SQLException {
        String string = JAVA_LANG_OBJECT;
        switch (n) {
            case 50: {
                string = JAVA_LANG_BOOLEAN;
                break;
            }
            case 48: 
            case 52: 
            case 56: 
            case 65: {
                string = JAVA_LANG_INTEGER;
                break;
            }
            case 66: 
            case 191: {
                string = JAVA_LANG_LONG;
                break;
            }
            case 67: {
                string = JAVA_MATH_BIGDECIMAL;
                break;
            }
            case 68: {
                switch (n4) {
                    case 2: {
                        string = JAVA_LANG_INTEGER;
                        break;
                    }
                    case 4: {
                        string = JAVA_LANG_LONG;
                        break;
                    }
                    case 8: {
                        string = JAVA_MATH_BIGDECIMAL;
                    }
                }
                break;
            }
            case 38: {
                if (n4 <= 4) {
                    string = JAVA_LANG_INTEGER;
                    break;
                }
                string = JAVA_LANG_LONG;
                break;
            }
            case 59: {
                string = JAVA_LANG_FLOAT;
                break;
            }
            case 62: 
            case 109: {
                if (n4 == 4) {
                    string = JAVA_LANG_FLOAT;
                    break;
                }
                string = JAVA_LANG_DOUBLE;
                break;
            }
            case 35: 
            case 39: 
            case 47: 
            case 174: 
            case 175: {
                string = JAVA_LANG_STRING;
                break;
            }
            case 60: 
            case 106: 
            case 108: 
            case 110: 
            case 122: {
                string = JAVA_MATH_BIGDECIMAL;
                break;
            }
            case 34: 
            case 37: 
            case 45: 
            case 103: 
            case 104: {
                string = new byte[1].getClass().getName();
                break;
            }
            case 225: {
                if (n2 == 34 || n2 == 35) {
                    string = JAVA_LANG_STRING;
                    break;
                }
                string = new byte[1].getClass().getName();
                break;
            }
            case 58: 
            case 61: 
            case 111: 
            case 187: {
                string = JAVA_SQL_TIMESTAMP;
                break;
            }
            case 49: 
            case 123: {
                string = JAVA_SQL_DATE;
                break;
            }
            case 51: 
            case 147: 
            case 188: {
                string = JAVA_SQL_TIME;
                break;
            }
            case 36: {
                switch (n3) {
                    case 1: 
                    case 2: {
                        string = JAVA_LANG_OBJECT;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        string = JAVA_IO_FILTERINPUTSTREAM;
                    }
                }
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0TC");
            }
        }
        return string;
    }

    private void openCacheStream() {
        this.in = new CacheStream(this._context._cm, this.in, this._context._timeout);
    }

    private Object readObject() throws SQLException {
        Object object = null;
        try {
            this._columnInputStream = this.makeNewRIS(4);
            if (this._columnInputStream.available() > 0) {
                ObjectInputStream objectInputStream = this._classLoader == null ? new ObjectInputStream(this._columnInputStream) : new DynamicObjectInputStream((InputStream)this._columnInputStream, this._classLoader);
                object = objectInputStream.readObject();
                objectInputStream.close();
            } else {
                this._isNull = true;
            }
            this._columnInputStream.close();
            this._columnInputStream = null;
        }
        catch (Exception exception) {
            ErrorMessage.raiseError("JZ010", exception.getMessage());
        }
        return object;
    }

    @Override
    public Blob getInitializedBlob() throws SQLException {
        Blob blob = (Blob)((Object)this.getLob(7, true));
        return blob;
    }

    @Override
    public Clob getInitializedClob() throws SQLException {
        Clob clob = (Clob)((Object)this.getLob(6, true));
        return clob;
    }

    @Override
    public NClob getInitializedNClob() throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "getInitializedNClob()");
        return null;
    }
}

