@ECHO OFF
c:
cd c:\aspect7\bin\service

set SERVICE_NAME=AspectService
set PR_DESCRIPTION=AspectService
set PR_INSTALL=c:\aspect7\bin\service\prunsrv64.exe

REM Service log configuration
set PR_LOGPREFIX=commons-daemon
set PR_LOGPATH=c:\aspect7\bin\service
set PR_STDOUTPUT=c:\aspect7\bin\service\stdout.txt
set PR_STDERROR=c:\aspect7\bin\service\stderr.txt
set PR_LOGLEVEL=Info
 
REM Path to java installation
REM It is not necessary for JAVA_HOME to ne defined.
set PR_JVM=auto
set PR_CLASSPATH=c:\aspect7\bin\service\AspectService.jar
 
REM Startup configuration
set PR_STARTUP=auto
set PR_STARTPATH=c:\aspect7\bin\service
set PR_STARTMODE=jvm
set PR_STARTCLASS=net.AspectSoftware.AspectService
set PR_STARTMETHOD=start
 
REM Shutdown configuration
set PR_STOPMODE=jvm
set PR_STOPPATH=c:\aspect7\bin\service
set PR_STOPCLASS=net.AspectSoftware.AspectService
set PR_STOPMETHOD=stop
 
REM JVM configuration
set PR_JVMMS=0 
set PR_JVMMX=128
set PR_JVMSS=100

rem set PR_JVMOPTIONS=-Duser.language=EN;-Duser.region=us

if /I "%1"=="test" goto TEST
if /I "%1"=="install" goto INSTALL
if /I "%1"=="restart" goto RESTART
if /I "%1"=="delete" goto DELETE
if /I "%1"=="start" goto START
if /I "%1"=="stop" goto STOP
if /I "%1"=="update" goto UPDATE
goto USAGE

rem This command will execute the class directly and display the contents in the console window.
:TEST
@echo Running in console
prunsrv64.exe //TS//AspectService
goto END

:INSTALL
@echo Installing...
prunsrv64.exe //IS//AspectService
goto END

:RESTART
@echo Restarting...
prunsrv64.exe //DS//AspectService
if exist AspectServiceUpdate.jar copy AspectServiceUpdate.jar AspectService.jar>temp.$$$
prunsrv64.exe //IS//AspectService
prunsrv64.exe //ES//AspectService
goto END

:DELETE
@echo Deleting service...
prunsrv64.exe //DS//AspectService
goto END

:START
@echo Starting Aspect...
prunsrv64.exe //IS//AspectService
prunsrv64.exe //ES//AspectService
goto END

:STOP
@echo Stopping service
prunsrv64.exe //SS//AspectService
goto END

:UPDATE
@echo Update service parameters
prunsrv64.exe //US//AspectService
goto END

:USAGE
@echo Missing parameter
@echo Use:
@echo service test
@echo service install
@echo service delete
@echo service start
@echo service stop
@echo service update

:END
