function showTooltip(e,Msg,OffsetX,OffsetY,MaxWidth)
{
	if (OffsetX==0) OffsetX = 10;
	if (OffsetY==0) OffsetY = 10;
	
	if ((MaxWidth==null) || (MaxWidth==0)) MaxWidth = 400;
	
	div = document.getElementById("tooltip");
	
	if (div==null) {
		tagBody=document.getElementsByTagName('BODY')[0];
		div = document.createElement('div');
		div.id="tooltip";
		div.className="tooltip"; //apparantly setAttrubute("class"...) doesn't work in IE
		tagBody.appendChild(div);		
	};
	
	div.innerHTML=Msg;

	//don't use the event (e) if just hiding with a blank message.  This allows the showTooltip method to be called
	//without an event if it needs to be cleared manually.  One example of this is when a div is made visible under
	//a tooltip that is being displayed.  
	if (Msg.length>0) {
		W = div.offsetWidth;
		H = div.offsetHeight;
		X = e.clientX;
		Y = e.clientY;
		Top	 = Y+OffsetY;
		Left = X+OffsetX;
		div.style.border="1pt solid";
		div.style.top = Top+"px";
		div.style.left = Left+"px";
		
		if (div.offsetWidth>MaxWidth) {
			div.style.width=MaxWidth+"px";
		};
		
		div.style.padding=5;
		div.style.border=5;
	}
	else {
		div.style.padding=0;
		//alert("border="+div.style.border);
		div.style.border="none";
		div.style.width="auto";
	};

	//div.innerHTML = "W:"+W+" H:"+H+" ScreenX:"+e.screenX+" ScreenY:"+e.screenY+" clientX="+e.clientX+" clientY="+e.clientY;
};

